/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.org.history;

import java.util.ArrayList;
import java.util.Calendar;
import java.util.Date;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import kd.bos.base.utils.BaseBatchHandler;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.metadata.IDataEntityType;
import kd.bos.dataentity.metadata.dynamicobject.DynamicObjectType;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.org.utils.DynamicObjectUtils;
import kd.bos.org.utils.Utils;
import kd.bos.orm.query.QFilter;
import kd.bos.orm.util.CollectionUtils;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.operation.DeleteServiceHelper;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import kd.bos.threads.ThreadPools;
import kd.sdk.annotation.SdkPublic;

@SdkPublic
public class UserHistoryUtils {
    private static final Log logger = LogFactory.getLog(UserHistoryUtils.class);

    public static void saveUserHistory(List<Long> userIds) {
        UserHistoryUtils.saveUserHistory(userIds, true);
    }

    public static void saveUserHistory(List<Long> userIds, boolean asynchronous) {
        if (CollectionUtils.isEmpty(userIds)) {
            return;
        }
        logger.info("\u4fdd\u5b58\u4eba\u5458\u66f4\u65b0\u5386\u53f2\uff1a" + userIds.size());
        if (asynchronous) {
            ThreadPools.executeOnceIncludeRequestContext((String)"saveUserHistory", () -> UserHistoryUtils.doSaveUserHistory(userIds));
        } else {
            UserHistoryUtils.doSaveUserHistory(userIds);
        }
    }

    private static void doSaveUserHistory(List<Long> userIds) {
        DynamicObjectUtils.saveHistory("bos_user", userIds, params -> {
            DynamicObject[] objArr = (DynamicObject[])params[0];
            boolean includeExtendProp = (Boolean)params[1];
            return UserHistoryUtils.copyUserToHistory(objArr, includeExtendProp);
        }, params -> {
            List batchList = (List)params[0];
            DynamicObject[] userHistoryArr = (DynamicObject[])params[1];
            UserHistoryUtils.saveUserChargeAndHistory(userHistoryArr, batchList);
            return null;
        });
    }

    private static void saveUserChargeAndHistory(DynamicObject[] userHistoryArr, List<Long> userIds) {
        List<Map<Long, Long>> oldDirectorList = UserHistoryUtils.getOldDirector(userIds);
        List<Map<Long, Long>> directorList = UserHistoryUtils.getCurrentDirector(userHistoryArr);
        if (oldDirectorList.isEmpty()) {
            UserHistoryUtils.saveNewUserCharge(directorList);
        } else if (directorList.isEmpty()) {
            UserHistoryUtils.deleteUserCharge(oldDirectorList);
        } else {
            UserHistoryUtils.addOrUpdateUserChangeHistory(directorList, oldDirectorList);
        }
    }

    private static void addOrUpdateUserChangeHistory(List<Map<Long, Long>> directorList, List<Map<Long, Long>> oldDirectorList) {
        Iterator<Map<Long, Long>> oldItor = oldDirectorList.iterator();
        while (oldItor.hasNext()) {
            Map<Long, Long> oldMap = oldItor.next();
            for (Map.Entry<Long, Long> entry : oldMap.entrySet()) {
                UserHistoryUtils.removeExistsUserChangeRecord(oldItor, entry, directorList);
            }
        }
        UserHistoryUtils.saveNewUserCharge(directorList);
        UserHistoryUtils.deleteUserCharge(oldDirectorList);
    }

    private static void removeExistsUserChangeRecord(Iterator<Map<Long, Long>> oldItor, Map.Entry<Long, Long> entry, List<Map<Long, Long>> directorList) {
        long orgId = entry.getKey();
        long userId = entry.getValue();
        boolean oldRemoved = false;
        Iterator<Map<Long, Long>> itor = directorList.iterator();
        while (itor.hasNext()) {
            Map<Long, Long> map = itor.next();
            Long userIdObj = map.get(orgId);
            if (userIdObj == null || userId != userIdObj) continue;
            if (!oldRemoved) {
                oldRemoved = true;
                oldItor.remove();
            }
            itor.remove();
        }
    }

    private static List<Map<Long, Long>> getOldDirector(List<Long> userIds) {
        String selectFields = "id,user,org";
        Date today = Utils.getDate((int)0);
        QFilter startDateFilter = new QFilter("startdate", "<=", (Object)today);
        QFilter endDateFilter = new QFilter("enddate", ">=", (Object)today);
        QFilter userFilter = new QFilter("user", "in", userIds);
        QFilter[] filters = new QFilter[]{userFilter, startDateFilter, endDateFilter};
        DynamicObjectCollection directorCol = QueryServiceHelper.query((String)"bos_user_director", (String)selectFields, (QFilter[])filters);
        ArrayList<Map<Long, Long>> oldDirectorList = new ArrayList<Map<Long, Long>>();
        if (Utils.isListNotEmpty((List)directorCol)) {
            for (DynamicObject director : directorCol) {
                HashMap<Long, Long> orgUserMap = new HashMap<Long, Long>(1);
                orgUserMap.put(director.getLong("org"), director.getLong("user"));
                oldDirectorList.add(orgUserMap);
            }
        }
        return oldDirectorList;
    }

    private static List<Map<Long, Long>> getCurrentDirector(DynamicObject[] userHistoryArr) {
        ArrayList<Map<Long, Long>> directorList = new ArrayList<Map<Long, Long>>();
        for (DynamicObject user : userHistoryArr) {
            DynamicObjectCollection dpEntity = user.getDynamicObjectCollection("entryentity");
            if (dpEntity == null) continue;
            for (DynamicObject dpObj : dpEntity) {
                DynamicObject org;
                if (!dpObj.getBoolean("isincharge") || (org = dpObj.getDynamicObject("dpt")) == null) continue;
                HashMap<Long, Long> orgUserMap = new HashMap<Long, Long>(1);
                orgUserMap.put(org.getLong("id"), user.getLong("user"));
                directorList.add(orgUserMap);
            }
        }
        return directorList;
    }

    private static void saveNewUserCharge(List<Map<Long, Long>> directorList) {
        if (Utils.isListEmpty(directorList)) {
            return;
        }
        Date today = Utils.getDate((int)0);
        Date endDate = Utils.getEndDate();
        int count = directorList.size();
        ArrayList<DynamicObject> newList = new ArrayList<DynamicObject>(count);
        ArrayList<DynamicObject> newHistoryList = new ArrayList<DynamicObject>(count);
        DynamicObjectType dynamicObjectType = DynamicObjectUtils.getDynamicObjectType("bos_user_director", true);
        DynamicObjectType historyDynamicObjectType = DynamicObjectUtils.getDynamicObjectType("bos_user_director_history", false);
        for (Map<Long, Long> orgUserMap : directorList) {
            long orgId = 0L;
            long userId = 0L;
            for (Map.Entry<Long, Long> entry : orgUserMap.entrySet()) {
                orgId = entry.getKey();
                userId = entry.getValue();
            }
            DynamicObject director = new DynamicObject(dynamicObjectType);
            director.set("org", (Object)orgId);
            director.set("user", (Object)userId);
            director.set("ischief", (Object)Boolean.TRUE);
            director.set("startdate", (Object)today);
            director.set("enddate", (Object)endDate);
            newList.add(director);
            DynamicObject directorHistory = new DynamicObject(historyDynamicObjectType);
            directorHistory.set("org", (Object)orgId);
            directorHistory.set("user", (Object)userId);
            directorHistory.set("ischief", (Object)Boolean.TRUE);
            directorHistory.set("startdate", (Object)today);
            directorHistory.set("enddate", (Object)endDate);
            newHistoryList.add(directorHistory);
        }
        if (Utils.isListNotEmpty(newList)) {
            SaveServiceHelper.save((DynamicObject[])newList.toArray(new DynamicObject[newList.size()]));
            SaveServiceHelper.save((DynamicObject[])newHistoryList.toArray(new DynamicObject[newHistoryList.size()]));
        }
    }

    private static void deleteUserCharge(List<Map<Long, Long>> directorList) {
        if (Utils.isListEmpty(directorList)) {
            return;
        }
        Date today = Utils.getDate((int)0);
        QFilter startDateFilter = new QFilter("startdate", "<=", (Object)today);
        QFilter endDateFilter = new QFilter("enddate", ">=", (Object)today);
        QFilter timeFilter = startDateFilter.and(endDateFilter);
        QFilter filter = null;
        for (Map<Long, Long> orgUserMap : directorList) {
            for (Map.Entry<Long, Long> entry : orgUserMap.entrySet()) {
                QFilter orgFilter = new QFilter("org", "=", (Object)entry.getKey());
                QFilter userFilter = new QFilter("user", "=", (Object)entry.getValue());
                orgFilter = orgFilter.and(userFilter);
                if (filter == null) {
                    filter = orgFilter;
                    continue;
                }
                filter = filter.or(orgFilter);
            }
        }
        QFilter[] filters = new QFilter[]{filter, timeFilter};
        DeleteServiceHelper.delete((String)"bos_user_director", (QFilter[])filters);
        UserHistoryUtils.updateUserChargeHistory(filters);
    }

    private static List<Map<Long, Long>> updateUserChargeHistory(QFilter[] filters) {
        String selectFields = "id,org,user,startdate,enddate";
        DynamicObject[] userArr = BusinessDataServiceHelper.load((String)"bos_user_director_history", (String)selectFields, (QFilter[])filters);
        if (userArr == null || userArr.length == 0) {
            return new ArrayList<Map<Long, Long>>(0);
        }
        Date today = Utils.getDate((int)0);
        ArrayList<Map<Long, Long>> oldDirectorList = new ArrayList<Map<Long, Long>>(userArr.length);
        for (DynamicObject userHistory : userArr) {
            DynamicObject user;
            DynamicObject org = userHistory.getDynamicObject("org");
            if (org == null || (user = userHistory.getDynamicObject("user")) == null) continue;
            Date startDate = userHistory.getDate("startdate");
            if (startDate != null && startDate.compareTo(today) > 0) {
                userHistory.set("startdate", (Object)today);
            }
            userHistory.set("enddate", (Object)today);
            HashMap<Long, Long> orgUserMap = new HashMap<Long, Long>(1);
            orgUserMap.put(org.getLong("id"), user.getLong("id"));
            oldDirectorList.add(orgUserMap);
        }
        SaveServiceHelper.save((DynamicObject[])userArr);
        return oldDirectorList;
    }

    public static void saveUserDeleteHistory(List<Long> userIds) {
        if (CollectionUtils.isEmpty(userIds)) {
            return;
        }
        logger.info("\u4fdd\u5b58\u4eba\u5458\u5220\u9664\u5386\u53f2\uff1a" + userIds.size());
        ThreadPools.executeOnceIncludeRequestContext((String)"saveUserDeleteHistory", () -> BaseBatchHandler.handle(userIds, batchList -> UserHistoryUtils.updateUserHistory(batchList, Utils.getDate((int)0))));
    }

    public static DynamicObject[] genUserHistoryObject(List<Long> userIds) {
        if (Utils.isListEmpty(userIds)) {
            return new DynamicObject[0];
        }
        DynamicObject userType = BusinessDataServiceHelper.newDynamicObject((String)"bos_user");
        DynamicObject[] userArr = (DynamicObject[])BusinessDataServiceHelper.load((Object[])userIds.toArray(new Object[userIds.size()]), (IDataEntityType)userType.getDataEntityType());
        if (userArr == null || userArr.length == 0) {
            return new DynamicObject[0];
        }
        return UserHistoryUtils.copyUserToHistory(userArr, userIds);
    }

    public static DynamicObject[] copyUserToHistory(DynamicObject[] userArr, List<Long> userIds) {
        return UserHistoryUtils.copyUserToHistory(userArr, true);
    }

    private static DynamicObject[] copyUserToHistory(DynamicObject[] userArr, boolean includeExtendProp) {
        Date today = Utils.getDate((int)0);
        Date endDate = Utils.getEndDate();
        HashMap<String, String> transKeyMap = new HashMap<String, String>(1);
        transKeyMap.put("id", "user");
        DynamicObject[] userHistoryArr = new DynamicObject[userArr.length];
        int index = 0;
        long curUserId = RequestContext.get().getCurrUserId();
        Date curTime = Calendar.getInstance().getTime();
        DynamicObjectType dynamicObjectType = DynamicObjectUtils.getDynamicObjectType("bos_user_history", includeExtendProp);
        for (DynamicObject user : userArr) {
            DynamicObject userHistory = new DynamicObject(dynamicObjectType);
            DynamicObjectUtils.copy(user, userHistory, transKeyMap);
            userHistory.set("creator", (Object)curUserId);
            userHistory.set("createtime", (Object)curTime);
            userHistory.set("modifier", (Object)curUserId);
            userHistory.set("modifytime", (Object)curTime);
            userHistory.set("startdate", (Object)today);
            userHistory.set("enddate", (Object)endDate);
            userHistoryArr[index++] = userHistory;
        }
        return userHistoryArr;
    }

    private static List<Long> updateUserHistory(List<Long> userIds, Date today) {
        String selectFields = "id,user,startdate,enddate,modifier,modifytime";
        QFilter userFilter = new QFilter("user", "in", userIds);
        QFilter startDateFilter = new QFilter("startdate", "<=", (Object)today);
        QFilter endDateFilter = new QFilter("enddate", ">=", (Object)today);
        QFilter[] filters = new QFilter[]{userFilter, startDateFilter, endDateFilter};
        DynamicObject[] userArr = BusinessDataServiceHelper.load((String)"bos_user_history", (String)selectFields, (QFilter[])filters);
        if (userArr == null || userArr.length == 0) {
            return new ArrayList<Long>(0);
        }
        ArrayList<Long> oldUserIds = new ArrayList<Long>(userArr.length);
        long curUserId = RequestContext.get().getCurrUserId();
        Date curTime = Calendar.getInstance().getTime();
        for (DynamicObject userHistory : userArr) {
            userHistory.set("modifier", (Object)curUserId);
            userHistory.set("modifytime", (Object)curTime);
            Date startDate = userHistory.getDate("startdate");
            if (startDate != null && startDate.compareTo(today) > 0) {
                userHistory.set("startdate", (Object)today);
            }
            userHistory.set("enddate", (Object)today);
            oldUserIds.add(userHistory.getLong("user"));
        }
        SaveServiceHelper.save((DynamicObject[])userArr);
        return oldUserIds;
    }
}

