/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.org.manager;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.org.utils.Utils;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import kd.bos.servicehelper.org.OrgUnitServiceHelper;

public class OrgLeafUtils {
    private static final Log log = LogFactory.getLog(OrgLeafUtils.class);

    public static void updateParentOrgLeaf(List<Long> orgIds) {
        OrgLeafUtils.updateParentOrgLeaf(OrgLeafUtils.getParentViewMapByOrgId(orgIds));
    }

    public static void updateParentOrgLeaf(Map<String, List<Long>> viewOrgMap) {
        if (viewOrgMap == null || viewOrgMap.isEmpty()) {
            log.info("\u53c2\u6570\u4e0d\u80fd\u4e3a\u7a7a");
            return;
        }
        QFilter filter = OrgLeafUtils.genParentViewFilter(viewOrgMap);
        if (filter == null) {
            log.info("\u8fc7\u6ee4\u4e0d\u80fd\u6761\u4ef6\u4e3a\u7a7a");
            return;
        }
        String selectFields = "id,view.number view,parent";
        QFilter[] filters = new QFilter[]{filter};
        DynamicObjectCollection subOrgCol = QueryServiceHelper.query((String)"bos_org_structure", (String)selectFields, (QFilter[])filters);
        if (Utils.isListEmpty((List)subOrgCol)) {
            OrgLeafUtils.updateOrgLeaf(OrgLeafUtils.genOrgViewFilter(viewOrgMap), true);
            return;
        }
        Map<String, List<Long>> hasSubOrgMap = OrgLeafUtils.getHasSubOrgMap(viewOrgMap, subOrgCol);
        OrgLeafUtils.updateOrgLeaf(OrgLeafUtils.genOrgViewFilter(hasSubOrgMap), false);
        OrgLeafUtils.updateOrgLeaf(OrgLeafUtils.genOrgViewFilter(viewOrgMap), true);
    }

    public static void updateOrgLeaf(QFilter filter, boolean isLeaf) {
        if (filter == null) {
            log.info("\u53c2\u6570\u4e0d\u80fd\u4e3a\u7a7a");
            return;
        }
        String selectProperties = "id,org,view,isleaf,isctrlunit,isstatsum,isbizunit";
        QFilter[] filters = new QFilter[]{filter};
        DynamicObject[] orgArr = BusinessDataServiceHelper.load((String)"bos_org_structure", (String)selectProperties, (QFilter[])filters);
        if (orgArr == null || orgArr.length == 0) {
            return;
        }
        boolean isChanged = false;
        for (DynamicObject org : orgArr) {
            if (isLeaf == org.getBoolean("isleaf")) continue;
            isChanged = true;
            OrgLeafUtils.genLeafOrgObj(org, isLeaf);
        }
        if (isChanged) {
            SaveServiceHelper.save((DynamicObject[])orgArr);
        }
    }

    private static void genLeafOrgObj(DynamicObject org, boolean isLeaf) {
        org.set("isleaf", (Object)isLeaf);
        DynamicObject viewObj = org.getDynamicObject("view");
        String treeType = viewObj.getString("treetype");
        if ("16".equals(treeType)) {
            DynamicObject orgObj = org.getDynamicObject("org");
            if (orgObj != null && OrgUnitServiceHelper.getRootOrgId() == orgObj.getLong("id") || !isLeaf) {
                org.set("isctrlunit", (Object)Boolean.TRUE);
            } else {
                org.set("isctrlunit", (Object)Boolean.FALSE);
            }
        } else {
            org.set("isctrlunit", (Object)Boolean.TRUE);
        }
        org.set("isstatsum", (Object)(!isLeaf ? 1 : 0));
        org.set("isbizunit", (Object)isLeaf);
    }

    public static QFilter genParentViewFilter(Map<String, List<Long>> viewOrgMap) {
        return OrgLeafUtils.genFilter(viewOrgMap, "parent");
    }

    public static QFilter genOrgViewFilter(Map<String, List<Long>> viewOrgMap) {
        return OrgLeafUtils.genFilter(viewOrgMap, "org");
    }

    public static Map<String, List<Long>> getParentViewMapByOrgId(List<Long> orgIds) {
        String selectFields = "id,view.treetype view,parent";
        QFilter orgFilter = new QFilter("org", "in", orgIds);
        QFilter[] filters = new QFilter[]{orgFilter};
        DynamicObjectCollection orgCol = QueryServiceHelper.query((String)"bos_org_structure", (String)selectFields, (QFilter[])filters);
        if (Utils.isListEmpty((List)orgCol)) {
            return new HashMap<String, List<Long>>(0);
        }
        HashMap<String, List<Long>> viewOrgMap = new HashMap<String, List<Long>>(orgCol.size());
        for (DynamicObject org : orgCol) {
            long parentId;
            String view = org.getString("view");
            ArrayList<Long> parentIds = (ArrayList<Long>)viewOrgMap.get(view);
            if (parentIds == null) {
                parentIds = new ArrayList<Long>();
                viewOrgMap.put(view, parentIds);
            }
            if (parentIds.contains(parentId = org.getLong("parent"))) continue;
            parentIds.add(parentId);
        }
        return viewOrgMap;
    }

    private static QFilter genFilter(Map<String, List<Long>> viewOrgMap, String fieldName) {
        QFilter filter = null;
        if (viewOrgMap.isEmpty()) {
            return filter;
        }
        for (Map.Entry<String, List<Long>> entry : viewOrgMap.entrySet()) {
            List<Long> orgIds;
            String orgViewType = entry.getKey();
            if (StringUtils.isBlank((CharSequence)orgViewType) || Utils.isListEmpty(orgIds = entry.getValue())) continue;
            QFilter viewFilter = new QFilter("view.number", "=", (Object)orgViewType);
            QFilter orgFilter = new QFilter(fieldName, "in", orgIds);
            viewFilter = viewFilter.and(orgFilter);
            if (filter == null) {
                filter = viewFilter;
                continue;
            }
            filter = filter.or(viewFilter);
        }
        return filter;
    }

    private static Map<String, List<Long>> getHasSubOrgMap(Map<String, List<Long>> viewOrgMap, DynamicObjectCollection subOrgCol) {
        HashMap<String, List<Long>> hasSubOrgMap = new HashMap<String, List<Long>>(subOrgCol.size());
        for (DynamicObject subOrg : subOrgCol) {
            List<Long> orgIds;
            String orgViewType = subOrg.getString("view");
            long parentId = subOrg.getLong("parent");
            ArrayList<Long> parentIds = (ArrayList<Long>)hasSubOrgMap.get(orgViewType);
            if (parentIds == null) {
                parentIds = new ArrayList<Long>();
                hasSubOrgMap.put(orgViewType, parentIds);
            }
            if (!parentIds.contains(parentId)) {
                parentIds.add(parentId);
            }
            if (Utils.isListEmpty(orgIds = viewOrgMap.get(orgViewType))) {
                viewOrgMap.remove(orgViewType);
                continue;
            }
            ArrayList<Long> tempOrgIds = new ArrayList<Long>(orgIds);
            viewOrgMap.put(orgViewType, tempOrgIds);
            tempOrgIds.remove(parentId);
        }
        return hasSubOrgMap;
    }
}

