/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.org.model;

import java.util.ArrayList;
import java.util.List;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.datamodel.ITreeModel;
import kd.bos.entity.tree.TreeNode;
import kd.bos.form.IFormView;
import kd.bos.form.IPageCache;
import kd.bos.form.control.TreeView;
import kd.bos.list.ITreeListView;
import kd.bos.mvc.list.ListView;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.sdk.annotation.SdkPublic;

@SdkPublic
public class OrgTreeSearchParam {
    public static final String CACHE_KEY_SEARCH_NODES = "_searchNodes";
    public static final String CACHE_KEY_OLD_SEARCH_TEXT = "_oldSearchText";
    public static final String CACHE_KEY_OLD_VIEW_SCHEMA = "_oldSearchViewSchema";
    public static final String CACHE_KEY_PARENTID = "_parentIdCacheKey";
    public static final String CACHE_KEY_RESULT_TOTAL = "_resultTotalCacheKey";
    private boolean searchById;
    private String searchText;
    private IFormView formView;
    private TreeView treeView;
    private ITreeModel treeModel;
    private String rootNodeCacheKey;
    private String orgViewNumber;
    private List<Long> orgRangeList;
    private List<QFilter> orgFilterList = new ArrayList<QFilter>();
    @Deprecated
    private List<QFilter> orgStructureFilterList = new ArrayList<QFilter>();
    private boolean clickNode;
    private IPageCache pageCache;
    private TreeNode rootNode;
    private boolean queryBeforeExpend;
    private final List<String> checkNodeIds = new ArrayList<String>();

    public OrgTreeSearchParam(String searchText, ListView listView, String orgViewNumber) {
        this.searchText = searchText;
        this.formView = listView;
        this.orgViewNumber = orgViewNumber;
        this.initParam(listView);
    }

    public OrgTreeSearchParam(String searchText, IFormView formView, TreeView treeView, String rootNodeCacheKey, String orgViewNumber) {
        this.searchText = searchText;
        this.formView = formView;
        this.treeView = treeView;
        this.rootNodeCacheKey = rootNodeCacheKey;
        if (formView != null) {
            this.pageCache = formView.getPageCache();
        }
        this.orgViewNumber = orgViewNumber;
    }

    public OrgTreeSearchParam(String searchText, IFormView formView, TreeView treeView, String rootNodeCacheKey, long orgViewSchemaId) {
        this.searchText = searchText;
        this.formView = formView;
        this.treeView = treeView;
        this.rootNodeCacheKey = rootNodeCacheKey;
        if (formView != null) {
            this.pageCache = formView.getPageCache();
        }
        this.initParam(orgViewSchemaId);
    }

    public OrgTreeSearchParam(String searchText, IFormView formView, TreeView treeView, TreeNode rootNode, long orgViewSchemaId) {
        this.searchText = searchText;
        this.formView = formView;
        this.treeView = treeView;
        this.rootNode = rootNode;
        if (formView != null) {
            this.pageCache = formView.getPageCache();
        }
        this.initParam(orgViewSchemaId);
    }

    private void initParam(ListView listView) {
        if (listView != null) {
            this.pageCache = listView.getPageCache();
            ITreeListView treeListView = listView.getTreeListView();
            if (treeListView != null) {
                if (this.treeView == null) {
                    this.treeView = treeListView.getTreeView();
                }
                this.treeModel = treeListView.getTreeModel();
            }
        }
    }

    private void initParam(long orgViewSchemaId) {
        DynamicObject viewObj = null;
        if (orgViewSchemaId > 0L) {
            viewObj = BusinessDataServiceHelper.loadSingleFromCache((Object)orgViewSchemaId, (String)"bos_org_viewschema", (String)"number");
        }
        this.orgViewNumber = viewObj == null ? "15" : viewObj.getString("number");
    }

    public boolean isSearchById() {
        return this.searchById;
    }

    public void setSearchById(boolean searchById) {
        this.searchById = searchById;
    }

    public String getSearchText() {
        return this.searchText;
    }

    public void setSearchText(String searchText) {
        this.searchText = searchText;
    }

    public IFormView getFormView() {
        return this.formView;
    }

    public void setFormView(IFormView formView) {
        this.formView = formView;
    }

    public TreeView getTreeView() {
        return this.treeView;
    }

    public void setTreeView(TreeView treeView) {
        this.treeView = treeView;
    }

    public String getRootNodeCacheKey() {
        return this.rootNodeCacheKey;
    }

    public void setRootNodeCacheKey(String rootNodeCacheKey) {
        this.rootNodeCacheKey = rootNodeCacheKey;
    }

    public TreeNode getRootNode() {
        if (this.treeModel != null) {
            return this.treeModel.getRoot();
        }
        if (StringUtils.isBlank((CharSequence)this.rootNodeCacheKey)) {
            return this.rootNode;
        }
        String rootNodeCache = this.getPageCache().get(this.rootNodeCacheKey);
        if (StringUtils.isNotBlank((CharSequence)rootNodeCache)) {
            return (TreeNode)SerializationUtils.fromJsonString((String)rootNodeCache, TreeNode.class);
        }
        return null;
    }

    public String getOrgViewNumber() {
        return this.orgViewNumber;
    }

    public void setOrgViewNumber(String orgViewNumber) {
        this.orgViewNumber = orgViewNumber;
    }

    public List<Long> getOrgRangeList() {
        return this.orgRangeList;
    }

    public void setOrgRangeList(List<Long> orgRangeList) {
        this.orgRangeList = orgRangeList;
    }

    public List<QFilter> getOrgFilterList() {
        return this.orgFilterList;
    }

    public void setOrgFilterList(List<QFilter> orgFilterList) {
        this.orgFilterList = orgFilterList;
    }

    @Deprecated
    public List<QFilter> getOrgStructureFilterList() {
        return this.orgStructureFilterList;
    }

    @Deprecated
    public void setOrgStructureFilterList(List<QFilter> orgStructureFilterList) {
        this.orgStructureFilterList = orgStructureFilterList;
    }

    public boolean isClickNode() {
        return this.clickNode;
    }

    public void setClickNode(boolean clickNode) {
        this.clickNode = clickNode;
    }

    public IPageCache getPageCache() {
        return this.pageCache;
    }

    public void setPageCache(IPageCache pageCache) {
        this.pageCache = pageCache;
    }

    public boolean isQueryBeforeExpend() {
        return this.queryBeforeExpend;
    }

    public void setQueryBeforeExpend(boolean queryBeforeExpend) {
        this.queryBeforeExpend = queryBeforeExpend;
    }

    public List<String> getCheckNodeIds() {
        return this.checkNodeIds;
    }
}

