/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.org.opplugin;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import kd.bos.base.utils.BaseUtils;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.entity.ILocaleString;
import kd.bos.dataentity.entity.LocaleString;
import kd.bos.dataentity.metadata.dynamicobject.DynamicObjectType;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.operate.result.IOperateInfo;
import kd.bos.entity.operate.result.OperationResult;
import kd.bos.entity.plugin.AddValidatorsEventArgs;
import kd.bos.entity.plugin.args.EndOperationTransactionArgs;
import kd.bos.entity.plugin.args.ReturnOperationArgs;
import kd.bos.entity.property.BasedataProp;
import kd.bos.entity.validate.AbstractValidator;
import kd.bos.org.opplugin.AbstractOrgOpPlugin;
import kd.bos.org.opplugin.change.OrgChangeOpBaseValidator;
import kd.bos.org.opplugin.common.OrgOpCheckerValidator;
import kd.bos.org.utils.OrgChangeType;
import kd.bos.org.utils.TaskStatus;
import kd.bos.orm.ORM;
import kd.bos.orm.query.QFilter;
import kd.bos.orm.util.CollectionUtils;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.operation.DeleteServiceHelper;
import kd.bos.servicehelper.operation.OperationServiceHelper;
import kd.bos.servicehelper.workflow.MessageCenterServiceHelper;
import kd.bos.workflow.engine.msg.info.MessageInfo;

public abstract class AbstractOrgChangeOpPlugin
extends AbstractOrgOpPlugin {
    protected Map<Long, Map<Long, Long>> orgBizHandoverMap = new HashMap<Long, Map<Long, Long>>(64);
    protected Map<Long, Map<Long, Long>> validBizOrgHandoverMap = new HashMap<Long, Map<Long, Long>>(64);
    private long changRecordId;
    protected final Map<Long, Map<Long, Set<String>>> orgViewErrorMap = new HashMap<Long, Map<Long, Set<String>>>(64);

    protected abstract OrgChangeType getOrgChangeType();

    public final void onAddValidators(AddValidatorsEventArgs e) {
        e.addValidator((AbstractValidator)new OrgChangeOpBaseValidator(this.orgOpContext, this.getOrgChangeType(), this.orgBizHandoverMap));
        this.onAddOrgValidators(e);
        e.addValidator((AbstractValidator)new OrgOpCheckerValidator(this.orgOpContext, this.getOrgChangeType(), this.orgViewErrorMap));
    }

    @Override
    public void initializeOperationResult(OperationResult result) {
        super.initializeOperationResult(result);
        String orgChangeRecordIdParam = this.orgOpContext.getOptionVariables().getOrDefault("orgChangeRecordId", "0");
        this.changRecordId = Long.parseLong(orgChangeRecordIdParam);
    }

    protected void onAddOrgValidators(AddValidatorsEventArgs e) {
    }

    @Override
    protected void endOrgOperationTransaction(EndOperationTransactionArgs e) {
        super.endOrgOperationTransaction(e);
        this.genChangRecordId();
    }

    private boolean genChangRecordId() {
        if (Objects.equals(this.changRecordId, 0L)) {
            this.changRecordId = ORM.create().genLongId("bos_org_changerecord");
            return true;
        }
        return false;
    }

    @Override
    protected void addWorkflowEventParam(Map<String, Object> workflowEventParam) {
        workflowEventParam.put("orgChangeRecordId", this.changRecordId);
    }

    public void onReturnOperation(ReturnOperationArgs e) {
        this.parseOperationError();
        this.saveChangeRecord();
        this.getOption().setVariableValue("orgChangeRecordId", Long.toString(this.changRecordId));
    }

    private void saveChangeRecord() {
        DynamicObject changeObject;
        DynamicObject dynamicObject = changeObject = this.genChangRecordId() ? null : BusinessDataServiceHelper.loadSingleFromCache((Object)this.changRecordId, (String)"bos_org_changerecord");
        if (changeObject == null) {
            changeObject = BusinessDataServiceHelper.newDynamicObject((String)"bos_org_changerecord");
            changeObject.set("id", (Object)this.changRecordId);
        }
        changeObject.set("changetype", (Object)this.getOrgChangeType().getChangeType());
        DynamicObjectCollection detailCol = changeObject.getDynamicObjectCollection("entryentity");
        this.genExistEntryResult(detailCol);
        this.genAddNewEntryResult(detailCol);
        this.modifyChangRecord(changeObject);
        this.convertResult(changeObject);
        OperationResult operationResult = OperationServiceHelper.executeOperate((String)"save", (String)"bos_org_changerecord", (DynamicObject[])new DynamicObject[]{changeObject}, null);
        String operationResultError = BaseUtils.getOperationResultError(operationResult, true);
        if (StringUtils.isBlank((CharSequence)operationResultError)) {
            if (!this.validBizOrgHandoverMap.isEmpty()) {
                this.deleteHandoverOrg();
                this.addNewHandoverOrg();
            }
        } else {
            changeObject.set("executionstatus", (Object)TaskStatus.F);
            changeObject.set("result", (Object)operationResultError);
            logger.info("\u6267\u884c\u7ec4\u7ec7\u53d8\u66f4\u8bb0\u5f55\u4fdd\u5b58\u5931\u8d25\uff1a" + operationResultError);
        }
        this.sendChangeRecordMessage(changeObject);
    }

    private void convertResult(DynamicObject changeObject) {
        if (this.isSuccessStatus(changeObject)) {
            changeObject.set("executionstatus", (Object)TaskStatus.C);
        }
        DynamicObjectCollection detailCol = changeObject.getDynamicObjectCollection("entryentity");
        int total = detailCol.size();
        changeObject.set("totalcount", (Object)total);
        int successCount = 0;
        for (DynamicObject entryObject : detailCol) {
            if (!Objects.equals(TaskStatus.D.toString(), entryObject.getString("detailstatus"))) continue;
            ++successCount;
        }
        changeObject.set("successcount", (Object)successCount);
        changeObject.set("failcount", (Object)(total - successCount));
    }

    protected void modifyChangRecord(DynamicObject changeObject) {
    }

    private void deleteHandoverOrg() {
        for (Map.Entry<Long, Map<Long, Long>> entry : this.validBizOrgHandoverMap.entrySet()) {
            QFilter bizFilter = new QFilter("biz", "=", (Object)entry.getKey());
            QFilter orgFilter = new QFilter("org", "in", entry.getValue().keySet());
            QFilter[] filters = new QFilter[]{bizFilter, orgFilter};
            DeleteServiceHelper.delete((String)"bos_org_handover", (QFilter[])filters);
        }
    }

    protected void addNewHandoverOrg() {
    }

    private boolean isSuccessStatus(DynamicObject changeObject) {
        Object status = changeObject.get("executionstatus");
        return Objects.isNull(status) || TaskStatus.A.name().equals(status) || TaskStatus.B.name().equals(status) || TaskStatus.C.name().equals(status);
    }

    private void parseOperationError() {
        OperationResult operationResult = this.getOperationResult();
        List errorInfoList = operationResult.getAllErrorOrValidateInfo();
        if (CollectionUtils.isEmpty((Collection)errorInfoList)) {
            return;
        }
        for (IOperateInfo info : errorInfoList) {
            String msg = info.getMessage();
            Object pk = info.getPkValue();
            if (!(pk instanceof Long)) continue;
            Map<Long, Set<String>> viewErrorMap = this.orgViewErrorMap.get(pk);
            boolean isViewError = false;
            if (viewErrorMap == null) {
                viewErrorMap = new HashMap<Long, Set<String>>(64);
                this.orgViewErrorMap.put((Long)pk, viewErrorMap);
            } else {
                for (Map.Entry<Long, Set<String>> viewEntry : viewErrorMap.entrySet()) {
                    if (!viewEntry.getValue().contains(msg)) continue;
                    isViewError = true;
                    break;
                }
            }
            if (isViewError) continue;
            viewErrorMap.computeIfAbsent(0L, v -> new LinkedHashSet(errorInfoList.size())).add(msg);
        }
    }

    private void genExistEntryResult(DynamicObjectCollection detailCol) {
        for (DynamicObject entryObject : detailCol) {
            Long handoverOrgId;
            DynamicObject orgObj = entryObject.getDynamicObject("org");
            if (orgObj == null) continue;
            long orgId = orgObj.getLong("id");
            Map<Long, Long> bizHandoverOrgMap = this.orgBizHandoverMap.get(orgObj.getPkValue());
            if (bizHandoverOrgMap == null) continue;
            long bizId = 0L;
            DynamicObject bizObj = entryObject.getDynamicObject("biz");
            if (bizObj != null) {
                bizId = bizObj.getLong("id");
            }
            if ((handoverOrgId = bizHandoverOrgMap.remove(bizId)) != null) {
                this.genChangeRecordResult(orgId, entryObject, handoverOrgId);
            }
            if (!bizHandoverOrgMap.isEmpty()) continue;
            this.orgBizHandoverMap.remove(orgId);
        }
    }

    private void genAddNewEntryResult(DynamicObjectCollection detailCol) {
        if (this.orgBizHandoverMap.isEmpty()) {
            return;
        }
        DynamicObjectType entryType = detailCol.getDynamicObjectType();
        BasedataProp orgProp = (BasedataProp)entryType.getProperty("org");
        BasedataProp bizProp = (BasedataProp)entryType.getProperty("biz");
        Map orgObjMap = BusinessDataServiceHelper.loadFromCache((Object[])this.orgBizHandoverMap.keySet().toArray(new Long[0]), (DynamicObjectType)((DynamicObjectType)orgProp.getComplexType()));
        for (Map.Entry<Long, Map<Long, Long>> orgEntry : this.orgBizHandoverMap.entrySet()) {
            Long orgId = orgEntry.getKey();
            DynamicObject orgObj = (DynamicObject)orgObjMap.get(orgId);
            if (orgObj == null) continue;
            Map<Long, Long> bizHandoverOrgMap = this.orgBizHandoverMap.get(orgObj.getPkValue());
            Map bizObjMap = BusinessDataServiceHelper.loadFromCache((Object[])bizHandoverOrgMap.keySet().toArray(new Long[0]), (DynamicObjectType)((DynamicObjectType)bizProp.getComplexType()));
            for (Map.Entry<Long, Long> bizEntry : bizHandoverOrgMap.entrySet()) {
                DynamicObject bizObj = (DynamicObject)bizObjMap.get(bizEntry.getKey());
                if (bizObj == null) continue;
                DynamicObject entryObject = detailCol.addNew();
                entryObject.set("org", (Object)orgObj);
                entryObject.set("biz", (Object)bizObj);
                this.genChangeRecordResult(orgId, entryObject, bizEntry.getValue());
            }
        }
    }

    protected void genChangeRecordResult(long orgId, DynamicObject entryObject, Long handoverOrgId) {
        StringBuilder entryError;
        long bizId = 0L;
        DynamicObject bizObj = entryObject.getDynamicObject("biz");
        if (bizObj != null) {
            bizId = bizObj.getLong("id");
        }
        if (StringUtils.isBlank((CharSequence)(entryError = this.getEntryError(orgId, entryObject)))) {
            entryObject.set("detailstatus", (Object)TaskStatus.D);
            if (!entryObject.getDataEntityState().getFromDatabase()) {
                entryObject.set("handoverorg", (Object)handoverOrgId);
            }
            if (!Objects.equals(bizId, 0L)) {
                Map orgHandoverMap = this.validBizOrgHandoverMap.computeIfAbsent(bizId, v -> new HashMap(64));
                orgHandoverMap.put(orgId, handoverOrgId);
            }
        } else {
            String errorMsg = entryError == null ? "" : entryError.toString();
            entryObject.set("detailstatus", (Object)TaskStatus.F);
            if (errorMsg.length() > 255) {
                errorMsg = errorMsg.substring(0, 255);
            }
            entryObject.set("detailresult", (Object)errorMsg);
        }
    }

    private StringBuilder getEntryError(long orgId, DynamicObject entryObject) {
        Map<Long, Set<String>> viewErrorMap = this.orgViewErrorMap.get(orgId);
        if (CollectionUtils.isEmpty(viewErrorMap)) {
            return null;
        }
        DynamicObject entryViewObj = entryObject.getDynamicObject("view");
        Set<String> errorList = entryViewObj == null ? this.getEntryErrorByBizId(entryObject, viewErrorMap) : viewErrorMap.get(entryViewObj.getLong("id"));
        if (CollectionUtils.isEmpty(errorList)) {
            errorList = viewErrorMap.get(0L);
        }
        if (CollectionUtils.isEmpty(errorList)) {
            errorList = new LinkedHashSet<String>(1);
            errorList.add(ResManager.loadKDString((String)"\u5f53\u524d\u804c\u80fd\u6821\u9a8c\u6210\u529f\uff0c\u4f46\u5904\u7406\u7ec8\u6b62\u3002\u539f\u56e0\uff1a\u8be5\u7ec4\u7ec7\u5b58\u5728\u5176\u5b83\u6821\u9a8c\u5931\u8d25\u7684\u804c\u80fd\u7c7b\u578b\u3002", (String)"AbstractOrgChangeOpPlugin_4", (String)"bos-org-common", (Object[])new Object[0]));
        }
        return this.getErrorList(errorList);
    }

    private Set<String> getEntryErrorByBizId(DynamicObject entryObject, Map<Long, Set<String>> viewErrorMap) {
        DynamicObject bizObj = entryObject.getDynamicObject("biz");
        if (bizObj == null) {
            return null;
        }
        List<DynamicObject> viewObjList = this.orgOpContext.getDataProvider().getViewDynamicObjectByBizId(bizObj.getLong("id"));
        LinkedHashSet<String> errorList = new LinkedHashSet<String>(viewObjList.size());
        for (DynamicObject viewObj : viewObjList) {
            Set<String> viewErrorList = viewErrorMap.get(viewObj.getLong("id"));
            if (viewErrorList == null) continue;
            errorList.addAll(viewErrorList);
        }
        return errorList;
    }

    private StringBuilder getErrorList(Set<String> errorList) {
        if (CollectionUtils.isEmpty(errorList)) {
            return null;
        }
        StringBuilder error = new StringBuilder();
        for (String errorMsg : errorList) {
            error.append(errorMsg);
        }
        return error;
    }

    private Map<String, Object> sendChangeRecordMessage(DynamicObject changeObject) {
        String sendMsg = this.getOption().getVariableValue("orgChangeSendMessageParam", Boolean.TRUE.toString());
        if (!Boolean.parseBoolean(sendMsg)) {
            return null;
        }
        ArrayList<MessageInfo> messageInfoList = new ArrayList<MessageInfo>(1);
        messageInfoList.add(this.genChangeRecordMessage(changeObject));
        return MessageCenterServiceHelper.batchSendMessages(messageInfoList);
    }

    private MessageInfo genChangeRecordMessage(DynamicObject changeObject) {
        MessageInfo messageInfo = new MessageInfo();
        messageInfo.setType("message");
        String title = ResManager.loadKDString((String)"\u7ec4\u7ec7\u53d8\u66f4\u5904\u7406\u901a\u77e5", (String)"AbstractOrgChangeOpPlugin_0", (String)"bos-org-common", (Object[])new Object[0]);
        messageInfo.setMessageTitle((ILocaleString)new LocaleString(title));
        messageInfo.setMessageTag((ILocaleString)new LocaleString(this.getOrgChangeType().getDesc()));
        StringBuilder content = new StringBuilder();
        String name = changeObject.getString("name");
        content.append(String.format(ResManager.loadKDString((String)"\u6267\u884c%1$s%2$s\u5b8c\u6210\u3002\u7ec4\u7ec7\u53d8\u66f4\u5355\u7f16\u7801\uff1a%3$s\u3002\u53d8\u66f4\u7684\u7ec4\u7ec7\u603b\u6570\uff1a%4$s\uff1b\u6210\u529f\u6570\u91cf\uff1a%5$s\uff1b\u5931\u8d25\u6570\u91cf\uff1a%6$s\u3002", (String)"AbstractOrgChangeOpPlugin_1", (String)"bos-org-common", (Object[])new Object[0]), name == null ? "" : name, this.getOrgChangeType().getDesc(), changeObject.getString("number"), changeObject.get("totalcount"), changeObject.get("successcount"), changeObject.get("failcount")));
        if (!TaskStatus.C.name().equals(changeObject.get("executionstatus"))) {
            content.append(String.format(ResManager.loadKDString((String)"\u5931\u8d25\u539f\u56e0\uff1a%s\u3002", (String)"AbstractOrgChangeOpPlugin_3", (String)"bos-org-common", (Object[])new Object[0]), changeObject.getString("result")));
        }
        messageInfo.setMessageContent((ILocaleString)new LocaleString(content.toString()));
        messageInfo.setSenderId(Long.valueOf(RequestContext.get().getCurrUserId()));
        ArrayList<Long> userIds = new ArrayList<Long>();
        userIds.add(changeObject.getLong("modifier_id"));
        messageInfo.setUserIds(userIds);
        messageInfo.setEntityNumber("bos_org_changerecord");
        messageInfo.setBizDataId(Long.valueOf(this.changRecordId));
        messageInfo.setNestEntityNumber("bos_org_changerecord");
        messageInfo.setNestBillId(Long.valueOf(this.changRecordId));
        messageInfo.setNestBillno(changeObject.getString("number"));
        return messageInfo;
    }
}

