/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.org.opplugin;

import java.util.HashMap;
import java.util.Map;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.entity.operate.result.OperationResult;
import kd.bos.entity.plugin.AbstractOperationServicePlugIn;
import kd.bos.entity.plugin.args.AfterOperationArgs;
import kd.bos.entity.plugin.args.EndOperationTransactionArgs;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.org.manager.CacheManager;
import kd.bos.org.opplugin.model.OrgChangeData;
import kd.bos.org.opplugin.model.OrgChangeDataProvider;
import kd.bos.org.opplugin.model.OrgOpContext;
import kd.bos.servicehelper.permission.PermissionServiceHelper;

public abstract class AbstractOrgOpPlugin
extends AbstractOperationServicePlugIn {
    protected static final Log logger = LogFactory.getLog(AbstractOrgOpPlugin.class);
    protected OrgOpContext orgOpContext = new OrgOpContext();

    public void initializeOperationResult(OperationResult result) {
        super.initializeOperationResult(result);
        this.setOptionVariables();
        this.orgOpContext.setOptionVariables(this.getOption().getVariables());
        this.orgOpContext.setOperationKey((String)this.operateMeta.get("key"));
        this.orgOpContext.isCompared();
        if (this.billEntityType == null) {
            this.orgOpContext.setFromAdminOrg(false);
        } else {
            this.orgOpContext.setFromAdminOrg("bos_adminorg".equals(this.billEntityType.getName()));
        }
    }

    private void setOptionVariables() {
        this.getOption().setVariableValue("orm_removeDataCache", "false");
    }

    public void endOperationTransaction(EndOperationTransactionArgs e) {
        this.endOrgOperationTransaction(e);
        Map<String, Object> workflowEventParam = this.getWorkflowEventParam(e.getDataEntities());
        this.addWorkflowEventParam(workflowEventParam);
        String becEventOperationParams = SerializationUtils.toJsonString(workflowEventParam);
        this.getOption().setVariableValue("becEventOperationParams", becEventOperationParams);
        logger.info("\u3010\u7ec4\u7ec7\u64cd\u4f5c\u3011\u53d8\u66f4\u4fe1\u606f\uff1a" + becEventOperationParams);
    }

    public final void afterExecuteOperationTransaction(AfterOperationArgs e) {
        try {
            DynamicObject[] dataEntities = e.getDataEntities();
            if (dataEntities == null || dataEntities.length == 0) {
                return;
            }
            this.afterOrgExecuteOperationTransaction(e);
        }
        catch (Exception ex) {
            logger.error("\u3010\u7ec4\u7ec7\u64cd\u4f5c\u3011\u53d1\u751f\u5f02\u5e38\uff1a", (Throwable)ex);
            throw ex;
        }
        finally {
            this.updateOrgCache();
        }
    }

    protected void afterOrgExecuteOperationTransaction(AfterOperationArgs e) {
    }

    protected void endOrgOperationTransaction(EndOperationTransactionArgs e) {
    }

    private void updateOrgCache() {
        CacheManager.removeCache("bos_org");
        CacheManager.removeCache("bos_org_structure");
        PermissionServiceHelper.clearAllCache();
    }

    protected void addWorkflowEventParam(Map<String, Object> workflowEventParam) {
    }

    private Map<String, Object> getWorkflowEventParam(DynamicObject[] dataEntities) {
        OrgChangeDataProvider contextChangeProvider = this.orgOpContext.getChangeDataProvider();
        OrgChangeDataProvider addNewChangeProvider = new OrgChangeDataProvider();
        OrgChangeDataProvider updateChangeProvider = new OrgChangeDataProvider();
        for (DynamicObject orgObj : dataEntities) {
            long id = orgObj.getLong("id");
            if (this.orgOpContext.getErrorIds().contains(id)) continue;
            if (contextChangeProvider.getAddNewOrgIds().contains(id)) {
                addNewChangeProvider.putOrgChangeData(id, "number", new OrgChangeData(orgObj.get("number"), orgObj.get("number")));
                addNewChangeProvider.putOrgChangeData(id, "name", new OrgChangeData(orgObj.get("name"), orgObj.get("name")));
                DynamicObjectCollection structureCol = orgObj.getDynamicObjectCollection("structure");
                for (DynamicObject structureObj : structureCol) {
                    DynamicObject viewObj = structureObj.getDynamicObject("view");
                    DynamicObject parentObj = structureObj.getDynamicObject("viewparent");
                    long parentId = parentObj == null ? 0L : parentObj.getLong("id");
                    addNewChangeProvider.putStructureChangeData(id, viewObj.getLong("id"), "viewparent", new OrgChangeData(parentId, parentId));
                }
                continue;
            }
            Map<String, Map<String, Map<Long, Map<String, OrgChangeData>>>> updateMap = contextChangeProvider.getData().get(id);
            if (updateMap == null) continue;
            updateChangeProvider.getData().put(id, updateMap);
        }
        HashMap<String, Object> params = new HashMap<String, Object>(2);
        params.put("add", addNewChangeProvider.getData());
        params.put("update", updateChangeProvider.getData());
        return params;
    }
}

