/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.org.opplugin;

import java.util.List;
import java.util.Map;
import kd.bos.base.utils.msg.OrgMessage;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.entity.ExtendedDataEntity;
import kd.bos.entity.validate.AbstractValidator;
import kd.bos.org.opplugin.model.OrgChangeData;
import kd.bos.org.opplugin.model.OrgOpContext;
import kd.bos.org.utils.OrgTreeOrder;
import kd.bos.orm.util.CollectionUtils;

public abstract class AbstractOrgOpValidator
extends AbstractValidator {
    protected OrgOpContext orgOpContext;

    public AbstractOrgOpValidator(OrgOpContext orgOpContext) {
        this.orgOpContext = orgOpContext;
        this.orgOpContext.setValidatorHandler((dataEntity, errorMsg) -> this.addOrgErrorMessage(dataEntity, errorMsg));
    }

    protected void addErrorMessage(ExtendedDataEntity dataEntity, String content) {
        super.addErrorMessage(dataEntity, content);
        DynamicObject orgObj = dataEntity.getDataEntity();
        long id = orgObj.getLong("id");
        this.orgOpContext.getErrorIds().add(id);
    }

    protected void addOrgErrorMessage(ExtendedDataEntity dataEntity, String content) {
        this.addOrgErrorMessage(dataEntity, content, true);
    }

    private void addOrgErrorMessage(ExtendedDataEntity dataEntity, String content, boolean checkRootChangeError) {
        this.addErrorMessage(dataEntity, content);
        DynamicObject orgObj = dataEntity.getDataEntity();
        long id = orgObj.getLong("id");
        if (!checkRootChangeError || !this.addChangeRootOrgErrorMessage(orgObj, id)) {
            this.addSubOrgErrorMessage(orgObj, id);
        }
    }

    private boolean addChangeRootOrgErrorMessage(DynamicObject orgObj, long id) {
        boolean isChangeRootOrgErrorMessage = false;
        List<OrgChangeData> rootChangeDataList = this.orgOpContext.getChangeDataProvider().getRootChangeDataList();
        for (OrgChangeData rootChangeData : rootChangeDataList) {
            if (id != (Long)rootChangeData.getOldValue() && id != (Long)rootChangeData.getNewValue()) continue;
            if (this.addChangeRootOrgErrorMessage(orgObj, this.orgOpContext.getDataEntityMap().get(rootChangeData.getNewValue()))) {
                isChangeRootOrgErrorMessage = true;
            }
            if (!this.addChangeRootOrgErrorMessage(orgObj, this.orgOpContext.getDataEntityMap().get(rootChangeData.getOldValue()))) continue;
            isChangeRootOrgErrorMessage = true;
        }
        return isChangeRootOrgErrorMessage;
    }

    private boolean addChangeRootOrgErrorMessage(DynamicObject orgObj, ExtendedDataEntity rootDataEntity) {
        if (rootDataEntity == null) {
            return false;
        }
        if (!this.orgOpContext.getErrorIds().contains(rootDataEntity.getDataEntity().getPkValue())) {
            String message = OrgMessage.getMessage("M00193", orgObj.getString("number"), orgObj.getString("name"));
            this.addOrgErrorMessage(rootDataEntity, message, false);
        }
        return true;
    }

    private void addSubOrgErrorMessage(DynamicObject orgObj, long id) {
        Map<Long, Map<Object, Map<String, Object>>> viewSortedOrgMap = this.orgOpContext.getViewSortedOrgMap();
        String message = null;
        block0: for (Map.Entry<Long, Map<Object, Map<String, Object>>> viewEntry : viewSortedOrgMap.entrySet()) {
            Map<Object, Map<String, Object>> sortedOrgMap = viewEntry.getValue();
            for (Map.Entry<Object, Map<String, Object>> orgEntry : sortedOrgMap.entrySet()) {
                Map<String, Object> orgMap = orgEntry.getValue();
                Map<String, Object> currentOrgMap = OrgTreeOrder.find(orgMap, id);
                if (CollectionUtils.isEmpty(currentOrgMap)) continue;
                message = message == null ? OrgMessage.getMessage("M00168", orgObj.getString("number"), orgObj.getString("name")) : message;
                this.addSubOrgErrorMessage((Map)currentOrgMap.get("children"), message);
                continue block0;
            }
        }
    }

    private void addSubOrgErrorMessage(Map<Object, Map<String, Object>> childrenMap, String content) {
        if (CollectionUtils.isEmpty(childrenMap)) {
            return;
        }
        for (Map.Entry<Object, Map<String, Object>> orgEntry : childrenMap.entrySet()) {
            Map<String, Object> orgMap = orgEntry.getValue();
            Object id = orgMap.get("id");
            if (!this.orgOpContext.getErrorIds().contains(id)) {
                this.addErrorMessage(this.orgOpContext.getDataEntityMap().get(id), content);
            }
            this.addSubOrgErrorMessage((Map)orgMap.get("children"), content);
        }
    }

    protected DynamicObject validateAdminOrgStructure(ExtendedDataEntity dataEntity) {
        DynamicObjectCollection structureObjCol = dataEntity.getDataEntity().getDynamicObjectCollection("structure");
        DynamicObject adminStructureObj = null;
        for (DynamicObject structureObj : structureObjCol) {
            DynamicObject viewObj = structureObj.getDynamicObject("view");
            if (viewObj == null || 1L != viewObj.getLong("id")) continue;
            adminStructureObj = structureObj;
            break;
        }
        if (adminStructureObj == null) {
            this.addErrorMessage(dataEntity, OrgMessage.getMessage("M00211"));
        }
        return adminStructureObj;
    }
}

