/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.org.opplugin;

import java.util.HashMap;
import java.util.Map;
import kd.bos.base.utils.msg.BaseMessage;
import kd.bos.base.utils.msg.OrgMessage;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.entity.ILocaleString;
import kd.bos.dataentity.entity.LocaleString;
import kd.bos.dataentity.utils.ObjectUtils;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.ExtendedDataEntity;
import kd.bos.entity.property.TextProp;
import kd.bos.exception.KDBizException;
import kd.bos.org.opplugin.model.OrgChangeData;
import kd.bos.org.opplugin.model.OrgOpContext;
import kd.bos.org.utils.OrgViewUtils;
import kd.bos.org.utils.Utils;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.org.OrgUnitServiceHelper;

public class OrgOperationUtils {
    public static final long ALL_VIEW_ID = 0L;
    public static final String DELETE_DUTY = "deleteduty";
    public static final int GENERAL_INIT_SIZE = 64;
    public static final String KEY_FROM_ADMINORG_STRUCTURE_LIST = "_from_adminorg_structure_list_";
    public static final String ORIGINAL_CHECKED_PARENT_VIEW = "originalCheckedParentView";
    private static final String ORG_SELECT_FIELDS = "id,enable,status,startdate,enddate,fyzjorgid,structure.view,structure.vieworg,structure.yzjorgid,structure.viewparent,structure.yzjparentorgid,structure.isctrlunit,structure.isstatsum,structure.isleaf,structure.level,structure.longnumber,structure.fullname,structure.isfreeze,structure.sortcode,structure.sortnumber,structure.isbizunit,structure.viewstartdate,structure.viewenddate,structure.viewenable,structure.viewstatus,structure.seq,structure.yzjorgid,structure.yzjparentorgid";

    private OrgOperationUtils() {
    }

    public static DynamicObject[] getOrgObject(QFilter[] filters) {
        return OrgOperationUtils.getOrderOrgObject(filters, "");
    }

    public static DynamicObject[] getOrderOrgObject(QFilter[] filters) {
        return OrgOperationUtils.getOrderOrgObject(filters, "structure.level");
    }

    private static DynamicObject[] getOrderOrgObject(QFilter[] filters, String orderBy) {
        return BusinessDataServiceHelper.load((String)"bos_org", (String)ORG_SELECT_FIELDS, (QFilter[])filters, (String)orderBy);
    }

    public static void generateStructureEntry(DynamicObject orgObj, DynamicObject structureObj, Map<Long, DynamicObject> parentStructureMap, OrgOpContext orgOpContext) {
        if (orgObj == null || structureObj == null || parentStructureMap == null) {
            return;
        }
        DynamicObject viewObj = structureObj.getDynamicObject("view");
        if (viewObj == null) {
            return;
        }
        long id = orgObj.getLong("id");
        if (!parentStructureMap.containsKey(id)) {
            parentStructureMap.put(id, structureObj);
        }
        long parentId = 0L;
        DynamicObject parentObj = structureObj.getDynamicObject("viewparent");
        String yzjParentOrgId = "";
        if (parentObj != null) {
            parentId = parentObj.getLong("id");
            yzjParentOrgId = parentObj.getString("fyzjorgid");
        }
        if (parentId == orgObj.getLong("id")) {
            return;
        }
        structureObj.set("yzjorgid", orgObj.get("fyzjorgid"));
        structureObj.set("yzjparentorgid", (Object)yzjParentOrgId);
        DynamicObject parentStructObj = parentStructureMap.get(parentId);
        boolean isBDControl = "16".equals(viewObj.getString("treetype"));
        if (parentStructObj == null) {
            OrgOperationUtils.generateRootStructureEntry(parentId, structureObj, orgObj, viewObj, isBDControl, orgOpContext);
        } else {
            OrgOperationUtils.generateStructureEntry(orgObj, structureObj, parentStructObj, viewObj, parentId, isBDControl, orgOpContext);
        }
        OrgOperationUtils.generateStructureEntry(orgObj, structureObj);
    }

    private static void generateRootStructureEntry(long parentId, DynamicObject structureObj, DynamicObject orgObj, DynamicObject viewObj, boolean isBDControl, OrgOpContext orgOpContext) {
        if (parentId != 0L) {
            return;
        }
        structureObj.set("viewparent", null);
        structureObj.set("level", (Object)1);
        structureObj.set("longnumber", orgObj.get("number"));
        structureObj.set("fullname", orgObj.get("name"));
        OrgOperationUtils.setRootCtrlUnit(orgObj, structureObj, isBDControl, orgOpContext);
        OrgOperationUtils.setSortNumber(orgObj, structureObj, viewObj);
    }

    private static void generateStructureEntry(DynamicObject orgObj, DynamicObject structureObj, DynamicObject parentStructObj, DynamicObject viewObj, long parentId, boolean isBDControl, OrgOpContext orgOpContext) {
        OrgOperationUtils.setStructureLeaf(parentStructObj, Boolean.FALSE);
        OrgOperationUtils.setStructureParent(structureObj, parentStructObj, parentId);
        if (!isBDControl) {
            structureObj.set("isctrlunit", (Object)Boolean.TRUE);
        }
        structureObj.set("level", (Object)(parentStructObj.getInt("level") + 1));
        OrgOperationUtils.setSortCode(orgObj, structureObj, viewObj);
        OrgOperationUtils.generateLongNumber(orgObj, structureObj, parentStructObj, orgOpContext);
        OrgOperationUtils.generateFullName(orgObj, structureObj, parentStructObj, orgOpContext);
    }

    private static void generateLongNumber(DynamicObject orgObj, DynamicObject structureObj, DynamicObject parentStructObj, OrgOpContext orgOpContext) {
        DynamicObject viewObj = structureObj.getDynamicObject("view");
        if (viewObj == null) {
            return;
        }
        String longNumber = parentStructObj.get("longnumber") + "!" + orgObj.get("number");
        TextProp longNumberProp = (TextProp)structureObj.getDynamicObjectType().getProperty("longnumber");
        if (longNumber.length() > longNumberProp.getMaxLenth()) {
            String errorMsg = OrgMessage.getMessage("M00218", viewObj.getString("name"), longNumber.length(), longNumberProp.getMaxLenth());
            OrgOperationUtils.handleLengthError(errorMsg, orgObj, orgOpContext);
            return;
        }
        structureObj.set("longnumber", (Object)longNumber);
    }

    private static void generateFullName(DynamicObject orgObj, DynamicObject structureObj, DynamicObject parentStructObj, OrgOpContext orgOpContext) {
        DynamicObject viewObj = structureObj.getDynamicObject("view");
        if (viewObj == null) {
            return;
        }
        ILocaleString parentFullName = parentStructObj.getLocaleString("fullname");
        if (parentFullName == null) {
            return;
        }
        ILocaleString fullNameLocale = structureObj.getLocaleString("fullname");
        if (fullNameLocale == null) {
            fullNameLocale = new LocaleString();
        }
        String fullNameSep = orgOpContext == null ? OrgUnitServiceHelper.getOrgSeparation().getFullNameSep() : orgOpContext.getConfigProvider().getOrgSeparation().getFullNameSep();
        TextProp fullNameProp = (TextProp)structureObj.getDynamicObjectType().getProperty("fullname");
        boolean hasError = false;
        HashMap<String, String> fullNameMap = new HashMap<String, String>(parentFullName.size());
        int fullNameLength = 0;
        for (Map.Entry parentFullNameEntry : parentFullName.entrySet()) {
            String langKey = (String)parentFullNameEntry.getKey();
            ILocaleString name = orgObj.getLocaleString("name");
            if (name == null) continue;
            String fullName = (String)parentFullNameEntry.getValue() + fullNameSep + (String)name.get((Object)langKey);
            fullNameLength = fullName.length();
            if (fullNameLength > fullNameProp.getMaxLenth()) {
                hasError = true;
                break;
            }
            fullNameMap.put(langKey, fullName);
        }
        if (hasError) {
            String errorMsg = OrgMessage.getMessage("M00219", viewObj.getString("name"), fullNameLength, fullNameProp.getMaxLenth());
            OrgOperationUtils.handleLengthError(errorMsg, orgObj, orgOpContext);
        } else {
            fullNameLocale.putAll(fullNameMap);
            structureObj.set("fullname", (Object)fullNameLocale);
        }
    }

    private static void handleLengthError(String errorMsg, DynamicObject orgObj, OrgOpContext orgOpContext) {
        ExtendedDataEntity dataEntity = null;
        if (orgOpContext != null) {
            dataEntity = orgOpContext.getDataEntityMap().get(orgObj.getLong("id"));
        }
        if (dataEntity == null) {
            throw new KDBizException(orgObj.getString("number") + BaseMessage.getMessage("M00067") + errorMsg);
        }
        orgOpContext.getValidatorHandler().handle(dataEntity, errorMsg);
    }

    private static void setRootCtrlUnit(DynamicObject orgObj, DynamicObject structureObj, boolean isBDControl, OrgOpContext orgOpContext) {
        boolean isAutoSetCtrlUnit;
        if (structureObj.getBoolean("isctrlunit")) {
            return;
        }
        boolean bl = isAutoSetCtrlUnit = !isBDControl || !structureObj.getDataEntityState().getFromDatabase();
        if (!isAutoSetCtrlUnit && orgOpContext != null) {
            long viewId = structureObj.getDynamicObject("view").getLong("id");
            OrgChangeData ctrlChangeData = orgOpContext.getChangeDataProvider().getStructureProperty(orgObj.getLong("id"), viewId, "isctrlunit");
            if (ctrlChangeData == null || ((Boolean)ctrlChangeData.getNewValue()).booleanValue()) {
                isAutoSetCtrlUnit = true;
            }
        }
        if (isAutoSetCtrlUnit) {
            structureObj.set("isctrlunit", (Object)Boolean.TRUE);
        }
    }

    private static void setSortCode(DynamicObject orgObj, DynamicObject structureObj, DynamicObject viewObj) {
        if (structureObj.getDataEntityState().getFromDatabase()) {
            return;
        }
        OrgOperationUtils.setSortNumber(orgObj, structureObj, viewObj);
    }

    private static void setStructureParent(DynamicObject structureObj, DynamicObject parentStructObj, long parentId) {
        DynamicObject viewParentObj = structureObj.getDynamicObject("viewparent");
        DynamicObject parentStructOrgObj = parentStructObj.getDynamicObject("vieworg");
        if (viewParentObj == null) {
            structureObj.set("viewparent", (Object)parentStructOrgObj);
        } else if (parentStructOrgObj != null && parentId != parentStructOrgObj.getLong("id")) {
            structureObj.set("viewparent", (Object)parentStructOrgObj);
        }
    }

    private static void generateStructureEntry(DynamicObject orgObj, DynamicObject structureObj) {
        if (StringUtils.isBlank((Object)orgObj.get("enable"))) {
            orgObj.set("enable", (Object)"1");
        }
        if (StringUtils.isBlank((Object)orgObj.get("status"))) {
            orgObj.set("status", (Object)"C");
        }
        if (StringUtils.isBlank((Object)structureObj.get("viewenable"))) {
            structureObj.set("viewenable", (Object)"1");
        }
        if (StringUtils.isBlank((Object)structureObj.get("viewstatus"))) {
            structureObj.set("viewstatus", (Object)"C");
        }
        if (orgObj.get("startdate") == null) {
            orgObj.set("startdate", (Object)Utils.getDate((int)0));
        }
        if (structureObj.get("viewstartdate") == null) {
            structureObj.set("viewstartdate", (Object)Utils.getDate((int)0));
        }
        if (orgObj.get("enddate") == null) {
            orgObj.set("enddate", (Object)Utils.getEndDate());
        }
        if (structureObj.get("viewenddate") == null) {
            structureObj.set("viewenddate", (Object)Utils.getEndDate());
        }
    }

    public static void setSortNumber(DynamicObject orgObj, DynamicObject dynamicObject, DynamicObject viewObj) {
        if (orgObj == null || dynamicObject == null || viewObj == null) {
            return;
        }
        long viewId = viewObj.getLong("id");
        long defaultSortNumber = OrgOperationUtils.getDefaultSortNumber(orgObj, viewId);
        String sortCode = dynamicObject.getString("sortcode");
        long sortNumber = dynamicObject.getLong("sortnumber");
        if (sortNumber != 0L) {
            if (StringUtils.isBlank((CharSequence)sortCode)) {
                dynamicObject.set("sortcode", (Object)String.valueOf(sortNumber));
            }
            return;
        }
        if ((sortNumber = OrgOperationUtils.getHashSortNumber(sortCode, sortNumber)) != 0L) {
            dynamicObject.set("sortnumber", (Object)sortNumber);
            return;
        }
        long newSortCode = defaultSortNumber == 0L ? (long)OrgViewUtils.getNewOrgSortCode(dynamicObject.getInt("level")) : defaultSortNumber;
        dynamicObject.set("sortcode", (Object)newSortCode);
        dynamicObject.set("sortnumber", (Object)newSortCode);
    }

    private static long getDefaultSortNumber(DynamicObject orgObj, long viewId) {
        if (1L == viewId || 15L == viewId) {
            return 0L;
        }
        long defaultSortNumber = 0L;
        DynamicObjectCollection structureObjCol = orgObj.getDynamicObjectCollection("structure");
        for (DynamicObject orgUnitStructureObj : structureObjCol) {
            DynamicObject orgUnitViewObj = orgUnitStructureObj.getDynamicObject("view");
            if (orgUnitViewObj == null || 15L != orgUnitViewObj.getLong("id") || (defaultSortNumber = orgUnitStructureObj.getLong("sortnumber")) != 0L) continue;
            defaultSortNumber = OrgOperationUtils.getHashSortNumber(orgUnitStructureObj.get("sortcode"), defaultSortNumber);
        }
        return defaultSortNumber;
    }

    private static long getHashSortNumber(Object sortCode, long sortNumber) {
        if (!ObjectUtils.isEmpty((Object)sortCode) && (sortNumber = (long)sortCode.hashCode()) < 0L) {
            sortNumber = Math.abs(sortNumber);
        }
        return sortNumber;
    }

    public static void setStructureLeaf(DynamicObject structure, Boolean isLeaf) {
        structure.set("isleaf", (Object)isLeaf);
        structure.set("isbizunit", (Object)isLeaf);
        structure.set("isstatsum", (Object)(isLeaf == false ? 1 : 0));
    }
}

