/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.org.opplugin.change;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import kd.bos.base.utils.msg.OrgMessage;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.entity.ExtendedDataEntity;
import kd.bos.entity.validate.AbstractValidator;
import kd.bos.org.opplugin.model.OrgChangeData;
import kd.bos.org.opplugin.model.OrgOpContext;
import kd.bos.org.utils.OrgChangeType;
import kd.bos.org.utils.OrgUtils;
import kd.bos.orm.util.CollectionUtils;

public class OrgChangeOpBaseValidator
extends AbstractValidator {
    private final OrgOpContext orgOpContext;
    private final OrgChangeType orgChangeType;
    private final Map<Long, Map<Long, Long>> orgBizHandoverMap;

    public OrgChangeOpBaseValidator(OrgOpContext orgOpContext, OrgChangeType orgChangeType, Map<Long, Map<Long, Long>> orgBizHandoverMap) {
        this.orgOpContext = orgOpContext;
        this.orgChangeType = orgChangeType;
        this.orgBizHandoverMap = orgBizHandoverMap;
    }

    public void validate() {
        this.prepare();
        this.parseOptionVariables();
        this.bizValidate();
    }

    private void prepare() {
        for (ExtendedDataEntity dataEntity : this.dataEntities) {
            DynamicObject orgObj = dataEntity.getDataEntity();
            long orgId = orgObj.getLong("id");
            this.orgOpContext.getDataEntityMap().put(orgId, dataEntity);
        }
    }

    private void parseOptionVariables() {
        String orgChangeParam = this.orgOpContext.getOptionVariables().getOrDefault("orgChangeOperationParam", null);
        if (orgChangeParam == null) {
            return;
        }
        Map<String, DynamicObject> bizNumberMap = OrgUtils.getBizNumberMap();
        Map orgChangeParamMap = (Map)SerializationUtils.fromJsonString((String)orgChangeParam, Map.class);
        block0: for (Map.Entry entry : orgChangeParamMap.entrySet()) {
            Long orgId = Long.valueOf(entry.getKey().toString());
            ExtendedDataEntity dataEntity = this.orgOpContext.getDataEntityMap().get(orgId);
            if (dataEntity == null) continue;
            Map paramProMap = (Map)entry.getValue();
            Map bizHandoverOrgMap = this.orgBizHandoverMap.computeIfAbsent(orgId, v -> new HashMap(paramProMap.size()));
            for (Map.Entry bizEntry : paramProMap.entrySet()) {
                String bizNumber = bizEntry.getKey().toString();
                DynamicObject bizObj = bizNumberMap.get(bizNumber);
                if (bizObj == null) {
                    this.addErrorMessage(dataEntity, OrgMessage.getMessage("M00022", bizNumber));
                    continue block0;
                }
                long bizId = bizObj.getLong("id");
                Long handOverOrgId = Long.valueOf(bizEntry.getValue().toString());
                bizHandoverOrgMap.put(bizId, handOverOrgId);
            }
        }
    }

    private void bizValidate() {
        for (ExtendedDataEntity dataEntity : this.dataEntities) {
            DynamicObject orgObj = dataEntity.getDataEntity();
            if (orgObj.getDataEntityState().getFromDatabase()) {
                Map<Long, Long> bizHandoverOrgMap = this.getBizHandoverOrgMap(dataEntity);
                if (CollectionUtils.isEmpty(bizHandoverOrgMap)) continue;
                this.bizValidate(dataEntity, bizHandoverOrgMap);
                continue;
            }
            if (OrgChangeType.RESETROOT != this.orgChangeType) continue;
            Map bizMap = this.orgBizHandoverMap.computeIfAbsent(orgObj.getLong("id"), v -> new HashMap(1));
            bizMap.put(0L, 0L);
        }
    }

    private Map<Long, Long> getBizHandoverOrgMap(ExtendedDataEntity dataEntity) {
        DynamicObject orgObj = dataEntity.getDataEntity();
        long orgId = orgObj.getLong("id");
        Map bizHandoverOrgMap = this.orgBizHandoverMap.get(orgId);
        if (!CollectionUtils.isEmpty(bizHandoverOrgMap)) {
            return bizHandoverOrgMap;
        }
        DynamicObject orgBizObj = orgObj.getDynamicObject("orgbizfunction");
        if (orgBizObj == null) {
            this.addErrorMessage(dataEntity, OrgMessage.getMessage("M00001"));
        } else {
            bizHandoverOrgMap = this.orgBizHandoverMap.computeIfAbsent(orgId, v -> new HashMap(1));
            bizHandoverOrgMap.put(orgBizObj.getLong("id"), 0L);
        }
        return bizHandoverOrgMap;
    }

    private void bizValidate(ExtendedDataEntity dataEntity, Map<Long, Long> bizHandoverOrgMap) {
        DynamicObject orgObj = dataEntity.getDataEntity();
        long orgId = orgObj.getLong("id");
        DynamicObjectCollection structureObjCol = orgObj.getDynamicObjectCollection("structure");
        ArrayList<Long> existsBizIds = new ArrayList<Long>(structureObjCol.size());
        for (DynamicObject structureObj : structureObjCol) {
            DynamicObject bizObj;
            DynamicObject viewObj = structureObj.getDynamicObject("view");
            if (viewObj == null || (bizObj = viewObj.getDynamicObject("treetypeid")) == null) continue;
            long bizId = bizObj.getLong("id");
            existsBizIds.add(bizId);
            Long handoverOrgId = bizHandoverOrgMap.get(bizId);
            if (handoverOrgId == null) continue;
            this.changeData(orgId, viewObj, handoverOrgId);
        }
        for (Map.Entry<Long, Long> entry : bizHandoverOrgMap.entrySet()) {
            DynamicObject bizObj;
            if (existsBizIds.contains(entry.getKey()) || (bizObj = this.orgOpContext.getDataProvider().getBizMap().get(entry.getKey())) == null) continue;
            this.addErrorMessage(dataEntity, OrgMessage.getMessage("M00227", bizObj.getString("fname")));
        }
    }

    private void changeData(long orgId, DynamicObject viewObj, Long handoverOrgId) {
        Boolean isFreeze = null;
        if (this.orgChangeType == OrgChangeType.BIZFREEZE) {
            isFreeze = Boolean.TRUE;
        } else if (this.orgChangeType == OrgChangeType.BIZUNFREEZE) {
            isFreeze = Boolean.FALSE;
        }
        if (isFreeze == null) {
            return;
        }
        long viewId = viewObj.getLong("id");
        this.orgOpContext.getChangeDataProvider().modifyView(orgId, viewId, "isfreeze", new OrgChangeData(isFreeze == false, isFreeze), this.orgChangeType.getChangeType());
        if (isFreeze.booleanValue() && !Objects.equals(0L, handoverOrgId)) {
            this.orgOpContext.getChangeDataProvider().modifyView(orgId, viewId, "handoverOrgId", new OrgChangeData(0L, handoverOrgId), this.orgChangeType.getChangeType());
        }
    }
}

