/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.org.opplugin.common;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.metadata.IDataEntityType;
import kd.bos.dataentity.metadata.dynamicobject.DynamicObjectType;
import kd.bos.entity.property.BasedataProp;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.org.opplugin.model.OrgChangeData;
import kd.bos.org.opplugin.model.OrgChangeDataProvider;
import kd.bos.org.opplugin.model.OrgOpContext;
import kd.bos.org.utils.DynamicObjectUtils;
import kd.bos.org.utils.OrgTreeOrder;
import kd.bos.orm.ORM;
import kd.bos.orm.util.CollectionUtils;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.org.OrgUnitServiceHelper;

public class OrgComparator {
    private static final Log logger = LogFactory.getLog(OrgComparator.class);
    private final OrgOpContext orgOpContext;
    private final Map<Object, DynamicObject> sourceOrgMap;
    private final Collection<DynamicObject> targetOrgList;
    private OrgChangeDataProvider changeDataProvider;
    private List<Long> topNewOrgUnitIds;
    private long currentUserId;
    private Date currentDate;
    private Map<Long, Map<Long, DynamicObject>> findParentViewOrgObjMap;

    public OrgComparator(OrgOpContext orgOpContext, Map<Object, DynamicObject> sourceOrgMap, Collection<DynamicObject> targetOrgList) {
        this.orgOpContext = orgOpContext;
        this.sourceOrgMap = sourceOrgMap == null ? new HashMap() : sourceOrgMap;
        this.targetOrgList = targetOrgList == null ? new ArrayList() : targetOrgList;
    }

    public void compare() {
        if (CollectionUtils.isEmpty(this.targetOrgList)) {
            return;
        }
        this.init();
        int count = this.targetOrgList.size();
        ArrayList<Long> needLoadIds = new ArrayList<Long>(count);
        HashMap<Long, DynamicObject> fromDataBaseOrgMap = new HashMap<Long, DynamicObject>(count);
        ArrayList<DynamicObject> addNewOrgList = new ArrayList<DynamicObject>(count);
        ArrayList<DynamicObject> newStructureObjList = new ArrayList<DynamicObject>(count * 64);
        HashMap<DynamicObject, List<DynamicObject>> andNewViewOrgMap = new HashMap<DynamicObject, List<DynamicObject>>(count);
        IDataEntityType orgEntityType = null;
        DynamicObjectType orgDynamicObjectType = null;
        for (DynamicObject orgObj : this.targetOrgList) {
            boolean orgFromDatabase;
            long id = orgObj.getLong("id");
            if (orgEntityType == null) {
                orgEntityType = orgObj.getDataEntityType();
            }
            if (orgDynamicObjectType == null) {
                orgDynamicObjectType = orgObj.getDynamicObjectType();
            }
            if (orgFromDatabase = orgObj.getDataEntityState().getFromDatabase()) {
                fromDataBaseOrgMap.put(id, orgObj);
                if (!this.sourceOrgMap.containsKey(id)) {
                    needLoadIds.add(id);
                }
            } else {
                addNewOrgList.add(orgObj);
            }
            DynamicObjectCollection structureCol = orgObj.getDynamicObjectCollection("structure");
            HashMap<Long, DynamicObject> currentViewStructMap = new HashMap<Long, DynamicObject>(structureCol.size());
            int seq = 1;
            for (DynamicObject structureObj : structureCol) {
                if (!structureObj.getDataEntityState().getFromDatabase()) {
                    newStructureObjList.add(structureObj);
                }
                structureObj.set("seq", (Object)seq++);
                this.prepareViewOrg(orgObj, structureObj, andNewViewOrgMap);
                DynamicObject viewObj = structureObj.getDynamicObject("view");
                if (viewObj == null) continue;
                long viewId = viewObj.getLong("id");
                currentViewStructMap.put(viewId, structureObj);
            }
            Map<Long, DynamicObject> dbViewStructureMap = this.getDbViewStructureMap(orgFromDatabase, orgObj);
            newStructureObjList.addAll(this.addDefaultView(structureCol, dbViewStructureMap, currentViewStructMap));
        }
        this.loadSourceOrg(needLoadIds, orgDynamicObjectType);
        this.prepareAddNewOrg(addNewOrgList, orgEntityType, andNewViewOrgMap);
        this.prepareAddNewStructure(newStructureObjList);
        this.compareFromDataBase(fromDataBaseOrgMap);
    }

    private void init() {
        this.changeDataProvider = this.orgOpContext.getChangeDataProvider();
        this.currentDate = new Date();
        this.currentUserId = RequestContext.get().getCurrUserId();
        this.findParentViewOrgObjMap = new HashMap<Long, Map<Long, DynamicObject>>(64);
    }

    private void loadSourceOrg(List<Long> ids, DynamicObjectType orgDynamicObjectType) {
        if (CollectionUtils.isEmpty(ids)) {
            return;
        }
        Map orgObjMap = BusinessDataServiceHelper.loadFromCache((Object[])ids.toArray(new Object[ids.size()]), (DynamicObjectType)orgDynamicObjectType);
        if (orgObjMap != null) {
            this.sourceOrgMap.putAll(orgObjMap);
        }
    }

    private void prepareViewOrg(DynamicObject orgObj, DynamicObject structureObj, Map<DynamicObject, List<DynamicObject>> emptyPkViewOrgMap) {
        if (structureObj.get("vieworg") != null) {
            return;
        }
        BasedataProp orgPro = (BasedataProp)structureObj.getDynamicObjectType().getProperty("vieworg");
        DynamicObject viewOrgObj = new DynamicObject((DynamicObjectType)orgPro.getComplexType());
        DynamicObjectUtils.copy(orgObj, viewOrgObj);
        long id = orgObj.getLong("id");
        if (id == 0L) {
            emptyPkViewOrgMap.computeIfAbsent(orgObj, k -> new ArrayList()).add(viewOrgObj);
        } else {
            viewOrgObj.set("id", (Object)id);
        }
        structureObj.set("vieworg", (Object)viewOrgObj);
    }

    private void prepareAddNewOrg(List<DynamicObject> emptyPkObjList, IDataEntityType orgEntityType, Map<DynamicObject, List<DynamicObject>> emptyViewOrgMap) {
        int size = emptyPkObjList.size();
        if (size == 0) {
            return;
        }
        logger.info("\u3010\u7ec4\u7ec7\u7ed3\u6784\u5206\u5f55\u6784\u5efa\u7c7b\u3011\u6267\u884c\u7ec4\u7ec7\u4e3b\u952e\u9884\u7f6e" + size);
        long[] ids = ORM.create().genLongIds(orgEntityType, size);
        for (int i = 0; i < size; ++i) {
            List<DynamicObject> viewObjList;
            DynamicObject orgObj = emptyPkObjList.get(i);
            long id = orgObj.getLong("id");
            if (id == 0L) {
                id = ids[i];
                orgObj.set("id", (Object)id);
            }
            this.changeDataProvider.getAddNewOrgIds().add(id);
            if (orgObj.getLong("masterid") == 0L) {
                orgObj.set("masterid", (Object)id);
            }
            if (orgObj.get("creator") == null) {
                orgObj.set("creator", (Object)this.currentUserId);
                orgObj.set("createtime", (Object)this.currentDate);
                orgObj.set("modifier", (Object)this.currentUserId);
                orgObj.set("modifytime", (Object)this.currentDate);
            }
            if ((viewObjList = emptyViewOrgMap.get(orgObj)) == null) continue;
            for (DynamicObject viewOrgObj : viewObjList) {
                viewOrgObj.set("id", (Object)id);
            }
        }
    }

    private void prepareAddNewStructure(List<DynamicObject> addNewStructureObjList) {
        if (addNewStructureObjList.isEmpty()) {
            return;
        }
        logger.info("\u3010\u7ec4\u7ec7\u7ed3\u6784\u5206\u5f55\u6784\u5efa\u7c7b\u3011\u6267\u884c\u7ec4\u7ec7\u7ed3\u6784\u4e3b\u952e\u9884\u7f6e" + addNewStructureObjList.size());
        long[] ids = ORM.create().genLongIds("bos_org_structure", addNewStructureObjList.size());
        int idIndex = 0;
        for (DynamicObject structureObj : addNewStructureObjList) {
            this.changeDataProvider.modifyView(structureObj, true);
            if (structureObj.getLong("id") == 0L) {
                long id = ids[idIndex++];
                structureObj.set("id", (Object)id);
                structureObj.set("viewmasterid", (Object)id);
            }
            if (structureObj.get("viewcreator") != null) continue;
            structureObj.set("viewcreator", (Object)this.currentUserId);
            structureObj.set("viewcreatetime", (Object)this.currentDate);
            structureObj.set("viewmodifier", (Object)this.currentUserId);
            structureObj.set("viewmodifytime", (Object)this.currentDate);
        }
    }

    private void compareFromDataBase(Map<Long, DynamicObject> fromDataBaseOrgMap) {
        if (fromDataBaseOrgMap.isEmpty() || this.sourceOrgMap.isEmpty()) {
            return;
        }
        logger.info("\u3010\u7ec4\u7ec7\u4fdd\u5b58\u64cd\u4f5c\u3011\u6267\u884c\u7ec4\u7ec7\u4fe1\u606f\u53d8\u66f4\u6bd4\u8f83", (Object)fromDataBaseOrgMap.size());
        for (Map.Entry<Long, DynamicObject> entry : fromDataBaseOrgMap.entrySet()) {
            DynamicObject currentOrgObj = entry.getValue();
            DynamicObject dbOrgObj = this.sourceOrgMap.get(currentOrgObj.getLong("id"));
            if (dbOrgObj == null) continue;
            this.compareOrgProperty("number", dbOrgObj, currentOrgObj);
            this.compareOrgProperty("name", dbOrgObj, currentOrgObj);
            this.compareOrgProperty("fyzjorgid", dbOrgObj, currentOrgObj);
            this.compareOrgProperty("timezone", dbOrgObj, currentOrgObj);
            this.compareStructure(dbOrgObj, currentOrgObj);
        }
    }

    private OrgChangeData compareOrgProperty(String property, DynamicObject dbOrgObj, DynamicObject currentOrgObj) {
        OrgChangeData orgChangeData = this.changeDataProvider.putOrgChangeData(dbOrgObj.getLong("id"), property, dbOrgObj.get(property), currentOrgObj.get(property));
        return orgChangeData;
    }

    private void compareStructure(DynamicObject dbOrgObj, DynamicObject currentOrgObj) {
        DynamicObjectCollection dbStructCol = dbOrgObj.getDynamicObjectCollection("structure");
        HashMap<Long, DynamicObject> dbViewStructMap = new HashMap<Long, DynamicObject>(dbStructCol.size());
        this.getViewStructureMap(dbStructCol, null, dbViewStructMap);
        DynamicObjectCollection currentStructCol = currentOrgObj.getDynamicObjectCollection("structure");
        HashMap<Object, DynamicObject> currentStructMap = new HashMap<Object, DynamicObject>(currentStructCol.size());
        HashMap<Long, DynamicObject> currentViewStructMap = new HashMap<Long, DynamicObject>(currentStructCol.size());
        this.getViewStructureMap(currentStructCol, currentStructMap, currentViewStructMap);
        block0: for (DynamicObject dbStructObj : dbStructCol) {
            DynamicObject dbViewObj = dbStructObj.getDynamicObject("view");
            if (dbViewObj == null) continue;
            long dbViewId = dbViewObj.getLong("id");
            DynamicObject currentStructObj = (DynamicObject)currentStructMap.get(dbStructObj.getPkValue());
            if (currentStructObj == null) {
                currentStructObj = (DynamicObject)currentViewStructMap.remove(dbViewId);
            } else {
                currentViewStructMap.remove(dbViewId);
            }
            if (currentStructObj == null) {
                this.changeDataProvider.modifyView(dbStructObj, false);
                if (15L != dbViewId) continue;
                Iterator iterator = currentStructCol.iterator();
                while (iterator.hasNext()) {
                    DynamicObject structureObj = (DynamicObject)iterator.next();
                    DynamicObject viewObj = structureObj.getDynamicObject("view");
                    if (viewObj == null || 16L != viewObj.getLong("id")) continue;
                    this.changeDataProvider.modifyView(structureObj, false);
                    iterator.remove();
                    continue block0;
                }
                continue;
            }
            if (!this.compareView(dbOrgObj, dbStructObj, currentStructObj, dbViewObj)) continue;
            this.compareParent(dbViewId, dbOrgObj, dbStructObj, currentStructObj);
            this.compareStructureProperty("isfreeze", dbViewId, dbOrgObj, dbStructObj, currentStructObj);
            this.compareStructureProperty("isctrlunit", dbViewId, dbOrgObj, dbStructObj, currentStructObj);
        }
        if (!currentViewStructMap.isEmpty()) {
            this.addDefaultView(currentStructCol, dbViewStructMap, currentViewStructMap);
            for (Map.Entry viewEntry : currentViewStructMap.entrySet()) {
                this.changeDataProvider.modifyView((DynamicObject)viewEntry.getValue(), true);
            }
        }
    }

    private void getViewStructureMap(DynamicObjectCollection structureObjCol, Map<Object, DynamicObject> structureMap, Map<Long, DynamicObject> viewStructureMap) {
        for (DynamicObject structureObj : structureObjCol) {
            DynamicObject currentViewObj;
            if (structureMap != null && structureObj.getDataEntityState().getFromDatabase()) {
                structureMap.put(structureObj.getPkValue(), structureObj);
            }
            if ((currentViewObj = structureObj.getDynamicObject("view")) == null) continue;
            viewStructureMap.put(currentViewObj.getLong("id"), structureObj);
        }
    }

    private boolean compareView(DynamicObject dbOrgObj, DynamicObject dbStructObj, DynamicObject currentStructObj, DynamicObject dbViewObj) {
        if (!currentStructObj.getDataEntityState().getFromDatabase() || dbViewObj == null) {
            return true;
        }
        DynamicObject currentViewObj = currentStructObj.getDynamicObject("view");
        if (currentViewObj == null) {
            return true;
        }
        boolean isSame = true;
        if (dbStructObj.getLong("id") == currentStructObj.getLong("id")) {
            if (currentViewObj.getLong("id") != dbViewObj.getLong("id")) {
                isSame = false;
            }
        } else {
            isSame = false;
        }
        if (!isSame) {
            this.changeDataProvider.putStructureChangeData(dbOrgObj.getLong("id"), currentViewObj.getLong("id"), "view", new OrgChangeData(dbViewObj, currentViewObj));
        }
        return isSame;
    }

    private void compareParent(long viewId, DynamicObject dbOrgObj, DynamicObject dbStructObj, DynamicObject currentStructObj) {
        OrgChangeData propertyChangeData;
        DynamicObject dbParentObj = dbStructObj.getDynamicObject("viewparent");
        long dbParentId = 0L;
        if (dbParentObj != null) {
            dbParentId = dbParentObj.getLong("id");
        }
        DynamicObject currentParentObj = currentStructObj.getDynamicObject("viewparent");
        long currentParentId = 0L;
        if (currentParentObj != null) {
            currentParentId = currentParentObj.getLong("id");
        }
        if ((propertyChangeData = this.changeDataProvider.getChangeData(dbParentId, currentParentId)) != null) {
            this.changeDataProvider.putStructureChangeData(dbOrgObj.getLong("id"), viewId, "viewparent", propertyChangeData);
            this.changeDataProvider.putStructureChangeData(dbOrgObj.getLong("id"), viewId, "longnumber", new OrgChangeData(dbStructObj.getString("longnumber"), currentStructObj.getString("longnumber")));
            this.changeDataProvider.putStructureChangeData(dbOrgObj.getLong("id"), viewId, "fullname", new OrgChangeData(dbStructObj.get("fullname"), currentStructObj.get("fullname")));
        }
    }

    private void compareStructureProperty(String property, long viewId, DynamicObject dbOrgObj, DynamicObject dbStructObj, DynamicObject currentStructObj) {
        this.changeDataProvider.putStructureChangeData(dbOrgObj.getLong("id"), viewId, property, dbStructObj.get(property), currentStructObj.get(property));
    }

    private Map<Long, DynamicObject> getDbViewStructureMap(boolean orgFromDatabase, DynamicObject orgObj) {
        if (!orgFromDatabase) {
            return Collections.EMPTY_MAP;
        }
        DynamicObject dbOrgObj = this.sourceOrgMap.get(orgObj.getPkValue());
        if (dbOrgObj == null) {
            return Collections.EMPTY_MAP;
        }
        DynamicObjectCollection dbStructCol = dbOrgObj.getDynamicObjectCollection("structure");
        HashMap<Long, DynamicObject> dbViewStructMap = new HashMap<Long, DynamicObject>(dbStructCol.size());
        for (DynamicObject structureObj : dbStructCol) {
            DynamicObject currentViewObj = structureObj.getDynamicObject("view");
            if (currentViewObj == null) continue;
            dbViewStructMap.put(currentViewObj.getLong("id"), structureObj);
        }
        return dbViewStructMap;
    }

    private List<DynamicObject> addDefaultView(DynamicObjectCollection currentStructCol, Map<Long, DynamicObject> dbViewStructMap, Map<Long, DynamicObject> currentViewStructMap) {
        DynamicObject structureObj;
        boolean isBizOrg;
        if (currentStructCol == null || dbViewStructMap == null || currentViewStructMap == null) {
            return Collections.EMPTY_LIST;
        }
        DynamicObject orgUnitStructureObj = currentViewStructMap.get(15L);
        if (orgUnitStructureObj == null ? dbViewStructMap.containsKey(15L) : currentViewStructMap.containsKey(16L)) {
            return Collections.EMPTY_LIST;
        }
        ArrayList<DynamicObject> structureList = new ArrayList<DynamicObject>(2);
        boolean bl = isBizOrg = orgUnitStructureObj != null;
        if (!isBizOrg) {
            isBizOrg = this.addOrgUnitView(currentStructCol, dbViewStructMap, currentViewStructMap, structureList);
        }
        if (isBizOrg && orgUnitStructureObj != null && !orgUnitStructureObj.getDataEntityState().getFromDatabase() && (structureObj = this.addStructureObj(currentStructCol, dbViewStructMap, currentViewStructMap, 16L, currentViewStructMap.get(15L))) != null) {
            structureList.add(structureObj);
        }
        return structureList;
    }

    private boolean addOrgUnitView(DynamicObjectCollection currentStructCol, Map<Long, DynamicObject> dbViewStructMap, Map<Long, DynamicObject> currentViewStructMap, List<DynamicObject> structureList) {
        DynamicObject structureObj;
        boolean isBizOrg = false;
        DynamicObject bizStructureObj = null;
        for (Map.Entry<Long, DynamicObject> viewEntry : currentViewStructMap.entrySet()) {
            DynamicObject bizObj;
            DynamicObject structureObj2 = viewEntry.getValue();
            DynamicObject viewObj = this.orgOpContext.getDataProvider().getViewByStructure(structureObj2);
            if (viewObj == null || (bizObj = viewObj.getDynamicObject("treetypeid")) == null || !"1".equals(bizObj.getString("category"))) continue;
            isBizOrg = true;
            if (!viewObj.getBoolean("isdefault") || !bizObj.getBoolean("isbasetype")) continue;
            bizStructureObj = structureObj2;
            break;
        }
        if ((structureObj = this.addStructureObj(currentStructCol, dbViewStructMap, currentViewStructMap, 15L, bizStructureObj)) != null) {
            structureList.add(structureObj);
        }
        return isBizOrg;
    }

    private DynamicObject addStructureObj(DynamicObjectCollection currentStructCol, Map<Long, DynamicObject> dbViewStructMap, Map<Long, DynamicObject> currentViewStructMap, long viewId, DynamicObject fromStructureObj) {
        if (fromStructureObj == null) {
            return null;
        }
        if (dbViewStructMap.containsKey(viewId) || currentViewStructMap.containsKey(viewId)) {
            return null;
        }
        DynamicObject toStructureObj = currentStructCol.addNew();
        DynamicObjectUtils.copy(fromStructureObj, toStructureObj);
        DynamicObject viewOrgObj = toStructureObj.getDynamicObject("vieworg");
        long orgId = 0L;
        if (viewOrgObj != null) {
            orgId = viewOrgObj.getLong("id");
        }
        toStructureObj.set("view", (Object)this.orgOpContext.getDataProvider().getViewDynamicObjectMap().get(viewId));
        DynamicObject parentObj = fromStructureObj.getDynamicObject("viewparent");
        Map orgObjMap = this.findParentViewOrgObjMap.computeIfAbsent(viewId, k -> new HashMap(64));
        if (parentObj != null) {
            long parentId = parentObj.getLong("id");
            DynamicObject viewParentObj = (DynamicObject)orgObjMap.get(parentId);
            if (viewParentObj == null && !this.getTopNewOrgUnitIds().contains(orgId)) {
                viewParentObj = parentObj;
            }
            if (viewParentObj == null) {
                long viewParentId = OrgUnitServiceHelper.getParentIdBySelfOrOrgUnitView((long)parentId, (long)viewId);
                viewParentObj = BusinessDataServiceHelper.loadSingleFromCache((Object)viewParentId, (DynamicObjectType)parentObj.getDynamicObjectType());
                orgObjMap.put(viewParentId, viewParentObj);
            }
            toStructureObj.set("viewparent", (Object)viewParentObj);
        }
        currentViewStructMap.put(viewId, toStructureObj);
        orgObjMap.put(orgId, viewOrgObj);
        return toStructureObj;
    }

    private List<Long> getTopNewOrgUnitIds() {
        if (this.topNewOrgUnitIds != null) {
            return this.topNewOrgUnitIds;
        }
        this.topNewOrgUnitIds = new ArrayList<Long>(this.targetOrgList.size());
        ArrayList<Map<String, Object>> orgUnitDataList = new ArrayList<Map<String, Object>>(this.targetOrgList.size());
        block0: for (DynamicObject orgObj : this.targetOrgList) {
            DynamicObjectCollection structureCol = orgObj.getDynamicObjectCollection("structure");
            for (DynamicObject structureObj : structureCol) {
                DynamicObject viewObj = structureObj.getDynamicObject("view");
                if (viewObj == null || 15L != viewObj.getLong("id")) continue;
                if (structureObj.getDataEntityState().getFromDatabase()) continue block0;
                HashMap<String, Object> orgMap = new HashMap<String, Object>(16);
                orgMap.put("id", orgObj.getPkValue());
                long parentId = 0L;
                DynamicObject parentObj = structureObj.getDynamicObject("viewparent");
                if (parentObj != null) {
                    parentId = parentObj.getLong("id");
                }
                orgMap.put("parentId", parentId);
                orgUnitDataList.add(orgMap);
                continue block0;
            }
        }
        if (orgUnitDataList.isEmpty()) {
            return this.topNewOrgUnitIds;
        }
        OrgTreeOrder orgTreeOrder = new OrgTreeOrder(orgUnitDataList);
        Map<Object, Map<String, Object>> sortedOrgMap = orgTreeOrder.order();
        for (Map.Entry<Object, Map<String, Object>> orgEntry : sortedOrgMap.entrySet()) {
            Map<String, Object> orgMap = orgEntry.getValue();
            this.topNewOrgUnitIds.add((Long)orgMap.get("id"));
        }
        return this.topNewOrgUnitIds;
    }
}

