/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.org.opplugin.common;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.StringJoiner;
import kd.bos.base.utils.IBaseCallbackHandler;
import kd.bos.base.utils.msg.BaseMessage;
import kd.bos.base.utils.msg.OrgMessage;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.metadata.dynamicobject.DynamicObjectType;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.db.DB;
import kd.bos.db.DBRoute;
import kd.bos.entity.ExtendedDataEntity;
import kd.bos.entity.property.TextProp;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.org.opplugin.IOrgOpValidatorHandler;
import kd.bos.org.opplugin.model.OrgChangeData;
import kd.bos.org.opplugin.model.OrgChangeDataProvider;
import kd.bos.org.opplugin.model.OrgOpContext;
import kd.bos.servicehelper.BusinessDataServiceHelper;

public class OrgFieldLengthValidator {
    private static final Log logger = LogFactory.getLog(OrgFieldLengthValidator.class);
    private final OrgOpContext orgOpContext;
    private final Map<Long, ExtendedDataEntity> dataEntityMap;
    private final IOrgOpValidatorHandler validatorHandler;
    private final OrgChangeDataProvider changeDataProvider;
    private final Map<Long, String> numberChangedMap;
    private final Map<String, Map<Long, Integer>> numberOrgLengthMap;
    private final Map<String, Map<String, Map<Long, Integer>>> numberLangOrgLengthMap;
    private final List<Long> errorIds;
    private static final int RESERVE = 10;

    public OrgFieldLengthValidator() {
        this(new OrgOpContext());
    }

    public OrgFieldLengthValidator(OrgOpContext orgOpContext) {
        this.orgOpContext = orgOpContext;
        this.validatorHandler = this.orgOpContext.getValidatorHandler();
        this.changeDataProvider = this.orgOpContext.getChangeDataProvider();
        this.dataEntityMap = this.orgOpContext.getDataEntityMap();
        int changedCount = this.changeDataProvider.getData().size();
        this.numberChangedMap = new HashMap<Long, String>(changedCount);
        this.numberOrgLengthMap = new HashMap<String, Map<Long, Integer>>(changedCount);
        this.numberLangOrgLengthMap = new HashMap<String, Map<String, Map<Long, Integer>>>(changedCount);
        this.errorIds = new ArrayList<Long>(changedCount);
    }

    public void validateSubStructureField() {
        logger.info("\u3010\u7ec4\u7ec7\u5b57\u6bb5\u957f\u5ea6\u6821\u9a8c\u5668\u3011\u5f00\u59cb\u6821\u9a8c\u3002");
        Map<Long, Map<String, Map<String, Map<Long, Map<String, OrgChangeData>>>>> data = this.changeDataProvider.getData();
        if (data.isEmpty()) {
            return;
        }
        HashMap<Long, List<String>> orgPropertyMap = new HashMap<Long, List<String>>(data.size());
        DynamicObject orgObj = null;
        for (Map.Entry<Long, Map<String, Map<String, Map<Long, Map<String, OrgChangeData>>>>> dataEntry : data.entrySet()) {
            String number;
            ExtendedDataEntity dataEntity;
            Long id = dataEntry.getKey();
            if (this.orgOpContext.getErrorIds().contains(id) || this.changeDataProvider.getAddNewOrgIds().contains(id) || (dataEntity = this.dataEntityMap.get(id)) == null || StringUtils.isBlank((CharSequence)(number = (orgObj = dataEntity.getDataEntity()).getString("number")))) continue;
            Map<String, Map<String, Map<Long, Map<String, OrgChangeData>>>> entityMap = dataEntry.getValue();
            this.getPropertyChangedLength(orgObj, true, entityMap.get("org"), orgPropertyMap);
            this.getPropertyChangedLength(orgObj, false, entityMap.get("structure"), orgPropertyMap);
        }
        if (orgObj == null) {
            return;
        }
        DynamicObjectCollection structureObjCol = orgObj.getDynamicObjectCollection("structure");
        DynamicObjectType structureObjType = structureObjCol.getDynamicObjectType();
        TextProp longNumberProp = (TextProp)structureObjType.getProperty("longnumber");
        TextProp fullNameProp = (TextProp)structureObjType.getProperty("fullname");
        try {
            this.validateNumberLength(longNumberProp, orgPropertyMap);
            this.validateNameLength(fullNameProp, orgPropertyMap);
        }
        catch (Exception e) {
            logger.error("\u3010\u7ec4\u7ec7\u5b57\u6bb5\u957f\u5ea6\u6821\u9a8c\u5668\u3011\u6821\u9a8c\u7ec4\u7ec7\u5b57\u6bb5\u957f\u5ea6\u65f6\u53d1\u751f\u5f02\u5e38\u3002", (Throwable)e);
        }
        logger.info("\u3010\u7ec4\u7ec7\u5b57\u6bb5\u957f\u5ea6\u6821\u9a8c\u5668\u3011\u5b8c\u6210\u6821\u9a8c\u3002");
    }

    private void getPropertyChangedLength(DynamicObject orgObj, boolean isOrgProperty, Map<String, Map<Long, Map<String, OrgChangeData>>> orgDataMap, Map<Long, List<String>> orgPropertyMap) {
        if (orgDataMap == null) {
            return;
        }
        Map<Long, Map<String, OrgChangeData>> viewMap = orgDataMap.get("property");
        if (viewMap == null) {
            return;
        }
        for (Map.Entry<Long, Map<String, OrgChangeData>> viewEntry : viewMap.entrySet()) {
            this.getViewPropertyChangedLength(orgObj, isOrgProperty, viewEntry.getValue(), orgPropertyMap);
        }
    }

    private void getViewPropertyChangedLength(DynamicObject orgObj, boolean isOrgProperty, Map<String, OrgChangeData> changeDataMap, Map<Long, List<String>> orgPropertyMap) {
        if (changeDataMap == null) {
            return;
        }
        if (isOrgProperty) {
            this.getOldNumber(orgObj, changeDataMap);
            this.addNumberFieldChangedLength(orgObj, "number", changeDataMap, orgPropertyMap);
            this.addNameFieldChangedLength(orgObj, "name", changeDataMap, orgPropertyMap);
        } else {
            this.addNumberFieldChangedLength(orgObj, "longnumber", changeDataMap, orgPropertyMap);
            this.addNameFieldChangedLength(orgObj, "fullname", changeDataMap, orgPropertyMap);
        }
    }

    private void getOldNumber(DynamicObject orgObj, Map<String, OrgChangeData> changeDataMap) {
        String oldNumber = orgObj.getString("number");
        OrgChangeData numberChangeData = changeDataMap.get("number");
        if (numberChangeData != null) {
            oldNumber = String.valueOf(numberChangeData.getOldValue());
        }
        this.numberChangedMap.put(orgObj.getLong("id"), oldNumber);
    }

    private String getShowNumber(DynamicObject orgObj) {
        String number = this.numberChangedMap.get(orgObj.getLong("id"));
        if (number == null) {
            number = orgObj.getString("number");
        }
        return number;
    }

    private void addNumberFieldChangedLength(DynamicObject orgObj, String property, Map<String, OrgChangeData> changeDataMap, Map<Long, List<String>> orgPropertyMap) {
        OrgChangeData numberChangeData = changeDataMap.get(property);
        if (numberChangeData == null) {
            return;
        }
        long id = orgObj.getLong("id");
        String oldNumber = String.valueOf(numberChangeData.getOldValue());
        String newNumber = String.valueOf(numberChangeData.getNewValue());
        int numberLength = newNumber.length() - oldNumber.length();
        if (numberLength > 0) {
            this.numberOrgLengthMap.computeIfAbsent(oldNumber, v -> new HashMap(1)).put(id, numberLength);
            orgPropertyMap.computeIfAbsent(id, v -> new ArrayList(8)).add(property);
        }
    }

    private void addNameFieldChangedLength(DynamicObject orgObj, String property, Map<String, OrgChangeData> changeDataMap, Map<Long, List<String>> orgPropertyMap) {
        OrgChangeData nameChangeData = changeDataMap.get(property);
        if (nameChangeData == null) {
            return;
        }
        boolean added = false;
        Map newNameObj = (Map)nameChangeData.getNewValue();
        if (newNameObj == null) {
            return;
        }
        Map oldNameObj = (Map)nameChangeData.getOldValue();
        Set toEntries = newNameObj.entrySet();
        Map<String, String> languageNameMap = this.orgOpContext.getDataProvider().getLanguageNameMap();
        for (Map.Entry newNameEntry : toEntries) {
            int length;
            String oldName;
            String lang;
            if (StringUtils.isBlank((CharSequence)((CharSequence)newNameEntry.getValue())) || !languageNameMap.containsKey(lang = (String)newNameEntry.getKey())) continue;
            int newLength = ((String)newNameEntry.getValue()).length();
            int oldLength = 0;
            if (oldNameObj != null && (oldName = (String)oldNameObj.get(lang)) != null) {
                oldLength = oldName.length();
            }
            if ((length = newLength - oldLength) <= 0) continue;
            Map orgNameLengthMap = this.numberLangOrgLengthMap.computeIfAbsent(this.getShowNumber(orgObj), v -> new HashMap(newNameObj.size()));
            orgNameLengthMap.computeIfAbsent(lang, v -> new HashMap(newNameObj.size())).put(orgObj.getLong("id"), length);
            added = true;
        }
        if (added) {
            orgPropertyMap.computeIfAbsent(orgObj.getLong("id"), v -> new ArrayList(8)).add(property);
        }
    }

    private void validateNumberLength(TextProp longNumberProp, Map<Long, List<String>> orgPropertyMap) {
        if (this.numberOrgLengthMap.isEmpty()) {
            return;
        }
        int maxDiffLength = this.getMaxDiffLength(0, this.numberOrgLengthMap);
        int maxLength = longNumberProp.getMaxLenth();
        maxDiffLength = maxLength - maxDiffLength;
        String sql = "select s.flongnumber longnumber,length(flongnumber) dblength from t_org_structure s where " + maxDiffLength + " < length(flongnumber)";
        String longNumberSep = this.orgOpContext.getConfigProvider().getOrgSeparation().getLongNumberSep();
        DB.query((DBRoute)DBRoute.basedata, (String)sql, null, resultSet -> {
            while (resultSet.next()) {
                String longNumber = resultSet.getString("longnumber");
                String[] numbers = longNumber.split(longNumberSep);
                for (int i = numbers.length - 2; i >= 0; --i) {
                    Map<Long, Integer> orgLengthMap = this.numberOrgLengthMap.remove(numbers[i]);
                    if (orgLengthMap == null) continue;
                    int dbLength = resultSet.getInt("dblength");
                    this.validateNumberLength(dbLength, maxLength, orgLengthMap, orgPropertyMap);
                    if (this.numberOrgLengthMap.isEmpty()) break;
                }
                if (!this.numberOrgLengthMap.isEmpty()) continue;
                break;
            }
            return null;
        });
    }

    private void validateNumberLength(int dbLength, int maxLength, Map<Long, Integer> orgLengthMap, Map<Long, List<String>> orgPropertyMap) {
        this.validateLength("number", dbLength, maxLength, orgLengthMap, params -> {
            List properties = (List)orgPropertyMap.get(params[0]);
            if (properties == null || properties.contains(params[1])) {
                return OrgMessage.getMessage("M00220", maxLength);
            }
            return OrgMessage.getMessage("M00222", maxLength);
        });
    }

    private void validateNameLength(TextProp fullNameProp, Map<Long, List<String>> orgPropertyMap) {
        if (this.numberLangOrgLengthMap.isEmpty()) {
            return;
        }
        int maxDiffLength = 0;
        for (Map.Entry<String, Map<String, Map<Long, Integer>>> entry : this.numberLangOrgLengthMap.entrySet()) {
            Map<String, Map<Long, Integer>> orgNameLengthMap = entry.getValue();
            maxDiffLength = this.getMaxDiffLength(maxDiffLength, orgNameLengthMap);
        }
        int maxLength = fullNameProp.getMaxLenth();
        maxDiffLength = maxLength - maxDiffLength;
        String sql = "select s.flongnumber longnumber,length(sl.ffullname) dblength,sl.flocaleid flocaleid from t_org_structure s inner join t_org_structure_l sl on sl.fid = s.fid where " + maxDiffLength + " < length(sl.ffullname)";
        String longNumberSep = this.orgOpContext.getConfigProvider().getOrgSeparation().getLongNumberSep();
        DB.query((DBRoute)DBRoute.basedata, (String)sql, null, resultSet -> {
            while (resultSet.next()) {
                String longNumber = resultSet.getString("longnumber");
                String[] numbers = longNumber.split(longNumberSep);
                for (int i = numbers.length - 2; i >= 0; --i) {
                    String lang;
                    Map<Long, Integer> orgLengthMap;
                    Map<String, Map<Long, Integer>> orgNameLengthMap = this.numberLangOrgLengthMap.get(numbers[i]);
                    if (orgNameLengthMap == null || (orgLengthMap = orgNameLengthMap.remove(lang = resultSet.getString("flocaleid"))) == null) continue;
                    int dbLength = resultSet.getInt("dblength");
                    this.validateNameLength(dbLength, maxLength, orgLengthMap, orgPropertyMap);
                    if (!orgNameLengthMap.isEmpty()) continue;
                    this.numberLangOrgLengthMap.remove(numbers[i]);
                    break;
                }
                if (!this.numberLangOrgLengthMap.isEmpty()) continue;
                break;
            }
            return null;
        });
    }

    private void validateNameLength(int dbLength, int maxLength, Map<Long, Integer> orgLengthMap, Map<Long, List<String>> orgPropertyMap) {
        this.validateLength("name", dbLength, maxLength, orgLengthMap, params -> {
            List properties = (List)orgPropertyMap.get(params[0]);
            if (properties == null || properties.contains(params[1])) {
                return OrgMessage.getMessage("M00221", maxLength);
            }
            return OrgMessage.getMessage("M00223", maxLength);
        });
    }

    private void validateLength(String property, int dbLength, int maxLength, Map<Long, Integer> orgLengthMap, IBaseCallbackHandler handler) {
        for (Map.Entry<Long, Integer> lenEntry : orgLengthMap.entrySet()) {
            Long id = lenEntry.getKey();
            if (this.errorIds.contains(id) || dbLength + lenEntry.getValue() <= maxLength) continue;
            this.handleError(id, handler.handle(id, property).toString());
        }
    }

    private void handleError(long id, String message) {
        ExtendedDataEntity dataEntity = this.dataEntityMap.get(id);
        if (dataEntity == null) {
            return;
        }
        this.errorIds.add(id);
        this.validatorHandler.handle(dataEntity, message);
    }

    private int getMaxDiffLength(int maxDiffLength, Map<String, Map<Long, Integer>> orgLengthMap) {
        for (Map.Entry<String, Map<Long, Integer>> entry : orgLengthMap.entrySet()) {
            Map<Long, Integer> lengthMap = entry.getValue();
            for (Map.Entry<Long, Integer> lenEntry : lengthMap.entrySet()) {
                if (maxDiffLength >= lenEntry.getValue()) continue;
                maxDiffLength = lenEntry.getValue();
            }
        }
        return maxDiffLength;
    }

    public String validateStructureField() {
        StringJoiner messageSb = new StringJoiner("\r\n");
        try {
            DynamicObject dataEntity = BusinessDataServiceHelper.newDynamicObject((String)"bos_org");
            DynamicObjectCollection structureObjCol = dataEntity.getDynamicObjectCollection("structure");
            DynamicObjectType structureObjType = structureObjCol.getDynamicObjectType();
            TextProp longNumberProp = (TextProp)structureObjType.getProperty("longnumber");
            TextProp fullNameProp = (TextProp)structureObjType.getProperty("fullname");
            this.validateFieldLength(longNumberProp, "select max(length(flongnumber)) from t_org_structure", messageSb);
            this.validateFieldLength(fullNameProp, "select max (length(ffullname)) from t_org_structure_l", messageSb);
        }
        catch (Exception e) {
            logger.error("\u3010\u7ec4\u7ec7\u5065\u5eb7\u68c0\u67e5\u3011\u6821\u9a8c\u5b57\u6bb5\u957f\u5ea6\u65f6\u53d1\u751f\u5f02\u5e38\uff1a" + e.getMessage(), (Throwable)e);
        }
        return messageSb.toString();
    }

    private void validateFieldLength(TextProp textProp, String sql, StringJoiner messageSb) {
        DB.query((DBRoute)DBRoute.basedata, (String)sql, null, resultSet -> {
            while (resultSet.next()) {
                int currentMaxLength = resultSet.getInt(1);
                if (textProp.getMaxLenth() - 10 > currentMaxLength) continue;
                messageSb.add(BaseMessage.getMessage("M00077", textProp.getDisplayName(), currentMaxLength, textProp.getMaxLenth()));
            }
            return null;
        });
    }
}

