/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.org.opplugin.common;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.TreeMap;
import java.util.function.Function;
import kd.bos.algo.DataSet;
import kd.bos.algo.Row;
import kd.bos.base.utils.msg.BaseMessage;
import kd.bos.base.utils.msg.OrgMessage;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.entity.ILocaleString;
import kd.bos.dataentity.metadata.dynamicobject.DynamicObjectType;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.entity.ExtendedDataEntity;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.org.opplugin.IOrgOpValidatorHandler;
import kd.bos.org.opplugin.model.OrgChangeData;
import kd.bos.org.opplugin.model.OrgChangeDataProvider;
import kd.bos.org.opplugin.model.OrgOpContext;
import kd.bos.orm.query.QFilter;
import kd.bos.orm.util.CollectionUtils;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import org.apache.commons.collections4.map.CaseInsensitiveMap;

public class OrgFullNameValidator {
    private static final Log logger = LogFactory.getLog(OrgFullNameValidator.class);
    private final OrgOpContext orgOpContext;
    private final boolean validateFreezeStatus;
    private final Map<Long, ExtendedDataEntity> dataEntityMap;
    private final IOrgOpValidatorHandler validatorHandler;
    private final OrgChangeDataProvider changeDataProvider;
    private final Map<Long, Set<Long>> errorOrgViewsMap;

    public OrgFullNameValidator(OrgOpContext orgOpContext, boolean validateFreezeStatus) {
        this.orgOpContext = orgOpContext;
        this.validateFreezeStatus = validateFreezeStatus;
        this.validatorHandler = this.orgOpContext.getValidatorHandler();
        this.changeDataProvider = this.orgOpContext.getChangeDataProvider();
        this.dataEntityMap = this.orgOpContext.getDataEntityMap();
        this.errorOrgViewsMap = new HashMap<Long, Set<Long>>(this.dataEntityMap.size());
    }

    public void validate(ExtendedDataEntity[] dataEntities) {
        if (dataEntities == null || dataEntities.length == 0) {
            return;
        }
        HashMap<Long, Map<Long, List<ExtendedDataEntity>>> dbViewParentEntryMap = new HashMap<Long, Map<Long, List<ExtendedDataEntity>>>(64);
        HashMap<Long, Map> viewParentLangNameOrgMap = new HashMap<Long, Map>(64);
        for (ExtendedDataEntity dataEntity : dataEntities) {
            DynamicObject orgObj = dataEntity.getDataEntity();
            long id = orgObj.getLong("id");
            if (this.orgOpContext.getErrorIds().contains(id)) continue;
            this.dataEntityMap.put(id, dataEntity);
            DynamicObject orgBizObj = orgObj.getDynamicObject("orgbizfunction");
            DynamicObjectCollection structureCol = orgObj.getDynamicObjectCollection("structure");
            for (DynamicObject structureObj : structureCol) {
                DynamicObject bizObj;
                DynamicObject viewObj = structureObj.getDynamicObject("view");
                if (viewObj == null || (bizObj = viewObj.getDynamicObject("treetypeid")) == null || orgBizObj != null && !Objects.equals(orgBizObj.getPkValue(), bizObj.getPkValue())) continue;
                long viewId = viewObj.getLong("id");
                long parentId = 0L;
                DynamicObject parentObj = structureObj.getDynamicObject("viewparent");
                if (parentObj != null) {
                    parentId = parentObj.getLong("id");
                }
                Map parentLangNameOrgMap = viewParentLangNameOrgMap.computeIfAbsent(viewId, v -> new HashMap(dataEntities.length));
                if (!this.validate(dataEntity, viewId, parentLangNameOrgMap, parentId)) continue;
                Map parentOrgMap = dbViewParentEntryMap.computeIfAbsent(viewId, k -> new HashMap(64));
                List orgObjList = parentOrgMap.computeIfAbsent(parentId, k -> new ArrayList(64));
                orgObjList.add(dataEntity);
            }
        }
        this.validate(dbViewParentEntryMap);
    }

    public boolean validate(ExtendedDataEntity dataEntity, Long viewId, Map<Long, Map<String, Map<String, List<Long>>>> parentLangNameOrgMap, Long parentId) {
        if (this.orgOpContext.getIgnoreFullNameUniqueViewIds().contains(viewId)) {
            return true;
        }
        DynamicObject orgObj = dataEntity.getDataEntity();
        long id = orgObj.getLong("id");
        if (this.orgOpContext.getErrorIds().contains(id)) {
            return true;
        }
        ILocaleString nameLocaleString = orgObj.getLocaleString("name");
        if (nameLocaleString == null) {
            return true;
        }
        Map langNameOrgMap = parentLangNameOrgMap.computeIfAbsent(parentId, v -> new HashMap());
        Map<String, String> duplicateLanguage = this.getDuplicateLanguage(id, null, nameLocaleString, langNameOrgMap);
        boolean compareLocaleName = this.compareLocaleName(viewId, dataEntity, duplicateLanguage, false);
        for (Map.Entry nameEntry : nameLocaleString.entrySet()) {
            Map nameOrgMap = langNameOrgMap.computeIfAbsent(nameEntry.getKey(), v -> new HashMap());
            nameOrgMap.computeIfAbsent(nameEntry.getValue(), v -> new ArrayList()).add(id);
        }
        return compareLocaleName;
    }

    public void validate(Map<Long, Map<Long, List<ExtendedDataEntity>>> dbViewParentEntryMap) {
        if (dbViewParentEntryMap == null || dbViewParentEntryMap.isEmpty()) {
            return;
        }
        logger.info("\u3010\u7ec4\u7ec7\u957f\u540d\u79f0\u6821\u9a8c\u5668\u3011\u6267\u884c\u7ec4\u7ec7\u7ed3\u6784\u957f\u540d\u79f0\u6821\u9a8c", dbViewParentEntryMap.keySet());
        dbViewParentEntryMap.keySet().removeAll(this.orgOpContext.getIgnoreFullNameUniqueViewIds());
        if (dbViewParentEntryMap.isEmpty()) {
            return;
        }
        HashMap<Long, Map<Long, List<Long>>> viewParentOrgMap = new HashMap<Long, Map<Long, List<Long>>>(64);
        HashMap<String, Map<String, List<Long>>> langNameOrgMap = new HashMap<String, Map<String, List<Long>>>(64);
        this.getValidateFullNameSubOrg(dbViewParentEntryMap, viewParentOrgMap, langNameOrgMap);
        if (viewParentOrgMap.isEmpty()) {
            return;
        }
        ArrayList<Long> errorIds = new ArrayList<Long>(64);
        for (Map.Entry<Long, Map<Long, List<ExtendedDataEntity>>> entry : dbViewParentEntryMap.entrySet()) {
            Long viewId = entry.getKey();
            Map parentOrgMap = (Map)viewParentOrgMap.get(viewId);
            if (parentOrgMap == null) continue;
            Map<Long, List<ExtendedDataEntity>> parentEntryMap = entry.getValue();
            for (Map.Entry<Long, List<ExtendedDataEntity>> parentOrgEntry : parentEntryMap.entrySet()) {
                Long parentId = parentOrgEntry.getKey();
                List dbOrgIds = (List)parentOrgMap.get(parentId);
                if (dbOrgIds == null) continue;
                List<ExtendedDataEntity> orgEntryList = parentOrgEntry.getValue();
                for (ExtendedDataEntity dataEntity : orgEntryList) {
                    Map<String, String> duplicateLanguage;
                    ILocaleString nameLocaleString;
                    DynamicObject orgObj = dataEntity.getDataEntity();
                    long orgId = orgObj.getLong("id");
                    if (errorIds.contains(orgId) || (nameLocaleString = orgObj.getLocaleString("name")) == null || this.compareLocaleName(viewId, dataEntity, duplicateLanguage = this.getDuplicateLanguage(orgId, dbOrgIds, nameLocaleString, langNameOrgMap), false)) continue;
                    errorIds.add(orgId);
                }
            }
        }
    }

    private Map<String, String> getDuplicateLanguage(long orgId, List<Long> dbOrgIds, ILocaleString nameLocaleString, Map<String, Map<String, List<Long>>> langNameOrgMap) {
        Map<String, String> languageNameMap = this.orgOpContext.getDataProvider().getLanguageNameMap();
        TreeMap<String, String> duplicateLanguage = new TreeMap<String, String>();
        for (Map.Entry nameEntry : nameLocaleString.entrySet()) {
            String enableLang;
            List<Long> orgIds;
            Map<String, List<Long>> nameOrgMap;
            if (StringUtils.isBlank((CharSequence)((CharSequence)nameEntry.getValue())) || (nameOrgMap = langNameOrgMap.get(nameEntry.getKey())) == null || CollectionUtils.isEmpty(orgIds = nameOrgMap.get(nameEntry.getValue()))) continue;
            boolean isDuplicate = false;
            for (Long id : orgIds) {
                if (id == orgId || dbOrgIds != null && !dbOrgIds.contains(id)) continue;
                isDuplicate = true;
                break;
            }
            if (!isDuplicate || (enableLang = languageNameMap.get(nameEntry.getKey())) == null) continue;
            duplicateLanguage.put(enableLang, (String)nameEntry.getValue());
        }
        return duplicateLanguage;
    }

    private boolean compareLocaleName(Long viewId, ExtendedDataEntity dataEntity, Map<String, String> duplicateLanguage, boolean isDeleteView) {
        if (duplicateLanguage.isEmpty()) {
            return true;
        }
        DynamicObject orgObj = dataEntity.getDataEntity();
        long orgId = orgObj.getLong("id");
        Set<Long> viewIds = this.errorOrgViewsMap.get(orgId);
        if (viewIds != null && viewIds.contains(viewId)) {
            return true;
        }
        DynamicObjectCollection structureObjCol = orgObj.getDynamicObjectCollection("structure");
        DynamicObject parentObj = null;
        for (DynamicObject structureObj : structureObjCol) {
            DynamicObject viewObj = structureObj.getDynamicObject("view");
            if (viewObj == null || viewObj.getLong("id") != viewId.longValue()) continue;
            parentObj = structureObj.getDynamicObject("viewparent");
            if (!this.validateFreezeStatus) break;
            if (!structureObj.getBoolean("isfreeze")) continue;
            return true;
        }
        String viewName = this.getViewNameOfDuplicateError(viewId);
        String parentName = parentObj == null ? "" : parentObj.getString("name");
        Map<String, String> languageNameMap = this.orgOpContext.getDataProvider().getLanguageNameMap();
        CharSequence name = duplicateLanguage.get(languageNameMap.get(RequestContext.get().getLang().name()));
        if (name == null) {
            StringBuilder nameSb = new StringBuilder();
            String colon = null;
            for (Map.Entry<String, String> entry : duplicateLanguage.entrySet()) {
                if (colon == null) {
                    colon = BaseMessage.getMessage("M00067");
                } else {
                    nameSb.append("; ");
                }
                nameSb.append(entry.getKey());
                nameSb.append(colon);
                nameSb.append(entry.getValue());
            }
            name = nameSb;
        }
        if (isDeleteView) {
            this.validatorHandler.handle(dataEntity, OrgMessage.getMessage("M00189", orgObj.getString("name"), viewName, name));
        } else {
            this.validatorHandler.handle(dataEntity, OrgMessage.getMessage("M00188", viewName, parentName, name));
        }
        if (viewIds == null) {
            viewIds = new HashSet<Long>(8);
        }
        viewIds.add(viewId);
        this.errorOrgViewsMap.put(orgId, viewIds);
        return false;
    }

    private String getViewNameOfDuplicateError(long viewId) {
        DynamicObject viewObj = this.orgOpContext.getDataProvider().getViewDynamicObjectMap().get(viewId);
        String viewName = "";
        if (viewObj == null) {
            return viewName;
        }
        DynamicObject bizObj = null;
        if (viewObj.getBoolean("isdefault")) {
            bizObj = viewObj.getDynamicObject("treetypeid");
        }
        viewName = bizObj == null ? viewObj.getString("name") : bizObj.getString("fname");
        return viewName;
    }

    private void getValidateFullNameSubOrg(Map<Long, Map<Long, List<ExtendedDataEntity>>> dbViewParentEntryMap, Map<Long, Map<Long, List<Long>>> viewParentOrgMap, Map<String, Map<String, List<Long>>> langNameOrgMap) {
        HashSet<Long> parentIds = new HashSet<Long>(64);
        for (Map.Entry<Long, Map<Long, List<ExtendedDataEntity>>> viewEntry : dbViewParentEntryMap.entrySet()) {
            Set<Long> viewParentIds = viewEntry.getValue().keySet();
            parentIds.addAll(viewParentIds);
            Map parentOrgMap = viewParentOrgMap.computeIfAbsent(viewEntry.getKey(), v -> new HashMap(viewParentIds.size()));
            for (Long parentId : viewParentIds) {
                parentOrgMap.put(parentId, new ArrayList());
            }
        }
        QFilter viewFilter = new QFilter("view", "in", dbViewParentEntryMap.keySet());
        QFilter parentFilter = new QFilter("parent", "in", parentIds);
        QFilter freezeFilter = new QFilter("isfreeze", "=", (Object)Boolean.FALSE);
        QFilter[] filters = new QFilter[]{viewFilter, parentFilter, freezeFilter};
        HashMap<Long, ILocaleString> orgNameMap = new HashMap<Long, ILocaleString>(64);
        try (DataSet dataSet = QueryServiceHelper.queryDataSet((String)"OrgStructureValidator.getValidateFullNameSubOrg", (String)"bos_org_structure", (String)"view,org,parent", (QFilter[])filters, (String)"");){
            HashSet<Long> orgIds = new HashSet<Long>(64);
            for (Row row : dataSet) {
                long parentId;
                List<Long> orgIdList;
                long viewId = row.getLong("view");
                Map<Long, List<Long>> parentOrgMap = viewParentOrgMap.get(viewId);
                if (parentOrgMap == null || (orgIdList = parentOrgMap.get(parentId = row.getLong("parent").longValue())) == null) continue;
                long orgId = row.getLong("org");
                ILocaleString orgName = (ILocaleString)orgNameMap.get(orgId);
                if (orgName == null) {
                    ExtendedDataEntity dataEntity;
                    ExtendedDataEntity extendedDataEntity = dataEntity = this.orgOpContext.getErrorIds().contains(orgId) ? null : this.dataEntityMap.get(orgId);
                    if (dataEntity == null) {
                        orgIds.add(orgId);
                    } else {
                        orgName = dataEntity.getDataEntity().getLocaleString("name");
                        if (orgName == null) {
                            orgIds.add(orgId);
                        } else {
                            this.recordOrgName(orgId, orgName, langNameOrgMap);
                        }
                    }
                    orgNameMap.put(orgId, orgName);
                }
                orgIdList.add(orgId);
            }
            this.getValidateFullNameSubOrg(orgIds, langNameOrgMap);
        }
    }

    private void getValidateFullNameSubOrg(Set<Long> orgIds, Map<String, Map<String, List<Long>>> langNameOrgMap) {
        if (orgIds.isEmpty()) {
            return;
        }
        HashSet<String> select = new HashSet<String>(4);
        select.add("id");
        select.add("number");
        select.add("name");
        DynamicObjectType orgDataEntityType = EntityMetadataCache.getSubDataEntityType((String)"bos_org", select);
        Map dbOrgObjMap = BusinessDataServiceHelper.loadFromCache((Object[])orgIds.toArray(new Object[orgIds.size()]), (DynamicObjectType)orgDataEntityType);
        if (CollectionUtils.isEmpty((Map)dbOrgObjMap)) {
            return;
        }
        HashMap<Long, ILocaleString> orgNameMap = new HashMap<Long, ILocaleString>(dbOrgObjMap.size());
        Collection orgObjs = dbOrgObjMap.values();
        for (DynamicObject orgObj : orgObjs) {
            this.recordOrgName(orgObj, orgNameMap, langNameOrgMap);
        }
    }

    private void recordOrgName(DynamicObject orgObj, Map<Long, ILocaleString> orgNameMap, Map<String, Map<String, List<Long>>> langNameOrgMap) {
        long orgId = orgObj.getLong("id");
        ILocaleString orgName = orgNameMap.get(orgId);
        if (orgName == null) {
            ExtendedDataEntity dataEntity = this.orgOpContext.getErrorIds().contains(orgId) ? null : this.dataEntityMap.get(orgId);
            orgName = dataEntity == null ? orgObj.getLocaleString("name") : dataEntity.getDataEntity().getLocaleString("name");
            orgNameMap.put(orgId, orgName);
        }
        this.recordOrgName(orgId, orgName, langNameOrgMap);
    }

    private void recordOrgName(long orgId, ILocaleString orgName, Map<String, Map<String, List<Long>>> langNameOrgMap) {
        Boolean isNameCaseInsensitive = this.orgOpContext.isNameCaseInsensitive();
        Map<String, String> languageNameMap = this.orgOpContext.getDataProvider().getLanguageNameMap();
        for (Map.Entry nameEntry : orgName.entrySet()) {
            if (!StringUtils.isNotBlank((CharSequence)((CharSequence)nameEntry.getValue())) || !languageNameMap.containsKey(nameEntry.getKey())) continue;
            Map nameOrgMap = langNameOrgMap.computeIfAbsent((String)nameEntry.getKey(), (Function<String, Map<String, List<Long>>>)((Function<String, Map>)v -> isNameCaseInsensitive != false ? new CaseInsensitiveMap(64) : new HashMap(64)));
            nameOrgMap.computeIfAbsent(nameEntry.getValue(), v -> new ArrayList(64)).add(orgId);
        }
    }

    public void validateAfterDelete() {
        TreeMap<Long, TreeMap<String, Map<Long, Long>>> deletedViewLongNumberOrgParentMap = new TreeMap<Long, TreeMap<String, Map<Long, Long>>>();
        HashMap<Long, List<Long>> deletedViewOrgMap = new HashMap<Long, List<Long>>(64);
        HashSet<Long> orgAndOldParentIds = new HashSet<Long>(this.dataEntityMap.size());
        this.filterMoveUpOrg(deletedViewLongNumberOrgParentMap, deletedViewOrgMap, orgAndOldParentIds);
        logger.info("\u3010\u7ec4\u7ec7\u957f\u540d\u79f0\u6821\u9a8c\u5668\u3011\u6267\u884c\u7ec4\u7ec7\u79fb\u52a8\u540e\u7684\u957f\u540d\u79f0\u6821\u9a8c", (Object)orgAndOldParentIds.size());
        if (orgAndOldParentIds.isEmpty()) {
            return;
        }
        HashMap<Long, ILocaleString> orgNameMap = new HashMap<Long, ILocaleString>();
        HashMap<String, Map<String, List<Long>>> langNameOrgMap = new HashMap<String, Map<String, List<Long>>>(orgAndOldParentIds.size());
        HashMap<Long, Map<Long, List<Long>>> viewParentOrgMap = new HashMap<Long, Map<Long, List<Long>>>(64);
        this.getMoveUpOrg(deletedViewOrgMap.keySet(), orgAndOldParentIds, orgNameMap, langNameOrgMap, viewParentOrgMap);
        ArrayList<Long> errorIds = new ArrayList<Long>(64);
        for (Map.Entry viewEntry : deletedViewLongNumberOrgParentMap.entrySet()) {
            Long viewId = (Long)viewEntry.getKey();
            Map parentOrgMap = (Map)viewParentOrgMap.get(viewId);
            if (CollectionUtils.isEmpty((Map)parentOrgMap)) continue;
            List deletedOrgIds = (List)deletedViewOrgMap.remove(viewId);
            deletedOrgIds = deletedOrgIds == null ? new ArrayList(0) : deletedOrgIds;
            Map longNumberOrgMap = (Map)viewEntry.getValue();
            String longNumber = null;
            for (Map.Entry orgEntry : longNumberOrgMap.entrySet()) {
                if (longNumber != null && ((String)orgEntry.getKey()).startsWith(longNumber + "!")) continue;
                longNumber = (String)orgEntry.getKey();
                Map orgOldParentMap = (Map)orgEntry.getValue();
                this.compareMoveUpOrgName(viewId, orgNameMap, langNameOrgMap, orgOldParentMap, parentOrgMap, deletedOrgIds, errorIds);
            }
        }
    }

    private void compareMoveUpOrgName(long viewId, Map<Long, ILocaleString> orgNameMap, Map<String, Map<String, List<Long>>> langNameOrgMap, Map<Long, Long> orgOldParentMap, Map<Long, List<Long>> parentOrgMap, List<Long> deletedOrgIds, List<Long> errorIds) {
        for (Map.Entry<Long, Long> parentEntry : orgOldParentMap.entrySet()) {
            Long orgId = parentEntry.getKey();
            ExtendedDataEntity dataEntity = this.dataEntityMap.get(orgId);
            if (dataEntity == null) continue;
            List<Long> moveUpOrgIds = parentOrgMap.get(orgId);
            List<Long> sameLevelOrgIds = parentOrgMap.get(parentEntry.getValue());
            if (CollectionUtils.isEmpty(moveUpOrgIds) || CollectionUtils.isEmpty(sameLevelOrgIds)) continue;
            moveUpOrgIds.removeAll(deletedOrgIds);
            sameLevelOrgIds.removeAll(deletedOrgIds);
            if (moveUpOrgIds.isEmpty() || sameLevelOrgIds.isEmpty()) continue;
            for (Long subOrgId : moveUpOrgIds) {
                ILocaleString nameLocaleString;
                if (errorIds.contains(subOrgId) || (nameLocaleString = orgNameMap.get(subOrgId)) == null) continue;
                Map<String, String> duplicateLanguage = this.getDuplicateLanguage(subOrgId, sameLevelOrgIds, nameLocaleString, langNameOrgMap);
                if (this.compareLocaleName(viewId, dataEntity, duplicateLanguage, true)) continue;
                errorIds.add(subOrgId);
            }
        }
    }

    private void filterMoveUpOrg(Map<Long, TreeMap<String, Map<Long, Long>>> deletedViewLongNumberOrgParentMap, Map<Long, List<Long>> deletedViewOrgMap, Set<Long> orgAndOldParentIds) {
        Map<Long, Map<String, Map<String, Map<Long, Map<String, OrgChangeData>>>>> data = this.changeDataProvider.getData();
        for (Map.Entry<Long, Map<String, Map<String, Map<Long, Map<String, OrgChangeData>>>>> orgEntry : data.entrySet()) {
            Map<Long, Map<String, OrgChangeData>> deleteViewMap;
            Map<String, Map<Long, Map<String, OrgChangeData>>> structureMap = orgEntry.getValue().get("structure");
            if (structureMap == null || (deleteViewMap = structureMap.get("delete")) == null) continue;
            for (Map.Entry<Long, Map<String, OrgChangeData>> viewEntry : deleteViewMap.entrySet()) {
                OrgChangeData longNumberChangeData;
                Map<String, OrgChangeData> changeDataMap;
                OrgChangeData leafChangeData;
                Long viewId = viewEntry.getKey();
                if (this.orgOpContext.getIgnoreFullNameUniqueViewIds().contains(viewId) || (leafChangeData = (changeDataMap = viewEntry.getValue()).get("isleaf")) != null && ((Boolean)leafChangeData.getOldValue()).booleanValue() || (longNumberChangeData = changeDataMap.get("longnumber")) == null) continue;
                Long orgId = orgEntry.getKey();
                deletedViewOrgMap.computeIfAbsent(viewId, v -> new ArrayList()).add(orgId);
                Map longNumberOrgMap = deletedViewLongNumberOrgParentMap.computeIfAbsent(viewEntry.getKey(), v -> new TreeMap());
                HashMap<Long, Long> orgOldParentMap = new HashMap<Long, Long>(1);
                orgAndOldParentIds.add(orgId);
                Long oldParentId = (Long)viewEntry.getValue().get("viewparent").getOldValue();
                orgAndOldParentIds.add(oldParentId);
                orgOldParentMap.put(orgId, oldParentId);
                longNumberOrgMap.put((String)longNumberChangeData.getOldValue(), orgOldParentMap);
            }
        }
    }

    private void getMoveUpOrg(Set<Long> viewIds, Set<Long> orgAndOldParentIds, Map<Long, ILocaleString> orgNameMap, Map<String, Map<String, List<Long>>> langNameOrgMap, Map<Long, Map<Long, List<Long>>> viewParentOrgMap) {
        String selectFields = "view,org,parent";
        QFilter freezeFilter = new QFilter("isfreeze", "=", (Object)Boolean.FALSE);
        QFilter viewFilter = new QFilter("view", "in", viewIds);
        QFilter parentFilter = new QFilter("parent", "in", orgAndOldParentIds);
        QFilter[] filters = new QFilter[]{freezeFilter, viewFilter, parentFilter};
        DynamicObject[] structureObjArr = BusinessDataServiceHelper.load((String)"bos_org_structure", (String)selectFields, (QFilter[])filters);
        if (structureObjArr == null || structureObjArr.length == 0) {
            return;
        }
        int count = orgAndOldParentIds.size();
        for (DynamicObject structureObj : structureObjArr) {
            DynamicObject viewObj = structureObj.getDynamicObject("view");
            DynamicObject orgObj = structureObj.getDynamicObject("org");
            if (viewObj == null || orgObj == null) continue;
            long viewId = viewObj.getLong("id");
            long orgId = orgObj.getLong("id");
            this.recordOrgName(orgObj, orgNameMap, langNameOrgMap);
            DynamicObject parentObj = structureObj.getDynamicObject("parent");
            if (parentObj == null) continue;
            Map parentOrgMap = viewParentOrgMap.computeIfAbsent(viewId, v -> new HashMap(count));
            parentOrgMap.computeIfAbsent(parentObj.getLong("id"), v -> new ArrayList(count)).add(orgId);
        }
    }
}

