/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.org.opplugin.common;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kd.bos.entity.ExtendedDataEntity;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.org.opplugin.AbstractOrgOpValidator;
import kd.bos.org.opplugin.IOrgOpValidatorHandler;
import kd.bos.org.opplugin.model.OrgChangeData;
import kd.bos.org.opplugin.model.OrgOpBizChecker;
import kd.bos.org.opplugin.model.OrgOpContext;
import kd.bos.org.utils.OrgChangeType;
import kd.bos.org.utils.OrgCheckerUtils;
import kd.bos.orm.util.CollectionUtils;
import org.apache.commons.collections4.map.CaseInsensitiveMap;

public class OrgOpCheckerValidator
extends AbstractOrgOpValidator {
    private static final Log logger = LogFactory.getLog(OrgOpCheckerValidator.class);
    private List<OrgOpBizChecker> bizCheckers;
    private final String orgOperation;
    private final String registerOperation;
    private Map<String, Object> operationParams;
    private final Map<Long, Map<Long, Set<String>>> orgViewErrorMap;

    public OrgOpCheckerValidator(OrgOpContext orgOpContext, OrgChangeType changeType, Map<Long, Map<Long, Set<String>>> orgViewErrorMap) {
        this(orgOpContext, changeType.getChangeType(), changeType.getChangeType(), orgViewErrorMap);
    }

    public OrgOpCheckerValidator(OrgOpContext orgOpContext, String orgOperation, String registerOperation) {
        this(orgOpContext, orgOperation, registerOperation, null);
    }

    public OrgOpCheckerValidator(OrgOpContext orgOpContext, String orgOperation, String registerOperation, Map<Long, Map<Long, Set<String>>> orgViewErrorMap) {
        super(orgOpContext);
        this.orgOperation = orgOperation;
        this.registerOperation = registerOperation;
        this.orgViewErrorMap = orgViewErrorMap;
    }

    public void validate() {
        this.register();
        if (CollectionUtils.isEmpty(this.bizCheckers)) {
            return;
        }
        logger.info("\u3010\u7ec4\u7ec7\u4fdd\u5b58\u64cd\u4f5c\u3011\u5f00\u59cb\u6267\u884c\u4e1a\u52a1\u6ce8\u518c\u7684\u6821\u9a8c");
        this.operationParams = new CaseInsensitiveMap(this.orgOpContext.getOptionVariables());
        for (ExtendedDataEntity dataEntity : this.dataEntities) {
            for (OrgOpBizChecker checker : this.bizCheckers) {
                this.execute(dataEntity, checker);
            }
        }
        logger.info("\u3010\u7ec4\u7ec7\u4fdd\u5b58\u64cd\u4f5c\u3011\u5b8c\u6210\u6267\u884c\u4e1a\u52a1\u6ce8\u518c\u7684\u6821\u9a8c");
    }

    private void execute(ExtendedDataEntity dataEntity, OrgOpBizChecker checker) {
        long id = (Long)dataEntity.getDataEntity().getPkValue();
        Map<Long, Map<String, OrgChangeData>> viewPropertyChangedMap = checker.getOrgViewPropertyChangedMap().get(id);
        if (viewPropertyChangedMap == null) {
            return;
        }
        IOrgOpValidatorHandler validatorHandler = this.orgOpContext.getValidatorHandler();
        if (validatorHandler == null) {
            return;
        }
        ArrayList<Long> orgIds = new ArrayList<Long>(1);
        orgIds.add(id);
        ArrayList<Long> viewIds = new ArrayList<Long>(viewPropertyChangedMap.keySet());
        Map<Long, Map<Long, Set<String>>> checkerOrgViewErrorMap = OrgCheckerUtils.execute(checker.getOperation(), orgIds, viewIds, this.operationParams);
        OrgCheckerUtils.mergeResult(this.orgViewErrorMap, checkerOrgViewErrorMap, params -> {
            validatorHandler.handle(dataEntity, String.valueOf(params[0]));
            return null;
        });
    }

    private void register() {
        this.bizCheckers = new ArrayList<OrgOpBizChecker>();
        Map<Long, Map<String, Map<String, Map<Long, Map<String, OrgChangeData>>>>> data = this.orgOpContext.getChangeDataProvider().getData();
        HashMap<Long, Map<Long, Map<String, OrgChangeData>>> orgViewMap = new HashMap<Long, Map<Long, Map<String, OrgChangeData>>>(data.size());
        for (Map.Entry<Long, Map<String, Map<String, Map<Long, Map<String, OrgChangeData>>>>> dataEntry : data.entrySet()) {
            Map<Long, Map<String, OrgChangeData>> viewProMap;
            Map<String, Map<String, Map<Long, Map<String, OrgChangeData>>>> dataMap = dataEntry.getValue();
            Map<String, Map<Long, Map<String, OrgChangeData>>> structureMap = dataMap.get("structure");
            if (structureMap == null || (viewProMap = structureMap.get(this.orgOperation)) == null) continue;
            orgViewMap.put(dataEntry.getKey(), viewProMap);
        }
        if (!CollectionUtils.isEmpty(orgViewMap)) {
            OrgOpBizChecker checker = new OrgOpBizChecker(this.registerOperation, orgViewMap);
            this.bizCheckers.add(checker);
        }
        logger.info("\u3010\u7ec4\u7ec7\u4fdd\u5b58\u64cd\u4f5c\u3011\u4e1a\u52a1\u6ce8\u518c\u7684\u6821\u9a8c\u5668\u6570\u91cf\uff1a" + this.bizCheckers.size());
    }
}

