/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.org.opplugin.common;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.entity.ILocaleString;
import kd.bos.dataentity.entity.LocaleString;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.ExtendedDataEntity;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.org.model.OrgSeparation;
import kd.bos.org.opplugin.OrgOperationUtils;
import kd.bos.org.opplugin.model.OrgChangeData;
import kd.bos.org.opplugin.model.OrgChangeDataProvider;
import kd.bos.org.opplugin.model.OrgOpContext;
import kd.bos.org.utils.OrgTreeOrder;
import kd.bos.orm.query.QFilter;
import kd.bos.orm.util.CollectionUtils;
import kd.bos.servicehelper.org.OrgUnitServiceHelper;

public class OrgSorter {
    private static final Log logger = LogFactory.getLog(OrgSorter.class);
    private final OrgOpContext orgOpContext;
    private final ExtendedDataEntity[] dataEntities;
    private final Set<Long> validateViewIds;
    private final boolean validateAndSave;

    public OrgSorter(OrgOpContext orgOpContext, ExtendedDataEntity[] dataEntities, Set<Long> validateViewIds, boolean validateAndSave) {
        this.orgOpContext = orgOpContext;
        this.dataEntities = dataEntities;
        this.validateViewIds = validateViewIds;
        this.validateAndSave = validateAndSave;
    }

    public void sort() {
        if (this.validateViewIds.isEmpty()) {
            return;
        }
        logger.info("\u3010\u7ec4\u7ec7\u6392\u5e8f\u5904\u7406\u3011\u6267\u884c\u7ec4\u7ec7\u7ed3\u6784\u6392\u5e8f\uff1a" + this.dataEntities.length);
        HashMap<Long, List> allViewStructureMap = new HashMap<Long, List>(64);
        for (ExtendedDataEntity dataEntity : this.dataEntities) {
            DynamicObject orgObj = dataEntity.getDataEntity();
            long id = orgObj.getLong("id");
            this.orgOpContext.getDataEntityMap().put(id, dataEntity);
            DynamicObjectCollection structureObjCol = orgObj.getDynamicObjectCollection("structure");
            for (DynamicObject structureObj : structureObjCol) {
                long viewId;
                DynamicObject viewObj = structureObj.getDynamicObject("view");
                if (viewObj == null || !this.validateViewIds.contains(viewId = viewObj.getLong("id"))) continue;
                List orgMapList = allViewStructureMap.computeIfAbsent(viewId, k -> new ArrayList());
                HashMap<String, Long> orgMap = new HashMap<String, Long>(16);
                orgMapList.add(orgMap);
                orgMap.put("id", id);
                long parentId = 0L;
                DynamicObject parentObj = structureObj.getDynamicObject("viewparent");
                if (parentObj != null) {
                    parentId = parentObj.getLong("id");
                }
                orgMap.put("parentId", parentId);
                orgMap.put("structure", (Long)structureObj);
            }
        }
        HashSet<Long> parentIds = new HashSet<Long>(64);
        Map<Long, Map<Object, Map<String, Object>>> viewSortedOrgMap = this.orgOpContext.getViewSortedOrgMap();
        for (Map.Entry viewStructEntry : allViewStructureMap.entrySet()) {
            OrgTreeOrder orgTreeOrder = new OrgTreeOrder((List)viewStructEntry.getValue());
            Map<Object, Map<String, Object>> sortedOrgMap = orgTreeOrder.order();
            Long viewId = (Long)viewStructEntry.getKey();
            viewSortedOrgMap.put(viewId, sortedOrgMap);
            for (Map.Entry<Object, Map<String, Object>> orgEntry : sortedOrgMap.entrySet()) {
                Map<String, Object> orgMap = orgEntry.getValue();
                long parentId = (Long)orgMap.get("parentId");
                if (parentId == 0L) continue;
                parentIds.add(parentId);
            }
        }
        this.build(viewSortedOrgMap, parentIds);
    }

    private void build(Map<Long, Map<Object, Map<String, Object>>> viewSortedOrgMap, Set<Long> parentIds) {
        Map<Long, Map<Long, DynamicObject>> viewParentStructureMap = this.getParentStructure(parentIds);
        for (Map.Entry<Long, Map<Object, Map<String, Object>>> viewEntry : viewSortedOrgMap.entrySet()) {
            Map<Object, Map<String, Object>> sortedOrgMap = viewEntry.getValue();
            for (Map.Entry<Object, Map<String, Object>> orgEntry : sortedOrgMap.entrySet()) {
                Map<String, Object> orgMap = orgEntry.getValue();
                Map parentStructureMap = viewParentStructureMap.getOrDefault(viewEntry.getKey(), new HashMap(64));
                this.build(orgMap, parentStructureMap);
                this.buildSubOrg(orgMap, parentStructureMap);
            }
        }
    }

    private void build(Map<String, Object> orgMap, Map<Long, DynamicObject> parentStructureMap) {
        Long id = (Long)orgMap.get("id");
        DynamicObject structureObj = (DynamicObject)orgMap.get("structure");
        if (this.validateAndSave) {
            DynamicObject oldStructureObj = parentStructureMap.get(id);
            if (oldStructureObj == null) {
                oldStructureObj = structureObj;
            }
            String oldLongNumber = oldStructureObj.getString("longnumber");
            ILocaleString oldFullName = this.copyOldFullName(oldStructureObj.getLocaleString("fullname"));
            ExtendedDataEntity dataEntity = this.orgOpContext.getDataEntityMap().get(id);
            OrgOperationUtils.generateStructureEntry(dataEntity.getDataEntity(), structureObj, parentStructureMap, this.orgOpContext);
            this.generateSubStructureEntry(oldLongNumber, structureObj, oldFullName, parentStructureMap);
        } else {
            parentStructureMap.put(id, structureObj);
        }
        DynamicObject parentStructureObj = null;
        DynamicObject parentObj = structureObj.getDynamicObject("viewparent");
        if (parentObj != null) {
            parentStructureObj = parentStructureMap.get(parentObj.getLong("id"));
        }
        orgMap.put("structure.viewparent", parentStructureObj);
    }

    private ILocaleString copyOldFullName(ILocaleString localeString) {
        LocaleString oldLocaleString = new LocaleString();
        if (null != localeString) {
            oldLocaleString.putAll((Map)localeString);
        }
        return oldLocaleString;
    }

    private void generateSubStructureEntry(String oldLongNumber, DynamicObject structureObj, ILocaleString oldFullNameLocale, Map<Long, DynamicObject> parentStructureMap) {
        if (StringUtils.isBlank((CharSequence)oldLongNumber)) {
            return;
        }
        OrgChangeDataProvider changeDataProvider = new OrgChangeDataProvider();
        String newLongNumber = structureObj.getString("longnumber");
        OrgChangeData longNumChangeData = changeDataProvider.getChangeData(oldLongNumber, newLongNumber);
        ILocaleString newFullNameLocale = structureObj.getLocaleString("fullname");
        OrgChangeData fullNameChangeData = changeDataProvider.getChangeData(oldFullNameLocale, newFullNameLocale);
        if (longNumChangeData == null && fullNameChangeData == null) {
            return;
        }
        OrgSeparation orgSeparation = OrgUnitServiceHelper.getOrgSeparation();
        String longNumberSep = orgSeparation.getLongNumberSep();
        String fullNameSep = orgSeparation.getFullNameSep();
        String oldLongNumberPre = oldLongNumber + longNumberSep;
        for (Map.Entry<Long, DynamicObject> entry : parentStructureMap.entrySet()) {
            DynamicObject parentStructure = entry.getValue();
            String longNumber = parentStructure.getString("longnumber");
            ILocaleString fullNameLocale = parentStructure.getLocaleString("fullname");
            if (longNumber == null || !longNumber.startsWith(oldLongNumberPre)) continue;
            String newLongNumberPre = newLongNumber + longNumberSep;
            longNumber = longNumber.replace(oldLongNumberPre, newLongNumberPre);
            for (Map.Entry fullNameEntry : fullNameLocale.entrySet()) {
                String lang = (String)fullNameEntry.getKey();
                String fullName = (String)fullNameEntry.getValue();
                String oldFullNamePre = (String)oldFullNameLocale.get((Object)lang) + fullNameSep;
                String newFullNamePre = (String)newFullNameLocale.get((Object)lang) + fullNameSep;
                fullNameLocale.put((Object)lang, (Object)fullName.replace(oldFullNamePre, newFullNamePre));
            }
            parentStructure.set("longnumber", (Object)longNumber);
            parentStructure.set("fullname", (Object)fullNameLocale);
            parentStructure.set("level", (Object)longNumber.split(longNumberSep).length);
        }
    }

    private void buildSubOrg(Map<String, Object> orgMap, Map<Long, DynamicObject> parentStructureMap) {
        Map childrenMap = (Map)orgMap.get("children");
        if (CollectionUtils.isEmpty((Map)childrenMap)) {
            return;
        }
        for (Map.Entry subOrgEntry : childrenMap.entrySet()) {
            Map subOrgMap = (Map)subOrgEntry.getValue();
            this.build(subOrgMap, parentStructureMap);
            this.buildSubOrg(subOrgMap, parentStructureMap);
        }
    }

    private Map<Long, Map<Long, DynamicObject>> getParentStructure(Set<Long> parentIds) {
        HashMap<Long, Map<Long, DynamicObject>> viewStructureObjMap = new HashMap<Long, Map<Long, DynamicObject>>(64);
        QFilter orgFilter = new QFilter("id", "in", parentIds);
        QFilter[] filters = new QFilter[]{orgFilter};
        DynamicObject[] orgObjArr = OrgOperationUtils.getOrderOrgObject(filters);
        if (orgObjArr == null || orgObjArr.length == 0) {
            return new HashMap<Long, Map<Long, DynamicObject>>(0);
        }
        for (DynamicObject orgObj : orgObjArr) {
            long id = orgObj.getLong("id");
            DynamicObjectCollection structureCol = orgObj.getDynamicObjectCollection("structure");
            for (DynamicObject structureObj : structureCol) {
                DynamicObject viewObj = structureObj.getDynamicObject("view");
                if (viewObj == null) continue;
                long viewId = viewObj.getLong("id");
                Map structureMap = viewStructureObjMap.computeIfAbsent(viewId, k -> new HashMap(64));
                structureMap.put(id, structureObj);
            }
        }
        return viewStructureObjMap;
    }
}

