/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.org.opplugin.model;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import kd.bos.base.utils.IBaseCallbackHandler;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.org.opplugin.model.OrgChangeData;

public class OrgChangeDataProvider {
    private final Set<Long> changedViewIds = new HashSet<Long>(64);
    private final Set<Long> addNewOrgIds = new HashSet<Long>();
    private final List<OrgChangeData> rootChangeDataList = new ArrayList<OrgChangeData>(64);
    private final Map<Long, Map<String, Map<String, Map<Long, Map<String, OrgChangeData>>>>> data = new HashMap<Long, Map<String, Map<String, Map<Long, Map<String, OrgChangeData>>>>>();

    public Map<Long, Map<String, Map<String, Map<Long, Map<String, OrgChangeData>>>>> getData() {
        return this.data;
    }

    public Set<Long> getAddNewOrgIds() {
        return this.addNewOrgIds;
    }

    public Set<Long> getChangedViewIds() {
        return this.changedViewIds;
    }

    public List<OrgChangeData> getRootChangeDataList() {
        return this.rootChangeDataList;
    }

    public OrgChangeData getOrgProperty(long id, String property) {
        return this.getProperties(id, 0L, "org").get(property);
    }

    public OrgChangeData getStructureProperty(long id, long viewId, String property) {
        return this.getProperties(id, viewId, "structure").get(property);
    }

    public Map<Long, Map<String, OrgChangeData>> getViewChangeData(long id, String category) {
        return this.getViewChangeData(id, "structure", category);
    }

    private Map<String, OrgChangeData> getProperties(long id, long viewId, String entity) {
        Map<Long, Map<String, OrgChangeData>> viewMap = this.getViewChangeData(id, entity, "property");
        HashMap proMap = viewMap.get(viewId);
        return proMap == null ? new HashMap(0) : proMap;
    }

    private Map<Long, Map<String, OrgChangeData>> getViewChangeData(long id, String entity, String category) {
        Map<String, Map<String, Map<Long, Map<String, OrgChangeData>>>> dataMap = this.data.get(id);
        if (dataMap == null) {
            return new HashMap<Long, Map<String, OrgChangeData>>(0);
        }
        Map<String, Map<Long, Map<String, OrgChangeData>>> entityMap = dataMap.get(entity);
        if (entityMap == null) {
            return new HashMap<Long, Map<String, OrgChangeData>>(0);
        }
        HashMap viewMap = entityMap.get(category);
        return viewMap == null ? new HashMap(0) : viewMap;
    }

    public OrgChangeData putOrgChangeData(long id, String property, Object oldValue, Object newValue) {
        return this.putOrgChangeData(id, property, this.getChangeData(oldValue, newValue));
    }

    public OrgChangeData putOrgChangeData(long id, String property, OrgChangeData orgChangeData) {
        return this.putChangeData(id, 0L, "org", "property", property, orgChangeData);
    }

    public OrgChangeData putStructureChangeData(long id, long viewId, String property, Object oldValue, Object newValue) {
        return this.putStructureChangeData(id, viewId, property, this.getChangeData(oldValue, newValue));
    }

    public OrgChangeData putStructureChangeData(long id, long viewId, String property, OrgChangeData orgChangeData) {
        return this.putChangeData(id, viewId, "structure", "property", property, orgChangeData);
    }

    private OrgChangeData putChangeData(long id, long viewId, String entity, String category, String property, OrgChangeData orgChangeData) {
        if (orgChangeData == null) {
            return null;
        }
        Map dataMap = this.data.computeIfAbsent(id, v -> new HashMap(8));
        Map structureMap = dataMap.computeIfAbsent(entity, v -> new HashMap(64));
        Map viewMap = structureMap.computeIfAbsent(category, v -> new HashMap(64));
        Map proMap = viewMap.computeIfAbsent(viewId, v -> new HashMap(64));
        proMap.put(property, orgChangeData);
        this.changedViewIds.add(viewId);
        return orgChangeData;
    }

    public void modifyView(DynamicObject structureObj, boolean isAddView) {
        DynamicObject orgObj = structureObj.getDynamicObject("vieworg");
        if (orgObj == null) {
            return;
        }
        DynamicObject viewObj = structureObj.getDynamicObject("view");
        if (viewObj == null) {
            return;
        }
        this.modifyView(orgObj.getLong("id"), viewObj.getLong("id"), structureObj, isAddView);
    }

    public void modifyView(long id, long viewId, DynamicObject structureObj, boolean isAddView) {
        long parentId = 0L;
        DynamicObject parentObj = structureObj.getDynamicObject("viewparent");
        if (parentObj != null) {
            parentId = parentObj.getLong("id");
        }
        this.modifyView(id, viewId, "viewparent", new OrgChangeData(parentId, parentId), isAddView);
        String longNumber = structureObj.getString("longnumber");
        this.modifyView(id, viewId, "longnumber", new OrgChangeData(longNumber, longNumber), isAddView);
        Boolean isLeaf = structureObj.getBoolean("isleaf");
        this.modifyView(id, viewId, "isleaf", new OrgChangeData(isLeaf, isLeaf), isAddView);
        Boolean isFreeze = structureObj.getBoolean("isfreeze");
        this.modifyView(id, viewId, "isfreeze", new OrgChangeData(isFreeze, isFreeze), isAddView);
    }

    public void modifyView(long id, long viewId, String property, OrgChangeData orgChangeData, boolean isAddView) {
        this.modifyView(id, viewId, property, orgChangeData, isAddView ? "add" : "delete");
    }

    public void modifyView(long id, long viewId, String property, OrgChangeData orgChangeData, String operation) {
        this.putChangeData(id, viewId, "structure", operation, property, orgChangeData);
    }

    public Map<String, Object> convertToOperationParam() {
        HashMap<String, Object> orgChangeDataMap = new HashMap<String, Object>(4);
        orgChangeDataMap.put("data", this.getData());
        orgChangeDataMap.put("view", this.getChangedViewIds());
        orgChangeDataMap.put("addnew", this.getAddNewOrgIds());
        return orgChangeDataMap;
    }

    public boolean parseFromOperationParam(String orgChangeDataParam) {
        if (orgChangeDataParam == null) {
            return false;
        }
        Map orgChangeDataMap = (Map)SerializationUtils.fromJsonString((String)orgChangeDataParam, Map.class);
        boolean isCompared = this.parseFromOperationParam(orgChangeDataMap);
        this.parseLongParam((Collection)orgChangeDataMap.get("view"), this.getChangedViewIds());
        this.parseLongParam((Collection)orgChangeDataMap.get("addnew"), this.getAddNewOrgIds());
        return isCompared;
    }

    private void parseLongParam(Collection<Object> sourceIds, Collection<Long> targetIds) {
        if (sourceIds == null) {
            return;
        }
        for (Object id : sourceIds) {
            if (id instanceof Long) {
                targetIds.add((Long)id);
                continue;
            }
            targetIds.add(Long.valueOf(id.toString()));
        }
    }

    private boolean parseFromOperationParam(Map<String, Object> orgChangeDataMap) {
        Map data = (Map)orgChangeDataMap.get("data");
        if (data == null) {
            return false;
        }
        for (Map.Entry orgEntry : data.entrySet()) {
            long id = Long.parseLong((String)orgEntry.getKey());
            Map entityMap = (Map)orgEntry.getValue();
            for (Map.Entry entityEntry : entityMap.entrySet()) {
                this.parseFromOperationOrgParam(id, (String)entityEntry.getKey(), (Map)entityEntry.getValue());
            }
        }
        return true;
    }

    private void parseFromOperationOrgParam(long id, String entity, Map<String, Map<String, Map<String, Map<String, Object>>>> dataMap) {
        for (Map.Entry<String, Map<String, Map<String, Map<String, Object>>>> typeEntry : dataMap.entrySet()) {
            String operationType = typeEntry.getKey();
            this.parseFromOperationParam(typeEntry.getValue(), params -> {
                int index = 0;
                long viewId = (Long)params[index++];
                String property = (String)params[index++];
                OrgChangeData orgChangeData = (OrgChangeData)params[index++];
                if ("add".equals(operationType)) {
                    this.modifyView(id, viewId, property, orgChangeData, true);
                } else if ("delete".equals(operationType)) {
                    this.modifyView(id, viewId, property, orgChangeData, false);
                } else if ("org".equals(entity)) {
                    this.putOrgChangeData(id, property, orgChangeData);
                } else {
                    this.putStructureChangeData(id, viewId, property, orgChangeData);
                }
                return null;
            });
        }
    }

    private void parseFromOperationParam(Map<String, Map<String, Map<String, Object>>> viewChangeMap, IBaseCallbackHandler handler) {
        for (Map.Entry<String, Map<String, Map<String, Object>>> entry : viewChangeMap.entrySet()) {
            long viewId = Long.parseLong(entry.getKey());
            Map<String, Map<String, Object>> propertyMap = entry.getValue();
            for (Map.Entry<String, Map<String, Object>> propEntry : propertyMap.entrySet()) {
                Object newValue;
                Map<String, Object> valueMap = propEntry.getValue();
                Object oldValue = valueMap.get("oldValue");
                if (oldValue instanceof Integer) {
                    oldValue = Long.valueOf(oldValue.toString());
                }
                if ((newValue = valueMap.get("newValue")) instanceof Integer) {
                    newValue = Long.valueOf(newValue.toString());
                }
                handler.handle(viewId, propEntry.getKey(), new OrgChangeData(oldValue, newValue));
            }
        }
    }

    public OrgChangeData getChangeData(Object oldValue, Object newValue) {
        if (oldValue instanceof DynamicObject || newValue instanceof DynamicObject) {
            return this.getDynamicObjectChangeData(oldValue, newValue);
        }
        if (this.isChanged(oldValue, newValue)) {
            return new OrgChangeData(oldValue, newValue);
        }
        return null;
    }

    private boolean isChanged(Object oldValue, Object newValue) {
        if (oldValue instanceof Map || newValue instanceof Map) {
            return this.isLocaleStringChanged(oldValue, newValue);
        }
        return !Objects.equals(oldValue, newValue);
    }

    private OrgChangeData getDynamicObjectChangeData(Object oldValue, Object newValue) {
        DynamicObject oldDynamicObject = (DynamicObject)oldValue;
        DynamicObject newDynamicObject = (DynamicObject)newValue;
        Object oldPk = null;
        if (oldDynamicObject != null) {
            oldPk = oldDynamicObject.getPkValue();
        }
        Object newPk = null;
        if (newDynamicObject != null) {
            newPk = newDynamicObject.getPkValue();
        }
        if (oldPk == null) {
            if (newPk instanceof Long) {
                oldPk = 0L;
            }
        } else if (newPk == null && oldPk instanceof Long) {
            newPk = 0L;
        }
        if (Objects.equals(oldPk, newPk)) {
            return null;
        }
        return new OrgChangeData(oldPk, newPk);
    }

    private boolean isLocaleStringChanged(Object oldValue, Object newValue) {
        boolean isLocaleStringChanged = false;
        if (oldValue == null || newValue == null) {
            isLocaleStringChanged = true;
        } else {
            Set toEntries = ((Map)newValue).entrySet();
            for (Map.Entry nameEntry : toEntries) {
                if ("GLang".equals(nameEntry.getKey()) || !StringUtils.isNotBlank((CharSequence)((CharSequence)nameEntry.getValue())) || ((String)nameEntry.getValue()).equals(((Map)oldValue).get(nameEntry.getKey()))) continue;
                isLocaleStringChanged = true;
                break;
            }
        }
        return isLocaleStringChanged;
    }
}

