/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.org.opplugin.model;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import kd.bos.base.utils.BaseUtils;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.metadata.dynamicobject.DynamicObjectType;
import kd.bos.entity.property.BasedataProp;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.org.utils.OrgUtils;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.org.OrgUnitServiceHelper;

public class OrgDataProvider {
    private static final Log log = LogFactory.getLog(OrgDataProvider.class);
    private Long rootOrgId;
    private Set<Long> corporateOrgIds;
    private DynamicObjectType patternObjectType;
    private Map<Long, DynamicObject> patternObjectMap;
    private Map<Object, DynamicObject> bizMap;
    private Map<Object, DynamicObject> viewMap;
    private Map<String, DynamicObject> defaultViewMap;
    private Map<Long, List<DynamicObject>> bizViewMap = new HashMap<Long, List<DynamicObject>>(64);
    private Map<String, String> languageNameMap;

    public Long getRootOrgId() {
        if (this.rootOrgId == null) {
            this.rootOrgId = OrgUnitServiceHelper.getRootOrgId();
        }
        return this.rootOrgId;
    }

    public Set<Long> getCorporateOrgIds() {
        if (this.corporateOrgIds == null) {
            this.corporateOrgIds = new HashSet<Long>(OrgUtils.getCorporateOrgIds(false));
            log.info("\u3010\u7ec4\u7ec7\u64cd\u4f5c\u4e0a\u4e0b\u6587\u3011\u516c\u53f8\u5f62\u6001\u7684\u7ec4\u7ec7\uff1a" + this.viewMap.keySet());
        }
        return this.corporateOrgIds;
    }

    public DynamicObject getPatternObject(long id, DynamicObject orgObject) {
        DynamicObject patternObject = null;
        if (this.patternObjectMap == null) {
            this.patternObjectMap = new HashMap<Long, DynamicObject>(16);
        } else {
            patternObject = this.patternObjectMap.get(id);
        }
        if (patternObject == null) {
            patternObject = BusinessDataServiceHelper.loadSingleFromCache((Object)id, (DynamicObjectType)this.getPatternObjectType(orgObject));
            this.patternObjectMap.put(id, patternObject);
        }
        return patternObject;
    }

    private DynamicObjectType getPatternObjectType(DynamicObject orgObject) {
        if (this.patternObjectType == null) {
            BasedataProp patternProp = (BasedataProp)orgObject.getDataEntityType().getProperties().get((Object)"orgpattern");
            this.patternObjectType = (DynamicObjectType)patternProp.getComplexType();
        }
        return this.patternObjectType;
    }

    public Map<Object, DynamicObject> getBizMap() {
        if (this.bizMap == null) {
            this.bizMap = BusinessDataServiceHelper.loadFromCache((String)"bos_org_biz", null);
            log.info("\u3010\u7ec4\u7ec7\u64cd\u4f5c\u4e0a\u4e0b\u6587\u3011\u5168\u90e8\u804c\u80fd\u7c7b\u578b\uff1a" + this.bizMap.keySet());
        }
        return this.bizMap;
    }

    public DynamicObject getBizDynamicObject(Object pk) {
        return this.getBizMap().get(pk);
    }

    public Map<Object, DynamicObject> getViewDynamicObjectMap() {
        if (this.viewMap == null) {
            this.viewMap = BusinessDataServiceHelper.loadFromCache((String)"bos_org_viewschema", null);
            log.info("\u3010\u7ec4\u7ec7\u64cd\u4f5c\u4e0a\u4e0b\u6587\u3011\u5168\u90e8\u89c6\u56fe\u65b9\u6848\uff1a" + this.viewMap.keySet());
        }
        return this.viewMap;
    }

    public List<DynamicObject> getViewDynamicObjectByBizId(long bizId) {
        List<DynamicObject> viewObjList = this.bizViewMap.get(bizId);
        if (viewObjList == null) {
            viewObjList = new ArrayList<DynamicObject>(64);
            this.bizViewMap.put(bizId, viewObjList);
            Map<Object, DynamicObject> viewDynamicObjectMap = this.getViewDynamicObjectMap();
            for (Map.Entry<Object, DynamicObject> viewEntry : viewDynamicObjectMap.entrySet()) {
                DynamicObject viewObj = viewEntry.getValue();
                DynamicObject bizObj = viewObj.getDynamicObject("treetypeid");
                if (bizObj == null || !Objects.equals(bizId, bizObj.getLong("id"))) continue;
                viewObjList.add(viewObj);
            }
        }
        return viewObjList;
    }

    public DynamicObject getDefaultViewDynamicObject(String viewType) {
        if (this.defaultViewMap == null) {
            this.viewMap = this.getViewDynamicObjectMap();
            this.defaultViewMap = new HashMap<String, DynamicObject>(this.viewMap.size());
            for (Map.Entry<Object, DynamicObject> viewEntry : this.viewMap.entrySet()) {
                DynamicObject viewObj = viewEntry.getValue();
                if (!viewObj.getBoolean("isdefault")) continue;
                this.defaultViewMap.put(viewObj.getString("treetype"), viewObj);
            }
            log.info("\u3010\u7ec4\u7ec7\u64cd\u4f5c\u4e0a\u4e0b\u6587\u3011\u9ed8\u8ba4\u89c6\u56fe\u65b9\u6848\uff1a" + this.defaultViewMap.keySet());
        }
        return this.defaultViewMap.get(viewType);
    }

    public Map<String, String> getLanguageNameMap() {
        if (this.languageNameMap == null) {
            this.languageNameMap = BaseUtils.getEnableLangMap();
        }
        return this.languageNameMap;
    }

    public DynamicObject getViewByStructure(DynamicObject structureObj) {
        if (structureObj == null) {
            return null;
        }
        DynamicObject viewObj = structureObj.getDynamicObject("view");
        if (viewObj == null) {
            return null;
        }
        return this.getViewDynamicObjectMap().get(viewObj.getPkValue());
    }
}

