/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.org.opplugin.model;

import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.entity.ExtendedDataEntity;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.org.opplugin.IOrgOpValidatorHandler;
import kd.bos.org.opplugin.model.OrgChangeDataProvider;
import kd.bos.org.opplugin.model.OrgConfigProvider;
import kd.bos.org.opplugin.model.OrgDataProvider;
import kd.bos.org.utils.OrgUtils;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import org.apache.commons.collections4.map.CaseInsensitiveMap;

public class OrgOpContext {
    private static final Log log = LogFactory.getLog(OrgOpContext.class);
    private boolean fromAdminOrg;
    private String operationKey;
    private Map<String, String> optionVariables = new CaseInsensitiveMap(64);
    private Map<Long, ExtendedDataEntity> dataEntityMap = new HashMap<Long, ExtendedDataEntity>(64);
    private IOrgOpValidatorHandler validatorHandler;
    private final Set<Long> errorIds = new HashSet<Long>();
    private final OrgConfigProvider configProvider = new OrgConfigProvider();
    private final OrgDataProvider dataProvider = new OrgDataProvider();
    private final OrgChangeDataProvider changeDataProvider = new OrgChangeDataProvider();
    private final Map<Long, Map<Object, Map<String, Object>>> viewSortedOrgMap = new HashMap<Long, Map<Object, Map<String, Object>>>(64);
    private Boolean nameCaseInsensitive;
    private List<Long> ignoreFullNameUniqueViewIds;
    private Boolean compared;
    private Boolean orgApiBuildView;

    public boolean isFromAdminOrg() {
        return this.fromAdminOrg;
    }

    public void setFromAdminOrg(boolean fromAdminOrg) {
        this.fromAdminOrg = fromAdminOrg;
    }

    public String getOperationKey() {
        return this.operationKey;
    }

    public void setOperationKey(String operationKey) {
        this.operationKey = operationKey;
    }

    public Map<String, String> getOptionVariables() {
        return this.optionVariables;
    }

    public void setOptionVariables(Map<String, String> optionVariables) {
        log.info("\u3010\u7ec4\u7ec7\u64cd\u4f5c\u4e0a\u4e0b\u6587\u3011\u64cd\u4f5c\u53c2\u6570\uff1a" + optionVariables);
        if (optionVariables == null) {
            return;
        }
        this.optionVariables.putAll(optionVariables);
    }

    public Map<Long, ExtendedDataEntity> getDataEntityMap() {
        return this.dataEntityMap;
    }

    public IOrgOpValidatorHandler getValidatorHandler() {
        return this.validatorHandler;
    }

    public void setValidatorHandler(IOrgOpValidatorHandler validatorHandler) {
        this.validatorHandler = validatorHandler;
    }

    public Set<Long> getErrorIds() {
        return this.errorIds;
    }

    public OrgConfigProvider getConfigProvider() {
        return this.configProvider;
    }

    public OrgDataProvider getDataProvider() {
        return this.dataProvider;
    }

    public OrgChangeDataProvider getChangeDataProvider() {
        return this.changeDataProvider;
    }

    public Map<Long, Map<Object, Map<String, Object>>> getViewSortedOrgMap() {
        return this.viewSortedOrgMap;
    }

    public Boolean isNameCaseInsensitive() {
        if (this.nameCaseInsensitive == null) {
            QFilter idFilter = new QFilter("id", "=", (Object)1L);
            QFilter statusFilter = new QFilter("status", "=", (Object)"c");
            QFilter[] filters = new QFilter[]{idFilter, statusFilter};
            DynamicObject orgConfigObj = BusinessDataServiceHelper.loadSingleFromCache((String)"bos_org_config", (String)"id", (QFilter[])filters);
            this.nameCaseInsensitive = orgConfigObj != null;
        }
        return this.nameCaseInsensitive;
    }

    public List<Long> getIgnoreFullNameUniqueViewIds() {
        if (this.ignoreFullNameUniqueViewIds == null) {
            this.ignoreFullNameUniqueViewIds = OrgUtils.getIgnoreFullNameUniqueViewIds();
        }
        return this.ignoreFullNameUniqueViewIds;
    }

    public Boolean isCompared() {
        if (this.compared == null) {
            String orgChangeDataParam = this.getOptionVariables().getOrDefault("orgApiChangeData", null);
            this.compared = this.changeDataProvider.parseFromOperationParam(orgChangeDataParam);
        }
        return this.compared;
    }

    public Boolean isOrgApiBuildView() {
        if (this.orgApiBuildView != null) {
            return this.orgApiBuildView;
        }
        String orgApiBuildViewParam = this.getOptionVariables().getOrDefault("isOrgApiBuildView", Boolean.FALSE.toString());
        this.orgApiBuildView = Boolean.valueOf(orgApiBuildViewParam);
        return this.orgApiBuildView;
    }
}

