/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.org.utils;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kd.bos.base.utils.BaseBatchHandler;
import kd.bos.base.utils.IBaseCallbackHandler;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.metadata.IDataEntityProperty;
import kd.bos.dataentity.metadata.ISimpleProperty;
import kd.bos.dataentity.metadata.clr.DataEntityPropertyCollection;
import kd.bos.dataentity.metadata.dynamicobject.DynamicObjectType;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.entity.EntityObjectReader;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.metadata.dao.MetaCategory;
import kd.bos.metadata.dao.MetadataDao;
import kd.bos.metadata.entity.EntityItem;
import kd.bos.metadata.entity.EntityMetadata;
import kd.bos.orm.util.CollectionUtils;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import kd.sdk.annotation.SdkPublic;

@SdkPublic
public class DynamicObjectUtils {
    private static final Log logger = LogFactory.getLog(DynamicObjectUtils.class);

    public static void copy(DynamicObject fromObj, DynamicObject toObj) {
        DynamicObjectUtils.copy(fromObj, toObj, null, null);
    }

    public static void copy(DynamicObject fromObj, DynamicObject toObj, Set<String> ignoreKeys) {
        DynamicObjectUtils.copy(fromObj, toObj, ignoreKeys, null);
    }

    public static void copy(DynamicObject fromObj, DynamicObject toObj, Map<String, String> transKeyMap) {
        DynamicObjectUtils.copy(fromObj, toObj, null, transKeyMap);
    }

    public static void copy(DynamicObject fromObj, DynamicObject toObj, Set<String> ignoreKeys, Map<String, String> transKeyMap) {
        if (fromObj == null || toObj == null) {
            return;
        }
        DataEntityPropertyCollection fromPros = fromObj.getDataEntityType().getProperties();
        if (fromPros == null || fromPros.size() == 0) {
            return;
        }
        DataEntityPropertyCollection toPros = toObj.getDataEntityType().getProperties();
        if (toPros == null || toPros.size() == 0) {
            return;
        }
        HashSet<String> fromPsSet = new HashSet<String>(fromPros.size());
        for (Object pro : fromPros) {
            fromPsSet.add(pro.getName());
        }
        HashSet<String> toPsSet = new HashSet<String>(fromPros.size());
        for (IDataEntityProperty pro : toPros) {
            toPsSet.add(pro.getName());
        }
        ISimpleProperty primaryKeyObj = toObj.getDataEntityType().getPrimaryKey();
        String primaryKey = "";
        if (primaryKeyObj != null) {
            primaryKey = primaryKeyObj.getName();
        }
        if (transKeyMap == null) {
            transKeyMap = new HashMap<String, String>(0);
        }
        for (IDataEntityProperty pro : toPros) {
            String toProName = pro.getName();
            String fromProName = toProName;
            String customKey = transKeyMap.get(fromProName);
            if (StringUtils.isNotBlank((CharSequence)customKey)) {
                toProName = customKey;
            } else if (ignoreKeys != null && ignoreKeys.contains(toProName)) continue;
            if (!fromPsSet.contains(fromProName) || !toPsSet.contains(toProName)) continue;
            if (toProName.equals(primaryKey)) {
                toObj.set(toProName, null);
                continue;
            }
            Object value = fromObj.get(fromProName);
            if (value instanceof DynamicObjectCollection) {
                DynamicObjectCollection toEntity = DynamicObjectUtils.copyEntryEntity(value, toObj, toProName, ignoreKeys, transKeyMap);
                toObj.set(toProName, (Object)toEntity);
                continue;
            }
            toObj.set(toProName, value);
        }
    }

    private static DynamicObjectCollection copyEntryEntity(Object value, DynamicObject toObj, String toProName, Set<String> ignoreKeys, Map<String, String> transKeyMap) {
        DynamicObjectCollection formEntity = (DynamicObjectCollection)value;
        DynamicObjectCollection toEntity = toObj.getDynamicObjectCollection(toProName);
        if (toEntity != null) {
            toEntity.clear();
            DynamicObjectType entityType = toEntity.getDynamicObjectType();
            for (DynamicObject baseEntry : formEntity) {
                DynamicObject newEntry = new DynamicObject(entityType);
                DynamicObjectUtils.copy(baseEntry, newEntry, ignoreKeys, transKeyMap);
                toEntity.add((Object)newEntry);
            }
        }
        return toEntity;
    }

    public static EntityMetadata getEntityMetadata(String entityNumber) {
        ArrayList<String> fields = new ArrayList<String>(1);
        fields.add("dentityid");
        Map entityMap = EntityObjectReader.loadEntityObjectsFromCache(fields, (Object[])new String[]{entityNumber});
        if (CollectionUtils.isEmpty((Map)entityMap)) {
            return null;
        }
        DynamicObject entityObject = (DynamicObject)entityMap.entrySet().iterator().next().getValue();
        String id = entityObject.getString("dentityid");
        return (EntityMetadata)MetadataDao.readRuntimeMeta((String)id, (MetaCategory)MetaCategory.Entity);
    }

    public static DynamicObjectType getDynamicObjectType(String entityNumber, boolean includeExtendProp) {
        if (includeExtendProp) {
            return BusinessDataServiceHelper.newDynamicObject((String)entityNumber).getDynamicObjectType();
        }
        EntityMetadata entityMetadata = DynamicObjectUtils.getEntityMetadata(entityNumber);
        if (entityMetadata == null) {
            return BusinessDataServiceHelper.newDynamicObject((String)entityNumber).getDynamicObjectType();
        }
        List items = entityMetadata.getItems();
        HashSet<String> select = new HashSet<String>(items.size());
        for (EntityItem item : items) {
            if (item.isExt()) continue;
            select.add(item.getKey());
        }
        return EntityMetadataCache.getSubDataEntityType((String)entityNumber, select);
    }

    public static void saveHistory(String entityNumber, List<Long> ids, IBaseCallbackHandler copyHandler) {
        DynamicObjectUtils.saveHistory(entityNumber, ids, copyHandler, null);
    }

    public static void saveHistory(String entityNumber, List<Long> ids, IBaseCallbackHandler copyHandler, IBaseCallbackHandler historyHandler) {
        if (CollectionUtils.isEmpty(ids)) {
            return;
        }
        BaseBatchHandler.handle(ids, batchList -> {
            DynamicObject[] historyArr = null;
            try {
                historyArr = DynamicObjectUtils.saveHistory(entityNumber, (List<Long>)batchList, copyHandler, true);
            }
            catch (Exception e) {
                try {
                    historyArr = DynamicObjectUtils.saveHistory(entityNumber, (List<Long>)batchList, copyHandler, false);
                }
                catch (Exception ex) {
                    logger.info(entityNumber + "\uff1a\u4fdd\u5b58\u5386\u53f2\u6570\u636e\u53d1\u751f\u5f02\u5e38\uff1a" + ex.getMessage());
                }
            }
            if (historyHandler != null && historyArr != null) {
                historyHandler.handle(batchList, historyArr);
            }
        });
    }

    private static DynamicObject[] saveHistory(String entityNumber, List<Long> ids, IBaseCallbackHandler handler, boolean includeExtendProp) {
        DynamicObjectType dynamicObjectType = DynamicObjectUtils.getDynamicObjectType(entityNumber, includeExtendProp);
        DynamicObject[] objArr = BusinessDataServiceHelper.load((Object[])ids.toArray(new Object[ids.size()]), (DynamicObjectType)dynamicObjectType);
        if (objArr == null || objArr.length == 0) {
            logger.info(entityNumber + "\uff1a\u67e5\u8be2\u4e0d\u5230\u6570\u636e\uff0c\u751f\u6210\u5386\u53f2\u5931\u8d25\uff1a" + ids);
            return null;
        }
        DynamicObject[] historyArr = (DynamicObject[])handler.handle(objArr, includeExtendProp);
        if (historyArr == null || historyArr.length == 0) {
            logger.info(entityNumber + "\uff1a\u590d\u5236\u751f\u6210\u5386\u53f2\u8bb0\u5f55\u5931\u8d25\uff1a" + ids);
            return null;
        }
        return (DynamicObject[])SaveServiceHelper.save((DynamicObject[])historyArr);
    }
}

