/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.org.utils;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kd.bos.algo.DataSet;
import kd.bos.algo.Row;
import kd.bos.base.utils.msg.BaseMessage;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.datamodel.IDataModel;
import kd.bos.entity.tree.TreeNode;
import kd.bos.exception.KDBizException;
import kd.bos.form.FormShowParameter;
import kd.bos.form.IFormView;
import kd.bos.form.IPageCache;
import kd.bos.list.IListView;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.org.utils.Utils;
import kd.bos.orm.ORM;
import kd.bos.orm.query.QFilter;
import kd.bos.permission.api.HasPermOrgResult;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.devportal.BizAppServiceHelp;
import kd.bos.servicehelper.org.OrgUnitServiceHelper;
import kd.bos.servicehelper.permission.PermissionServiceHelper;

public class OrgBillListCommon {
    private static final Log log = LogFactory.getLog(OrgBillListCommon.class);
    public static final String IS_SHOW_DISABLED = "isshowdisabled";
    public static final String CUSTOM_ROOT_ID = "rootId";
    public static final String PARAM_INIT_ORG_ID = "initOrgId";
    public static final String PARAM_IS_LOCK_FUNC = "islockfunc";
    public static final String CACHE_CUSTOM_FILTER = "cache_custom_filter";
    public static final String CACHE_ADMIN_CHARGE_ORG = "cache_admin_charge_org";
    public static final String CACHE_COMMON_FIXED_FILTERS = "cache_common_fixed_filters";
    public static final String PARAM_IS_ORG_BASE_ADMIN = "isOrgBaseAdmin";
    public static final String PARAM_IS_ADD_USER_PERM_ORG_FILTER = "isAddUserPermOrgFilter";
    public static final String PARAM_ORGRELATION = "orgRelation";
    public static final String PARAM_IS_ONLY_DISPLAY_ORG_LEAVES = "isOnlyDisplayOrgLeaves";
    public static final String PARAM_ORG_RANGE_LIST = "range";
    public static final String PARAM_STRUCTURE_FILTER = "structureFilter";
    public static final String IS_DEFAULT_VIEW_SCHEME_NUMBER = "isDefaultViewSchemeNumber";
    public static final String ORG_FUNC_ID = "orgFuncId";
    public static final String ORG_VIEW_SCHEME_NUMBER = "orgViewSchemeNumber";
    public static final String INIT_ORG_FUNC_ID = "initOrgFuncId";
    public static final String FIRST_TIME_LOAD = "first_time_load";
    public static final String PARAM_PERM_ENTITYNUMBER = "permEntityNumber";

    public static void clearFilterCache(IPageCache pageCache, String orgViewNumber) {
        pageCache.remove(orgViewNumber + CACHE_COMMON_FIXED_FILTERS);
    }

    public static boolean addOrgFilterFromCache(Set<Long> orgFilterSet, IFormView formView, IPageCache pageCache, String orgViewNumber, TreeNode rootNode, boolean isIncludeFreeze, boolean isOrgF7) {
        String cacheKey = orgViewNumber + CACHE_COMMON_FIXED_FILTERS;
        String orgFilterSetCache = pageCache.get(cacheKey);
        boolean isAddedFilter = false;
        Map customParams = formView.getFormShowParameter().getCustomParams();
        if (orgFilterSetCache == null) {
            isAddedFilter = OrgBillListCommon.addOrgFixedFilter(orgFilterSet, formView, customParams, orgViewNumber, rootNode, isOrgF7);
            if (isAddedFilter) {
                pageCache.put(cacheKey, SerializationUtils.toJsonString(orgFilterSet));
            } else {
                pageCache.put(cacheKey, "");
            }
        } else if (StringUtils.isNotBlank((CharSequence)orgFilterSetCache)) {
            isAddedFilter = true;
            Set cacheSet = (Set)SerializationUtils.fromJsonString((String)orgFilterSetCache, Set.class);
            if (cacheSet != null) {
                orgFilterSet.addAll(cacheSet);
            }
        }
        isAddedFilter = OrgBillListCommon.addDynamicFilter(orgViewNumber, isIncludeFreeze, orgFilterSet, isAddedFilter);
        return isAddedFilter;
    }

    public static boolean addOrgFilter(Set<Long> orgFilterSet, IFormView formView, String orgViewNumber, TreeNode rootNode, boolean isIncludeFreeze, boolean isOrgF7) {
        return OrgBillListCommon.addOrgFilter(orgFilterSet, formView, formView.getFormShowParameter().getCustomParams(), orgViewNumber, rootNode, isIncludeFreeze, isOrgF7);
    }

    public static boolean addOrgFilter(Set<Long> orgFilterSet, Map<String, Object> customParams, String orgViewNumber) {
        boolean isIncludeFreeze = false;
        Object paramIsIncludeFreeze = customParams.get(IS_SHOW_DISABLED);
        if (StringUtils.isBlank((Object)paramIsIncludeFreeze) || ((Boolean)paramIsIncludeFreeze).booleanValue()) {
            isIncludeFreeze = true;
        }
        return OrgBillListCommon.addOrgFilter(orgFilterSet, null, customParams, orgViewNumber, null, isIncludeFreeze, true);
    }

    public static boolean addOrgFilter(Set<Long> orgFilterSet, IFormView formView, Map<String, Object> customParams, String orgViewNumber, TreeNode rootNode, boolean isIncludeFreeze, boolean isOrgF7) {
        boolean isAddedFilter = OrgBillListCommon.addOrgFixedFilter(orgFilterSet, formView, customParams, orgViewNumber, rootNode, isOrgF7);
        isAddedFilter = OrgBillListCommon.addDynamicFilter(orgViewNumber, isIncludeFreeze, orgFilterSet, isAddedFilter);
        return isAddedFilter;
    }

    private static boolean addOrgFixedFilter(Set<Long> orgFilterSet, IFormView formView, Map<String, Object> customParams, String orgViewNumber, TreeNode rootNode, boolean isOrgF7) {
        List<Long> customSubOrgIds = OrgBillListCommon.getCustomParamFilter(customParams, orgViewNumber, rootNode);
        boolean isAddedFilter = false;
        if (customSubOrgIds != null) {
            isAddedFilter = true;
            orgFilterSet.addAll(customSubOrgIds);
        }
        if (isAddedFilter && orgFilterSet.isEmpty()) {
            return isAddedFilter;
        }
        List<Long> relationOrgIds = OrgBillListCommon.getOrgRelation(customParams);
        if (relationOrgIds != null) {
            if (isAddedFilter) {
                orgFilterSet.retainAll(relationOrgIds);
            } else {
                orgFilterSet.addAll(relationOrgIds);
                isAddedFilter = true;
            }
        }
        if (isAddedFilter && orgFilterSet.isEmpty()) {
            return isAddedFilter;
        }
        List<Long> userPermOrgIds = OrgBillListCommon.getPermOrgs(formView, orgViewNumber, customParams, isOrgF7);
        if (userPermOrgIds != null) {
            orgFilterSet.retainAll(userPermOrgIds);
            if (isAddedFilter) {
                orgFilterSet.retainAll(userPermOrgIds);
            } else {
                orgFilterSet.addAll(userPermOrgIds);
                isAddedFilter = true;
            }
        }
        return isAddedFilter;
    }

    private static List<Long> getCustomParamFilter(Map<String, Object> customParams, String orgViewNumber, TreeNode rootNode) {
        QFilter customFilter = null;
        Object rangeOrgList = customParams.get(PARAM_ORG_RANGE_LIST);
        if (rangeOrgList != null) {
            QFilter rangeFilter;
            customFilter = rangeFilter = new QFilter("org", "in", rangeOrgList);
        }
        Object isOnlyDisplayOrgLeavesObj = customParams.get(PARAM_IS_ONLY_DISPLAY_ORG_LEAVES);
        boolean isOnlyDisplayOrgLeaves = false;
        if (StringUtils.isNotBlank((Object)isOnlyDisplayOrgLeavesObj)) {
            isOnlyDisplayOrgLeaves = Boolean.parseBoolean(isOnlyDisplayOrgLeavesObj.toString());
        }
        if (isOnlyDisplayOrgLeaves) {
            customFilter = customFilter == null ? new QFilter("isleaf", "=", (Object)Boolean.TRUE) : customFilter.and(new QFilter("isleaf", "=", (Object)Boolean.TRUE));
        }
        Object rootId = customParams.get(CUSTOM_ROOT_ID);
        ArrayList<Boolean> rootChildren = new ArrayList<Boolean>();
        boolean isRootOrgLeaf = true;
        QFilter customRootFilter = OrgBillListCommon.getCustomRootOrgFilter(rootId, orgViewNumber, rootNode, isOnlyDisplayOrgLeaves, rootChildren);
        if (customRootFilter != null) {
            customFilter = customFilter == null ? customRootFilter : customFilter.and(customRootFilter);
            if (!rootChildren.isEmpty()) {
                isRootOrgLeaf = (Boolean)rootChildren.get(0);
            }
        }
        customFilter = OrgBillListCommon.getStructureFilters(customParams, customFilter);
        if ((customFilter = OrgBillListCommon.getOrgViewNumberFilter(orgViewNumber, customParams, customFilter)) != null) {
            QFilter[] filters = new QFilter[]{customFilter};
            ArrayList<Long> orgIds = new ArrayList<Long>();
            try (DataSet ds = ORM.create().queryDataSet("kd.bos.orgview.OrgViewTreeListPlugin.getCustomRootFilter", "bos_org_structure", "org", filters);){
                for (Row row : ds) {
                    orgIds.add(row.getLong("org"));
                }
            }
            if (StringUtils.isNotBlank((Object)rootId) && (!isOnlyDisplayOrgLeaves || isRootOrgLeaf)) {
                orgIds.add(Long.valueOf(rootId.toString()));
            }
            return orgIds;
        }
        return null;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private static QFilter getCustomRootOrgFilter(Object rootId, String orgViewNumber, TreeNode rootNode, boolean isOnlyDisplayOrgLeaves, List<Boolean> rootChildren) {
        if (StringUtils.isBlank((Object)rootId)) {
            return null;
        }
        QFilter viewFilter = new QFilter("view.number", "=", (Object)orgViewNumber);
        String longNumber = "";
        if (rootNode == null || isOnlyDisplayOrgLeaves) {
            QFilter filter = new QFilter("org", "=", (Object)Long.valueOf(rootId.toString()));
            QFilter[] filters = new QFilter[]{filter, viewFilter};
            String selectFields = "longnumber,isleaf";
            try (DataSet ds = QueryServiceHelper.queryDataSet((String)"kd.bos.org.utils.OrgBillListCommon.getCustomParamFilter", (String)"bos_org_structure", (String)selectFields, (QFilter[])filters, (String)"", (int)1);){
                if (!ds.hasNext()) return new QFilter("longnumber", "like", (Object)(longNumber + "!" + "%"));
                Row row = ds.next();
                rootChildren.add(row.getBoolean("isleaf"));
                longNumber = row.getString("longnumber");
                return new QFilter("longnumber", "like", (Object)(longNumber + "!" + "%"));
            }
        } else {
            longNumber = rootNode.getLongNumber();
        }
        return new QFilter("longnumber", "like", (Object)(longNumber + "!" + "%"));
    }

    private static QFilter getOrgViewNumberFilter(String orgViewNumber, Map<String, Object> customParams, QFilter customFilter) {
        if (customFilter == null) {
            Object isDefaultViewObj = customParams.get(IS_DEFAULT_VIEW_SCHEME_NUMBER);
            if (isDefaultViewObj != null && !Boolean.parseBoolean(isDefaultViewObj.toString())) {
                QFilter viewFilter;
                customFilter = viewFilter = new QFilter("view.number", "=", (Object)orgViewNumber);
            }
        } else {
            QFilter viewFilter = new QFilter("view.number", "=", (Object)orgViewNumber);
            customFilter = customFilter.and(viewFilter);
        }
        return customFilter;
    }

    private static QFilter getStructureFilters(Map<String, Object> customParams, QFilter customFilter) {
        Object structureFilterObj = customParams.get(PARAM_STRUCTURE_FILTER);
        if (StringUtils.isBlank((Object)structureFilterObj)) {
            return customFilter;
        }
        QFilter structureFilter = null;
        try {
            structureFilter = QFilter.fromSerializedString((String)structureFilterObj.toString());
        }
        catch (Exception e) {
            throw new KDBizException(ResManager.loadKDString((String)"\u89e3\u6790\u53c2\u6570\u201cstructureFilter\u201d\u5931\u8d25\uff0c\u8bf7\u8054\u7cfb\u4e1a\u52a1\u5f00\u53d1\u4eba\u5458\u786e\u8ba4\u53c2\u6570\u503c\u662f\u5426\u5df2\u7ecf\u6267\u884c\u5e8f\u5217\u5316\u3002", (String)"OrgBillListCommon_0", (String)"bos-org-common", (Object[])new Object[0]));
        }
        customFilter = customFilter == null ? structureFilter : customFilter.and(structureFilter);
        return customFilter;
    }

    public static List<Long> getPermOrgs(IFormView formView, String orgViewNumber, Map<String, Object> customParams, boolean isOrgF7) {
        long userId = Long.parseLong(RequestContext.get().getUserId());
        Object isAddChargeOrgFilter = customParams.get(PARAM_IS_ORG_BASE_ADMIN);
        if (isAddChargeOrgFilter != null && Boolean.parseBoolean(isAddChargeOrgFilter.toString())) {
            HasPermOrgResult hasPermOrgResult = PermissionServiceHelper.getAdminChargeOrg((Long)userId, (String)orgViewNumber);
            if (hasPermOrgResult != null && !hasPermOrgResult.hasAllOrgPerm()) {
                List perOrgList = hasPermOrgResult.getHasPermOrgs();
                if (perOrgList == null || perOrgList.isEmpty()) {
                    return null;
                }
                return hasPermOrgResult.getHasPermOrgs();
            }
        } else {
            Object isAddUserPermOrgFilter = customParams.get(PARAM_IS_ADD_USER_PERM_ORG_FILTER);
            if (isAddUserPermOrgFilter != null && Boolean.parseBoolean(isAddUserPermOrgFilter.toString())) {
                String entityNum = OrgBillListCommon.getEntityNumber(formView, isOrgF7);
                String appId = "";
                if (StringUtils.isNotBlank((CharSequence)entityNum)) {
                    appId = BizAppServiceHelp.getAppIdByFormNum((String)entityNum);
                }
                return OrgBillListCommon.getUserHasPermOrgs(appId, entityNum);
            }
        }
        return null;
    }

    private static String getEntityNumber(IFormView formView, boolean isOrgF7) {
        if (formView == null) {
            return "";
        }
        if (!isOrgF7) {
            return formView.getEntityId();
        }
        IFormView parentView = formView.getViewNoPlugin(formView.getFormShowParameter().getParentPageId());
        if (parentView == null) {
            return "";
        }
        String entityNum = "";
        if (parentView instanceof IListView && StringUtils.isBlank((CharSequence)(entityNum = ((IListView)parentView).getBillFormId()))) {
            entityNum = parentView.getFormShowParameter().getFormId();
        }
        if (StringUtils.isBlank((CharSequence)entityNum)) {
            entityNum = parentView.getEntityId();
        }
        return entityNum;
    }

    private static List<Long> getUserHasPermOrgs(String appId, String entityNum) {
        long userId = Long.parseLong(RequestContext.get().getUserId());
        if (StringUtils.isBlank((CharSequence)entityNum)) {
            HasPermOrgResult permOrg = PermissionServiceHelper.getUserHasPermOrgs((long)userId);
            if (permOrg.hasAllOrgPerm()) {
                return null;
            }
            return permOrg.getHasPermOrgs();
        }
        HasPermOrgResult permOrg = PermissionServiceHelper.getAllPermOrgs((Long)userId, (String)appId, (String)entityNum, (String)"47150e89000000ac");
        if (permOrg.hasAllOrgPerm()) {
            return null;
        }
        return permOrg.getHasPermOrgs();
    }

    private static List<Long> getOrgRelation(Map<String, Object> customParams) {
        Map relationParams = (Map)customParams.get(PARAM_ORGRELATION);
        List relationOrgList = null;
        if (relationParams == null) {
            return relationOrgList;
        }
        Object orgpkid = relationParams.get("orgpkid");
        if (StringUtils.isBlank(orgpkid)) {
            return relationOrgList;
        }
        long orgId = Long.parseLong(orgpkid.toString());
        String directtype = String.valueOf(relationParams.get("directtype"));
        String fromtype = String.valueOf(relationParams.get("fromtype"));
        String totype = String.valueOf(relationParams.get("totype"));
        try {
            boolean isGetFromOrg = false;
            if ("toorg".equals(directtype)) {
                relationOrgList = OrgUnitServiceHelper.getAllToOrg((String)fromtype, (String)totype, (Long)orgId, (boolean)false);
            } else {
                relationOrgList = OrgUnitServiceHelper.getFromOrgs((String)totype, (Long)orgId, (String)fromtype, (boolean)false);
                isGetFromOrg = true;
            }
            if (Utils.isListEmpty((List)relationOrgList)) {
                return null;
            }
            if (isGetFromOrg) {
                if (StringUtils.isBlank((CharSequence)fromtype) || !"01".equals(fromtype) && OrgUnitServiceHelper.checkOrgFunction((Long)orgId, (String)fromtype)) {
                    relationOrgList.add(orgId);
                }
            } else if (!"01".equals(totype) && OrgUnitServiceHelper.checkOrgFunction((Long)orgId, (String)totype)) {
                relationOrgList.add(orgId);
            }
        }
        catch (Exception e) {
            log.info("\u751f\u6210\u4e1a\u52a1\u5355\u5143\u95f4\u534f\u4f5c\u8fc7\u6ee4\u6761\u4ef6\u65f6\u53d1\u751f\u5f02\u5e38\uff1a" + e.getMessage());
        }
        return relationOrgList;
    }

    private static boolean addDynamicFilter(String orgViewNumber, boolean isIncludeFreeze, Set<Long> orgFilterSet, boolean isAddedFilter) {
        if (isAddedFilter && orgFilterSet.isEmpty()) {
            return isAddedFilter;
        }
        if (!isIncludeFreeze && "01".equals(orgViewNumber)) {
            QFilter isFreezeFilter = new QFilter("isfreeze", "=", (Object)Boolean.FALSE);
            QFilter viewFilter = new QFilter("view.number", "=", (Object)orgViewNumber);
            if (isAddedFilter) {
                viewFilter = viewFilter.and(new QFilter("org", "in", orgFilterSet));
            }
            String selectFields = "id,org";
            QFilter[] filters = new QFilter[]{viewFilter, isFreezeFilter};
            DynamicObjectCollection orgCol = QueryServiceHelper.query((String)"bos_org_structure", (String)selectFields, (QFilter[])filters);
            orgFilterSet.clear();
            if (Utils.isListEmpty((List)orgCol)) {
                return true;
            }
            isAddedFilter = true;
            for (DynamicObject org : orgCol) {
                orgFilterSet.add(org.getLong("org"));
            }
        }
        return isAddedFilter;
    }

    public static boolean isIncludeFreeze(IDataModel dataModel) {
        try {
            return (Boolean)dataModel.getValue(IS_SHOW_DISABLED);
        }
        catch (Exception e) {
            return false;
        }
    }

    public static void initializeOrgView(FormShowParameter formShowParameter, String defaultViewType) {
        Map<String, String> viewMap = OrgBillListCommon.getInitializeOrgView(formShowParameter, defaultViewType);
        if (formShowParameter != null) {
            formShowParameter.setCustomParam(ORG_FUNC_ID, (Object)viewMap.get(ORG_FUNC_ID));
            formShowParameter.setCustomParam(ORG_VIEW_SCHEME_NUMBER, (Object)viewMap.get(ORG_VIEW_SCHEME_NUMBER));
        }
    }

    public static Map<String, String> getInitializeOrgView(FormShowParameter formShowParameter, String defaultViewType) {
        DynamicObject viewObject;
        Object islockfuncObj;
        HashMap<String, String> viewMap = new HashMap<String, String>(2);
        if (formShowParameter == null) {
            return viewMap;
        }
        String orgViewType = (String)formShowParameter.getCustomParam(ORG_FUNC_ID);
        String orgViewSchemeNumber = (String)formShowParameter.getCustomParam(ORG_VIEW_SCHEME_NUMBER);
        boolean hideViewTypeCombo = true;
        if (StringUtils.isBlank((CharSequence)orgViewType) && StringUtils.isBlank((CharSequence)orgViewSchemeNumber)) {
            hideViewTypeCombo = false;
            String initOrgViewType = (String)formShowParameter.getCustomParam(INIT_ORG_FUNC_ID);
            if (StringUtils.isNotBlank((CharSequence)initOrgViewType)) {
                orgViewType = initOrgViewType;
            }
        }
        if (StringUtils.isNotBlank((Object)(islockfuncObj = formShowParameter.getCustomParam(PARAM_IS_LOCK_FUNC))) && Boolean.parseBoolean(islockfuncObj.toString())) {
            hideViewTypeCombo = true;
        }
        formShowParameter.setCustomParam(PARAM_IS_LOCK_FUNC, (Object)hideViewTypeCombo);
        if (StringUtils.isNotBlank((CharSequence)orgViewType) && StringUtils.isNotBlank((CharSequence)orgViewSchemeNumber)) {
            viewMap.put(ORG_FUNC_ID, orgViewType);
            viewMap.put(ORG_VIEW_SCHEME_NUMBER, orgViewSchemeNumber);
            return viewMap;
        }
        QFilter[] filters = null;
        if (StringUtils.isBlank((CharSequence)orgViewType)) {
            if (StringUtils.isBlank((CharSequence)orgViewSchemeNumber)) {
                orgViewType = defaultViewType;
            } else {
                QFilter numberFilter = new QFilter("number", "=", (Object)orgViewSchemeNumber);
                filters = new QFilter[]{numberFilter};
            }
        }
        if (StringUtils.isBlank((CharSequence)orgViewSchemeNumber)) {
            QFilter treeTypeFilter = new QFilter("treetype", "=", (Object)orgViewType);
            QFilter defaultFilter = new QFilter("isdefault", "=", (Object)Boolean.TRUE);
            filters = new QFilter[]{treeTypeFilter, defaultFilter};
        }
        if (filters != null && (viewObject = BusinessDataServiceHelper.loadSingleFromCache((String)"bos_org_viewschema", (String)"treetype,isdefault", filters)) != null) {
            orgViewSchemeNumber = viewObject.getString("number");
            orgViewType = viewObject.getString("treetype");
        }
        if (StringUtils.isBlank((CharSequence)orgViewType) || StringUtils.isBlank((CharSequence)orgViewSchemeNumber)) {
            throw new KDBizException(BaseMessage.getMessage("M00028", ResManager.loadKDString((String)"\u804c\u80fd\u7c7b\u578b", (String)"OrgBillListCommon_1", (String)"bos-org-common", (Object[])new Object[0])));
        }
        viewMap.put(ORG_FUNC_ID, orgViewType);
        viewMap.put(ORG_VIEW_SCHEME_NUMBER, orgViewSchemeNumber);
        return viewMap;
    }
}

