/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.org.utils;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kd.bos.base.utils.IBaseCallbackHandler;
import kd.bos.base.utils.msg.OrgMessage;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.orm.util.CollectionUtils;
import kd.bos.service.DispatchService;
import kd.bos.service.lookup.ServiceLookup;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import org.apache.commons.collections4.map.CaseInsensitiveMap;

public class OrgCheckerUtils {
    private static final Log logger = LogFactory.getLog(OrgCheckerUtils.class);
    public static final String ENTITY_BOS_ORG_CHECKERREGISTER = "bos_org_checkerregister";
    public static final String APP = "app";
    public static final String SERVICE_FACTORY = "servicefactory";
    public static final String SERVICE_NAME = "servicename";
    public static final String METHOD = "method";
    public static final String CHECK_BIZ_CLEAR = "checkBizClear";
    public static final String VALIDATE = "validate";
    public static final String BATCH_CHECK_BIZ_CLEAR = "batchCheckBizClear";

    private OrgCheckerUtils() {
    }

    public static Map<Long, Map<Long, Set<String>>> execute(String operation, List<Long> orgIds, List<Long> viewIds, Map<String, Object> operationParams) {
        if (StringUtils.isBlank((CharSequence)operation)) {
            logger.info("\u3010\u7ec4\u7ec7\u4e1a\u52a1\u6821\u9a8c\u5668\u5de5\u5177\u7c7b\u3011\u201c\u64cd\u4f5c\u201d\u4e3a\u7a7a\uff0c\u5ffd\u7565\u6821\u9a8c\u5668\u6821\u9a8c\u3002");
            return new HashMap<Long, Map<Long, Set<String>>>(0);
        }
        if (CollectionUtils.isEmpty(orgIds)) {
            logger.info("\u3010\u7ec4\u7ec7\u4e1a\u52a1\u6821\u9a8c\u5668\u5de5\u5177\u7c7b\u3011\u201c\u7ec4\u7ec7ID\u201d\u4e3a\u7a7a\uff0c\u5ffd\u7565\u6821\u9a8c\u5668\u6821\u9a8c\u3002");
            return new HashMap<Long, Map<Long, Set<String>>>(0);
        }
        if (CollectionUtils.isEmpty(viewIds)) {
            logger.info("\u3010\u7ec4\u7ec7\u4e1a\u52a1\u6821\u9a8c\u5668\u5de5\u5177\u7c7b\u3011\u201c\u89c6\u56feID\u201d\u4e3a\u7a7a\uff0c\u5ffd\u7565\u6821\u9a8c\u5668\u6821\u9a8c\u3002");
            return new HashMap<Long, Map<Long, Set<String>>>(0);
        }
        Map<Object, DynamicObject> checkerObjMap = OrgCheckerUtils.getBizCheckers(operation, viewIds);
        HashMap<Long, Map<Long, Set<String>>> orgViewErrorMap = new HashMap<Long, Map<Long, Set<String>>>(orgIds.size());
        if (operationParams == null) {
            operationParams = new CaseInsensitiveMap();
        }
        for (Map.Entry<Object, DynamicObject> checkerEntry : checkerObjMap.entrySet()) {
            DynamicObject checkerObj = checkerEntry.getValue();
            OrgCheckerUtils.mergeResult(orgViewErrorMap, OrgCheckerUtils.execute(checkerObj, orgIds, OrgCheckerUtils.getValidateViewIds(checkerObj, viewIds), (Map<String, Object>)operationParams), null);
        }
        logger.info("\u3010\u7ec4\u7ec7\u4e1a\u52a1\u6821\u9a8c\u5668\u5de5\u5177\u7c7b\u3011\u6267\u884c\u7ed3\u679c\uff1a" + orgViewErrorMap);
        return orgViewErrorMap;
    }

    private static Map<Long, Map<Long, Set<String>>> execute(DynamicObject checkerObj, List<Long> orgIds, List<Long> viewIds, Map<String, Object> operationParams) {
        if (checkerObj == null) {
            return new HashMap<Long, Map<Long, Set<String>>>(0);
        }
        DynamicObject appObj = checkerObj.getDynamicObject(APP);
        if (appObj == null) {
            logger.info("\u3010\u7ec4\u7ec7\u4e1a\u52a1\u6821\u9a8c\u5668\u5de5\u5177\u7c7b\u3011" + checkerObj.getString("number") + "\uff1a\u5e94\u7528ID\u4e3a\u7a7a\uff0c\u5ffd\u7565\u6821\u9a8c\u5668\u6821\u9a8c\u3002");
            return new HashMap<Long, Map<Long, Set<String>>>(0);
        }
        HashMap<Long, Map<Long, Set<String>>> orgViewErrorMap = new HashMap<Long, Map<Long, Set<String>>>(orgIds.size());
        String factory = checkerObj.getString(SERVICE_FACTORY).trim();
        String appId = appObj.getString("number");
        String serviceName = checkerObj.getString(SERVICE_NAME).trim();
        String method = checkerObj.getString(METHOD);
        try {
            DispatchService service = (DispatchService)ServiceLookup.lookup(DispatchService.class, (String)appId);
            if (VALIDATE.equals(method)) {
                for (Long viewId : viewIds) {
                    Object result = service.invoke(factory, serviceName, method, new Object[]{viewId, orgIds, operationParams});
                    if (!(result instanceof Map)) continue;
                    OrgCheckerUtils.mergeResult(orgViewErrorMap, (Map)result);
                }
            } else {
                boolean multiView = BATCH_CHECK_BIZ_CLEAR.equals(method);
                for (Long orgId : orgIds) {
                    Object error = multiView ? service.invoke(factory, serviceName, method, new Object[]{orgId, OrgCheckerUtils.getViewNumberById(viewIds)}) : service.invoke(factory, serviceName, method, new Object[]{orgId});
                    OrgCheckerUtils.putError(orgViewErrorMap, error, orgId, viewIds);
                }
            }
        }
        catch (Exception e) {
            String errorMsg = OrgMessage.getMessage("M00075", checkerObj.getString("number"), e.getMessage());
            logger.info("\u3010\u7ec4\u7ec7\u4e1a\u52a1\u6821\u9a8c\u5668\u5de5\u5177\u7c7b\u3011" + errorMsg);
        }
        return orgViewErrorMap;
    }

    private static Map<Object, DynamicObject> getBizCheckers(String operation, List<Long> viewIds) {
        String selectFields = "id,number,view,operation,app,servicefactory,servicename,method";
        QFilter enableFilter = new QFilter("enable", "=", (Object)Boolean.TRUE);
        QFilter opFilter = new QFilter("operation", "=", (Object)operation);
        ArrayList<Long> allViewIds = new ArrayList<Long>(viewIds);
        allViewIds.add(0L);
        QFilter viewFilter = new QFilter("view", "in", allViewIds);
        QFilter[] filters = new QFilter[]{enableFilter, opFilter, viewFilter};
        return BusinessDataServiceHelper.loadFromCache((String)ENTITY_BOS_ORG_CHECKERREGISTER, (String)selectFields, (QFilter[])filters);
    }

    private static List<Long> getValidateViewIds(DynamicObject checkerObj, List<Long> viewIds) {
        DynamicObject viewObj = checkerObj.getDynamicObject("view");
        if (viewObj == null) {
            return viewIds;
        }
        ArrayList<Long> validateViewIds = new ArrayList<Long>(1);
        validateViewIds.add(viewObj.getLong("id"));
        return validateViewIds;
    }

    private static List<String> getViewNumberById(List<Long> viewIds) {
        ArrayList<String> viewNumberList = new ArrayList<String>(viewIds.size());
        Map viewObjMap = BusinessDataServiceHelper.loadFromCache((Object[])viewIds.toArray(new Object[0]), (String)"bos_org_viewschema");
        for (Map.Entry entry : viewObjMap.entrySet()) {
            DynamicObject viewObj = (DynamicObject)entry.getValue();
            if (!viewIds.contains(viewObj.getPkValue())) continue;
            viewNumberList.add(viewObj.getString("number"));
        }
        return viewNumberList;
    }

    private static void putError(Map<Long, Map<Long, Set<String>>> orgViewErrorMap, Object error, long orgId, List<Long> viewIds) {
        if (StringUtils.isBlank((Object)error)) {
            return;
        }
        Map viewErrorMap = orgViewErrorMap.computeIfAbsent(orgId, v -> new HashMap(64));
        for (Long viewId : viewIds) {
            viewErrorMap.computeIfAbsent(viewId, v -> new LinkedHashSet(4)).add(error.toString());
        }
    }

    public static void mergeResult(Map<Long, Map<Long, Set<String>>> originalMap, Map<Long, Map<Long, Set<String>>> currentMap) {
        OrgCheckerUtils.mergeResult(originalMap, currentMap, null);
    }

    public static void mergeResult(Map<Long, Map<Long, Set<String>>> originalMap, Map<Long, Map<Long, Set<String>>> currentMap, IBaseCallbackHandler customHandler) {
        if (currentMap == null) {
            return;
        }
        for (Map.Entry<Long, Map<Long, Set<String>>> orgEntry : currentMap.entrySet()) {
            Map<Long, Set<String>> viewErrorMap = orgEntry.getValue();
            if (CollectionUtils.isEmpty(viewErrorMap)) continue;
            for (Map.Entry<Long, Set<String>> viewEntry : viewErrorMap.entrySet()) {
                Set<String> errorList = viewEntry.getValue();
                if (CollectionUtils.isEmpty(errorList)) continue;
                if (originalMap != null) {
                    Map oriViewErrorMap = originalMap.computeIfAbsent(orgEntry.getKey(), v -> new HashMap(64));
                    oriViewErrorMap.computeIfAbsent(viewEntry.getKey(), v -> new LinkedHashSet()).addAll(errorList);
                }
                if (customHandler == null) continue;
                for (String error : errorList) {
                    customHandler.handle(error);
                }
            }
        }
    }
}

