/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.org.utils;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Future;
import kd.bos.algo.DataSet;
import kd.bos.algo.Row;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.tree.TreeNode;
import kd.bos.entity.tree.TreeNodeLabel;
import kd.bos.exception.KDBizException;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.org.model.OrgSeparation;
import kd.bos.org.model.OrgTreeBuildType;
import kd.bos.org.model.OrgTreeNodeLabel;
import kd.bos.org.model.OrgTreeParam;
import kd.bos.org.utils.OrgTreeUtils;
import kd.bos.org.utils.OrgUtils;
import kd.bos.org.utils.Utils;
import kd.bos.orm.impl.ORMUtil;
import kd.bos.orm.query.QFilter;
import kd.bos.orm.util.CollectionUtils;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.org.OrgUnitServiceHelper;
import kd.bos.threads.ThreadPool;
import kd.bos.threads.ThreadPools;

public class OrgTreeBuilder {
    private static final Log log = LogFactory.getLog(OrgTreeBuilder.class);
    private final OrgTreeParam param;
    private String selectFields;
    private QFilter commonFilter;
    private QFilter viewFilter;
    private String orderBy;
    private String orgTreeNodeNameFormat;
    private static final ThreadPool threadPool = ThreadPools.newFixedThreadPool((String)"kd.bos.org.utils.OrgTreeBuilder.ThreadPools", (int)2);
    private OrgSeparation orgSeparation;
    private String longNumberSep;
    private static final String DEFAULT_NODE_COLOR = "#000000";

    public OrgTreeBuilder(OrgTreeParam param) {
        this.param = param;
        if (param == null) {
            log.error("\u53c2\u6570\u4e3a\u7a7a\uff0c\u6784\u5efa\u7ec4\u7ec7\u6811\u5931\u8d25\u3002");
            return;
        }
        this.orgSeparation = OrgUnitServiceHelper.getOrgSeparation();
        this.longNumberSep = this.orgSeparation.getLongNumberSep();
        this.orderBy = OrgUtils.getOrgTreeOrderByFields(param.getOrderBy());
        this.selectFields = OrgUtils.getOrgTreeSelectFields(this.param.getNameProperty(), this.orderBy);
        this.initCommonFilter();
        this.orgTreeNodeNameFormat = OrgTreeUtils.getOrgTreeNodeFormat();
    }

    public Map<String, Object> buildRootNode() {
        return this.convertNodeToMap(this.buildRootTreeNode());
    }

    public TreeNode buildRootTreeNode() {
        if (this.param == null) {
            log.error("\u53c2\u6570\u4e3a\u7a7a\uff0c\u6784\u5efa\u7ec4\u7ec7\u6811\u6839\u8282\u70b9\u5931\u8d25\u3002");
            return null;
        }
        String rootLongNumber = this.findMaxCommonLongNumber();
        if (StringUtils.isBlank((CharSequence)rootLongNumber)) {
            log.error("\u83b7\u53d6\u6839\u7ec4\u7ec7\u957f\u7f16\u7801\u5931\u8d25\u3002");
            return null;
        }
        QFilter longNumberFilter = new QFilter("structure.longnumber", "=", (Object)rootLongNumber);
        QFilter[] filters = new QFilter[]{this.viewFilter, longNumberFilter};
        try (DataSet rootOrg = QueryServiceHelper.queryDataSet((String)"OrgTreeBuilder.buildRootTreeNode", (String)"bos_org", (String)this.selectFields, (QFilter[])filters, (String)"");){
            if (rootOrg.hasNext()) {
                TreeNode rootNode = this.convertToTreeNode(rootOrg.next());
                if (rootNode == null) {
                    TreeNode treeNode = null;
                    return treeNode;
                }
                rootNode.setIsOpened(true);
                rootNode.setParentid("");
                TreeNode treeNode = rootNode;
                return treeNode;
            }
        }
        return null;
    }

    public List<Map<String, Object>> build() {
        List<TreeNode> treeNodes = this.buildTreeNodes();
        ArrayList<Map<String, Object>> treeNodeMapList = new ArrayList<Map<String, Object>>(treeNodes.size());
        for (TreeNode treeNode : treeNodes) {
            this.build(treeNodeMapList, treeNode);
        }
        return treeNodeMapList;
    }

    private void build(List<Map<String, Object>> treeNodeMapList, TreeNode treeNode) {
        if (treeNode == null) {
            return;
        }
        treeNodeMapList.add(this.convertNodeToMap(treeNode));
        List children = treeNode.getChildren();
        if (children == null || children.isEmpty()) {
            return;
        }
        for (TreeNode childNode : children) {
            this.build(treeNodeMapList, childNode);
        }
    }

    public List<TreeNode> buildTreeNodes() {
        if (this.param == null) {
            log.error("\u53c2\u6570\u4e3a\u7a7a\uff0c\u6784\u5efa\u7ec4\u7ec7\u6811\u4e0b\u7ea7\u8282\u70b9\u5931\u8d25\u3002");
            return new ArrayList<TreeNode>(0);
        }
        OrgTreeBuildType treeType = this.param.getTreeBuildType();
        if (OrgTreeBuildType.FILL_HIDDEN_PARENT_ALL.equals((Object)treeType)) {
            return this.getTreeChildrenFillHiddenParent();
        }
        if (OrgTreeBuildType.SKIP_HIDDEN_PARENT_ALL.equals((Object)treeType)) {
            return this.getTreeChildrenSkipHiddenParent();
        }
        if (OrgTreeBuildType.QUERY_ALL_AS_LIST.equals((Object)treeType)) {
            List<QFilter> filters = this.getSubOrgFilterByParam(null);
            return this.getChildren(filters.toArray(new QFilter[filters.size()]), null);
        }
        return this.getDirectChildrenFillHiddenParent();
    }

    private String findMaxCommonLongNumber() {
        String rootLongNumber = "";
        List<QFilter> rootNodeFilter = this.getRootNodeFilter();
        try (DataSet dataSet = QueryServiceHelper.queryDataSet((String)"OrgTreeBuilder.findMaxCommonLongNumber", (String)"bos_org", (String)"structure.longnumber", (QFilter[])rootNodeFilter.toArray(new QFilter[rootNodeFilter.size()]), (String)"");){
            int startIndex = -1;
            for (Row row : dataSet) {
                String longNumber = row.getString("structure.longnumber");
                if (StringUtils.isBlank((CharSequence)longNumber)) {
                    log.error("\u7ec4\u7ec7\u7ed3\u6784\u8868\u5b58\u5728\u5f02\u5e38\u6570\u636e\uff1a\u957f\u7f16\u7801\u4e3a\u7a7a\u3002");
                    continue;
                }
                if (startIndex == -1) {
                    startIndex = this.findSecondLevelStartIndex(longNumber);
                    rootLongNumber = longNumber;
                } else {
                    rootLongNumber = this.findMaxCommonLongNumber(rootLongNumber, longNumber, startIndex);
                }
                if (rootLongNumber.indexOf(this.longNumberSep) != -1) continue;
                break;
            }
        }
        return rootLongNumber;
    }

    private String findMaxCommonLongNumber(String rootLongNumber, String longNumber, int startIndex) {
        int length = rootLongNumber.length();
        char differentChar = '\u0000';
        if (length > longNumber.length()) {
            length = longNumber.length();
            differentChar = rootLongNumber.charAt(length);
        } else if (length < longNumber.length()) {
            differentChar = longNumber.charAt(length);
        }
        int differentCharIndex = -1;
        for (int i = startIndex; i < length; ++i) {
            char tempChar = rootLongNumber.charAt(i);
            if (tempChar == longNumber.charAt(i)) continue;
            differentChar = tempChar;
            differentCharIndex = i;
            break;
        }
        if (differentCharIndex == -1) {
            if (longNumber.length() == rootLongNumber.length()) {
                return rootLongNumber;
            }
            differentCharIndex = length;
        }
        boolean isSubstringBySplit = differentChar == this.longNumberSep.charAt(0) ? length >= differentCharIndex + 1 : true;
        rootLongNumber = rootLongNumber.substring(0, differentCharIndex);
        if (isSubstringBySplit) {
            rootLongNumber = StringUtils.substringBeforeLast((String)rootLongNumber, (String)this.longNumberSep);
        }
        return rootLongNumber;
    }

    private List<QFilter> getRootNodeFilter() {
        ArrayList<QFilter> filters = new ArrayList<QFilter>(32);
        long orgId = this.param.getId();
        if (orgId == 0L) {
            if (this.param.isBuildRootNodeInRange()) {
                filters.add(this.commonFilter);
                filters.addAll(this.getOrgFiltersByCustomFilter());
            } else {
                filters.add(this.viewFilter);
                QFilter parentFilter = new QFilter("structure.viewparent", "=", (Object)0L);
                filters.add(parentFilter);
            }
        } else {
            log.info(orgId + "\uff1a\u6839\u636eID\u521b\u5efa\u6839\u7ec4\u7ec7\u8282\u70b9\u3002");
            filters.add(this.viewFilter);
            QFilter orgFilter = new QFilter("id", "=", (Object)orgId);
            filters.add(orgFilter);
        }
        return filters;
    }

    private int findSecondLevelStartIndex(String longNumber) {
        int startIndex = longNumber.indexOf(this.longNumberSep) - 1;
        if (startIndex < 0) {
            startIndex = 0;
        }
        return startIndex;
    }

    private List<TreeNode> getDirectChildrenFillHiddenParent() {
        ArrayList<TreeNode> treeNodeList = new ArrayList<TreeNode>();
        long orgId = this.param.getId();
        if (orgId == 0L) {
            TreeNode rootNode = this.buildRootTreeNode();
            if (rootNode != null) {
                treeNodeList.add(rootNode);
            }
            return treeNodeList;
        }
        DynamicObjectCollection directSubOrgCol = this.getOrgTreeDirectSubordinate();
        if (CollectionUtils.isEmpty((Collection)directSubOrgCol)) {
            return treeNodeList;
        }
        int parentLevel = 0;
        String parentLongNumber = "";
        Iterator direStructItr = directSubOrgCol.iterator();
        int directSubOrgCount = directSubOrgCol.size() - 1;
        while (direStructItr.hasNext()) {
            DynamicObject orgObj = (DynamicObject)direStructItr.next();
            String longNumber = orgObj.getString("structure.longnumber");
            if (orgId != orgObj.getLong("id")) continue;
            parentLevel = orgObj.getInt("structure.level");
            parentLongNumber = longNumber;
            direStructItr.remove();
            break;
        }
        if (parentLevel == 0) {
            log.error(orgId + "\uff1a\u67e5\u8be2\u5f53\u524d\u7ec4\u7ec7\u6811\u8282\u70b9\u4fe1\u606f\u5931\u8d25\uff1a" + this.commonFilter);
            return treeNodeList;
        }
        if (directSubOrgCount <= 0) {
            log.info(orgId + "\uff1a\u67e5\u8be2\u5f53\u524d\u7ec4\u7ec7\u6811\u8282\u70b9\u76f4\u63a5\u4e0b\u7ea7\u6570\u91cf\u4e3a0" + this.commonFilter);
            return treeNodeList;
        }
        List<QFilter> childrenFilters = this.getSubOrgFilterByParam(parentLongNumber);
        Map<String, Boolean> longNumberLeafMap = this.getOrgLongNumberLeafMap(directSubOrgCount, parentLevel, childrenFilters);
        if (longNumberLeafMap.isEmpty()) {
            return new ArrayList<TreeNode>(0);
        }
        return this.getDirectChildrenFillHiddenParent(directSubOrgCol, longNumberLeafMap);
    }

    private List<TreeNode> getDirectChildrenFillHiddenParent(DynamicObjectCollection directSubOrgCol, Map<String, Boolean> longNumberLeafMap) {
        ArrayList<TreeNode> treeNodeList = new ArrayList<TreeNode>(directSubOrgCol.size());
        try (DataSet dataSet = ORMUtil.toDataSet((DynamicObjectCollection)directSubOrgCol);){
            for (Row orgObj : dataSet) {
                if (longNumberLeafMap.isEmpty()) {
                    break;
                }
                String longNumber = orgObj.getString("structure.longnumber");
                Boolean isLeaf = longNumberLeafMap.remove(longNumber);
                if (isLeaf == null) continue;
                TreeNode node = this.convertToTreeNode(orgObj);
                this.setLeaf(node, isLeaf);
                treeNodeList.add(node);
            }
        }
        return treeNodeList;
    }

    private List<QFilter> getSubOrgFilterByParam(String parentLongNumber) {
        ArrayList<QFilter> childrenFilters = new ArrayList<QFilter>();
        childrenFilters.add(this.commonFilter);
        childrenFilters.addAll(this.getOrgFiltersByCustomFilter());
        if (StringUtils.isNotBlank((CharSequence)parentLongNumber)) {
            QFilter longNumberFilter = QFilter.like((String)"structure.longnumber", (String)(parentLongNumber + this.longNumberSep + "%"));
            childrenFilters.add(longNumberFilter);
        }
        return childrenFilters;
    }

    private List<QFilter> getOrgFiltersByCustomFilter() {
        List orgRangeList = this.param.getOrgRangeList();
        ArrayList<QFilter> filters = new ArrayList<QFilter>();
        if (orgRangeList != null) {
            if (orgRangeList.isEmpty()) {
                filters.add(new QFilter("id", "in", (Object)orgRangeList));
                return filters;
            }
            filters.add(new QFilter("id", "in", (Object)orgRangeList));
        }
        if (Utils.isListNotEmpty((List)this.param.getCustomFilterList())) {
            filters.addAll(this.param.getCustomFilterList());
        }
        return filters;
    }

    private Map<String, Boolean> getOrgLongNumberLeafMap(int directSubOrgCount, int parentLevel, List<QFilter> childrenFilters) {
        HashMap<String, Boolean> longNumberLeafMap = new HashMap<String, Boolean>(directSubOrgCount);
        try (DataSet ds = QueryServiceHelper.queryDataSet((String)"OrgTreeBuilder.getOrgLongNumberLeafMap", (String)"bos_org", (String)"structure.longnumber,structure.level", (QFilter[])childrenFilters.toArray(new QFilter[childrenFilters.size()]), (String)"");){
            int directSubOrgLevel = parentLevel + 1;
            for (Row row : ds) {
                String rowLongNumber = row.getString("structure.longnumber");
                if (row.getInteger("structure.level") == directSubOrgLevel) {
                    if (longNumberLeafMap.containsKey(rowLongNumber)) continue;
                    longNumberLeafMap.put(rowLongNumber, Boolean.TRUE);
                    continue;
                }
                longNumberLeafMap.put(this.getLongNumberByLevel(rowLongNumber, directSubOrgLevel), Boolean.FALSE);
            }
        }
        return longNumberLeafMap;
    }

    private String getLongNumberByLevel(String longNumber, int level) {
        char[] lnChars = longNumber.toCharArray();
        StringBuilder directLnSb = new StringBuilder();
        int splitCount = 0;
        char longNumberChar = this.longNumberSep.charAt(0);
        for (char c : lnChars) {
            if (c == longNumberChar) {
                ++splitCount;
            }
            if (splitCount == level) break;
            directLnSb.append(c);
        }
        return directLnSb.toString();
    }

    private DynamicObjectCollection getOrgTreeDirectSubordinate() {
        QFilter orgFilter = new QFilter("structure.vieworg", "=", (Object)this.param.getId());
        orgFilter = orgFilter.or(new QFilter("structure.viewparent", "=", (Object)this.param.getId()));
        QFilter[] filters = new QFilter[]{this.viewFilter, orgFilter};
        return QueryServiceHelper.query((String)"bos_org", (String)this.selectFields, (QFilter[])filters, (String)this.orderBy);
    }

    /*
     * Loose catch block
     */
    private List<TreeNode> getTreeChildrenFillHiddenParent() {
        ArrayList<TreeNode> arrayList;
        Throwable throwable;
        DataSet orderDataSet;
        Throwable throwable2;
        DataSet dataSet;
        block31: {
            block32: {
                block29: {
                    block30: {
                        TreeNode parentOrgNode = this.getParentOrgNode();
                        if (parentOrgNode == null) {
                            return new ArrayList<TreeNode>(0);
                        }
                        String parentLongNumber = parentOrgNode.getLongNumber();
                        Future numberFuture = threadPool.submit(() -> this.getSubOrgNumbers(parentLongNumber));
                        QFilter longNumberFilter = QFilter.like((String)"structure.longnumber", (String)(parentLongNumber + this.longNumberSep + "%"));
                        QFilter[] filters = new QFilter[]{this.viewFilter, longNumberFilter};
                        dataSet = QueryServiceHelper.queryDataSet((String)"OrgTreeBuilder.getTreeChildrenFillHiddenParent", (String)"bos_org", (String)this.selectFields, (QFilter[])filters, (String)"");
                        throwable2 = null;
                        orderDataSet = dataSet.orderBy(this.orderBy.split(","));
                        throwable = null;
                        Set orgNumbers = (Set)numberFuture.get();
                        HashMap<String, TreeNode> orgNodeMap = new HashMap<String, TreeNode>(orgNumbers.size());
                        ArrayList<TreeNode> treeNodeList = new ArrayList<TreeNode>(orgNumbers.size());
                        for (Row orgObj : orderDataSet) {
                            if (!orgNumbers.remove(orgObj.getString("number"))) continue;
                            TreeNode treeNode = this.convertToTreeNode(orgObj);
                            this.addChild(treeNode, treeNodeList, orgNodeMap);
                        }
                        arrayList = treeNodeList;
                        if (orderDataSet == null) break block29;
                        if (throwable == null) break block30;
                        try {
                            orderDataSet.close();
                        }
                        catch (Throwable throwable3) {
                            throwable.addSuppressed(throwable3);
                        }
                        break block29;
                    }
                    orderDataSet.close();
                }
                if (dataSet == null) break block31;
                if (throwable2 == null) break block32;
                try {
                    dataSet.close();
                }
                catch (Throwable throwable4) {
                    throwable2.addSuppressed(throwable4);
                }
                break block31;
            }
            dataSet.close();
        }
        return arrayList;
        {
            catch (Throwable throwable5) {
                try {
                    try {
                        try {
                            try {
                                throwable = throwable5;
                                throw throwable5;
                            }
                            catch (Throwable throwable6) {
                                if (orderDataSet != null) {
                                    if (throwable != null) {
                                        try {
                                            orderDataSet.close();
                                        }
                                        catch (Throwable throwable7) {
                                            throwable.addSuppressed(throwable7);
                                        }
                                    } else {
                                        orderDataSet.close();
                                    }
                                }
                                throw throwable6;
                            }
                        }
                        catch (Throwable throwable8) {
                            throwable2 = throwable8;
                            throw throwable8;
                        }
                    }
                    catch (Throwable throwable9) {
                        if (dataSet != null) {
                            if (throwable2 != null) {
                                try {
                                    dataSet.close();
                                }
                                catch (Throwable throwable10) {
                                    throwable2.addSuppressed(throwable10);
                                }
                            } else {
                                dataSet.close();
                            }
                        }
                        throw throwable9;
                    }
                }
                catch (InterruptedException e) {
                    log.error("\u83b7\u53d6\u8865\u9f50\u9690\u85cf\u4e0a\u7ea7\u7684\u6784\u9020\u6811\u5168\u90e8\u4e0b\u7ea7\u5931\u8d25\uff1a" + e.getMessage(), (Throwable)e);
                }
                catch (ExecutionException e) {
                    log.error("\u83b7\u53d6\u8865\u9f50\u9690\u85cf\u4e0a\u7ea7\u7684\u6784\u9020\u6811\u5168\u90e8\u4e0b\u7ea7\u5931\u8d25\uff1a" + e.getMessage(), (Throwable)e);
                }
            }
        }
        return new ArrayList<TreeNode>(0);
    }

    private Set<String> getSubOrgNumbers(String parentLongNumber) {
        List<QFilter> childrenFilters = this.getSubOrgFilterByParam(parentLongNumber);
        HashSet<String> numbersIncludeParent = new HashSet<String>();
        try (DataSet dataSet = QueryServiceHelper.queryDataSet((String)"OrgTreeBuilder.getSubOrgNumbers", (String)"bos_org", (String)"structure.longnumber", (QFilter[])childrenFilters.toArray(new QFilter[childrenFilters.size()]), (String)"");){
            for (Row row : dataSet) {
                String subLongNumber = row.getString("structure.longnumber");
                if (!StringUtils.isNotBlank((CharSequence)subLongNumber)) continue;
                numbersIncludeParent.addAll(Arrays.asList(subLongNumber.split(this.longNumberSep)));
            }
        }
        numbersIncludeParent.removeAll(Arrays.asList(parentLongNumber.split(this.longNumberSep)));
        return numbersIncludeParent;
    }

    private TreeNode getParentOrgNode() {
        long orgId = this.param.getId();
        QFilter parentFilter = orgId == 0L ? new QFilter("structure.viewparent", "=", (Object)orgId) : new QFilter("id", "=", (Object)orgId);
        QFilter[] filters = new QFilter[]{this.viewFilter, parentFilter};
        try (DataSet dataSet = QueryServiceHelper.queryDataSet((String)"OrgTreeBuilder.getParentOrgNode", (String)"bos_org", (String)this.selectFields, (QFilter[])filters, (String)"");){
            if (dataSet.hasNext()) {
                TreeNode treeNode = this.convertToTreeNode(dataSet.next());
                return treeNode;
            }
        }
        return null;
    }

    private List<TreeNode> getTreeChildrenSkipHiddenParent() {
        TreeNode parentOrgNode = this.getParentOrgNode();
        if (parentOrgNode == null) {
            return new ArrayList<TreeNode>(0);
        }
        String parentLongNumber = parentOrgNode.getLongNumber();
        List<QFilter> childrenFilters = this.getSubOrgFilterByParam(parentLongNumber);
        return this.getChildren(childrenFilters.toArray(new QFilter[childrenFilters.size()]), parentOrgNode);
    }

    private List<TreeNode> getChildren(QFilter[] filters, TreeNode parentOrgNode) {
        ArrayList<TreeNode> treeNodeList = new ArrayList<TreeNode>(64);
        try (DataSet dataSet = QueryServiceHelper.queryDataSet((String)"OrgTreeBuilder.getTreeChildrenSkipHiddenParent", (String)"bos_org", (String)this.selectFields, (QFilter[])filters, (String)"");
             DataSet orderDataSet = dataSet.orderBy(this.orderBy.split(","));){
            HashMap<String, TreeNode> longnumberNodeMap = new HashMap<String, TreeNode>(64);
            HashMap<String, TreeNode> orgNodeMap = new HashMap<String, TreeNode>(64);
            for (Row orgObj : orderDataSet) {
                if (orgObj == null) continue;
                TreeNode treeNode = this.convertToTreeNode(orgObj);
                if (parentOrgNode == null) {
                    treeNodeList.add(treeNode);
                    continue;
                }
                String nodeLongnumber = orgObj.getString("structure.longnumber");
                longnumberNodeMap.put(nodeLongnumber, treeNode);
                if (!parentOrgNode.getId().equals(treeNode.getId())) {
                    this.findParentByLongnumber(treeNode, nodeLongnumber, longnumberNodeMap, parentOrgNode);
                }
                this.addChild(treeNode, treeNodeList, orgNodeMap);
            }
        }
        return treeNodeList;
    }

    private void addChild(TreeNode treeNode, List<TreeNode> treeNodeList, Map<String, TreeNode> orgNodeMap) {
        this.setLeaf(treeNode, Boolean.TRUE);
        TreeNode parentNode = orgNodeMap.get(treeNode.getParentid());
        if (parentNode == null) {
            treeNodeList.add(treeNode);
        } else {
            this.setLeaf(parentNode, Boolean.FALSE);
            parentNode.addChild(treeNode);
        }
        orgNodeMap.put(treeNode.getId(), treeNode);
    }

    private void findParentByLongnumber(TreeNode currentNode, String longnumber, Map<String, TreeNode> longnumberNodeMap, TreeNode firstNode) {
        String parentLongnumber = StringUtils.substringBeforeLast((String)longnumber, (String)this.longNumberSep);
        TreeNode parentNode = longnumberNodeMap.get(parentLongnumber);
        String number = StringUtils.substringAfterLast((String)currentNode.getLongNumber(), (String)this.longNumberSep);
        if (StringUtils.isBlank((Object)parentNode)) {
            if (parentLongnumber.indexOf(this.longNumberSep) == -1) {
                currentNode.setParentid(firstNode.getId());
                currentNode.setLongNumber(firstNode.getLongNumber() + this.longNumberSep + number);
            } else {
                this.findParentByLongnumber(currentNode, parentLongnumber, longnumberNodeMap, firstNode);
            }
        } else {
            currentNode.setParentid(parentNode.getId());
            currentNode.setLongNumber(parentNode.getLongNumber() + this.longNumberSep + number);
        }
    }

    private void initCommonFilter() {
        this.commonFilter = new QFilter("status", "=", (Object)"C");
        long orgViewId = this.param.getOrgViewId();
        if (orgViewId != 0L) {
            this.viewFilter = new QFilter("structure.view", "=", (Object)orgViewId);
        } else if (StringUtils.isNotBlank((CharSequence)this.param.getOrgViewNumber())) {
            String orgViewNumber = this.param.getOrgViewNumber();
            this.viewFilter = new QFilter("structure.view.number", "=", (Object)orgViewNumber);
        } else if (StringUtils.isNotBlank((CharSequence)this.param.getOrgViewType())) {
            String orgViewType = this.param.getOrgViewType();
            this.viewFilter = new QFilter("structure.view.treetype", "=", (Object)orgViewType);
            this.viewFilter = this.viewFilter.and(new QFilter("structure.view.isdefault", "=", (Object)Boolean.TRUE));
        } else {
            this.viewFilter = new QFilter("structure.view", "=", (Object)1L);
        }
        this.commonFilter = this.commonFilter.and(this.viewFilter);
        if (!this.param.isIncludeDisable()) {
            this.commonFilter = this.commonFilter.and(new QFilter("enable", "=", (Object)Boolean.TRUE));
            this.commonFilter = this.commonFilter.and(new QFilter("structure.viewenable", "=", (Object)Boolean.TRUE));
        }
        if (!this.param.isIncludeFreeze()) {
            this.commonFilter = this.commonFilter.and(new QFilter("structure.isfreeze", "=", (Object)Boolean.FALSE));
        }
    }

    private TreeNode convertToTreeNode(Row orgObj) {
        if (orgObj == null) {
            return null;
        }
        TreeNode treeNode = new TreeNode();
        String number = orgObj.getString("number");
        String name = orgObj.getString("name");
        treeNode.setId(orgObj.getString("id"));
        Long parentId = orgObj.getLong("structure.viewparent");
        treeNode.setParentid(parentId == 0L ? "" : Long.toString(parentId));
        treeNode.setText(OrgTreeUtils.formatOrgTreeNodeName(number, name, this.orgTreeNodeNameFormat));
        treeNode.setLongNumber(orgObj.getString("structure.longnumber"));
        treeNode.setLeaf(orgObj.getBoolean("structure.isleaf").booleanValue());
        if (this.param.isCheckAbleInRange() && this.param.getOrgRangeList() != null && !this.param.getOrgRangeList().contains(orgObj.getLong("id"))) {
            treeNode.setCheckable(false);
        } else {
            treeNode.setCheckable(true);
        }
        OrgTreeBuilder.addNodeLabel(this.param, treeNode, orgObj);
        return treeNode;
    }

    private Map<String, Object> convertNodeToMap(TreeNode treeNode) {
        if (treeNode == null) {
            return null;
        }
        HashMap<String, Object> node = new HashMap<String, Object>(16);
        node.put("id", Long.valueOf(treeNode.getId()));
        String longNumber = treeNode.getLongNumber();
        String number = StringUtils.substringAfterLast((String)longNumber, (String)this.longNumberSep);
        node.put("number", number);
        String text = treeNode.getText();
        node.put("name", text);
        node.put("text", text);
        node.put("parentid", treeNode.getParentid());
        node.put("longnumber", longNumber);
        node.put("isleaf", treeNode.isLeaf());
        node.put("checkable", treeNode.isCheckable());
        return node;
    }

    private void setLeaf(TreeNode treeNode, boolean isLeaf) {
        treeNode.setLeaf(isLeaf);
        if (isLeaf) {
            treeNode.setChildren(null);
        } else if (treeNode.getChildren() == null) {
            treeNode.setChildren(new ArrayList());
        }
    }

    public static void updateNodeLabel(TreeNode treeNode, Map<String, Object> dataMap, OrgTreeParam param) {
        if (treeNode == null) {
            return;
        }
        treeNode.setColor(null);
        if (treeNode.getLabelPara() != null) {
            treeNode.getLabelPara().clear();
        }
        if (dataMap == null || dataMap.isEmpty()) {
            treeNode.setColor(DEFAULT_NODE_COLOR);
            return;
        }
        if (param == null) {
            param = new OrgTreeParam();
            param.setMarkFreeze(true);
        }
        OrgTreeBuilder.addNodeLabel(param, treeNode, dataMap);
    }

    private static void addNodeLabel(OrgTreeParam param, TreeNode treeNode, Object dataObj) {
        ArrayList<TreeNodeLabel> labelParas = new ArrayList<TreeNodeLabel>(16);
        if (param.isMarkFreeze()) {
            OrgTreeBuilder.addNodeLabel(param, treeNode, dataObj, labelParas, param.getDefaultLabelList());
        }
        OrgTreeBuilder.addNodeLabel(param, treeNode, dataObj, labelParas, param.getCustomLabelList());
        if (!labelParas.isEmpty()) {
            treeNode.setLabelPara(labelParas);
            treeNode.setLabelShowType(1);
        }
    }

    private static void addNodeLabel(OrgTreeParam param, TreeNode treeNode, Object dataObj, List<TreeNodeLabel> labelParas, List<OrgTreeNodeLabel> labelList) {
        for (OrgTreeNodeLabel label : labelList) {
            if (label.isSingleOne() && !labelParas.isEmpty() || !Objects.equals(label.getShowCondition(), OrgTreeBuilder.getLabelPropValue(dataObj, label.getProperty(), label.getShowCondition()))) continue;
            if (label.isDisableType() && param.isLockDisableType()) {
                treeNode.setDisabled(true);
            }
            if (treeNode.getColor() == null) {
                treeNode.setColor(label.getNodeColor());
            }
            TreeNodeLabel treeNodeLabel = new TreeNodeLabel();
            treeNodeLabel.setColor(label.getLabelColor());
            treeNodeLabel.setLabel(label.getText());
            labelParas.add(treeNodeLabel);
        }
    }

    private static Object getLabelPropValue(Object dataObj, String property, Object showCondition) {
        Object value;
        if (dataObj instanceof Row) {
            Row dataRow = (Row)dataObj;
            value = showCondition instanceof Boolean ? dataRow.getBoolean(property) : dataRow.get(property);
        } else if (dataObj instanceof Map) {
            Map dataMap = (Map)dataObj;
            value = dataMap.get(property);
        } else {
            throw new KDBizException("OrgTreeBuilder.addNodeLabel: the type of value object must be kd.bos.algo.Row or java.util.Map");
        }
        return value;
    }
}

