/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.org.utils;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import kd.bos.base.utils.msg.BaseMessage;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.exception.KDBizException;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.util.CollectionUtils;

public class OrgTreeOrder {
    private static final Log log = LogFactory.getLog(OrgTreeOrder.class);
    private final List<Map<String, Object>> param;
    private final List<Long> ids;
    private String parentKey = "parentId";

    public OrgTreeOrder(List<Map<String, Object>> param) {
        this.param = param;
        this.ids = this.param == null ? new ArrayList<Long>(0) : new ArrayList<Long>(param.size());
    }

    public OrgTreeOrder(List<Map<String, Object>> param, String parentKey) {
        this.param = param;
        this.ids = this.param == null ? new ArrayList<Long>(0) : new ArrayList<Long>(param.size());
        this.parentKey = parentKey;
    }

    public Map<Object, Map<String, Object>> order() {
        if (CollectionUtils.isEmpty(this.param)) {
            return new HashMap<Object, Map<String, Object>>(0);
        }
        log.info("\u5f00\u59cb\u6267\u884c\u7ec4\u7ec7\u6811\u6309\u7167\u4e0a\u4e0b\u7ea7\u6392\u5e8f\u3002");
        int count = this.param.size();
        LinkedHashMap<Object, Map<String, Object>> orgLevelMap = new LinkedHashMap<Object, Map<String, Object>>(count);
        HashMap<Object, Map<String, Object>> allNodeMap = new HashMap<Object, Map<String, Object>>(count);
        HashMap<Object, List<Map<String, Object>>> parentNodeMap = new HashMap<Object, List<Map<String, Object>>>(count);
        for (Map<String, Object> orgMap : this.param) {
            Map parentMap;
            Object id = orgMap.get("id");
            if (StringUtils.isBlank((Object)id)) {
                throw new KDBizException(BaseMessage.getMessage("M00015", ResManager.loadKDString((String)"\u7ec4\u7ec7(id)", (String)"OrgTreeOrder_0", (String)"bos-org-common", (Object[])new Object[0])));
            }
            this.ids.add(Long.valueOf(id.toString()));
            Object parentId = orgMap.get(this.parentKey);
            if (parentId == null) {
                throw new KDBizException(BaseMessage.getMessage("M00015", ResManager.loadKDString((String)"\u4e0a\u7ea7\u7ec4\u7ec7(parentId)", (String)"OrgTreeOrder_1", (String)"bos-org-common", (Object[])new Object[0])));
            }
            if (StringUtils.isBlank((Object)parentId)) {
                parentId = parentId instanceof String ? "0" : Long.valueOf(0L);
            }
            if ((parentMap = (Map)allNodeMap.get(parentId)) == null) {
                orgLevelMap.put(id, orgMap);
            } else {
                this.addChild(parentMap, orgMap);
            }
            this.acceptChildren(orgLevelMap, orgMap, parentNodeMap);
            allNodeMap.put(id, orgMap);
        }
        log.info("\u5b8c\u6210\u6267\u884c\u7ec4\u7ec7\u6811\u6309\u7167\u4e0a\u4e0b\u7ea7\u6392\u5e8f\uff1a" + orgLevelMap.keySet());
        return orgLevelMap;
    }

    public List<Long> getIds() {
        return this.ids;
    }

    public static Map<String, Object> find(Map<String, Object> orgDataMap, long orgId) {
        Map subOrg;
        if (orgDataMap == null) {
            return new HashMap<String, Object>(0);
        }
        Map<String, Object> dataMap = new HashMap<String, Object>(orgDataMap.size());
        Long id = (Long)orgDataMap.get("id");
        if (id == null) {
            return dataMap;
        }
        if (id == orgId) {
            dataMap.putAll(orgDataMap);
            return dataMap;
        }
        Map childrenMap = (Map)orgDataMap.get("children");
        if (CollectionUtils.isEmpty((Map)childrenMap)) {
            return dataMap;
        }
        Iterator iterator = childrenMap.values().iterator();
        while (iterator.hasNext() && (dataMap = OrgTreeOrder.find(subOrg = (Map)iterator.next(), orgId)).isEmpty()) {
        }
        return dataMap;
    }

    public static void findChildren(Map<String, Object> orgDataMap, List<Map<String, Object>> children, boolean findAll) {
        if (orgDataMap == null || children == null) {
            return;
        }
        Map childrenMap = (Map)orgDataMap.get("children");
        if (CollectionUtils.isEmpty((Map)childrenMap)) {
            return;
        }
        for (Map subOrg : childrenMap.values()) {
            children.add(subOrg);
            if (!findAll) continue;
            OrgTreeOrder.findChildren(subOrg, children, findAll);
        }
    }

    public static void findChildrenId(Map<String, Object> orgDataMap, List<Long> orgIds, boolean findAll) {
        if (orgDataMap == null || orgIds == null) {
            return;
        }
        Map childrenMap = (Map)orgDataMap.get("children");
        if (CollectionUtils.isEmpty((Map)childrenMap)) {
            return;
        }
        for (Map subOrg : childrenMap.values()) {
            Long orgId = (Long)subOrg.get("id");
            if (orgId == null) continue;
            orgIds.add(orgId);
            if (!findAll) continue;
            OrgTreeOrder.findChildrenId(subOrg, orgIds, findAll);
        }
    }

    private void acceptChildren(Map<Object, Map<String, Object>> orgLevelMap, Map<String, Object> nodeMap, Map<Object, List<Map<String, Object>>> parentNodeMap) {
        List<Map<String, Object>> subNodes = parentNodeMap.remove(nodeMap.get("id"));
        List<Object> subNodeIds = this.addChildren(nodeMap, subNodes);
        for (Object subNodeId : subNodeIds) {
            orgLevelMap.remove(subNodeId);
        }
        Object parentId = nodeMap.get(this.parentKey);
        subNodes = parentNodeMap.get(parentId);
        if (subNodes == null) {
            subNodes = new ArrayList<Map<String, Object>>();
            parentNodeMap.put(parentId, subNodes);
        }
        subNodes.add(nodeMap);
    }

    private void addChild(Map<String, Object> nodeMap, Map<String, Object> childNodeMap) {
        this.addChildren(nodeMap, Collections.singletonList(childNodeMap));
    }

    private List<Object> addChildren(Map<String, Object> nodeMap, List<Map<String, Object>> children) {
        if (children == null) {
            return new ArrayList<Object>(0);
        }
        LinkedHashMap<Object, Map<String, Object>> childrenMap = (LinkedHashMap<Object, Map<String, Object>>)nodeMap.get("children");
        if (childrenMap == null) {
            childrenMap = new LinkedHashMap<Object, Map<String, Object>>(children.size());
            nodeMap.put("children", childrenMap);
        }
        ArrayList<Object> ids = new ArrayList<Object>(children.size());
        for (Map<String, Object> childNodeMap : children) {
            Object id = childNodeMap.get("id");
            childrenMap.put(id, childNodeMap);
            ids.add(id);
        }
        return ids;
    }
}

