/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.org.utils;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.StringJoiner;
import kd.bos.algo.DataSet;
import kd.bos.algo.Row;
import kd.bos.base.utils.msg.BaseMessage;
import kd.bos.common.BaseAppParameterServiceHelper;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.datamodel.ITreeModel;
import kd.bos.entity.datamodel.ListSelectedRow;
import kd.bos.entity.datamodel.ListSelectedRowCollection;
import kd.bos.entity.tree.TreeNode;
import kd.bos.exception.KDBizException;
import kd.bos.form.IFormView;
import kd.bos.form.IPageCache;
import kd.bos.form.control.TreeView;
import kd.bos.list.ITreeListView;
import kd.bos.list.events.ListRowClickEvent;
import kd.bos.mvc.list.ListView;
import kd.bos.org.model.OrgTreeParam;
import kd.bos.org.model.OrgTreeSearchParam;
import kd.bos.org.utils.OrgTreeBuilder;
import kd.bos.org.utils.OrgUtils;
import kd.bos.org.utils.OrgViewUtils;
import kd.bos.org.utils.Utils;
import kd.bos.orm.query.QFilter;
import kd.bos.orm.util.CollectionUtils;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.org.OrgUnitServiceHelper;
import kd.sdk.annotation.SdkPublic;

@SdkPublic
public class OrgTreeUtils {
    private static final String PARAM_ORG_TREENODE_FORMAT = "orgtreenodeformat";
    private static final String FORMAT_NODE_NUMBER = "!_!number!_!";
    private static final String FORMAT_NODE_NAME = "!_!name!_!";
    private static final String LASTTIME_SELECTED_PK_CACHE = "lasttimeSelectedPKCache";
    private static final String LASTTIME_SELECTED_COUNT_CACHE = "lasttimeSelectedCountCache";
    private static final String NODE_ID_EXTERNAL_USER_TYPE = "externalUserType";
    public static final String CUSTOM_ROOT_ID = "rootId";
    public static final String PARAM_INIT_ROOT_ORG_ID = "initRootOrgId";
    public static final String PARAM_INIT_ORG_ID = "initOrgId";
    public static final String CHECKBOX_SHOWALLORG = "showallorg";
    public static final String ORG_TREE_TRIGGER_BY_SEARCH = "orgTreeTriggerBySearch";
    private static final int SEARCH_THRESHOLD = 100;

    public static String getOrgNameByNodeId(long nodeId) {
        String selectFields = "id,name";
        QFilter idFilter = new QFilter("id", "=", (Object)nodeId);
        QFilter[] filters = new QFilter[]{idFilter};
        DynamicObjectCollection orgCol = QueryServiceHelper.query((String)"bos_org", (String)selectFields, (QFilter[])filters);
        if (Utils.isListEmpty((List)orgCol)) {
            return ResManager.loadKDString((String)"\u5168\u90e8", (String)"OrgTreeUtils_0", (String)"bos-org-common", (Object[])new Object[0]);
        }
        return ((DynamicObject)orgCol.get(0)).getString("name");
    }

    private static TreeNode getDefaultRootNode(String nodeId) {
        return new TreeNode("", nodeId, ResManager.loadKDString((String)"\u5168\u90e8", (String)"OrgTreeUtils_0", (String)"bos-org-common", (Object[])new Object[0]));
    }

    public static TreeNode genRootNodeByNodeId(String nodeId, String orgViewType) {
        String selectFields = "id,org.name name,longnumber";
        QFilter idFilter = new QFilter("org", "=", (Object)Long.valueOf(nodeId));
        QFilter viewFilter = OrgViewUtils.getOrgViewFilter(orgViewType);
        QFilter[] filters = new QFilter[]{idFilter, viewFilter};
        DynamicObjectCollection orgCol = QueryServiceHelper.query((String)"bos_org_structure", (String)selectFields, (QFilter[])filters);
        if (Utils.isListEmpty((List)orgCol)) {
            return OrgTreeUtils.getDefaultRootNode(nodeId);
        }
        DynamicObject org = (DynamicObject)orgCol.get(0);
        TreeNode root = new TreeNode("", nodeId, org.getString("name"));
        root.setLongNumber(org.getString("longnumber"));
        root.setIsOpened(true);
        return root;
    }

    public static TreeNode queryRootNode(String parentId, String orgViewType) {
        TreeNode root = null;
        List<TreeNode> rootNodeList = OrgTreeUtils.queryChildNodes(parentId, orgViewType, null, "level");
        if (Utils.isListNotEmpty(rootNodeList)) {
            root = rootNodeList.get(0);
            root.setParentid("");
            root.setIsOpened(true);
        } else {
            root = OrgTreeUtils.getDefaultRootNode("-1");
        }
        return root;
    }

    @Deprecated
    public static List<TreeNode> queryChildNodes(String parentId, String orgViewType, QFilter otherFilter, String orderBy) {
        ArrayList<TreeNode> childNodes = new ArrayList<TreeNode>();
        DynamicObjectCollection subOrgCol = OrgTreeUtils.getSubOrgByParentId(parentId, orgViewType, otherFilter, orderBy, false);
        if (Utils.isListEmpty((List)subOrgCol)) {
            return childNodes;
        }
        for (DynamicObject orgObj : subOrgCol) {
            childNodes.add(OrgTreeUtils.genTreeNode(orgObj));
        }
        return childNodes;
    }

    public static List<TreeNode> queryChildNodesForUser(String parentId, String orgViewType, QFilter otherFilter, String orderBy) {
        ArrayList<TreeNode> childNodes = new ArrayList<TreeNode>();
        DynamicObjectCollection subOrgCol = OrgTreeUtils.getSubOrgByParentId(parentId, orgViewType, otherFilter, orderBy, false);
        if (Utils.isListEmpty((List)subOrgCol)) {
            return childNodes;
        }
        ArrayList<Long> leafOrgIds = new ArrayList<Long>(subOrgCol.size());
        for (DynamicObject orgObj : subOrgCol) {
            childNodes.add(OrgTreeUtils.genTreeNode(orgObj));
            if (!orgObj.getBoolean("isleaf")) continue;
            leafOrgIds.add(orgObj.getLong("org"));
        }
        if (leafOrgIds.isEmpty()) {
            return childNodes;
        }
        String selectFields = "id,org";
        QFilter orgFilter = new QFilter("org", "in", leafOrgIds);
        QFilter[] filters = new QFilter[]{orgFilter};
        DynamicObjectCollection partnerCol = QueryServiceHelper.query((String)"bos_bizpartneruser", (String)selectFields, (QFilter[])filters);
        if (Utils.isListEmpty((List)partnerCol)) {
            return childNodes;
        }
        ArrayList<String> hasPartnerList = new ArrayList<String>(partnerCol.size());
        for (DynamicObject partnerObj : partnerCol) {
            hasPartnerList.add(partnerObj.getString("org"));
        }
        for (TreeNode orgNode : childNodes) {
            if (!hasPartnerList.contains(orgNode.getId())) continue;
            orgNode.setChildren(new ArrayList());
        }
        return childNodes;
    }

    @Deprecated
    public static List<TreeNode> queryChildNodes(String parentId, String orgViewType, QFilter otherFilter, String orderBy, TreeNode parentNode) {
        DynamicObjectCollection subOrgCol = OrgTreeUtils.getSubOrgByParentId(parentId, orgViewType, otherFilter, orderBy, true);
        if (Utils.isListEmpty((List)subOrgCol)) {
            return new ArrayList<TreeNode>(0);
        }
        int count = subOrgCol.size();
        ArrayList<Long> notLeafOrgList = new ArrayList<Long>(count);
        ArrayList<TreeNode> nodeList = new ArrayList<TreeNode>(count);
        for (DynamicObject orgObj : subOrgCol) {
            Long orgId = orgObj.getLong("org");
            if (!orgObj.getBoolean("isleaf")) {
                notLeafOrgList.add(orgId);
            }
            if (parentNode != null && parentId.equals(Long.toString(orgId))) {
                OrgTreeUtils.genTreeNode(orgObj, parentNode);
                continue;
            }
            nodeList.add(OrgTreeUtils.genTreeNode(orgObj));
        }
        HashSet<String> parentNodes = new HashSet<String>();
        if (!notLeafOrgList.isEmpty()) {
            String selectFields = "parent";
            QFilter parentFilter = new QFilter("parent", "in", notLeafOrgList);
            QFilter viewFilter = OrgViewUtils.getOrgViewFilter(orgViewType);
            QFilter[] filters = new QFilter[]{parentFilter, viewFilter, otherFilter};
            try (DataSet ds = QueryServiceHelper.queryDataSet((String)"kd.bos.org.utils.OrgTreeUtils.queryChildNodes", (String)"bos_org_structure", (String)selectFields, (QFilter[])filters, null);){
                for (Row row : ds) {
                    parentNodes.add(row.getString("parent"));
                }
            }
        }
        ArrayList<TreeNode> childNodes = new ArrayList<TreeNode>(nodeList.size());
        for (TreeNode node : nodeList) {
            String nodeId = node.getId();
            if (parentNodes.contains(nodeId)) {
                node.setChildren(new ArrayList());
            } else {
                node.setChildren(null);
            }
            childNodes.add(node);
        }
        return childNodes;
    }

    public static DynamicObjectCollection getSubOrgByParentId(String parentId, String orgViewType, QFilter otherFilter, String orderBy, boolean isIncludeCur) {
        long parentOrgId = 0L;
        if (StringUtils.isNotBlank((CharSequence)parentId)) {
            parentOrgId = Long.parseLong(parentId);
        }
        String selectFields = "id,org.id org,org.name name,parent.id parent,longNumber,isleaf,isfreeze";
        QFilter parentFilter = new QFilter("parent", "=", (Object)parentOrgId);
        if (isIncludeCur) {
            QFilter orgFilter = new QFilter("org", "=", (Object)parentOrgId);
            parentFilter = parentFilter.or(orgFilter);
        }
        QFilter viewFilter = OrgViewUtils.getOrgViewFilter(orgViewType);
        QFilter[] filters = new QFilter[]{parentFilter, viewFilter, otherFilter};
        if (StringUtils.isBlank((CharSequence)orderBy)) {
            orderBy = "level,longNumber";
        }
        DynamicObjectCollection subOrgCol = QueryServiceHelper.query((String)"bos_org_structure", (String)selectFields, (QFilter[])filters, (String)orderBy);
        return subOrgCol;
    }

    private static TreeNode genTreeNode(DynamicObject orgObj) {
        TreeNode node = new TreeNode();
        OrgTreeUtils.genTreeNode(orgObj, node);
        return node;
    }

    private static void genTreeNode(DynamicObject orgObj, TreeNode node) {
        node.setId(orgObj.getString("org"));
        node.setText(orgObj.getString("name"));
        HashMap<String, Object> dataMap = new HashMap<String, Object>(1);
        if (orgObj.getBoolean("isfreeze")) {
            dataMap.put("structure.isfreeze", Boolean.TRUE);
        }
        OrgTreeBuilder.updateNodeLabel(node, dataMap, null);
        String parentId = orgObj.getString("parent");
        if ("0".equals(parentId)) {
            parentId = "";
        }
        node.setParentid(parentId);
        node.setLongNumber(orgObj.getString("longnumber"));
        if (!orgObj.getBoolean("isleaf")) {
            node.setChildren(new ArrayList());
        }
    }

    public static void removeSearchTreeNodeCache(IFormView formView, String key) {
        OrgTreeUtils.removeSearchTreeNodeCache((IPageCache)formView.getService(IPageCache.class), key);
    }

    public static void removeSearchTreeNodeCache(IPageCache pageCache, String key) {
        pageCache.remove(key);
    }

    public static void removeAllSearchTreeNodeCache(IPageCache pageCache) {
        pageCache.remove("_searchNodes");
        pageCache.remove("_oldSearchText");
        pageCache.remove("_oldSearchViewSchema");
        pageCache.remove("_resultTotalCacheKey");
    }

    public static void removeLoopSearchTreeNodeCache(IPageCache pageCache) {
        pageCache.remove("_searchNodes");
    }

    public static void searchFromLazyOrgTree(OrgTreeSearchParam searchParam) {
        if (searchParam == null) {
            return;
        }
        String searchText = searchParam.getSearchText();
        if (StringUtils.isBlank((CharSequence)searchText)) {
            return;
        }
        IFormView formView = searchParam.getFormView();
        if (formView == null) {
            throw new KDBizException(BaseMessage.getMessage("M00028", ResManager.loadKDString((String)"\u8868\u5355\u89c6\u56fe", (String)"OrgTreeUtils_2", (String)"bos-org-common", (Object[])new Object[0])));
        }
        TreeView treeView = searchParam.getTreeView();
        if (treeView == null) {
            formView.showTipNotification(BaseMessage.getMessage("M00028", ResManager.loadKDString((String)"\u7ec4\u7ec7\u6811\u5f62\u63a7\u4ef6", (String)"OrgTreeUtils_3", (String)"bos-org-common", (Object[])new Object[0])));
            return;
        }
        TreeNode rootNode = searchParam.getRootNode();
        if (rootNode == null) {
            formView.showTipNotification(BaseMessage.getMessage("M00028", ResManager.loadKDString((String)"\u7ec4\u7ec7\u6839\u8282\u70b9", (String)"OrgTreeUtils_4", (String)"bos-org-common", (Object[])new Object[0])));
            return;
        }
        String orgViewNumber = searchParam.getOrgViewNumber();
        if (StringUtils.isBlank((CharSequence)orgViewNumber)) {
            formView.showTipNotification(BaseMessage.getMessage("M00028", ResManager.loadKDString((String)"\u89c6\u56fe\u65b9\u6848", (String)"OrgTreeUtils_5", (String)"bos-org-common", (Object[])new Object[0])));
            return;
        }
        IPageCache pageCache = searchParam.getPageCache();
        if (searchParam.isClickNode()) {
            pageCache.put(ORG_TREE_TRIGGER_BY_SEARCH, Boolean.TRUE.toString());
        }
        if (OrgTreeUtils.searchNodeForStringId(searchParam)) {
            return;
        }
        List treeNodes = null;
        if (!orgViewNumber.equals(pageCache.get("_oldSearchViewSchema"))) {
            OrgTreeUtils.removeAllSearchTreeNodeCache(pageCache);
        }
        pageCache.put("_oldSearchViewSchema", orgViewNumber);
        String oldSearchTextCacheKey = "_oldSearchText";
        String oldSearchText = pageCache.get("_oldSearchText");
        pageCache.put("_oldSearchText", searchText);
        if (searchText.equals(oldSearchText)) {
            String searchNodesCache = pageCache.get("_searchNodes");
            if (StringUtils.isNotBlank((CharSequence)searchNodesCache)) {
                treeNodes = SerializationUtils.fromJsonStringToList((String)searchNodesCache, TreeNode.class);
            }
        } else {
            OrgTreeUtils.removeLoopSearchTreeNodeCache(pageCache);
            treeNodes = OrgTreeUtils.searchTreeNode(searchParam);
            if (OrgTreeUtils.finishSearch(searchParam, treeNodes, true)) {
                return;
            }
            pageCache.put("_resultTotalCacheKey", Integer.toString(treeNodes.size()));
        }
        if (treeNodes == null || treeNodes.isEmpty()) {
            OrgTreeUtils.finishSearch(searchParam, treeNodes, false);
        } else {
            OrgTreeUtils.searchFromLazyOrgTree(searchParam, treeNodes);
        }
    }

    private static void searchFromLazyOrgTree(OrgTreeSearchParam searchParam, List<TreeNode> treeNodes) {
        IPageCache pageCache = searchParam.getPageCache();
        String resultTotal = pageCache.get("_resultTotalCacheKey");
        boolean firstTimeCheck = StringUtils.isNotBlank((CharSequence)resultTotal) && Integer.parseInt(resultTotal) == treeNodes.size();
        TreeView treeView = searchParam.getTreeView();
        treeView.uncheckNodes(treeView.getTreeState().getSelectedNodeId());
        TreeNode node = OrgTreeUtils.searchExistsNodeFromLazyOrgTree(searchParam, treeNodes);
        if (node == null) {
            OrgTreeUtils.finishSearch(searchParam, treeNodes, firstTimeCheck);
        } else {
            treeView.expand(searchParam.getRootNode().getId());
            if (searchParam.isClickNode()) {
                treeView.treeNodeClick(node.getParentid(), node.getId());
            }
            OrgTreeUtils.checkNodeForSearchFromLazyOrgTree(searchParam, node);
            OrgTreeUtils.focusNodeAfterSearch(searchParam, node);
            if (!searchParam.isSearchById() && treeNodes != null && !treeNodes.isEmpty()) {
                treeNodes.remove(0);
            }
        }
        pageCache.put("_searchNodes", SerializationUtils.toJsonString(treeNodes));
    }

    private static void focusNodeAfterSearch(OrgTreeSearchParam searchParam, TreeNode node) {
        searchParam.getTreeView().focusNode(node);
        IFormView formView = searchParam.getFormView();
        if (formView instanceof ListView) {
            ITreeListView treeListView = ((ListView)formView).getTreeListView();
            treeListView.getTreeModel().setCurrentNodeId((Object)node.getId());
        }
    }

    private static boolean searchNodeForStringId(OrgTreeSearchParam searchParam) {
        if (!searchParam.isSearchById()) {
            return false;
        }
        String searchText = searchParam.getSearchText();
        if (StringUtils.isNumeric((CharSequence)searchText)) {
            return false;
        }
        TreeView treeView = searchParam.getTreeView();
        TreeNode rootNode = searchParam.getRootNode();
        TreeNode node = OrgTreeUtils.getNode(rootNode, searchText);
        if (node == null) {
            if (searchText.startsWith(NODE_ID_EXTERNAL_USER_TYPE)) {
                treeView.queryTreeNodeChildren(rootNode.getId(), NODE_ID_EXTERNAL_USER_TYPE);
                rootNode = searchParam.getRootNode();
                node = OrgTreeUtils.getNode(rootNode, searchText);
            }
            if (node == null) {
                node = rootNode;
            }
        } else {
            TreeNode parentNode = OrgTreeUtils.getNode(rootNode, node.getParentid());
            if (parentNode != null && !parentNode.getIsOpened()) {
                treeView.expand(parentNode.getId());
                parentNode.setIsOpened(true);
            }
        }
        treeView.expand(node.getId());
        OrgTreeUtils.checkNodeForSearchFromLazyOrgTree(searchParam, node);
        if (searchParam.isClickNode()) {
            treeView.treeNodeClick(node.getParentid(), node.getId());
        }
        OrgTreeUtils.focusNodeAfterSearch(searchParam, node);
        return true;
    }

    private static void checkNodeForSearchFromLazyOrgTree(OrgTreeSearchParam searchParam, TreeNode node) {
        searchParam.getCheckNodeIds().add(node.getId());
        TreeView treeView = searchParam.getTreeView();
        treeView.uncheckNodes(treeView.getTreeState().getSelectedNodeId());
        if (!node.isDisabled()) {
            treeView.checkNode(node);
        }
    }

    private static boolean finishSearch(OrgTreeSearchParam searchParam, List<TreeNode> treeNodes, boolean noResult) {
        if (!CollectionUtils.isEmpty(treeNodes)) {
            return false;
        }
        searchParam.getPageCache().put("_searchNodes", "");
        searchParam.getPageCache().remove("_oldSearchText");
        if (!searchParam.isSearchById()) {
            if (noResult) {
                searchParam.getFormView().showTipNotification(BaseMessage.getMessage("M00030"));
            } else {
                searchParam.getFormView().showSuccessNotification(BaseMessage.getMessage("M00029"));
            }
            TreeView treeView = searchParam.getTreeView();
            TreeNode rootNode = searchParam.getRootNode();
            if (!rootNode.getId().equals(treeView.getTreeState().getFocusNodeId())) {
                treeView.uncheckNodes(treeView.getTreeState().getSelectedNodeId());
                treeView.treeNodeClick(rootNode.getParentid(), rootNode.getId());
                OrgTreeUtils.focusNodeAfterSearch(searchParam, rootNode);
            }
        }
        return true;
    }

    private static TreeNode searchExistsNodeFromLazyOrgTree(OrgTreeSearchParam searchParam, List<TreeNode> treeNodes) {
        if (CollectionUtils.isEmpty(treeNodes)) {
            return null;
        }
        TreeNode node = treeNodes.get(0);
        String parentId = node.getParentid();
        TreeNode parentNode = OrgTreeUtils.getNode(searchParam.getRootNode(), parentId);
        if (OrgTreeUtils.isChildNode(parentNode, node)) {
            ArrayList<String> loopController = new ArrayList<String>();
            ArrayList<TreeNode> unExpendNodes = new ArrayList<TreeNode>();
            OrgTreeUtils.expandParentNode(searchParam, parentId, loopController, unExpendNodes, false);
            for (TreeNode treeNode : unExpendNodes) {
                if (searchParam.isQueryBeforeExpend()) {
                    searchParam.getTreeView().queryTreeNodeChildren(treeNode.getParentid(), treeNode.getId());
                }
                OrgTreeUtils.expandNode(searchParam.getTreeView(), treeNode);
            }
        } else {
            OrgTreeUtils.queryTreeNodeWithParent(searchParam, node);
        }
        node = OrgTreeUtils.getNode(searchParam.getRootNode(), node.getId());
        if (node == null) {
            TreeNode removeNode = treeNodes.remove(0);
            String subNodeLongNumber = removeNode.getLongNumber() + "!";
            ArrayList<TreeNode> removeSubNodes = new ArrayList<TreeNode>(treeNodes.size());
            for (TreeNode subNode : treeNodes) {
                if (subNode.getLongNumber() == null || !subNode.getLongNumber().startsWith(subNodeLongNumber)) continue;
                removeSubNodes.add(subNode);
            }
            treeNodes.removeAll(removeSubNodes);
            return OrgTreeUtils.searchExistsNodeFromLazyOrgTree(searchParam, treeNodes);
        }
        return node;
    }

    private static boolean isChildNode(TreeNode parentNode, TreeNode node) {
        if (parentNode == null || CollectionUtils.isEmpty((Collection)parentNode.getChildren())) {
            return false;
        }
        for (TreeNode child : parentNode.getChildren()) {
            if (!node.getId().equals(child.getId())) continue;
            return true;
        }
        return false;
    }

    public static void expandParentNode(OrgTreeSearchParam searchParam, String nodeId, List<String> loopController) {
        if (searchParam != null) {
            OrgTreeUtils.expandParentNode(searchParam, nodeId, loopController, null, searchParam.isQueryBeforeExpend());
        }
    }

    private static void expandParentNode(OrgTreeSearchParam searchParam, String nodeId, List<String> loopController, List<TreeNode> unExpendNodes, boolean isQueryBeforeExpend) {
        if (searchParam == null || StringUtils.isBlank((CharSequence)nodeId)) {
            return;
        }
        if (loopController == null || loopController.contains(nodeId)) {
            return;
        }
        TreeNode rootNode = searchParam.getRootNode();
        if (rootNode == null) {
            return;
        }
        loopController.add(nodeId);
        TreeNode treeNode = OrgTreeUtils.getNode(rootNode, nodeId);
        if (treeNode != null && !treeNode.isExpend()) {
            if (isQueryBeforeExpend) {
                searchParam.getTreeView().queryTreeNodeChildren(treeNode.getParentid(), treeNode.getId());
            }
            if (unExpendNodes == null) {
                OrgTreeUtils.expandNode(searchParam.getTreeView(), treeNode);
            } else {
                unExpendNodes.add(0, treeNode);
            }
            OrgTreeUtils.expandParentNode(searchParam, treeNode.getParentid(), loopController, unExpendNodes, isQueryBeforeExpend);
        }
    }

    public static void expandParentNode(TreeView treeView, ITreeModel treeModel, String nodeId, List<String> loopController) {
        if (treeView == null || treeModel == null || StringUtils.isBlank((CharSequence)nodeId) || loopController == null || loopController.contains(nodeId)) {
            return;
        }
        TreeNode rootNode = treeModel.getRoot();
        if (rootNode == null) {
            return;
        }
        loopController.add(nodeId);
        TreeNode treeNode = OrgTreeUtils.getNode(rootNode, nodeId);
        if (treeNode != null && !treeNode.isExpend()) {
            OrgTreeUtils.expandNode(treeView, treeNode);
            OrgTreeUtils.expandParentNode(treeView, treeModel, treeNode.getParentid(), loopController);
        }
    }

    private static void expandNode(TreeView treeView, TreeNode treeNode) {
        treeView.expand(treeNode.getId());
        treeNode.setExpend(true);
    }

    private static List<TreeNode> searchTreeNode(OrgTreeSearchParam searchParam) {
        QFilter nodeFilter;
        ArrayList<TreeNode> treeNodes = new ArrayList<TreeNode>();
        OrgTreeUtils.searchRootNodeId(searchParam, treeNodes);
        if (!treeNodes.isEmpty()) {
            return treeNodes;
        }
        String searchText = searchParam.getSearchText();
        String orgViewNumber = searchParam.getOrgViewNumber();
        QFilter viewFilter = new QFilter("structure.view.number", "=", (Object)orgViewNumber);
        String searchFilterValue = null;
        List<QFilter> orgFilterList = null;
        if (searchParam.isSearchById()) {
            nodeFilter = new QFilter("id", "=", (Object)Long.valueOf(searchText));
        } else {
            orgFilterList = searchParam.getOrgFilterList();
            searchFilterValue = "%" + searchText + "%";
            QFilter nameFilter = new QFilter("name", "like", (Object)searchFilterValue);
            QFilter numberFilter = new QFilter("number", "like", (Object)searchFilterValue);
            nodeFilter = nameFilter.or(numberFilter);
        }
        QFilter[] filters = new QFilter[]{viewFilter, nodeFilter};
        String orderBy = OrgUtils.getOrgTreeOrderByFields(null);
        String selectFields = OrgTreeUtils.getSearchTreeNodeFields(orderBy);
        try (DataSet ds = QueryServiceHelper.queryDataSet((String)"OrgTreeUtils.searchTreeNodeDataSet", (String)"bos_org", (String)selectFields, (QFilter[])filters, (String)orderBy);){
            for (Row row : ds) {
                String orgId = row.getString("id");
                TreeNode treeNode = new TreeNode(row.getString("structure.viewparent"), orgId, row.getString("name"));
                treeNode.setExpend(true);
                String longNumber = row.getString("structure.longnumber");
                treeNode.setLongNumber(longNumber);
                treeNodes.add(treeNode);
            }
        }
        OrgTreeUtils.removeMismatchSearchTreeNode(searchFilterValue, treeNodes, orgFilterList, viewFilter);
        return treeNodes;
    }

    private static void removeMismatchSearchTreeNode(String searchFilterValue, List<TreeNode> treeNodes, List<QFilter> orgFilterList, QFilter viewFilter) {
        if (treeNodes.size() <= 100 || CollectionUtils.isEmpty(orgFilterList)) {
            return;
        }
        String longNumberSep = OrgUnitServiceHelper.getOrgSeparation().getLongNumberSep();
        Map<Integer, Set<String>> levelLongNumberMap = OrgTreeUtils.getMatchLevelLongNumberMap(searchFilterValue, orgFilterList, viewFilter, longNumberSep);
        if (levelLongNumberMap == null) {
            return;
        }
        if (levelLongNumberMap.isEmpty()) {
            treeNodes.clear();
            return;
        }
        Iterator<TreeNode> iterator = treeNodes.iterator();
        while (iterator.hasNext()) {
            TreeNode treeNode = iterator.next();
            String longNumber = treeNode.getLongNumber();
            if (longNumber == null || OrgTreeUtils.isMatchSearchTreeNode(levelLongNumberMap, longNumber, longNumberSep)) continue;
            iterator.remove();
        }
    }

    private static boolean isMatchSearchTreeNode(Map<Integer, Set<String>> levelLongNumberMap, String longNumber, String longNumberSep) {
        int level = longNumber.split(longNumberSep).length;
        String longNumberPre = longNumber + longNumberSep;
        for (Map.Entry<Integer, Set<String>> entry : levelLongNumberMap.entrySet()) {
            int currentLevel = entry.getKey();
            if (currentLevel < level) continue;
            Set<String> matchLongNumbers = entry.getValue();
            if (currentLevel == level) {
                if (!matchLongNumbers.contains(longNumber)) continue;
                return true;
            }
            for (String matchLongNumber : matchLongNumbers) {
                if (!matchLongNumber.startsWith(longNumberPre)) continue;
                return true;
            }
        }
        return false;
    }

    private static Map<Integer, Set<String>> getMatchLevelLongNumberMap(String searchFilterValue, List<QFilter> orgFilterList, QFilter viewFilter, String longNumberSep) {
        QFilter customFilter = null;
        for (QFilter filter : orgFilterList) {
            if (filter == null) continue;
            if (customFilter == null) {
                customFilter = filter;
                continue;
            }
            customFilter = customFilter.and(filter);
        }
        if (customFilter == null) {
            return null;
        }
        QFilter nameFilter = new QFilter("structure.longnumber", "like", (Object)searchFilterValue);
        QFilter numberFilter = new QFilter("structure.fullname", "like", (Object)searchFilterValue);
        customFilter = customFilter.and(nameFilter.or(numberFilter));
        HashMap<Integer, Set<String>> levelLongNumberMap = new HashMap<Integer, Set<String>>(64);
        QFilter[] filters = new QFilter[]{viewFilter, customFilter};
        try (DataSet ds = QueryServiceHelper.queryDataSet((String)"OrgTreeUtils.getMatchLevelLongNumberMap", (String)"bos_org", (String)"structure.longnumber", (QFilter[])filters, (String)"");){
            for (Row row : ds) {
                String longNumber = row.getString("structure.longnumber");
                if (longNumber == null) continue;
                int level = longNumber.split(longNumberSep).length;
                levelLongNumberMap.computeIfAbsent(level, v -> new HashSet(64)).add(longNumber);
            }
        }
        return levelLongNumberMap;
    }

    private static String getSearchTreeNodeFields(String orderBy) {
        String[] orderFields;
        HashSet<String> fields = new HashSet<String>(16);
        fields.add("id");
        fields.add("number");
        fields.add("name");
        fields.add("structure.viewparent");
        fields.add("structure.longnumber");
        for (String orderField : orderFields = orderBy.split(",")) {
            fields.add(orderField);
        }
        StringJoiner fieldsJoiner = new StringJoiner(",");
        fields.stream().forEach(field -> fieldsJoiner.add((CharSequence)field));
        return fieldsJoiner.toString();
    }

    private static void searchRootNodeId(OrgTreeSearchParam searchParam, List<TreeNode> treeNodes) {
        if (!searchParam.isSearchById()) {
            return;
        }
        TreeNode rootNode = searchParam.getRootNode();
        if (rootNode.getId().equals(searchParam.getSearchText())) {
            treeNodes.add(rootNode);
        }
    }

    private static void queryTreeNodeWithParent(OrgTreeSearchParam searchParam, TreeNode node) {
        TreeView treeView = searchParam.getTreeView();
        String orgViewNumber = searchParam.getOrgViewNumber();
        QFilter viewFilter = new QFilter("view.number", "=", (Object)orgViewNumber);
        List<String> longNumList = OrgTreeUtils.getParentNumbers(searchParam, node, viewFilter);
        if (longNumList.isEmpty()) {
            return;
        }
        String selectFields = "id,org,parent";
        QFilter numberFilter = new QFilter("org.number", "in", longNumList);
        QFilter[] filters = new QFilter[]{numberFilter, viewFilter};
        try (DataSet ds = QueryServiceHelper.queryDataSet((String)"OrgTreeUtils.queryTreeNodeWithParent", (String)"bos_org_structure", (String)selectFields, (QFilter[])filters, (String)"longnumber");){
            TreeNode parentNode = searchParam.getRootNode();
            for (Row row : ds) {
                String orgId = row.getString("org");
                if ((parentNode = OrgTreeUtils.getNode(parentNode, orgId)) == null || parentNode.getChildren() == null || parentNode.getChildren().isEmpty() || node.getParentid().equals(orgId)) {
                    String parentId = row.getString("parent");
                    treeView.queryTreeNodeChildren(parentId, orgId);
                }
                treeView.expand(orgId);
            }
        }
    }

    private static List<String> getParentNumbers(OrgTreeSearchParam searchParam, TreeNode node, QFilter viewFilter) {
        QFilter orgFilter;
        QFilter[] filters;
        DynamicObject structObj;
        ArrayList<String> longNumList = new ArrayList<String>();
        String longNumber = node.getLongNumber();
        if (StringUtils.isBlank((CharSequence)longNumber) && (structObj = BusinessDataServiceHelper.loadSingleFromCache((String)"bos_org_structure", (String)"longnumber", (QFilter[])(filters = new QFilter[]{viewFilter, orgFilter = new QFilter("org", "=", (Object)Long.valueOf(node.getId()))}))) != null) {
            longNumber = structObj.getString("longnumber");
            node.setLongNumber(longNumber);
        }
        if (StringUtils.isNotBlank((CharSequence)longNumber)) {
            int i;
            String[] numbers = longNumber.split("!");
            int n = i = searchParam.getRootNode().getId().equals(node.getParentid()) ? 0 : 1;
            while (i < numbers.length - 1) {
                longNumList.add(numbers[i]);
                ++i;
            }
        }
        return longNumList;
    }

    public static TreeNode getNode(Object nodeId, ITreeModel treeModel) {
        if (treeModel == null) {
            return null;
        }
        return OrgTreeUtils.getNode(treeModel.getRoot(), nodeId);
    }

    public static TreeNode getNode(TreeNode rootNode, Object nodeId) {
        if (rootNode == null || StringUtils.isBlank((Object)nodeId)) {
            return null;
        }
        return rootNode.getTreeNode(nodeId.toString());
    }

    public static boolean focusTreeNodeAfterListRowClick(ListRowClickEvent evt, IPageCache pageCache) {
        if (evt == null || pageCache == null) {
            return false;
        }
        if (pageCache.get(ORG_TREE_TRIGGER_BY_SEARCH) != null) {
            pageCache.remove(ORG_TREE_TRIGGER_BY_SEARCH);
            return false;
        }
        ListSelectedRow row = evt.getCurrentListSelectedRow();
        if (row == null) {
            OrgTreeUtils.removeListRowClickCache(pageCache);
            return false;
        }
        String lasttimeSelectedCountCache = pageCache.get(LASTTIME_SELECTED_COUNT_CACHE);
        int lasttimeSelectedCount = 0;
        if (StringUtils.isNotBlank((CharSequence)lasttimeSelectedCountCache)) {
            lasttimeSelectedCount = Integer.parseInt(lasttimeSelectedCountCache);
        }
        ListSelectedRowCollection listSelectedRowCollection = evt.getListSelectedRowCollection();
        int currentSelectedCount = 0;
        if (!CollectionUtils.isEmpty((Collection)listSelectedRowCollection)) {
            currentSelectedCount = listSelectedRowCollection.size();
        }
        pageCache.put(LASTTIME_SELECTED_COUNT_CACHE, Integer.toString(currentSelectedCount));
        boolean focus = false;
        String pk = row.getPrimaryKeyValue().toString();
        if (currentSelectedCount == 1) {
            if (!pk.equals(pageCache.get(LASTTIME_SELECTED_PK_CACHE))) {
                focus = true;
            }
        } else if (Math.abs(currentSelectedCount - lasttimeSelectedCount) == 1) {
            focus = true;
        } else {
            HashSet<Object> pkSet = new HashSet<Object>(listSelectedRowCollection.size());
            for (ListSelectedRow selectedRow : listSelectedRowCollection) {
                pkSet.add(selectedRow.getPrimaryKeyValue());
            }
            currentSelectedCount = pkSet.size();
            focus = Math.abs(currentSelectedCount - lasttimeSelectedCount) == 1;
        }
        pageCache.put(LASTTIME_SELECTED_PK_CACHE, pk);
        return focus;
    }

    public static void removeListRowClickCache(IPageCache pageCache) {
        pageCache.remove(LASTTIME_SELECTED_PK_CACHE);
        pageCache.remove(LASTTIME_SELECTED_COUNT_CACHE);
    }

    public static String getOrgTreeNodeFormat() {
        Object orgTreeNodeFormatParam = BaseAppParameterServiceHelper.getParameterFromCache((String)PARAM_ORG_TREENODE_FORMAT);
        return orgTreeNodeFormatParam == null ? "" : orgTreeNodeFormatParam.toString().trim().replace("number", FORMAT_NODE_NUMBER).replace("name", FORMAT_NODE_NAME);
    }

    public static String formatOrgTreeNodeName(String number, String name) {
        return OrgTreeUtils.formatOrgTreeNodeName(number, name, OrgTreeUtils.getOrgTreeNodeFormat());
    }

    public static String formatOrgTreeNodeName(String number, String name, String format) {
        if (StringUtils.isBlank((CharSequence)name) || StringUtils.isBlank((CharSequence)format)) {
            return name;
        }
        if (FORMAT_NODE_NAME.equals(format = format.toLowerCase(Locale.ENGLISH)) || format.indexOf(FORMAT_NODE_NAME) == -1) {
            return name;
        }
        name = format.replace(FORMAT_NODE_NAME, name);
        if (StringUtils.isNotBlank((CharSequence)number) && format.indexOf(FORMAT_NODE_NUMBER) != -1) {
            name = name.replace(FORMAT_NODE_NUMBER, number);
        }
        return name;
    }

    public static void getAllNodeId(TreeNode node, boolean includeChild, List<String> allNodeIds) {
        if (node == null || allNodeIds == null || allNodeIds.contains(node.getId())) {
            return;
        }
        allNodeIds.add(node.getId());
        if (!includeChild || node.getChildren() == null) {
            return;
        }
        for (TreeNode child : node.getChildren()) {
            OrgTreeUtils.getAllNodeId(child, true, allNodeIds);
        }
    }

    public static void focusInitOrgTreeNode(ListView view, String viewNumber) {
        if (Objects.isNull(view)) {
            return;
        }
        IPageCache pageCache = view.getPageCache();
        String initOrgId = pageCache.get(PARAM_INIT_ORG_ID);
        if (StringUtils.isBlank((CharSequence)initOrgId)) {
            return;
        }
        pageCache.remove(PARAM_INIT_ORG_ID);
        ITreeListView treeListView = view.getTreeListView();
        if (Objects.isNull(treeListView)) {
            return;
        }
        ITreeModel treeModel = treeListView.getTreeModel();
        if (Objects.isNull(treeModel)) {
            return;
        }
        TreeNode rootNode = treeModel.getRoot();
        if (Objects.isNull(rootNode)) {
            return;
        }
        String rootId = rootNode.getId();
        if (initOrgId.equals(rootId)) {
            return;
        }
        OrgTreeSearchParam searchParam = new OrgTreeSearchParam(initOrgId, view, viewNumber);
        searchParam.setSearchById(true);
        searchParam.setClickNode(true);
        OrgTreeUtils.searchFromLazyOrgTree(searchParam);
    }

    public static void fireClickShowAllOrgCheckBox(ListView view, OrgTreeParam orgTreeParam) {
        if (Objects.isNull(view) || Objects.isNull(orgTreeParam)) {
            return;
        }
        Map customParams = view.getFormShowParameter().getCustomParams();
        Object paramInitRootOrgId = customParams.get(PARAM_INIT_ROOT_ORG_ID);
        if (paramInitRootOrgId == null) {
            return;
        }
        TreeNode root = OrgUnitServiceHelper.getTreeRootNodeById((OrgTreeParam)orgTreeParam);
        if (root == null) {
            return;
        }
        ITreeListView treeListView = view.getTreeListView();
        if (Objects.isNull(treeListView)) {
            return;
        }
        TreeView treeView = treeListView.getTreeView();
        if (Objects.isNull(treeView)) {
            return;
        }
        treeView.deleteAllNodes();
        ITreeModel treeModel = treeListView.getTreeModel();
        if (Objects.isNull(treeModel)) {
            return;
        }
        OrgTreeUtils.removeSearchTreeNodeCache(view.getPageCache(), "_parentIdCacheKey");
        treeModel.setRoot(root);
        treeView.addNode(root);
        treeModel.setCurrentNodeId((Object)root.getId());
        treeView.treeNodeClick(root.getParentid(), root.getId());
    }
}

