/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.org.utils;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.StringJoiner;
import java.util.TreeMap;
import kd.bos.algo.DataSet;
import kd.bos.algo.Row;
import kd.bos.base.utils.msg.OrgMessage;
import kd.bos.common.BaseAppParameterServiceHelper;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.entity.MulBasedataDynamicObjectCollection;
import kd.bos.dataentity.metadata.dynamicobject.DynamicObjectType;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.property.BasedataProp;
import kd.bos.org.model.OrgDutyView;
import kd.bos.org.model.OrgParam;
import kd.bos.org.model.OrgTreeModel;
import kd.bos.org.model.OrgUnit;
import kd.bos.org.utils.OrgViewUtils;
import kd.bos.orm.ORM;
import kd.bos.orm.query.QFilter;
import kd.bos.orm.util.CollectionUtils;
import kd.bos.param.ParameterReader;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.org.OrgUnitServiceHelper;
import kd.bos.servicehelper.parameter.SystemParamServiceHelper;

public class OrgUtils {
    @Deprecated
    public static final String Org_structure = "bos_org_structure";
    public static final long ORG_PATTERN_GROUP_ID = 7L;
    public static final long ORG_PATTERN_GROUP_COMPANY_ID = 8L;
    public static final long ORG_PATTERN_COMPANY_ID = 1L;
    public static final long ORG_PATTERN_DEPARTMENT_ID = 4L;
    public static final String ORG_CHANGE_BIZ_PK_VALUE = "orgChangeBizPkValue";
    public static final long ALL_VIEW_ID = 0L;
    public static final int GENERAL_INIT_SIZE = 64;
    public static final String BOS_ORG_CHANGERECORD = "bos_org_changerecord";
    public static final String PARAM_ORG_API_CHANGE_DATA = "orgApiChangeData";
    public static final String PARAM_IS_ORG_API_BUILD_VIEW = "isOrgApiBuildView";
    public static final String OLD_VALUE = "oldValue";
    public static final String NEW_VALUE = "newValue";
    public static final String CHANGE_TYPE = "changetype";
    public static final String EXECUTION_DATE = "executiondate";
    public static final String EXECUTION_STATUS = "executionstatus";
    public static final String DETAIL_STATUS = "detailstatus";
    public static final String DETAIL_RESULT = "detailresult";
    public static final String TOTAL_COUNT = "totalcount";
    public static final String SUCCESS_COUNT = "successcount";
    public static final String FAIL_COUNT = "failcount";
    public static final String IS_ONLY_SHOW_DISABLED_ORG = "isOnlyShowDisabledOrg";
    public static final String CU_COLOR = "#55A0F5";
    public static final String IGNORE_ORG_NAME_UNIQUE = "ignoreorgnameunique";
    public static final String IGNORE_ORG_NAME_UNIQUE_VIEW = "ignoreorgnameuniqueview";
    public static final String DO_SYNC_TO_YUNZHIJIA_OPERATION = "doSyncToYunzhijiaOperation";
    public static final String IS_SHOW_DISABLED_NODE = "isshowdisablednode";
    public static final String BOS_ORG_HANDOVER = "bos_org_handover";
    public static final String HANDOVER_ORG = "handoverorg";
    public static final String HANDOVER_ORG_ID = "handoverOrgId";
    public static final String ORG_CHANGE_RECORD_ID = "orgChangeRecordId";
    public static final String ORG_CHANGE_OPERATION_PARAM = "orgChangeOperationParam";
    public static final String ORG_CHANGE_SEND_MESSAGE_PARAM = "orgChangeSendMessageParam";
    public static final int MESSAGE_MAX_LENGTH = 255;

    public static List<Map<String, String>> getOrgYzjId(List<Long> lstOrgIds) {
        ArrayList<Map<String, String>> lstOrgYjzIds = new ArrayList<Map<String, String>>();
        if (lstOrgIds == null || lstOrgIds.size() == 0) {
            return lstOrgYjzIds;
        }
        ORM orgORM = ORM.create();
        QFilter f1 = new QFilter("id", "in", lstOrgIds);
        try (DataSet ds = orgORM.queryDataSet(OrgUtils.class.getName(), "bos_org", "id,fyzjorgid", new QFilter[]{f1});){
            for (Row row : ds) {
                HashMap<String, String> mpOrg = new HashMap<String, String>();
                mpOrg.put(row.get("id").toString(), row.get("fyzjorgid").toString());
                lstOrgYjzIds.add(mpOrg);
            }
        }
        return lstOrgYjzIds;
    }

    @Deprecated
    public static void getAdminOrgFullPath(List<Map<String, String>> lstOrgIds) {
        if (lstOrgIds == null || lstOrgIds.size() == 0) {
            return;
        }
        ORM ormOV = ORM.create();
        QFilter f1 = OrgViewUtils.getOrgViewFilter("01");
        ArrayList<OrgTreeModel> lstAdminOrgTree = new ArrayList<OrgTreeModel>();
        HashMap<String, String> mpCurOrgs = new HashMap<String, String>();
        try (DataSet ds = ormOV.queryDataSet("kd.bos.org", Org_structure, "org.id,org.name,parent.id,parent.name", new QFilter[]{f1});){
            for (Row row : ds) {
                String orgId = row.get("org.id") == null ? "0" : row.get("org.id").toString();
                String orgName = row.get("org.name") == null ? "" : row.get("org.name").toString();
                String parentId = row.get("parent.id") == null ? "0" : row.get("parent.id").toString();
                String parentName = row.get("parent.name") == null ? "" : row.get("parent.name").toString();
                OrgTreeModel orgt = new OrgTreeModel(orgId, orgName, parentId, parentName);
                lstAdminOrgTree.add(orgt);
                if (parentId == null || "0".equals(parentId)) continue;
                mpCurOrgs.put(orgId, orgName);
            }
        }
        for (Map<String, String> org : lstOrgIds) {
            for (Map.Entry<String, String> entry : org.entrySet()) {
                String name;
                String sOrgID = entry.getKey();
                String sPath = OrgUtils.getParentPath(lstAdminOrgTree, sOrgID, "\\");
                sPath = !StringUtils.isEmpty((CharSequence)sPath) ? sPath.substring(1) : ((name = (String)mpCurOrgs.get(sOrgID)) == null ? "" : name);
                entry.setValue(sPath);
            }
        }
    }

    private static String getParentPath(List<OrgTreeModel> lstOrg, String iOrgId, String sSplitter) {
        String sPath = "";
        for (OrgTreeModel org : lstOrg) {
            if (!iOrgId.equalsIgnoreCase(org.getOrgId())) continue;
            if (!"0".equalsIgnoreCase(org.getParentOrgId())) {
                sPath = OrgUtils.getParentPath(lstOrg, org.getParentOrgId(), sSplitter) + sSplitter + org.getOrgName();
                break;
            }
            sPath = "";
            break;
        }
        return sPath;
    }

    public static List<DynamicObject> getOrgBizNameList() {
        ORM ormBiz = ORM.create();
        QFilter f2 = new QFilter("propertyname", "!=", (Object)"");
        QFilter[] filters = new QFilter[]{f2};
        DynamicObjectCollection list = ormBiz.query("bos_org_biz", "id,propertyname,fname,fnumber,ffieldname,fuserdefine,isbasetype,enable", filters);
        return list;
    }

    public static List<DynamicObject> getAllOrgBizNameList() {
        Map bizMap = BusinessDataServiceHelper.loadFromCache((String)"bos_org_biz", null);
        if (CollectionUtils.isEmpty((Map)bizMap)) {
            return new ArrayList<DynamicObject>(0);
        }
        return new ArrayList<DynamicObject>(bizMap.values());
    }

    public static Map<Object, DynamicObject> getAllBaseBUBizMap() {
        QFilter enableFilter = new QFilter("enable", "=", (Object)Boolean.TRUE);
        QFilter visiableFilter = new QFilter("visiable", "=", (Object)Boolean.TRUE);
        QFilter baseFilter = new QFilter("isbasetype", "=", (Object)Boolean.TRUE);
        QFilter categoryFilter = new QFilter("category", "=", (Object)"1");
        QFilter[] filters = new QFilter[]{enableFilter, visiableFilter, baseFilter, categoryFilter};
        Map bizMap = BusinessDataServiceHelper.loadFromCache((String)"bos_org_biz", (QFilter[])filters);
        if (CollectionUtils.isEmpty((Map)bizMap)) {
            return new HashMap<Object, DynamicObject>(0);
        }
        return bizMap;
    }

    @Deprecated
    public static boolean addOrgUnit(List<OrgUnit> lstOrgUnits) {
        if (lstOrgUnits == null) {
            return false;
        }
        int count = lstOrgUnits.size();
        ArrayList<OrgParam> orgParamList = new ArrayList<OrgParam>(count);
        Map<Integer, Long> patternMap = OrgUtils.getOrgPatternMap();
        ORM orm = ORM.create();
        long[] orgIdArr = orm.genLongIds("bos_org", count);
        int index = 0;
        for (OrgUnit dt : lstOrgUnits) {
            long id = orgIdArr[index++];
            dt.setId(id);
            OrgParam orgParam = new OrgParam();
            orgParamList.add(orgParam);
            orgParam.setCustomOrgId(id);
            orgParam.setNumber(dt.getNumber());
            String name = dt.getName();
            orgParam.setName(name);
            orgParam.setOrgPatternId(OrgUtils.matchOrgPattern(patternMap, name));
            HashMap<String, String> propertyMap = new HashMap<String, String>(1);
            propertyMap.put("fyzjorgid", dt.getFyzjorgid());
            orgParam.setPropertyMap(propertyMap);
            orgParam.setDescription(dt.getFcomment());
            TreeMap<String, OrgDutyView> multiViewMap = new TreeMap<String, OrgDutyView>();
            orgParam.setMultiViewMap(multiViewMap);
            OrgDutyView orgDutyView = new OrgDutyView(dt.getParentId());
            multiViewMap.put("01", orgDutyView);
            if (!dt.isAccounting()) continue;
            orgDutyView = new OrgDutyView(dt.getParentId());
            multiViewMap.put("10", orgDutyView);
        }
        OrgUnitServiceHelper.add(orgParamList);
        return true;
    }

    public static Map<Integer, Long> getOrgPatternMap() {
        HashMap<Integer, Long> patternMap = new HashMap<Integer, Long>(8);
        DynamicObjectCollection col = QueryServiceHelper.query((String)"bos_org_pattern", (String)"id", null, (String)"id");
        if (col == null || col.size() == 0) {
            return patternMap;
        }
        int index = 1;
        for (DynamicObject p : col) {
            patternMap.put(index++, p.getLong("id"));
        }
        return patternMap;
    }

    public static void matchOrgPattern(Map<Integer, Long> patternMap, String name, DynamicObject org) {
        if (org != null) {
            org.set("orgpattern", (Object)OrgUtils.matchOrgPattern(patternMap, name));
        }
    }

    public static long matchOrgPattern(Map<Integer, Long> patternMap, String name) {
        if (StringUtils.isBlank((CharSequence)name)) {
            return 0L;
        }
        if (patternMap == null) {
            patternMap = OrgUtils.getOrgPatternMap();
        }
        if (name.lastIndexOf(ResManager.loadKDString((String)"\u5206\u516c\u53f8", (String)"OrgUtils_0", (String)"bos-org-common", (Object[])new Object[0])) > 0) {
            return patternMap.get(2);
        }
        if (name.lastIndexOf(ResManager.loadKDString((String)"\u7701\u516c\u53f8", (String)"OrgUtils_1", (String)"bos-org-common", (Object[])new Object[0])) > 0) {
            return patternMap.get(2);
        }
        if (name.lastIndexOf(ResManager.loadKDString((String)"\u516c\u53f8", (String)"OrgUtils_2", (String)"bos-org-common", (Object[])new Object[0])) > 0) {
            return patternMap.get(1);
        }
        if (name.lastIndexOf(ResManager.loadKDString((String)"\u4e8b\u4e1a\u90e8", (String)"OrgUtils_3", (String)"bos-org-common", (Object[])new Object[0])) > 0) {
            return patternMap.get(3);
        }
        return patternMap.get(4);
    }

    public static String isDisableValid(Object orgId) {
        String errorMsg = "";
        QFilter freezeFilter = new QFilter("isfreeze", "=", (Object)Boolean.FALSE);
        QFilter viewFilter = new QFilter("view", "=", (Object)1L);
        QFilter orgFilter = new QFilter("org", "=", orgId);
        QFilter enableFilter = new QFilter("enable", "=", (Object)Boolean.TRUE);
        enableFilter = enableFilter.and(new QFilter("org.enable", "=", (Object)Boolean.TRUE));
        QFilter[] filters = new QFilter[]{freezeFilter, viewFilter, orgFilter, enableFilter};
        if (QueryServiceHelper.exists((String)Org_structure, (QFilter[])filters)) {
            errorMsg = OrgMessage.getMessage("M00129");
        }
        return errorMsg;
    }

    public static String getOrgSortSchema() {
        return OrgUtils.getOrgSortSchema(true);
    }

    public static String getOrgSortSchema(boolean settingDefault) {
        Map paramMap = BaseAppParameterServiceHelper.getParameterFromCache();
        if (paramMap == null || StringUtils.isBlank(paramMap.get("orgsortscheme"))) {
            return settingDefault ? "longnumber" : "";
        }
        return paramMap.get("orgsortscheme").toString();
    }

    public static String getOrgSortFields() {
        return OrgUtils.getOrgSortFields(true);
    }

    public static String getOrgSortFields(boolean settingDefault) {
        String orgSortScheme = OrgUtils.getOrgSortSchema(settingDefault);
        if (!settingDefault && StringUtils.isBlank((CharSequence)orgSortScheme)) {
            return "";
        }
        String sortFields = "";
        switch (orgSortScheme) {
            case "number": {
                sortFields = "number";
                break;
            }
            case "name": {
                sortFields = "name";
                break;
            }
            case "longnumber": {
                sortFields = "structure.longnumber";
                break;
            }
            case "fullname": {
                sortFields = "structure.fullname";
                break;
            }
            case "sortcode": {
                sortFields = "structure.sortcode";
                break;
            }
            case "sortnumber": {
                sortFields = "structure.sortnumber";
                break;
            }
            default: {
                sortFields = "structure.longnumber";
            }
        }
        return sortFields;
    }

    public static String getOrgStructureSortFields() {
        return OrgUtils.getOrgStructureSortFields(true);
    }

    public static String getOrgStructureSortFields(boolean settingDefault) {
        String orgSortScheme = OrgUtils.getOrgSortSchema(settingDefault);
        if (!settingDefault && StringUtils.isBlank((CharSequence)orgSortScheme)) {
            return "";
        }
        String sortFields = "";
        switch (orgSortScheme) {
            case "number": {
                sortFields = "org.number";
                break;
            }
            case "name": {
                sortFields = "org.name";
                break;
            }
            case "longnumber": {
                sortFields = "longnumber";
                break;
            }
            case "fullname": {
                sortFields = "fullname";
                break;
            }
            case "sortcode": {
                sortFields = "sortcode";
                break;
            }
            case "sortnumber": {
                sortFields = "sortnumber";
                break;
            }
            default: {
                sortFields = "longnumber";
            }
        }
        return sortFields;
    }

    public static String getOrgTreeOrderByFields(String orderBy) {
        if (StringUtils.isBlank((CharSequence)orderBy) && StringUtils.isBlank((CharSequence)(orderBy = OrgUtils.getOrgSortSchema()))) {
            return "structure.level";
        }
        switch (orderBy = orderBy.toLowerCase()) {
            case "number": {
                orderBy = OrgUtils.addStructLevelToOrderByFields("number");
                break;
            }
            case "name": {
                orderBy = OrgUtils.addStructLevelToOrderByFields("name");
                break;
            }
            case "longnumber": {
                orderBy = OrgUtils.addStructLevelToOrderByFields("number");
                break;
            }
            case "fullname": {
                orderBy = OrgUtils.addStructLevelToOrderByFields("name");
                break;
            }
            case "sortcode": {
                orderBy = OrgUtils.addStructLevelToOrderByFields("structure.sortcode");
                break;
            }
            case "sortnumber": {
                orderBy = OrgUtils.addStructLevelToOrderByFields("structure.sortnumber");
                break;
            }
            default: {
                orderBy = "structure.level";
            }
        }
        return orderBy;
    }

    public static String addLevelToOrderByFields(String orderBy) {
        return OrgUtils.addStructLevelToOrderByFields("level", orderBy);
    }

    public static String addStructLevelToOrderByFields(String orderBy) {
        return OrgUtils.addStructLevelToOrderByFields("structure.level", orderBy);
    }

    private static String addStructLevelToOrderByFields(String fieldName, String orderBy) {
        if (StringUtils.isBlank((CharSequence)orderBy)) {
            return fieldName;
        }
        if (orderBy.indexOf(fieldName) == -1) {
            orderBy = fieldName + "," + orderBy;
        } else {
            String levelOrder = "," + fieldName;
            if (orderBy.indexOf(levelOrder) != -1) {
                orderBy = orderBy.replace(levelOrder, "");
                orderBy = fieldName + "," + orderBy;
            }
        }
        return orderBy;
    }

    public static String getOrgTreeSelectFields(String orderBy) {
        return OrgUtils.getOrgTreeSelectFields("name", orderBy);
    }

    public static String getOrgTreeSelectFields(String nameProperty, String orderBy) {
        nameProperty = StringUtils.isBlank((CharSequence)nameProperty) ? "name" : nameProperty + " name";
        String selectFields = "id,number," + nameProperty + ",enable,status,structure.view,structure.viewparent,structure.level,structure.longnumber,structure.isleaf,structure.isfreeze,structure.isctrlunit,structure.viewenable,structure.viewstatus";
        HashSet<String> selectFieldSet = new HashSet<String>(36);
        selectFieldSet.add("name");
        return OrgUtils.getOrgSelectFields(selectFields, orderBy, selectFieldSet);
    }

    public static String getOrgSelectFields(String selectFields, String orderBy) {
        return OrgUtils.getOrgSelectFields(selectFields, orderBy, new HashSet<String>(36));
    }

    public static String getOrgSelectFields(String selectFields, String orderBy, Set<String> selectFieldSet) {
        String[] selectFieldArr;
        if (StringUtils.isBlank((CharSequence)selectFields)) {
            return selectFields;
        }
        if (StringUtils.isBlank((CharSequence)orderBy)) {
            return selectFields;
        }
        for (String field : selectFieldArr = selectFields.split(",")) {
            selectFieldSet.add(field.toLowerCase().trim());
        }
        String[] orderByFieldArr = orderBy.split(",");
        StringJoiner sj = new StringJoiner(",");
        sj.add(selectFields);
        for (String field : orderByFieldArr) {
            String orderField = field.toLowerCase().trim();
            if (selectFieldSet.contains(orderField)) continue;
            sj.add(orderField);
        }
        return sj.toString();
    }

    public static boolean isGalaxyUltimate() {
        return OrgUnitServiceHelper.isGalaxyUltimate();
    }

    public static List<Long> getCorporateOrgIds(boolean includeDisabled) {
        ArrayList<Long> orgIds = new ArrayList<Long>();
        QFilter patternTypeFilter = new QFilter("orgpattern.patterntype", "=", (Object)"1");
        QFilter viewFilter = new QFilter("isbizorg", "=", (Object)Boolean.TRUE);
        if (!includeDisabled) {
            QFilter enableFilter = new QFilter("enable", "=", (Object)Boolean.TRUE);
            viewFilter = viewFilter.and(enableFilter);
        }
        QFilter[] filters = new QFilter[]{patternTypeFilter, viewFilter};
        try (DataSet dataSet = QueryServiceHelper.queryDataSet((String)"OrgParamValidator.getCorporateOrg", (String)"bos_org", (String)"id", (QFilter[])filters, (String)"");){
            for (Row row : dataSet) {
                orgIds.add(row.getLong("id"));
            }
        }
        return orgIds;
    }

    public static Map<String, DynamicObjectType> getOrgEntityDynamicObjectType(DynamicObject orgObj) {
        HashMap<String, DynamicObjectType> dynamicObjectTypeMap = new HashMap<String, DynamicObjectType>(8);
        if (orgObj == null) {
            return dynamicObjectTypeMap;
        }
        BasedataProp patternPro = (BasedataProp)orgObj.getDynamicObjectType().getProperty("orgpattern");
        dynamicObjectTypeMap.put("orgpattern", (DynamicObjectType)patternPro.getComplexType());
        DynamicObjectType structureType = orgObj.getDynamicObjectCollection("structure").getDynamicObjectType();
        dynamicObjectTypeMap.put("structure", structureType);
        BasedataProp viewPro = (BasedataProp)structureType.getProperty("view");
        dynamicObjectTypeMap.put("view", (DynamicObjectType)viewPro.getComplexType());
        BasedataProp orgPro = (BasedataProp)structureType.getProperty("vieworg");
        dynamicObjectTypeMap.put("org", (DynamicObjectType)orgPro.getComplexType());
        BasedataProp parentPro = (BasedataProp)structureType.getProperty("viewparent");
        dynamicObjectTypeMap.put("parent", (DynamicObjectType)parentPro.getComplexType());
        return dynamicObjectTypeMap;
    }

    public static Map<String, DynamicObject> getNotBaseMaintainViewMap() {
        HashMap<String, DynamicObject> notBaseMaintainBizViewNumberMap;
        QFilter baseMaintainFilter = new QFilter("basemaintain", "=", (Object)Boolean.FALSE);
        baseMaintainFilter = baseMaintainFilter.or(new QFilter("treetypeid.basemaintain", "=", (Object)Boolean.FALSE));
        baseMaintainFilter = baseMaintainFilter.or(new QFilter("isdefault", "=", (Object)Boolean.FALSE));
        QFilter[] filters = new QFilter[]{baseMaintainFilter};
        Map viewObjMap = BusinessDataServiceHelper.loadFromCache((String)"bos_org_viewschema", (String)"id,number,isdefault", (QFilter[])filters);
        if (CollectionUtils.isEmpty((Map)viewObjMap)) {
            notBaseMaintainBizViewNumberMap = new HashMap<String, DynamicObject>(0);
        } else {
            notBaseMaintainBizViewNumberMap = new HashMap(viewObjMap.size());
            for (Map.Entry viewObjEntry : viewObjMap.entrySet()) {
                DynamicObject viewObj = (DynamicObject)viewObjEntry.getValue();
                notBaseMaintainBizViewNumberMap.put(viewObj.getString("number"), viewObj);
            }
        }
        return notBaseMaintainBizViewNumberMap;
    }

    public static List<Long> getIgnoreFullNameUniqueViewIds() {
        ArrayList<Long> ignoreFullNameUniqueViewIds = new ArrayList<Long>(64);
        boolean ignoreOrgNameUnique = OrgUtils.isIgnoreFullNameUnique("bos_org");
        List<Long> orgIgnoreFullNameUniqueViewIds = null;
        if (ignoreOrgNameUnique) {
            orgIgnoreFullNameUniqueViewIds = OrgUtils.getIgnoreFullNameUniqueViewIds("bos_org");
            ignoreFullNameUniqueViewIds.addAll(orgIgnoreFullNameUniqueViewIds);
        }
        boolean ignoreAdminOrgNameUnique = OrgUtils.isIgnoreFullNameUnique("bos_adminorg");
        List<Long> adminOrgIgnoreFullNameUniqueViewIds = null;
        if (ignoreAdminOrgNameUnique) {
            adminOrgIgnoreFullNameUniqueViewIds = OrgUtils.getIgnoreFullNameUniqueViewIds("bos_adminorg");
            ignoreFullNameUniqueViewIds.addAll(adminOrgIgnoreFullNameUniqueViewIds);
        }
        if (!ignoreOrgNameUnique && !ignoreAdminOrgNameUnique) {
            return ignoreFullNameUniqueViewIds;
        }
        if (orgIgnoreFullNameUniqueViewIds != null && !orgIgnoreFullNameUniqueViewIds.isEmpty() && adminOrgIgnoreFullNameUniqueViewIds != null && !adminOrgIgnoreFullNameUniqueViewIds.isEmpty()) {
            return ignoreFullNameUniqueViewIds;
        }
        Map viewObjMap = BusinessDataServiceHelper.loadFromCache((String)"bos_org_viewschema", null);
        for (Map.Entry viewEntry : viewObjMap.entrySet()) {
            DynamicObject viewObj = (DynamicObject)viewEntry.getValue();
            DynamicObject bizObj = viewObj.getDynamicObject("treetypeid");
            if (bizObj == null || ("2".equals(bizObj.get("category")) ? !ignoreAdminOrgNameUnique || !adminOrgIgnoreFullNameUniqueViewIds.isEmpty() : !ignoreOrgNameUnique || !orgIgnoreFullNameUniqueViewIds.isEmpty())) continue;
            ignoreFullNameUniqueViewIds.add(viewObj.getLong("id"));
        }
        return ignoreFullNameUniqueViewIds;
    }

    private static boolean isIgnoreFullNameUnique(String formId) {
        ParameterReader.getBillParameter((String)formId);
        Object ignoreOrgNameUnique = SystemParamServiceHelper.getBillParameter((String)formId, (String)IGNORE_ORG_NAME_UNIQUE);
        if (ignoreOrgNameUnique == null) {
            return false;
        }
        return (Boolean)ignoreOrgNameUnique;
    }

    private static List<Long> getIgnoreFullNameUniqueViewIds(String formId) {
        MulBasedataDynamicObjectCollection ignoreOrgNameUniqueObjs = (MulBasedataDynamicObjectCollection)SystemParamServiceHelper.getBillParameter((String)formId, (String)IGNORE_ORG_NAME_UNIQUE_VIEW);
        if (ignoreOrgNameUniqueObjs == null || ignoreOrgNameUniqueObjs.isEmpty()) {
            return new ArrayList<Long>(0);
        }
        ArrayList<Long> ignoreOrgNameUniqueViewIds = new ArrayList<Long>(ignoreOrgNameUniqueObjs.size());
        for (DynamicObject viewObj : ignoreOrgNameUniqueObjs) {
            ignoreOrgNameUniqueViewIds.add(viewObj.getLong("fbasedataid_id"));
        }
        return ignoreOrgNameUniqueViewIds;
    }

    public static Map<String, DynamicObject> getBizNumberMap() {
        Map bizMap = BusinessDataServiceHelper.loadFromCache((String)"bos_org_biz", null);
        HashMap<String, DynamicObject> numberBizMap = new HashMap<String, DynamicObject>(bizMap.size());
        for (Map.Entry entry : bizMap.entrySet()) {
            DynamicObject bizObj = (DynamicObject)entry.getValue();
            numberBizMap.put(bizObj.getString("fnumber"), bizObj);
        }
        return numberBizMap;
    }
}

