/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.org.utils;

import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import kd.bos.algo.DataSet;
import kd.bos.algo.Row;
import kd.bos.base.utils.BaseUtils;
import kd.bos.base.utils.msg.BaseMessage;
import kd.bos.base.utils.msg.OrgMessage;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.entity.ILocaleString;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.db.tx.TX;
import kd.bos.db.tx.TXHandle;
import kd.bos.form.IFormView;
import kd.bos.lang.Lang;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.org.model.OrgEntity;
import kd.bos.org.utils.Utils;
import kd.bos.org.utils.YzjSyncUtils;
import kd.bos.orm.query.QFilter;
import kd.bos.orm.util.CollectionUtils;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import kd.bos.servicehelper.org.OrgUnitServiceHelper;
import kd.sdk.annotation.SdkPublic;

@SdkPublic
public class OrgViewUtils {
    private static final Log log = LogFactory.getLog(OrgViewUtils.class);
    private static final String VIEW_NUMBER_FILTER = "view.number";
    private static final int RESERVED_NUMBER_MIN = 1;
    private static final int RESERVED_NUMBER_MAX = 1000;

    public static List<Long> getAllOrgId(String orgViewType, boolean isAllEnable, boolean isUnFreeze) {
        String selectFields = "org";
        QFilter viewFilter = OrgViewUtils.getOrgViewNumberFilter(orgViewType);
        if (isAllEnable) {
            viewFilter = viewFilter.and(new QFilter("org.enable", "=", (Object)Boolean.TRUE));
            viewFilter = viewFilter.and(new QFilter("enable", "=", (Object)Boolean.TRUE));
        }
        if (isUnFreeze) {
            viewFilter = viewFilter.and(new QFilter("isfreeze", "=", (Object)Boolean.FALSE));
        }
        QFilter[] filters = new QFilter[]{viewFilter};
        DynamicObjectCollection orgCol = QueryServiceHelper.query((String)"bos_org_structure", (String)selectFields, (QFilter[])filters, (String)"level");
        ArrayList<Long> orgIds = new ArrayList<Long>();
        if (Utils.isListEmpty((List)orgCol)) {
            return orgIds;
        }
        for (DynamicObject org : orgCol) {
            orgIds.add(org.getLong("org"));
        }
        return orgIds;
    }

    public static List<Long> getSubOrgId(String orgViewType, List<Long> orgIds, boolean isIncludeCurOrg, boolean isIncludeGrand, QFilter otherFilter) {
        if (isIncludeGrand) {
            return OrgViewUtils.getSubOrgIdIncludeGrand(orgViewType, orgIds, isIncludeCurOrg, otherFilter);
        }
        return OrgViewUtils.getSubOrgId(orgViewType, orgIds, isIncludeCurOrg, otherFilter);
    }

    public static List<Long> getSubOrgId(String orgViewType, List<Long> orgIds, boolean isIncludeCurOrg, QFilter otherFilter) {
        ArrayList<Long> subOrgList = new ArrayList<Long>();
        if (Utils.isListEmpty(orgIds)) {
            log.warn("getSubOrgId\u67e5\u8be2\u4e0b\u7ea7\u7ec4\u7ec7\u7684ID\u53c2\u6570\u4e3a\u7a7a");
            return subOrgList;
        }
        QFilter parentFilter = new QFilter("parent", "in", orgIds);
        if (otherFilter != null) {
            parentFilter = parentFilter.and(otherFilter);
        }
        OrgViewUtils.queryOrgId(subOrgList, orgViewType, parentFilter);
        if (isIncludeCurOrg) {
            subOrgList.addAll(orgIds);
        }
        return subOrgList;
    }

    private static void queryOrgId(List<Long> subOrgList, String orgViewType, QFilter filter) {
        String selectFields = "org";
        if (StringUtils.isNotBlank((CharSequence)orgViewType)) {
            filter = filter == null ? OrgViewUtils.getOrgViewNumberFilter(orgViewType) : filter.and(OrgViewUtils.getOrgViewNumberFilter(orgViewType));
        }
        QFilter[] filters = new QFilter[]{filter};
        try (DataSet ds = QueryServiceHelper.queryDataSet((String)"kd.bos.org.utils.OrgViewUtils", (String)"bos_org_structure", (String)selectFields, (QFilter[])filters, (String)"level");){
            for (Row row : ds) {
                subOrgList.add(row.getLong("org"));
            }
        }
    }

    public static List<Long> getSubOrgIdIncludeGrand(String orgViewType, List<Long> orgIds, boolean isIncludeCurOrg, QFilter otherFilter) {
        ArrayList<Long> subOrgList = new ArrayList<Long>();
        if (Utils.isListEmpty(orgIds)) {
            log.warn("getSubOrgIdIncludeGrand\u67e5\u8be2\u4e0b\u7ea7\u7ec4\u7ec7\u7684ID\u53c2\u6570\u4e3a\u7a7a");
            return subOrgList;
        }
        return OrgViewUtils.getSubOrgIdByLongNumber(orgViewType, OrgViewUtils.getOrgLongNumberById(orgViewType, orgIds), isIncludeCurOrg, otherFilter);
    }

    private static List<String> getOrgLongNumberById(String orgViewType, List<Long> orgIds) {
        String selectFields = "longnumber";
        QFilter orgFilter = new QFilter("org", "in", orgIds);
        if (StringUtils.isNotBlank((CharSequence)orgViewType)) {
            orgFilter.and(OrgViewUtils.getOrgViewNumberFilter(orgViewType));
        }
        QFilter[] filters = new QFilter[]{orgFilter};
        DynamicObjectCollection orgCol = QueryServiceHelper.query((String)"bos_org_structure", (String)selectFields, (QFilter[])filters, (String)"longnumber");
        ArrayList<String> longNumberList = new ArrayList<String>();
        if (Utils.isListEmpty((List)orgCol)) {
            return longNumberList;
        }
        ArrayList<String> tempLongNumberList = new ArrayList<String>();
        for (DynamicObject org : orgCol) {
            String longNumber = org.getString("longnumber");
            if (!StringUtils.isNotBlank((CharSequence)longNumber)) continue;
            longNumberList.add(longNumber);
            tempLongNumberList.add(longNumber);
        }
        ArrayList<String> duplicateList = new ArrayList<String>();
        for (String longNumber : longNumberList) {
            for (String tempLongNumber : tempLongNumberList) {
                if (!longNumber.startsWith(tempLongNumber + "!")) continue;
                duplicateList.add(longNumber);
            }
        }
        longNumberList.removeAll(duplicateList);
        return longNumberList;
    }

    public static List<Long> getSubOrgIdByLongNumber(String orgViewType, List<String> longNumberList, boolean isIncludeCurOrg, QFilter otherFilter) {
        ArrayList<Long> subOrgList = new ArrayList<Long>();
        if (Utils.isListEmpty(longNumberList)) {
            log.warn("\u67e5\u8be2\u4e0b\u7ea7\u7ec4\u7ec7\u7684\u957f\u7f16\u7801\u53c2\u6570\u4e3a\u7a7a");
            return subOrgList;
        }
        QFilter filter = OrgViewUtils.genLongNumberFilter(longNumberList, isIncludeCurOrg);
        if (otherFilter != null) {
            filter = filter == null ? otherFilter : filter.and(otherFilter);
        }
        OrgViewUtils.queryOrgId(subOrgList, orgViewType, filter);
        return subOrgList;
    }

    public static QFilter genSoleLongNumberFilter(List<String> longNumberList, boolean isIncludeCurOrg) {
        if (Utils.isListEmpty(longNumberList)) {
            return null;
        }
        ArrayList<String> tempLongNumberList = new ArrayList<String>();
        tempLongNumberList.addAll(longNumberList);
        ArrayList<String> duplicateList = new ArrayList<String>();
        for (String longNumber : longNumberList) {
            for (String tempLongNumber : tempLongNumberList) {
                if (!longNumber.startsWith(tempLongNumber + "!")) continue;
                duplicateList.add(longNumber);
            }
        }
        longNumberList.removeAll(duplicateList);
        return OrgViewUtils.genLongNumberFilter(longNumberList, isIncludeCurOrg);
    }

    public static QFilter genLongNumberFilter(List<String> longNumberList, boolean isIncludeCurOrg) {
        if (Utils.isListEmpty(longNumberList)) {
            return null;
        }
        QFilter curFilter = null;
        QFilter filter = null;
        for (String longNumber : longNumberList) {
            String longNumberFilter = longNumber + "!" + "%";
            filter = filter == null ? new QFilter("longnumber", "like", (Object)longNumberFilter) : filter.or(new QFilter("longnumber", "like", (Object)longNumberFilter));
            if (curFilter == null) {
                curFilter = new QFilter("longnumber", "=", (Object)longNumber);
                continue;
            }
            curFilter = curFilter.or(new QFilter("longnumber", "=", (Object)longNumber));
        }
        if (isIncludeCurOrg) {
            filter = filter == null ? curFilter : filter.or(curFilter);
        }
        return filter;
    }

    public static DynamicObject[] getSubOrg(String orgViewType, List<Long> orgIds, String selectProperties, String orderBy, boolean isIncludeCurOrg, boolean isIncludeGrand) {
        if (isIncludeGrand) {
            return OrgViewUtils.getSubOrgIncludeGrand(orgViewType, orgIds, selectProperties, orderBy, isIncludeCurOrg);
        }
        return OrgViewUtils.getSubOrg(orgViewType, orgIds, selectProperties, orderBy, isIncludeCurOrg);
    }

    public static DynamicObject[] getSubOrg(String orgViewType, List<Long> orgIds, String selectProperties, String orderBy, boolean isIncludeCurOrg) {
        DynamicObject[] orgArr;
        if (Utils.isListEmpty(orgIds)) {
            log.warn("getSubOrg\u67e5\u8be2\u4e0b\u7ea7\u7ec4\u7ec7\u7684ID\u53c2\u6570\u4e3a\u7a7a");
            return new DynamicObject[0];
        }
        QFilter filter = new QFilter("parent", "in", orgIds);
        if (isIncludeCurOrg) {
            filter = filter.or(new QFilter("org", "in", orgIds));
        }
        if (StringUtils.isNotBlank((CharSequence)orgViewType)) {
            filter = filter.and(OrgViewUtils.getOrgViewNumberFilter(orgViewType));
        }
        QFilter[] filters = new QFilter[]{filter};
        if (StringUtils.isBlank((CharSequence)orderBy)) {
            orderBy = "level";
        }
        if ((orgArr = BusinessDataServiceHelper.load((String)"bos_org_structure", (String)selectProperties, (QFilter[])filters, (String)orderBy)) == null) {
            return new DynamicObject[0];
        }
        return orgArr;
    }

    public static DynamicObject[] getSubOrgIncludeGrand(String orgViewType, List<Long> orgIds, String selectProperties, String orderBy, boolean isIncludeCurOrg) {
        if (Utils.isListEmpty(orgIds)) {
            log.warn("getSubOrgIncludeGrand\u67e5\u8be2\u4e0b\u7ea7\u7ec4\u7ec7\u7684ID\u53c2\u6570\u4e3a\u7a7a");
            return new DynamicObject[0];
        }
        return OrgViewUtils.getSubOrgByLongNumber(orgViewType, OrgViewUtils.getOrgLongNumberById(orgViewType, orgIds), selectProperties, orderBy, isIncludeCurOrg);
    }

    public static DynamicObject[] getSubOrgByLongNumber(String orgViewType, List<String> longNumberList, String selectProperties, String orderBy, boolean isIncludeCurOrg) {
        DynamicObject[] subOrgArr;
        if (Utils.isListEmpty(longNumberList)) {
            log.warn("getSubOrgByLongNumber\u67e5\u8be2\u4e0b\u7ea7\u7ec4\u7ec7\u7684ID\u53c2\u6570\u4e3a\u7a7a");
            return new DynamicObject[0];
        }
        QFilter filter = OrgViewUtils.genLongNumberFilter(longNumberList, isIncludeCurOrg);
        if (StringUtils.isNotBlank((CharSequence)orgViewType)) {
            filter = filter == null ? OrgViewUtils.getOrgViewNumberFilter(orgViewType) : filter.and(OrgViewUtils.getOrgViewNumberFilter(orgViewType));
        }
        QFilter[] filters = new QFilter[]{filter};
        if (StringUtils.isBlank((CharSequence)orderBy)) {
            orderBy = "level";
        }
        if ((subOrgArr = BusinessDataServiceHelper.load((String)"bos_org_structure", (String)selectProperties, (QFilter[])filters, (String)orderBy)) == null) {
            return new DynamicObject[0];
        }
        return subOrgArr;
    }

    public static Map<Long, String> getOrgYzjFullname(List<Long> orgIds) {
        if (Utils.isListEmpty(orgIds)) {
            return new HashMap<Long, String>(0);
        }
        QFilter viewFilter = OrgViewUtils.getOrgViewNumberFilter("01");
        QFilter orgFilter = new QFilter("org", "=", (Object)OrgUnitServiceHelper.getRootOrgId());
        String selectProperties = "id,org,fullname";
        QFilter[] filters = new QFilter[]{viewFilter, orgFilter = orgFilter.or(new QFilter("org", "in", orgIds))};
        DynamicObjectCollection orgCol = QueryServiceHelper.query((String)"bos_org_structure", (String)selectProperties, (QFilter[])filters, (String)"longnumber");
        if (Utils.isListEmpty((List)orgCol)) {
            return new HashMap<Long, String>(0);
        }
        HashMap<Long, String> fullNameMap = new HashMap<Long, String>();
        if (orgCol.size() == 1) {
            fullNameMap.put(OrgUnitServiceHelper.getRootOrgId(), "\\");
            return fullNameMap;
        }
        String rootFullname = "";
        String fullNameSep = OrgUnitServiceHelper.getOrgSeparation().getFullNameSep();
        for (DynamicObject org : orgCol) {
            Long curOrgId = org.getLong("org");
            String fullName = org.getString("fullname");
            if (curOrgId == OrgUnitServiceHelper.getRootOrgId()) {
                rootFullname = fullName;
                if (!orgIds.contains(curOrgId)) continue;
                fullNameMap.put(curOrgId, "\\");
                continue;
            }
            String orgFullname = "";
            orgFullname = (fullName = fullName.replaceFirst(rootFullname + fullNameSep, "")).indexOf(fullNameSep) != -1 ? fullName.replace(fullNameSep, "\\") : fullName;
            fullNameMap.put(curOrgId, orgFullname);
        }
        return fullNameMap;
    }

    public static Map<Long, String> getOrgYzjId(List<Long> orgIds) {
        if (Utils.isListEmpty(orgIds)) {
            return new HashMap<Long, String>(0);
        }
        QFilter viewFilter = OrgUnitServiceHelper.getBizOrgFilter((String)"01");
        QFilter orgFilter = new QFilter("id", "in", orgIds);
        String selectProperties = "id,fyzjorgid";
        QFilter[] filters = new QFilter[]{viewFilter, orgFilter};
        DynamicObjectCollection orgCol = QueryServiceHelper.query((String)"bos_org", (String)selectProperties, (QFilter[])filters);
        if (Utils.isListEmpty((List)orgCol)) {
            return new HashMap<Long, String>(0);
        }
        HashMap<Long, String> yzjorgIdMap = new HashMap<Long, String>();
        for (DynamicObject org : orgCol) {
            yzjorgIdMap.put(org.getLong("id"), org.getString("fyzjorgid"));
        }
        log.info(orgIds + "\uff1a\u6839\u636e\u7ec4\u7ec7ID\u83b7\u53d6\u4e91\u4e4b\u5bb6ID\u7684\u7ed3\u679c\uff1a" + yzjorgIdMap);
        return yzjorgIdMap;
    }

    public static void updateParentIsLeaf(List<Long> orgIds) {
        String selectFields = "id,parent";
        QFilter orgFilter = new QFilter("org", "in", orgIds);
        QFilter[] filters = new QFilter[]{orgFilter};
        DynamicObject[] orgList = BusinessDataServiceHelper.load((String)"bos_org_structure", (String)selectFields, (QFilter[])filters);
        if (orgList == null || orgList.length == 0) {
            return;
        }
        int parentCount = orgList.length;
        ArrayList<Long> parentIdList = new ArrayList<Long>(parentCount);
        for (DynamicObject org : orgList) {
            DynamicObject parentOrg = org.getDynamicObject("parent");
            if (parentOrg == null) continue;
            parentIdList.add(parentOrg.getLong("id"));
        }
        OrgViewUtils.updateParentIsLeaf(parentIdList, orgIds, false);
    }

    public static void updateParentIsLeaf(List<Long> parentIds, List<Long> orgIds, boolean isIncludeCurOrg) {
        QFilter[] filters;
        String selectFields;
        DynamicObject[] allSubOrgList;
        if (parentIds == null || parentIds.size() == 0) {
            return;
        }
        if (orgIds == null || orgIds.size() == 0) {
            return;
        }
        QFilter parentFilter = new QFilter("parent", "in", parentIds);
        if (!isIncludeCurOrg) {
            QFilter curOrgFilter = new QFilter("org", "not in", orgIds);
            parentFilter.and(curOrgFilter);
        }
        if ((allSubOrgList = BusinessDataServiceHelper.load((String)"bos_org_structure", (String)(selectFields = "id,parent"), (QFilter[])(filters = new QFilter[]{parentFilter}))) != null && allSubOrgList.length > 0) {
            for (DynamicObject org : allSubOrgList) {
                DynamicObject parentOrg = org.getDynamicObject("parent");
                if (parentOrg == null) continue;
                parentIds.remove(parentOrg.getLong("id"));
                if (parentIds.size() != 0) continue;
                return;
            }
        }
        OrgViewUtils.doUpdateParentIsLeaf(parentIds, true);
    }

    public static void doUpdateParentIsLeaf(List<Long> parentIds, boolean isLeaf) {
        if (Utils.isListEmpty(parentIds)) {
            return;
        }
        String selectFields = "id,org,view,isleaf,isctrlunit,isstatsum,isbizunit";
        QFilter updateParentFilter = new QFilter("org", "in", parentIds);
        QFilter[] filters = new QFilter[]{updateParentFilter};
        DynamicObject[] updateOrgArr = BusinessDataServiceHelper.load((String)"bos_org_structure", (String)selectFields, (QFilter[])filters);
        if (updateOrgArr == null || updateOrgArr.length == 0) {
            return;
        }
        for (DynamicObject updateOrg : updateOrgArr) {
            updateOrg.set("isleaf", (Object)isLeaf);
            if (isLeaf) {
                DynamicObject viewObj = updateOrg.getDynamicObject("view");
                if (viewObj != null && "16".equals(viewObj.getString("treetype"))) {
                    updateOrg.set("isctrlunit", (Object)Boolean.FALSE);
                }
                updateOrg.set("isstatsum", (Object)Boolean.FALSE);
                updateOrg.set("isbizunit", (Object)Boolean.TRUE);
                continue;
            }
            updateOrg.set("isctrlunit", (Object)Boolean.TRUE);
            updateOrg.set("isstatsum", (Object)Boolean.TRUE);
            updateOrg.set("isbizunit", (Object)Boolean.FALSE);
        }
        SaveServiceHelper.save((DynamicObject[])updateOrgArr);
    }

    public static boolean freezeOrg(List<Long> orgIds, boolean isDeleteYzj, List<String> errorMsg) {
        if (Utils.isListEmpty(orgIds)) {
            log.info("\u5c01\u5b58\u7ec4\u7ec7ID\u5217\u8868\u4e3a\u7a7a\u3002");
            return true;
        }
        List<Long> allOrgIds = OrgViewUtils.getSubOrgIdIncludeGrand("01", orgIds, true, null);
        DynamicObject[] orgStructureArr = OrgViewUtils.queryAllFreezeOrg(allOrgIds);
        if (orgStructureArr == null || orgStructureArr.length == 0) {
            String msg = BaseMessage.getMessage("M00062");
            if (errorMsg != null) {
                errorMsg.add(msg);
            }
            return false;
        }
        ArrayList<Long> lstDelOrgs = new ArrayList<Long>(orgStructureArr.length);
        Date nowTime = new Date();
        for (DynamicObject org : orgStructureArr) {
            org.set("isfreeze", (Object)Boolean.TRUE);
            org.set("sealuptime", (Object)nowTime);
            DynamicObject orgEntity = org.getDynamicObject("org");
            if (orgEntity == null) continue;
            lstDelOrgs.add(orgEntity.getLong("id"));
        }
        if (isDeleteYzj && !YzjSyncUtils.delYzjOrg(lstDelOrgs, errorMsg)) {
            return false;
        }
        SaveServiceHelper.save((DynamicObject[])orgStructureArr);
        OrgViewUtils.deleteYzjInfoOfOrg(allOrgIds);
        OrgViewUtils.deleteUserPosition(allOrgIds);
        return true;
    }

    private static DynamicObject[] queryAllFreezeOrg(List<Long> orgIdList) {
        QFilter orgFilter = new QFilter("org", "in", orgIdList);
        QFilter viewFilter = OrgViewUtils.getOrgViewNumberFilter("01");
        QFilter isFreezeFilter = new QFilter("isfreeze", "=", (Object)Boolean.FALSE);
        isFreezeFilter.or(QFilter.isNull((String)"isfreeze"));
        QFilter[] filters = new QFilter[]{orgFilter, viewFilter, isFreezeFilter};
        String selectFields = "id,org,isfreeze,sealuptime";
        DynamicObject[] orgStructureArr = BusinessDataServiceHelper.load((String)"bos_org_structure", (String)selectFields, (QFilter[])filters);
        return orgStructureArr;
    }

    private static void deleteYzjInfoOfOrg(List<Long> orgIdList) {
        String selectFields = "id,fyzjorgid,fyzjimorted,fisadministrative";
        QFilter idFilter = new QFilter("id", "in", orgIdList);
        QFilter[] filters = new QFilter[]{idFilter};
        DynamicObject[] orgArr = BusinessDataServiceHelper.load((String)"bos_org", (String)selectFields, (QFilter[])filters);
        if (orgArr == null || orgArr.length == 0) {
            return;
        }
        for (DynamicObject org : orgArr) {
            org.set("fyzjorgid", (Object)"");
            org.set("fyzjimorted", (Object)Boolean.FALSE);
        }
        SaveServiceHelper.save((DynamicObject[])orgArr);
    }

    private static boolean deleteUserPosition(List<Long> orgIdList) {
        String selectProperties = "id,entryentity,entryentity.dpt";
        QFilter orgFilter = new QFilter("entryentity.dpt", "in", orgIdList);
        QFilter[] filters = new QFilter[]{orgFilter};
        DynamicObject[] userArr = BusinessDataServiceHelper.load((String)"bos_user", (String)selectProperties, (QFilter[])filters);
        if (userArr == null || userArr.length == 0) {
            return true;
        }
        for (DynamicObject user : userArr) {
            DynamicObjectCollection entityCol = user.getDynamicObjectCollection("entryentity");
            if (Utils.isListEmpty((List)entityCol)) continue;
            Iterator entityItr = entityCol.iterator();
            while (entityItr.hasNext()) {
                DynamicObject entity = (DynamicObject)entityItr.next();
                DynamicObject org = entity.getDynamicObject("dpt");
                if (org == null || !orgIdList.contains(org.getLong("id"))) continue;
                entityItr.remove();
            }
        }
        SaveServiceHelper.save((DynamicObject[])userArr);
        return true;
    }

    public static void updateOrgName(List<Long> orgIds, Map<Long, String> newNameMap) {
        if (Utils.isListEmpty(orgIds)) {
            log.info("\u7ec4\u7ec7ID\u7684\u53c2\u6570\u4e3a\u7a7a");
            return;
        }
        if (newNameMap == null || newNameMap.size() == 0) {
            log.info("\u7ec4\u7ec7\u540d\u79f0\u96c6\u5408\u7684\u53c2\u6570\u4e3a\u7a7a");
            return;
        }
        String selectProperties = "id,name";
        QFilter idFilter = new QFilter("id", "in", orgIds);
        QFilter[] filters = new QFilter[]{idFilter};
        DynamicObject[] orgNameArr = BusinessDataServiceHelper.load((String)"bos_org", (String)selectProperties, (QFilter[])filters);
        if (orgNameArr != null && orgNameArr.length > 0) {
            for (DynamicObject org : orgNameArr) {
                String orgName = newNameMap.get(org.getLong("id"));
                if (!StringUtils.isNotBlank((CharSequence)orgName)) continue;
                org.set("name", (Object)orgName);
            }
            SaveServiceHelper.save((DynamicObject[])orgNameArr);
        }
        OrgViewUtils.updateOrgFullName(orgIds, newNameMap);
    }

    public static void updateOrgFullName(List<Long> orgIds, Map<Long, String> newNameMap) {
        if (Utils.isListEmpty(orgIds)) {
            log.info("\u7ec4\u7ec7ID\u7684\u53c2\u6570\u4e3a\u7a7a");
            return;
        }
        for (long orgId : orgIds) {
            OrgViewUtils.updateOrgStructureByBaseInfo(orgId);
        }
    }

    @Deprecated
    public static void updateAdminOrgStructure(List<Long> orgIds, Map<Long, DynamicObject> newParentMap) {
        ArrayList<Long> oldParentIds = new ArrayList<Long>(orgIds.size());
        oldParentIds.addAll(orgIds);
        ArrayList<DynamicObject> subOrgList = new ArrayList<DynamicObject>();
        OrgViewUtils.querySubAdminOrgList(subOrgList, orgIds, newParentMap);
        int count = subOrgList.size();
        if (count > 0) {
            SaveServiceHelper.save((DynamicObject[])subOrgList.toArray(new DynamicObject[count]));
            OrgViewUtils.doUpdateParentIsLeaf(oldParentIds, false);
        }
    }

    private static void querySubAdminOrgList(List<DynamicObject> subOrgList, List<Long> orgIds, Map<Long, DynamicObject> newParentMap) {
        QFilter parentFilter;
        if (Utils.isListEmpty(orgIds)) {
            return;
        }
        String selectFields = "id,org,parent,yzjorgid,yzjparentorgid,longnumber,fullname,level,isleaf,isctrlunit,isstatsum,isbizunit";
        QFilter viewFilter = OrgViewUtils.getOrgViewNumberFilter("01");
        QFilter[] filters = new QFilter[]{viewFilter, parentFilter = new QFilter("parent", "in", orgIds)};
        DynamicObject[] orgCol = BusinessDataServiceHelper.load((String)"bos_org_structure", (String)selectFields, (QFilter[])filters);
        if (orgCol == null || orgCol.length == 0) {
            return;
        }
        ArrayList<Long> parentIds = new ArrayList<Long>(orgCol.length);
        for (DynamicObject subOrg : orgCol) {
            long orgId;
            DynamicObject org = subOrg.getDynamicObject("org");
            if (org == null || newParentMap.containsKey(orgId = org.getLong("id"))) continue;
            DynamicObject parentOrg = null;
            DynamicObject parent = subOrg.getDynamicObject("parent");
            if (parent != null) {
                parentOrg = newParentMap.get(parent.getLong("id"));
            }
            OrgViewUtils.generateNewOrgStructure(subOrg, parentOrg, org);
            subOrgList.add(subOrg);
            parentIds.add(orgId);
            newParentMap.put(orgId, subOrg);
        }
        OrgViewUtils.querySubAdminOrgList(subOrgList, parentIds, newParentMap);
    }

    private static void generateNewOrgStructure(DynamicObject saveOrg, DynamicObject parentOrg, DynamicObject org) {
        String name = org.getString("name");
        saveOrg.set("name", (Object)name);
        if (parentOrg == null) {
            saveOrg.set("parent", (Object)0);
            saveOrg.set("yzjparentorgid", (Object)"");
            saveOrg.set("longnumber", (Object)saveOrg.getString("number"));
            saveOrg.set("fullname", (Object)saveOrg.getString("fullname"));
            saveOrg.set("level", (Object)1);
            saveOrg.set("isleaf", (Object)Boolean.FALSE);
            saveOrg.set("isctrlunit", (Object)Boolean.TRUE);
            saveOrg.set("isstatsum", (Object)Boolean.TRUE);
            saveOrg.set("isbizunit", (Object)Boolean.FALSE);
        } else {
            saveOrg.set("parent", (Object)parentOrg.getDynamicObject("org"));
            saveOrg.set("yzjparentorgid", (Object)parentOrg.getString("yzjorgid"));
            saveOrg.set("longnumber", (Object)(parentOrg.getString("longnumber") + "!" + org.getString("number")));
            saveOrg.set("fullname", (Object)(parentOrg.getString("fullname") + OrgUnitServiceHelper.getOrgSeparation().getFullNameSep() + name));
            saveOrg.set("level", (Object)(parentOrg.getInt("level") + 1));
            saveOrg.set("isleaf", (Object)Boolean.TRUE);
            saveOrg.set("isctrlunit", (Object)Boolean.FALSE);
            saveOrg.set("isstatsum", (Object)Boolean.FALSE);
            saveOrg.set("isbizunit", (Object)Boolean.TRUE);
            parentOrg.set("isleaf", (Object)Boolean.FALSE);
            parentOrg.set("isctrlunit", (Object)Boolean.TRUE);
            parentOrg.set("isstatsum", (Object)Boolean.TRUE);
            parentOrg.set("isbizunit", (Object)Boolean.FALSE);
        }
    }

    public static QFilter getOrgViewFilter(String orgViewType) {
        QFilter filter = new QFilter("view.isdefault", "=", (Object)Boolean.TRUE);
        filter.and(new QFilter("view.treetype", "=", (Object)orgViewType));
        return filter;
    }

    public static QFilter getOrgViewNumberFilter(String orgViewNumber) {
        QFilter filter = new QFilter(VIEW_NUMBER_FILTER, "=", (Object)orgViewNumber);
        return filter;
    }

    public static String getRootOrgFullName() {
        QFilter orgFilter = new QFilter("id", "=", (Object)OrgUnitServiceHelper.getRootOrgId());
        QFilter[] filters = new QFilter[]{orgFilter};
        DynamicObject org = BusinessDataServiceHelper.loadSingleFromCache((String)"bos_org", (String)"id,name", (QFilter[])filters);
        if (org == null) {
            return OrgViewUtils.getRootOrgFullNameByParentId();
        }
        return org.getString("name");
    }

    public static String getRootOrgFullNameByParentId() {
        QFilter orgFilter = new QFilter("parent", "=", (Object)0);
        orgFilter.or(QFilter.isNull((String)"parent"));
        QFilter[] filters = new QFilter[]{orgFilter};
        DynamicObject org = BusinessDataServiceHelper.loadSingleFromCache((String)"bos_org_structure", (String)"id,fullname", (QFilter[])filters);
        if (org == null) {
            return "";
        }
        return org.getString("fullname");
    }

    public static int getOrgSortCode(int level, int sort) {
        return level * 1000000 + sort;
    }

    public static int getNewOrgSortCode(int level) {
        return OrgViewUtils.getOrgSortCode(level, 999999);
    }

    public static void genCommonField(DynamicObject obj, boolean isHasCreator) {
        if (obj == null) {
            return;
        }
        if (isHasCreator) {
            String userId = RequestContext.get().getUserId();
            obj.set("creator", (Object)userId);
            obj.set("modifier", (Object)userId);
        }
        Date dateTime = new Date();
        obj.set("createtime", (Object)dateTime);
        obj.set("enable", (Object)1);
        obj.set("status", (Object)"C");
        obj.set("modifytime", (Object)dateTime);
    }

    public static DynamicObject getOrgBiz(String orgViewType) {
        String selectFields = "id,fnumber number,fname name,ffieldname,propertyname,fuserdefine,isbasetype";
        QFilter defaultFilter = new QFilter("isbasetype", "=", (Object)Boolean.TRUE);
        QFilter viewFilter = new QFilter("fnumber", "=", (Object)orgViewType);
        QFilter[] filters = new QFilter[]{defaultFilter, viewFilter};
        DynamicObject orgBiz = QueryServiceHelper.queryOne((String)"bos_org_biz", (String)selectFields, (QFilter[])filters);
        return orgBiz;
    }

    public static String getOrgBizProName(String orgViewType) {
        DynamicObject orgBiz = OrgViewUtils.getOrgBiz(orgViewType);
        if (orgBiz == null) {
            return "";
        }
        return orgBiz.getString("propertyname");
    }

    public static void updateViewParent(String orgViewType) {
        if (StringUtils.isBlank((CharSequence)orgViewType)) {
            return;
        }
        String viewProName = OrgViewUtils.getOrgBizProName(orgViewType);
        LinkedHashMap<Long, DynamicObject> viewMap = new LinkedHashMap<Long, DynamicObject>();
        OrgViewUtils.getOrgLevelMap(orgViewType, viewProName, viewMap);
        if (viewMap.size() == 0) {
            return;
        }
        LinkedHashMap<Long, DynamicObject> orgUnitMap = new LinkedHashMap<Long, DynamicObject>();
        OrgViewUtils.getOrgLevelMap("15", viewProName, orgUnitMap);
        if (orgUnitMap.size() == 0) {
            return;
        }
        int viewCount = viewMap.size();
        ArrayList<DynamicObject> orgList = new ArrayList<DynamicObject>(viewCount);
        for (Map.Entry entry : viewMap.entrySet()) {
            long parentId;
            DynamicObject org = (DynamicObject)entry.getValue();
            orgList.add(org);
            DynamicObject parent = org.getDynamicObject("parent");
            if (parent == null || (parentId = parent.getLong("id")) == 0L) continue;
            OrgViewUtils.genOrgViewParent(viewProName, parentId, orgUnitMap, viewMap, org);
        }
        SaveServiceHelper.save((DynamicObject[])orgList.toArray(new DynamicObject[viewCount]));
    }

    private static void getOrgLevelMap(String orgViewType, String viewProName, Map<Long, DynamicObject> viewMap) {
        StringBuilder selectFields = new StringBuilder();
        String commonFields = "id,org,parent,yzjorgid,yzjparentorgid,level,longnumber,fullname,isleaf,isctrlunit,isstatsum,isbizunit";
        selectFields.append(commonFields);
        if (StringUtils.isNotBlank((CharSequence)viewProName)) {
            selectFields.append(",");
            selectFields.append(viewProName);
        }
        QFilter viewFilter = OrgViewUtils.getOrgViewNumberFilter(orgViewType);
        QFilter[] filters = new QFilter[]{viewFilter};
        DynamicObject[] orgArr = BusinessDataServiceHelper.load((String)"bos_org_structure", (String)selectFields.toString(), (QFilter[])filters, (String)"longnumber");
        if (orgArr == null || orgArr.length == 0) {
            return;
        }
        for (DynamicObject orgObj : orgArr) {
            DynamicObject org = orgObj.getDynamicObject("org");
            if (org == null) continue;
            long orgId = org.getLong("id");
            viewMap.put(orgId, orgObj);
        }
    }

    /*
     * Enabled aggressive block sorting
     */
    private static void genOrgViewParent(String viewProName, long parentId, Map<Long, DynamicObject> orgUnitMap, Map<Long, DynamicObject> viewMap, DynamicObject org) {
        if (parentId == 0L) {
            DynamicObject rootOrg = viewMap.get(OrgUnitServiceHelper.getRootOrgId());
            if (rootOrg == null) {
                OrgViewUtils.genOrgViewNewParent(OrgUnitServiceHelper.getRootOrgId(), rootOrg, org);
                return;
            }
            OrgViewUtils.genOrgViewNewParent(parentId, rootOrg, org);
            return;
        }
        DynamicObject levelOrg = orgUnitMap.get(parentId);
        if (levelOrg == null) {
            return;
        }
        DynamicObject orgUnit = levelOrg.getDynamicObject("org");
        boolean isSelectedView = orgUnit.getBoolean(viewProName);
        if (!isSelectedView) {
            DynamicObject levelParent = levelOrg.getDynamicObject("parent");
            OrgViewUtils.genOrgViewParent(viewProName, levelParent.getLong("id"), orgUnitMap, viewMap, org);
            return;
        }
        DynamicObject parent = viewMap.get(parentId);
        if (parent == null) {
            DynamicObject levelParent = levelOrg.getDynamicObject("parent");
            if (levelParent == null) return;
            OrgViewUtils.genOrgViewParent(viewProName, levelParent.getLong("id"), orgUnitMap, viewMap, org);
            return;
        }
        OrgViewUtils.genOrgViewNewParent(parentId, parent, org);
    }

    private static void genOrgViewNewParent(long parentId, DynamicObject parentObj, DynamicObject orgObj) {
        DynamicObject org = orgObj.getDynamicObject("org");
        orgObj.set("isleaf", (Object)Boolean.TRUE);
        orgObj.set("isctrlunit", (Object)Boolean.FALSE);
        orgObj.set("isstatsum", (Object)Boolean.FALSE);
        orgObj.set("isbizunit", (Object)Boolean.TRUE);
        orgObj.set("parent", (Object)parentId);
        if (parentObj == null) {
            orgObj.set("level", (Object)1);
            orgObj.set("longnumber", (Object)org.getString("number"));
            orgObj.set("fullname", (Object)org.getString("name"));
        } else {
            parentObj.set("isleaf", (Object)Boolean.FALSE);
            parentObj.set("isctrlunit", (Object)Boolean.TRUE);
            parentObj.set("isstatsum", (Object)Boolean.TRUE);
            parentObj.set("isbizunit", (Object)Boolean.FALSE);
            orgObj.set("yzjparentorgid", parentObj.get("yzjorgid"));
            orgObj.set("level", (Object)(parentObj.getInt("level") + 1));
            orgObj.set("longnumber", (Object)(parentObj.getString("longnumber") + "!" + org.getString("number")));
            orgObj.set("fullname", (Object)(parentObj.getString("fullname") + OrgUnitServiceHelper.getOrgSeparation().getFullNameSep() + org.getString("name")));
        }
    }

    public static boolean isOrgNameValid(IFormView view, String str) {
        String msg = OrgViewUtils.isOrgNameValid(str);
        if (StringUtils.isNotBlank((CharSequence)msg)) {
            view.showErrorNotification(msg);
            return false;
        }
        return true;
    }

    public static String isOrgNameValid(String str) {
        return OrgViewUtils.isOrgNameValid(str, null);
    }

    public static String isOrgNameValid(String name, String fullNameSep) {
        if (StringUtils.isBlank((CharSequence)name)) {
            return BaseMessage.getMessage("M00004");
        }
        if ("null".equals(name.toLowerCase())) {
            return BaseMessage.getMessage("M00033", name);
        }
        List<String> orgNameReserveChar = OrgViewUtils.getOrgNameReserveChar(name, fullNameSep, true);
        if (!CollectionUtils.isEmpty(orgNameReserveChar)) {
            return BaseMessage.getMessage("M00010", orgNameReserveChar.get(0));
        }
        return "";
    }

    public static String isOrgNameValid(ILocaleString name, String separation, Map<String, String> enableLangMap, Lang currentLang) {
        if (name == null) {
            return BaseMessage.getMessage("M00004");
        }
        if (separation == null) {
            separation = OrgUnitServiceHelper.getOrgSeparation().getFullNameSep();
        }
        if (enableLangMap == null) {
            enableLangMap = BaseUtils.getEnableLangMap();
        }
        String errorMsg = "";
        boolean checkedCurrentLang = currentLang == null;
        for (Map.Entry<String, String> langEntry : enableLangMap.entrySet()) {
            List<String> orgNameReserveChar;
            String nameValue = (String)name.get((Object)langEntry.getKey());
            if (StringUtils.isBlank((CharSequence)nameValue)) continue;
            if ("null".equals(nameValue)) {
                return BaseMessage.getMessage("M00033", name);
            }
            boolean isCurrentLang = false;
            if (currentLang != null && langEntry.getKey().equalsIgnoreCase(currentLang.name())) {
                checkedCurrentLang = true;
                isCurrentLang = true;
            }
            if ((orgNameReserveChar = OrgViewUtils.getOrgNameReserveChar(nameValue, separation, true)).isEmpty()) continue;
            if (isCurrentLang) {
                return BaseMessage.getMessage("M00010", orgNameReserveChar.get(0));
            }
            errorMsg = OrgMessage.getMessage("M00202", langEntry.getValue(), orgNameReserveChar.get(0));
            if (!checkedCurrentLang) continue;
            break;
        }
        return errorMsg;
    }

    public static Map<String, List<String>> getOrgNameReserveChar(ILocaleString name, Map<String, String> enableLangMap, String separation, boolean checkCurrent) {
        if (name == null) {
            return new HashMap<String, List<String>>(0);
        }
        if (enableLangMap == null) {
            enableLangMap = BaseUtils.getEnableLangMap();
        }
        if (separation == null) {
            separation = OrgUnitServiceHelper.getOrgSeparation().getFullNameSep();
        }
        for (Map.Entry<String, String> langEntry : enableLangMap.entrySet()) {
            List<String> orgNameReserveChar;
            String nameValue = (String)name.get((Object)langEntry.getKey());
            if (StringUtils.isBlank((CharSequence)nameValue) || (orgNameReserveChar = OrgViewUtils.getOrgNameReserveChar(nameValue, separation, checkCurrent)).isEmpty()) continue;
            HashMap<String, List<String>> langSeparationMap = new HashMap<String, List<String>>(1);
            langSeparationMap.put(langEntry.getKey(), orgNameReserveChar);
            return langSeparationMap;
        }
        return new HashMap<String, List<String>>(0);
    }

    public static List<String> getOrgNameReserveChar(String name, String currentFullNameSep, boolean checkCurrent) {
        ArrayList<String> reserveChars = new ArrayList<String>(2);
        ArrayList<String> splitChars = new ArrayList<String>(2);
        splitChars.add("\\");
        if (checkCurrent) {
            if (currentFullNameSep == null) {
                currentFullNameSep = OrgUnitServiceHelper.getOrgSeparation().getFullNameSep();
            }
            splitChars.add(currentFullNameSep);
        }
        for (String splitStr : splitChars) {
            if (name.indexOf(splitStr) == -1) continue;
            reserveChars.add(splitStr);
        }
        return reserveChars;
    }

    public static String isOrgNumberValid(long orgId, String number) {
        String msg = OrgViewUtils.isOrgNumberValid(number);
        if (StringUtils.isBlank((CharSequence)msg)) {
            msg = OrgViewUtils.isOrgNumberExists(orgId, number);
        }
        return msg;
    }

    public static String isOrgNumberExists(long orgId, String number) {
        QFilter[] filters;
        if (StringUtils.isBlank((CharSequence)number)) {
            return "";
        }
        QFilter numberFilter = new QFilter("number", "=", (Object)number);
        if (orgId != 0L) {
            QFilter idFilter = new QFilter("id", "!=", (Object)orgId);
            numberFilter = numberFilter.and(idFilter);
        }
        if (QueryServiceHelper.exists((String)"bos_org", (QFilter[])(filters = new QFilter[]{numberFilter}))) {
            return BaseMessage.getMessage("M00006");
        }
        return "";
    }

    public static boolean isOrgNumberValid(IFormView view, String str) {
        String msg = OrgViewUtils.isOrgNumberValid(str);
        if (StringUtils.isNotBlank((CharSequence)msg)) {
            view.showErrorNotification(msg);
            return false;
        }
        return true;
    }

    public static String isOrgNumberValid(String str) {
        return OrgViewUtils.isOrgNumberValid(str, null);
    }

    public static String isOrgNumberValid(String number, String longNumberSep) {
        if (StringUtils.isBlank((CharSequence)number)) {
            return "";
        }
        if ("null".equals(number.toLowerCase())) {
            return BaseMessage.getMessage("M00032", number);
        }
        if (longNumberSep == null) {
            longNumberSep = OrgUnitServiceHelper.getOrgSeparation().getLongNumberSep();
        }
        if (number.indexOf(longNumberSep) != -1) {
            return BaseMessage.getMessage("M00009", longNumberSep);
        }
        return "";
    }

    public static List<String> getAllSuperiorLongnumber(String longnumber) {
        if (StringUtils.isBlank((CharSequence)longnumber) || longnumber.indexOf("!") == -1) {
            return new ArrayList<String>(0);
        }
        ArrayList<String> superiorLongnumberSet = new ArrayList<String>(32);
        String superiorLongnumber = StringUtils.substringBeforeLast((String)longnumber, (String)"!");
        superiorLongnumberSet.add(superiorLongnumber);
        while (superiorLongnumber.indexOf("!") > 0) {
            superiorLongnumber = StringUtils.substringBeforeLast((String)superiorLongnumber, (String)"!");
            superiorLongnumberSet.add(superiorLongnumber);
        }
        return superiorLongnumberSet;
    }

    @Deprecated
    public static void updateLongNumberAndFullname(OrgEntity orgEntity) {
        OrgViewUtils.updateLongNumberAndFullname(orgEntity, Lang.zh_CN.name());
    }

    @Deprecated
    public static void updateLongNumberAndFullname(OrgEntity orgEntity, String language) {
        if (orgEntity == null) {
            return;
        }
        QFilter filter = new QFilter("id", "=", (Object)orgEntity.getId());
        QFilter[] filters = new QFilter[]{filter};
        DynamicObject[] orgObjArr = BusinessDataServiceHelper.load((String)"bos_org", (String)"id,number,name", (QFilter[])filters);
        if (orgObjArr == null || orgObjArr.length == 0) {
            return;
        }
        for (DynamicObject orgObj : orgObjArr) {
            orgObj.set("number", (Object)orgEntity.getNumber());
            orgObj.set("name", (Object)orgEntity.getName());
        }
        try (TXHandle h = TX.required();){
            try {
                SaveServiceHelper.save((DynamicObject[])orgObjArr);
                OrgViewUtils.updateOrgStructureByBaseInfo(orgEntity.getId());
            }
            catch (Exception e) {
                log.error("[updateLongNumberAndFullname]\u66f4\u65b0\u7ec4\u7ec7\u957f\u7f16\u7801\u548c\u957f\u540d\u79f0\u51fa\u73b0\u5f02\u5e38\uff1a" + e.getMessage(), (Throwable)e);
                h.markRollback();
            }
        }
    }

    public static boolean isNumberUnSupport(IFormView view, String number, boolean check) {
        if (!check) {
            return false;
        }
        if (StringUtils.isBlank((CharSequence)number) || number.startsWith("0") || !StringUtils.isNumeric((CharSequence)number)) {
            return false;
        }
        BigDecimal num = new BigDecimal(number);
        if (num.compareTo(new BigDecimal(1)) >= 0 && num.compareTo(new BigDecimal(1000)) <= 0) {
            view.showTipNotification(BaseMessage.getMessage("M00066", 1, 1000));
            return true;
        }
        return false;
    }

    @Deprecated
    public static void updateOrgStructureByBaseInfo(long orgId) {
        if (orgId == 0L) {
            return;
        }
        Map viewObjMap = BusinessDataServiceHelper.loadFromCache((String)"bos_org_viewschema", null);
        if (viewObjMap == null || viewObjMap.isEmpty()) {
            return;
        }
        try (TXHandle h = TX.required();){
            try {
                QFilter orgFilter = new QFilter("org", "=", (Object)orgId);
                for (Map.Entry viewEntry : viewObjMap.entrySet()) {
                    QFilter parentOrgFilter;
                    QFilter[] parentFilters;
                    DynamicObject[] parentStructObjArr;
                    Object viewId = viewEntry.getKey();
                    QFilter viewFilter = new QFilter("view", "=", viewId);
                    QFilter[] filters = new QFilter[]{viewFilter, orgFilter};
                    DynamicObject[] structObjArr = OrgViewUtils.getOrgStructureByBaseInfo(filters);
                    if (structObjArr == null || structObjArr.length == 0) continue;
                    HashMap<Long, DynamicObject> parentStructMap = new HashMap<Long, DynamicObject>();
                    DynamicObject structObj = structObjArr[0];
                    String oldLongNumber = structObj.getString("longnumber");
                    DynamicObject orgObj = structObj.getDynamicObject("org");
                    if (orgObj == null) continue;
                    DynamicObject parentOrgObj = structObj.getDynamicObject("parent");
                    if (parentOrgObj != null && (parentStructObjArr = OrgViewUtils.getOrgStructureByBaseInfo(parentFilters = new QFilter[]{viewFilter, parentOrgFilter = new QFilter("org", "=", parentOrgObj.getPkValue())})) != null && parentStructObjArr.length != 0) {
                        parentStructMap.put(parentOrgObj.getLong("id"), parentStructObjArr[0]);
                    }
                    OrgViewUtils.generateOrgStructureByBaseInfo(structObj, parentStructMap);
                    SaveServiceHelper.save((DynamicObject[])structObjArr);
                    OrgViewUtils.updateSubOrgStructureByBaseInfo(viewId, oldLongNumber, parentStructMap);
                }
            }
            catch (Exception e) {
                log.error("[updateOrgStructureByBaseInfo]\u66f4\u65b0\u7ec4\u7ec7\u957f\u7f16\u7801\u548c\u957f\u540d\u79f0\u51fa\u73b0\u5f02\u5e38\uff1a" + e.getMessage(), (Throwable)e);
                h.markRollback();
            }
        }
    }

    @Deprecated
    public static void updateSubOrgStructureByBaseInfo(Object viewId, String parentLongNumber, Map<Long, DynamicObject> parentStructMap) {
        QFilter orgFilter = new QFilter("view", "=", viewId);
        String oldLongNumberFilter = parentLongNumber + "!" + "%";
        QFilter longNumberFilter = QFilter.like((String)"longnumber", (String)oldLongNumberFilter);
        QFilter[] filters = new QFilter[]{orgFilter, longNumberFilter};
        DynamicObject[] structObjArr = OrgViewUtils.getOrgStructureByBaseInfo(filters);
        if (structObjArr == null || structObjArr.length == 0) {
            return;
        }
        for (DynamicObject structObj : structObjArr) {
            OrgViewUtils.generateOrgStructureByBaseInfo(structObj, parentStructMap);
        }
        SaveServiceHelper.save((DynamicObject[])structObjArr);
    }

    @Deprecated
    public static DynamicObject[] getOrgStructureByBaseInfo(QFilter[] filters) {
        String selectFields = "id,view,org,parent,longnumber,fullname,level";
        return BusinessDataServiceHelper.load((String)"bos_org_structure", (String)selectFields, (QFilter[])filters, (String)"longnumber");
    }

    @Deprecated
    public static void generateOrgStructureByBaseInfo(DynamicObject structObj, Map<Long, DynamicObject> parentStructMap) {
        DynamicObject orgObj = structObj.getDynamicObject("org");
        if (orgObj == null) {
            return;
        }
        DynamicObject parentStructObj = null;
        DynamicObject parentOrgObj = structObj.getDynamicObject("parent");
        if (parentOrgObj != null) {
            parentStructObj = parentStructMap.get(parentOrgObj.getLong("id"));
        }
        if (parentStructObj == null) {
            structObj.set("level", (Object)1);
            structObj.set("longnumber", (Object)orgObj.getString("number"));
            structObj.set("fullname", (Object)orgObj.getString("name"));
        } else {
            structObj.set("level", (Object)(parentStructObj.getInt("level") + 1));
            structObj.set("longnumber", (Object)(parentStructObj.getString("longnumber") + "!" + orgObj.getString("number")));
            structObj.set("fullname", (Object)(parentStructObj.getString("fullname") + OrgUnitServiceHelper.getOrgSeparation().getFullNameSep() + orgObj.getString("name")));
        }
        parentStructMap.put(orgObj.getLong("id"), structObj);
    }
}

