/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.org.utils;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import kd.bos.base.utils.msg.OrgMessage;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.org.model.OrgEntity;
import kd.bos.org.model.OrgStructureEntity;
import kd.bos.org.model.OrgUnit;
import kd.bos.org.utils.OrgUtils;
import kd.bos.org.utils.OrgViewUtils;
import kd.bos.org.utils.Utils;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import kd.bos.servicehelper.org.OrgUnitServiceHelper;
import kd.bos.yzj.interfaces.IYzjOrgService;
import kd.bos.yzj.model.YzjConfig;
import kd.bos.yzj.model.org.YzjOrgParam;
import kd.bos.yzj.service.YzjServiceFactory;

public class YzjSyncUtils {
    private static final Log log = LogFactory.getLog(YzjSyncUtils.class);

    public static boolean addYzjOrg(List<OrgEntity> orgList) {
        if (Utils.isListEmpty(orgList)) {
            return true;
        }
        IYzjOrgService yzjService = YzjServiceFactory.getOrgService();
        return YzjSyncUtils.addYzjOrg(yzjService, orgList);
    }

    public static boolean addYzjOrg(IYzjOrgService yzjService, List<OrgEntity> orgList) {
        if (Utils.isListEmpty(orgList) || yzjService == null) {
            return true;
        }
        YzjConfig yzjConfig = yzjService.getConfig();
        if (3 != yzjConfig.getSyncMode()) {
            return true;
        }
        boolean isAddSuccess = true;
        int count = orgList.size();
        ArrayList<YzjOrgParam> yzjOrgList = new ArrayList<YzjOrgParam>(count);
        ArrayList<String> sameOrgList = new ArrayList<String>(count);
        for (OrgEntity orgEntity : orgList) {
            OrgStructureEntity orgStru;
            String fullname;
            if (orgEntity.getDuty() == null || !"01".equals(orgEntity.getDuty().getNumber()) || sameOrgList.contains(fullname = (orgStru = orgEntity.getOrgViewStru()).getFullname())) continue;
            sameOrgList.add(fullname);
            YzjOrgParam org = new YzjOrgParam();
            org.setFullname(fullname);
            org.setSortCode(Long.toString(orgStru.getSortCode()));
            yzjOrgList.add(org);
        }
        if (yzjOrgList.isEmpty()) {
            return true;
        }
        String rootOrgName = yzjService.getRootOrgName();
        if (!YzjSyncUtils.queryYzjExistsOrg(yzjService, orgList, yzjOrgList, rootOrgName)) {
            return false;
        }
        if (yzjOrgList.isEmpty()) {
            return true;
        }
        yzjService.add(yzjOrgList);
        isAddSuccess = YzjSyncUtils.isAddYzjOrgSuccess(yzjOrgList, orgList);
        return isAddSuccess;
    }

    private static boolean isAddYzjOrgSuccess(List<YzjOrgParam> yzjOrgList, List<OrgEntity> orgList) {
        boolean isAddSuccess = true;
        block0: for (YzjOrgParam orgModel : yzjOrgList) {
            String fullname = orgModel.getFullname();
            if (StringUtils.isBlank((CharSequence)fullname)) continue;
            for (OrgEntity orgEntity : orgList) {
                OrgStructureEntity orgStruct = orgEntity.getOrgViewStru();
                if (!fullname.equals(orgStruct.getFullname())) continue;
                if (orgModel.isSuccess()) {
                    orgEntity.setYzjImorted(true);
                    orgEntity.setYzjOrgId(orgModel.getYzjOrgId());
                } else {
                    isAddSuccess = false;
                    String msg = OrgMessage.getMessage("M00123", orgModel.getMsg());
                    orgEntity.setMsg(msg);
                }
                orgEntity.setSuccess(isAddSuccess);
                continue block0;
            }
        }
        return isAddSuccess;
    }

    private static boolean queryYzjExistsOrg(IYzjOrgService yzjService, List<OrgEntity> orgList, List<YzjOrgParam> yzjOrgList, String rootOrgName) {
        boolean isSuccess = true;
        List orgMapList = yzjService.get(1, yzjOrgList);
        if (Utils.isListEmpty((List)orgMapList)) {
            return isSuccess;
        }
        ArrayList<String> yzjOrgIds = new ArrayList<String>(orgMapList.size());
        for (Map orgMap : orgMapList) {
            String yzjOrgId = String.valueOf(orgMap.get("id"));
            yzjOrgIds.add(yzjOrgId);
        }
        Map<String, String> existsOrgMap = YzjSyncUtils.queryExsitsYzjOrg(yzjOrgIds);
        String rootPath = "\\\\";
        for (Map orgMap : orgMapList) {
            for (OrgEntity orgEntity : orgList) {
                isSuccess = YzjSyncUtils.findYzjExistsOrg(orgEntity, rootPath, orgMap, rootOrgName, existsOrgMap);
            }
            YzjSyncUtils.removeExsitsYzjOrg(yzjOrgList, orgMap, rootPath);
        }
        return isSuccess;
    }

    private static boolean findYzjExistsOrg(OrgEntity orgEntity, String rootPath, Map<String, Object> orgMap, String rootOrgName, Map<String, String> existsOrgMap) {
        String yzjOrgId = String.valueOf(orgMap.get("id"));
        String department = String.valueOf(orgMap.get("department"));
        OrgStructureEntity orgStru = orgEntity.getOrgViewStru();
        String paramFullname = orgStru.getFullname();
        boolean isSameOrg = false;
        if (rootPath.equals(paramFullname)) {
            isSameOrg = true;
        } else {
            String fullNameSep = OrgUnitServiceHelper.getOrgSeparation().getFullNameSep();
            String fullname = department.replace("\\", fullNameSep);
            fullname = rootOrgName + fullNameSep + fullname;
            if (fullname.equals(paramFullname)) {
                isSameOrg = true;
            }
        }
        if (isSameOrg) {
            if (existsOrgMap.containsKey(yzjOrgId)) {
                orgEntity.setYzjOrgId(yzjOrgId);
                orgEntity.setYzjImorted(false);
                orgEntity.setSuccess(false);
                String msg = OrgMessage.getMessage("M00126");
                orgEntity.setMsg(msg);
                return false;
            }
            orgEntity.setYzjImorted(true);
            orgEntity.setYzjOrgId(yzjOrgId);
            orgEntity.setSuccess(true);
        }
        return true;
    }

    private static void removeExsitsYzjOrg(List<YzjOrgParam> yzjOrgList, Map<String, Object> orgMap, String rootPath) {
        String department = String.valueOf(orgMap.get("department"));
        String yzjParentOrgId = String.valueOf(orgMap.get("parentId"));
        Iterator<YzjOrgParam> iterator = yzjOrgList.iterator();
        while (iterator.hasNext()) {
            YzjOrgParam YzjOrgParam2 = iterator.next();
            String orgPath = YzjOrgParam2.getDepartment();
            if (rootPath.equals(orgPath) && StringUtils.isBlank((CharSequence)yzjParentOrgId)) {
                iterator.remove();
                break;
            }
            if (!department.equals(orgPath)) continue;
            iterator.remove();
            break;
        }
    }

    private static Map<String, String> queryExsitsYzjOrg(List<String> yzjOrgIds) {
        HashMap<String, String> existsOrgMap = new HashMap<String, String>();
        String selectFields = "id,yzjorgid,fullname";
        QFilter viewFilter = OrgViewUtils.getOrgViewFilter("01");
        QFilter yzjidFilter = new QFilter("yzjorgid", "in", yzjOrgIds);
        QFilter[] filters = new QFilter[]{viewFilter, yzjidFilter};
        DynamicObjectCollection orgCol = QueryServiceHelper.query((String)"bos_org_structure", (String)selectFields, (QFilter[])filters);
        if (Utils.isListEmpty((List)orgCol)) {
            return existsOrgMap;
        }
        for (DynamicObject orgObj : orgCol) {
            existsOrgMap.put(orgObj.getString("yzjorgid"), orgObj.getString("fullname"));
        }
        return existsOrgMap;
    }

    public static boolean delYzjOrg(List<Long> orgIds, List<String> errorMsg) {
        if (Utils.isListEmpty(orgIds)) {
            return false;
        }
        IYzjOrgService yzjService = YzjServiceFactory.getOrgService();
        return YzjSyncUtils.delYzjOrg(yzjService, orgIds, errorMsg);
    }

    public static boolean delYzjOrg(IYzjOrgService yzjService, List<Long> orgIds, List<String> errorMsg) {
        if (Utils.isListEmpty(orgIds) || yzjService == null) {
            return true;
        }
        YzjConfig yzjConfig = yzjService.getConfig();
        if (3 != yzjConfig.getSyncMode()) {
            return true;
        }
        log.info("\u6839\u636e\u7ec4\u7ec7ID\u5220\u9664\u4e91\u4e4b\u5bb6\u7ec4\u7ec7\uff1a" + orgIds);
        ArrayList<Long> tempOrgIds = new ArrayList<Long>(orgIds);
        boolean result = YzjSyncUtils.delYzjOrgById(yzjService, tempOrgIds, errorMsg);
        if (!tempOrgIds.isEmpty()) {
            result = YzjSyncUtils.delYzjOrgByFullname(yzjService, tempOrgIds, errorMsg);
        }
        return result;
    }

    private static boolean delYzjOrgById(IYzjOrgService yzjService, List<Long> orgIds, List<String> errorMsg) {
        Map<Long, String> yzjorgIdMap = OrgViewUtils.getOrgYzjId(orgIds);
        if (yzjorgIdMap.isEmpty()) {
            return true;
        }
        List<YzjOrgParam> orgModelList = YzjSyncUtils.getDelYzjOrgByIdParam(yzjorgIdMap);
        ArrayList<YzjOrgParam> existsList = new ArrayList<YzjOrgParam>(yzjorgIdMap.size());
        ArrayList<Long> deletedOrgIds = new ArrayList<Long>();
        YzjSyncUtils.getDelOrgYzjId(yzjService, orgModelList, existsList, deletedOrgIds);
        orgIds.removeAll(deletedOrgIds);
        if (existsList.isEmpty()) {
            return true;
        }
        yzjService.deleteById(orgModelList);
        YzjOrgParam orgModel = orgModelList.get(0);
        if (orgModel.isSuccess()) {
            return true;
        }
        if (errorMsg != null) {
            String msg = OrgMessage.getMessage("M00124", orgModelList.get(0).getMsg());
            errorMsg.add(msg);
        }
        return false;
    }

    private static void getDelOrgYzjId(IYzjOrgService yzjService, List<YzjOrgParam> orgModelList, List<YzjOrgParam> existsList, List<Long> deletedOrgIds) {
        List yzjOrgList = yzjService.get(0, orgModelList);
        if (Utils.isListEmpty((List)yzjOrgList)) {
            return;
        }
        for (YzjOrgParam YzjOrgParam2 : orgModelList) {
            String yzjOrgId = YzjOrgParam2.getYzjOrgId();
            for (Map yzjOrgMap : yzjOrgList) {
                if (!yzjOrgId.equals(String.valueOf(yzjOrgMap.get("id")))) continue;
                existsList.add(YzjOrgParam2);
                deletedOrgIds.add(YzjOrgParam2.getId());
            }
        }
    }

    private static List<YzjOrgParam> getDelYzjOrgByIdParam(Map<Long, String> yzjorgIdMap) {
        ArrayList<YzjOrgParam> orgModelList = new ArrayList<YzjOrgParam>(yzjorgIdMap.size());
        for (Map.Entry<Long, String> entry : yzjorgIdMap.entrySet()) {
            long orgId = entry.getKey();
            String yzjOrgId = entry.getValue();
            if (StringUtils.isNotBlank((CharSequence)yzjOrgId) && !"0".equals(yzjOrgId)) {
                YzjOrgParam orgModel = new YzjOrgParam();
                orgModel.setId(orgId);
                orgModel.setYzjOrgId(yzjOrgId);
                orgModelList.add(orgModel);
                continue;
            }
            log.info(orgId + "\uff1a\u7ec4\u7ec7\u7684\u4e91\u4e4b\u5bb6ID\u672a\u8bbe\u7f6e\uff1a" + yzjOrgId);
        }
        return orgModelList;
    }

    private static boolean delYzjOrgByFullname(IYzjOrgService yzjService, List<Long> orgIds, List<String> errorMsg) {
        log.info("\u6839\u636e\u7ec4\u7ec7\u957f\u540d\u79f0\u5220\u9664\u4e91\u4e4b\u5bb6\u7ec4\u7ec7\uff1a" + orgIds);
        Map<Long, String> fullNameMap = OrgViewUtils.getOrgYzjFullname(orgIds);
        if (fullNameMap == null || fullNameMap.isEmpty()) {
            if (errorMsg != null) {
                String msg = OrgMessage.getMessage("M00127");
                errorMsg.add(msg);
            }
            return false;
        }
        log.info("\u6839\u636e\u7ec4\u7ec7\u957f\u540d\u79f0\u5220\u9664\u4e91\u4e4b\u5bb6\u7ec4\u7ec7\uff1a" + fullNameMap);
        List<YzjOrgParam> orgModelList = YzjSyncUtils.getDelYzjOrgByFullnameParam(fullNameMap);
        ArrayList<YzjOrgParam> existsList = new ArrayList<YzjOrgParam>();
        YzjSyncUtils.getDelYzjOrgIdByFullname(yzjService, orgModelList, existsList);
        if (existsList.isEmpty()) {
            return true;
        }
        yzjService.delete(existsList);
        YzjOrgParam orgModel = orgModelList.get(0);
        if (orgModel.isSuccess()) {
            return true;
        }
        if (errorMsg != null) {
            String msg = OrgMessage.getMessage("M00124", orgModelList.get(0).getMsg());
            errorMsg.add(msg);
        }
        return false;
    }

    private static void getDelYzjOrgIdByFullname(IYzjOrgService yzjService, List<YzjOrgParam> orgModelList, List<YzjOrgParam> existsList) {
        List yzjOrgList = yzjService.get(1, orgModelList);
        if (Utils.isListEmpty((List)yzjOrgList)) {
            return;
        }
        for (YzjOrgParam YzjOrgParam2 : orgModelList) {
            String yzjFullname = YzjOrgParam2.getDepartment();
            for (Map yzjOrgMap : yzjOrgList) {
                if (!yzjFullname.equals(String.valueOf(yzjOrgMap.get("department")))) continue;
                existsList.add(YzjOrgParam2);
            }
        }
    }

    private static List<YzjOrgParam> getDelYzjOrgByFullnameParam(Map<Long, String> fullNameMap) {
        ArrayList<YzjOrgParam> orgModelList = new ArrayList<YzjOrgParam>(fullNameMap.size());
        for (Map.Entry<Long, String> entry : fullNameMap.entrySet()) {
            String yzjFullname = entry.getValue();
            if (!StringUtils.isNotBlank((CharSequence)yzjFullname)) continue;
            YzjOrgParam orgModel = new YzjOrgParam();
            orgModel.setId(entry.getKey().longValue());
            orgModel.setFullname(yzjFullname);
            orgModelList.add(orgModel);
        }
        return orgModelList;
    }

    public static void moveYzjOrg(String yzjOrgId, String yzjParentId) {
        IYzjOrgService yzjService = YzjServiceFactory.getOrgService();
        YzjSyncUtils.moveYzjOrg(yzjService, yzjOrgId, yzjParentId);
    }

    public static String moveYzjOrg(IYzjOrgService yzjService, String yzjOrgId, String yzjParentId) {
        if (yzjService == null || 3 != yzjService.getConfig().getSyncMode()) {
            return "";
        }
        YzjOrgParam orgModel = new YzjOrgParam();
        orgModel.setYzjOrgId(yzjOrgId);
        orgModel.setMoveToYzjOrgId(yzjParentId);
        ArrayList<YzjOrgParam> yzjOrgList = new ArrayList<YzjOrgParam>(1);
        yzjOrgList.add(orgModel);
        yzjService.move(yzjOrgList);
        String result = orgModel.getMsg();
        if (StringUtils.isBlank((CharSequence)result)) {
            return "";
        }
        return result;
    }

    public static String updateYzjOrgName(String yzjOrgId, String orgName) {
        IYzjOrgService yzjService = YzjServiceFactory.getOrgService();
        return YzjSyncUtils.updateYzjOrgName(yzjService, yzjOrgId, orgName);
    }

    public static String updateYzjOrgName(IYzjOrgService yzjService, String yzjOrgId, String orgName) {
        if (yzjService == null || 3 != yzjService.getConfig().getSyncMode()) {
            return "";
        }
        if (StringUtils.isBlank((CharSequence)yzjOrgId)) {
            String msg = OrgMessage.getMessage("M00128");
            return msg;
        }
        ArrayList<YzjOrgParam> yzjOrgList = new ArrayList<YzjOrgParam>(1);
        YzjOrgParam orgModel = new YzjOrgParam();
        orgModel.setYzjOrgId(yzjOrgId);
        orgModel.setName(orgName);
        yzjOrgList.add(orgModel);
        yzjService.updateNameById(yzjOrgList);
        String result = orgModel.getMsg();
        if (StringUtils.isBlank((CharSequence)result)) {
            return "";
        }
        String msg = OrgMessage.getMessage("M00125", result);
        return msg;
    }

    public static void updateOrgSortCode(String yzjOrgId, long sortCode) {
        IYzjOrgService yzjService = YzjServiceFactory.getOrgService();
        YzjSyncUtils.updateOrgSortCode(yzjService, yzjOrgId, sortCode);
    }

    public static void updateOrgSortCode(IYzjOrgService yzjService, String yzjOrgId, long sortCode) {
        if (yzjService == null || 3 != yzjService.getConfig().getSyncMode()) {
            return;
        }
        ArrayList<YzjOrgParam> yzjOrgList = new ArrayList<YzjOrgParam>(1);
        YzjOrgParam yzjOrg = new YzjOrgParam();
        yzjOrg.setYzjOrgId(yzjOrgId);
        yzjOrg.setSortCode(Long.toString(sortCode));
        yzjOrgList.add(yzjOrg);
        yzjService.updateWeightById(yzjOrgList);
    }

    @Deprecated
    public static boolean addOrgUnit(List<OrgUnit> lstOrgUnits) {
        if (Utils.isListEmpty(lstOrgUnits)) {
            log.info("\u7ec4\u7ec7\u65b0\u589e\u5931\u8d25\uff1a\u7ec4\u7ec7\u4fe1\u606f\u4e0d\u80fd\u4e3a\u7a7a\u3002");
            return false;
        }
        return OrgUtils.addOrgUnit(lstOrgUnits);
    }

    @Deprecated
    public static boolean addAdminOrgStructure(List<OrgUnit> orgStructureList) {
        if (Utils.isListEmpty(orgStructureList)) {
            log.info("\u7ec4\u7ec7\u7ed3\u6784\u65b0\u589e\u5931\u8d25\uff1a\u7ec4\u7ec7\u4fe1\u606f\u4e0d\u80fd\u4e3a\u7a7a\u3002");
            return false;
        }
        return OrgUtils.addOrgUnit(orgStructureList);
    }

    @Deprecated
    public static boolean updateAdminOrgStructure(Map<String, OrgUnit> updateOrgMap, List<String> yzjOrgIdList) {
        QFilter orgFilter;
        if (updateOrgMap == null || updateOrgMap.size() == 0 || Utils.isListEmpty(yzjOrgIdList)) {
            log.info("\u7ec4\u7ec7\u7ed3\u6784\u65b0\u589e\u5931\u8d25\uff1a\u7ec4\u7ec7\u4fe1\u606f\u4e0d\u80fd\u4e3a\u7a7a\u3002");
            return false;
        }
        String selectProperties = "id,org,parent,yzjorgid,yzjparentorgid,sortcode,isfreeze,isleaf,isctrlunit,isstatsum";
        QFilter viewFilter = OrgViewUtils.getOrgViewFilter("01");
        QFilter[] filters = new QFilter[]{viewFilter, orgFilter = new QFilter("yzjorgid", "in", yzjOrgIdList)};
        DynamicObject[] orgArr = BusinessDataServiceHelper.load((String)"bos_org_structure", (String)selectProperties, (QFilter[])filters);
        if (orgArr == null || orgArr.length == 0) {
            return false;
        }
        for (DynamicObject org : orgArr) {
            String yzjOrgId = org.getString("yzjorgid");
            OrgUnit orgUnit = updateOrgMap.get(yzjOrgId);
            if (orgUnit == null) continue;
            org.set("yzjorgid", (Object)orgUnit.getFyzjorgid());
            org.set("yzjparentorgid", (Object)orgUnit.getParentYzjOrgid());
            org.set("sortcode", (Object)orgUnit.getSortCode());
            org.set("isfreeze", (Object)Boolean.FALSE);
            org.set("isleaf", (Object)Boolean.TRUE);
            org.set("isctrlunit", (Object)Boolean.FALSE);
            org.set("isstatsum", (Object)Boolean.FALSE);
        }
        SaveServiceHelper.save((DynamicObject[])orgArr);
        return true;
    }

    public static void updateOrgParentIsLeaf(List<String> yzjParentOrgIds) {
        YzjSyncUtils.updateOrgParentIsLeaf(yzjParentOrgIds, null);
    }

    public static void updateOrgParentIsLeaf(List<String> yzjParentOrgIds, String orgViewNumber) {
        DynamicObject[] orgArr;
        if (Utils.isListEmpty(yzjParentOrgIds)) {
            return;
        }
        QFilter viewFilter = null;
        if (StringUtils.isNotBlank((CharSequence)orgViewNumber)) {
            viewFilter = new QFilter("view.number", "=", (Object)orgViewNumber);
        }
        String selectFields = "id,view,yzjorgid,yzjparentorgid";
        QFilter parentFilter = new QFilter("yzjparentorgid", "in", yzjParentOrgIds);
        if (viewFilter != null) {
            parentFilter = parentFilter.and(viewFilter);
        }
        QFilter[] filters = new QFilter[]{parentFilter};
        DynamicObjectCollection orgCol = QueryServiceHelper.query((String)"bos_org_structure", (String)selectFields, (QFilter[])filters);
        HashMap<Long, List<String>> parentOrgMap = new HashMap<Long, List<String>>();
        YzjSyncUtils.getUpdateOrgParentIsLeafParentMap(orgCol, parentOrgMap);
        String selectProperties = "id,view,org,yzjorgid,isleaf,isctrlunit,isstatsum";
        QFilter orgFilter = new QFilter("yzjorgid", "in", yzjParentOrgIds);
        if (viewFilter != null) {
            orgFilter = orgFilter.and(viewFilter);
        }
        if ((orgArr = BusinessDataServiceHelper.load((String)"bos_org_structure", (String)selectProperties, (QFilter[])(filters = new QFilter[]{orgFilter}))) == null || orgArr.length == 0) {
            return;
        }
        for (DynamicObject org : orgArr) {
            YzjSyncUtils.genUpdateOrgParentIsLeafObj(org, parentOrgMap);
        }
        SaveServiceHelper.save((DynamicObject[])orgArr);
    }

    private static void getUpdateOrgParentIsLeafParentMap(DynamicObjectCollection orgCol, Map<Long, List<String>> parentOrgMap) {
        if (orgCol == null || orgCol.isEmpty()) {
            return;
        }
        for (DynamicObject org : orgCol) {
            String yzjParentOrgId = org.getString("yzjparentorgid");
            long viewId = org.getLong("view");
            List<String> parentList = parentOrgMap.get(viewId);
            if (parentList != null) {
                parentList.add(yzjParentOrgId);
                continue;
            }
            ArrayList<String> yzjParentOrgIdList = new ArrayList<String>(1);
            yzjParentOrgIdList.add(yzjParentOrgId);
            parentOrgMap.put(viewId, yzjParentOrgIdList);
        }
    }

    private static void genUpdateOrgParentIsLeafObj(DynamicObject org, Map<Long, List<String>> parentOrgMap) {
        DynamicObject viewEntity = org.getDynamicObject("view");
        if (viewEntity == null) {
            return;
        }
        long viewId = viewEntity.getLong("id");
        String yzjOrgId = org.getString("yzjorgid");
        List<String> yzjParentOrgIdList = parentOrgMap.get(viewId);
        if (yzjParentOrgIdList == null) {
            return;
        }
        if (yzjParentOrgIdList.contains(yzjOrgId)) {
            org.set("isleaf", (Object)Boolean.FALSE);
            org.set("isctrlunit", (Object)Boolean.TRUE);
            org.set("isstatsum", (Object)Boolean.TRUE);
        } else {
            org.set("isleaf", (Object)Boolean.TRUE);
            if ("16".equals(viewEntity.getString("treetype"))) {
                org.set("isctrlunit", (Object)Boolean.FALSE);
            }
            org.set("isstatsum", (Object)Boolean.FALSE);
        }
    }
}

