/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.qing.modeler.plugin.portal;

import com.alibaba.fastjson.JSONObject;
import java.io.UnsupportedEncodingException;
import java.net.URLEncoder;
import java.util.ArrayList;
import java.util.EventObject;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import kd.bos.exception.ErrorCode;
import kd.bos.exception.KDException;
import kd.bos.form.IPageCache;
import kd.bos.form.control.IFrame;
import kd.bos.form.events.CustomEventArgs;
import kd.bos.form.plugin.AbstractFormPlugin;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.qing.plugin.QingUtil;
import kd.bos.qing.plugin.util.StringUtils;

public abstract class AbstractQingModelerMetricCardSelectPlugin
extends AbstractFormPlugin {
    public static final String QING_MODELER_METRIC_CARD_INFO_MAP_JSON = "QingModelerMetricCardInfoMapJson";
    public static final String QING_MODELER_METRIC_CARD_ID = "QingModelerMetricCardId";
    public static final String QING_MODELER_METRIC_CARD_NAME = "QingModelerMetricCardName";
    protected static Log logger = LogFactory.getLog(AbstractQingModelerMetricCardSelectPlugin.class);

    protected abstract IFrame getCardSelectIframeCtrl();

    public void beforeBindData(EventObject e) {
        String pageId = this.getView().getPageId();
        String url = QingUtil.getQingURL((String)"/qing_modeler/metricSelectEntrance.do");
        url = QingUtil.appendParamToUrl((String)url, (String)"pageId", (String)pageId);
        IFrame frame = this.getCardSelectIframeCtrl();
        frame.setSrc(url);
        super.beforeBindData(e);
    }

    public void customEvent(CustomEventArgs e) {
        String eventArgs = e.getEventArgs();
        JSONObject jsonObject = JSONObject.parseObject((String)eventArgs);
        if ("sendMetricInfo".equals(e.getEventName())) {
            String cardId = jsonObject.getString("cardId");
            String cardName = jsonObject.getString("cardName");
            IPageCache cache = this.getPageCache();
            List<Map<String, String>> cardConfigList = this.getCardConfigList();
            HashMap<String, String> cardConfig = new HashMap<String, String>();
            cardConfig.put(QING_MODELER_METRIC_CARD_ID, cardId);
            try {
                cardConfig.put(QING_MODELER_METRIC_CARD_NAME, URLEncoder.encode(cardName, "utf-8"));
            }
            catch (UnsupportedEncodingException ex) {
                logger.error((Throwable)ex);
                throw new KDException(new ErrorCode("qingModeler", "program exception."), new Object[]{ex.getMessage()});
            }
            this.addCustomCardConfigProp(cardConfig);
            cardConfigList.add(cardConfig);
            String jsonMetricCardInfoListJson = JSONObject.toJSONString(cardConfigList);
            cache.put(QING_MODELER_METRIC_CARD_INFO_MAP_JSON, jsonMetricCardInfoListJson);
        } else if ("cancelSendMetricInfo".equals(e.getEventName())) {
            String cardId = jsonObject.getString("cardId");
            IPageCache cache = this.getPageCache();
            List<Map<String, String>> cardConfigList = this.getCardConfigList();
            Map<String, String> cardToRemove = null;
            for (Map<String, String> cardConfig : cardConfigList) {
                if (!cardConfig.get(QING_MODELER_METRIC_CARD_ID).equals(cardId)) continue;
                cardToRemove = cardConfig;
                break;
            }
            cardConfigList.remove(cardToRemove);
            String jsonMetricCardInfoListJson = JSONObject.toJSONString(cardConfigList);
            cache.put(QING_MODELER_METRIC_CARD_INFO_MAP_JSON, jsonMetricCardInfoListJson);
        }
    }

    protected List<Map<String, String>> getCardConfigList() {
        String jsonQingCardInfoListJson = this.getPageCache().get(QING_MODELER_METRIC_CARD_INFO_MAP_JSON);
        List cardConfigList = null;
        cardConfigList = StringUtils.isNotEmpty((CharSequence)jsonQingCardInfoListJson) ? (List)JSONObject.parseObject((String)jsonQingCardInfoListJson, List.class) : new ArrayList();
        return cardConfigList;
    }

    protected void addCustomCardConfigProp(Map<String, String> cardConfig) {
    }
}

