/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.qing.modeler.plugin.portal;

import java.net.URLDecoder;
import java.util.Base64;
import java.util.HashMap;
import java.util.Map;
import kd.bos.form.FormShowParameter;
import kd.bos.form.IFormView;
import kd.bos.form.IPageCache;
import kd.bos.form.ShowType;
import kd.bos.form.control.IFrame;
import kd.bos.form.events.CustomEventArgs;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.portal.pluginnew.GridCardPlugin;
import kd.bos.portal.pluginnew.GridContainerPlugin;
import kd.bos.qing.plugin.QingUtil;
import kd.bos.qing.plugin.i18n.Messages;

public class QingMetricCardExhibitionPlugin
extends GridCardPlugin {
    private static Log logger = LogFactory.getLog(QingMetricCardExhibitionPlugin.class);
    private static final String IFRAME_AP = "iframeap";
    private static final String METRIC_LIB_ID = "metricLibId";
    private static final String METRIC_NAME = "name";
    private static final String NAME_IN_CACHE = "qingMetricName";
    private static final String APP_ID = "qingmodeler";
    private static final String HOMEPAGE_CARD_ID = "HomepageCardId";
    private static final String CARD_ID = "cardId";

    protected void refreshCard(Map<String, String> allConfigMap) {
        String metricLibId = allConfigMap.get("QingModelerMetricCardId");
        String name = allConfigMap.get("QingModelerMetricCardName");
        IPageCache cache = this.getPageCache();
        cache.put(METRIC_LIB_ID, metricLibId);
        cache.put(NAME_IN_CACHE, name);
        String homepageCardId = allConfigMap.get(HOMEPAGE_CARD_ID);
        cache.put(HOMEPAGE_CARD_ID, homepageCardId);
        String url = QingUtil.getQingURL((String)"/qing_modeler/metricAnalysisCardExhibitionEntrance.do");
        url = QingUtil.appendParamToUrl((String)url, (String)"pageId", (String)this.getView().getPageId());
        url = QingUtil.appendParamToUrl((String)url, (String)METRIC_LIB_ID, (String)metricLibId);
        url = QingUtil.appendParamToUrl((String)url, (String)METRIC_NAME, (String)name);
        url = QingUtil.appendParamToUrl((String)url, (String)CARD_ID, (String)homepageCardId);
        IFrame frame = (IFrame)this.getView().getControl(IFRAME_AP);
        QingUtil.setQingIframeSrc((IFormView)this.getView(), (IFrame)frame, (String)url);
        if (this.isDesignMode()) {
            this.forbidIFramePointerEvt();
        } else {
            this.wakenIFramePointerEvt();
        }
    }

    public void customEvent(CustomEventArgs e) {
        IFormView view = this.getView();
        view.getFormShowParameter().setAppId(APP_ID);
        if ("openDesigner".equals(e.getEventName())) {
            this.openDesigner();
        } else if ("refreshCard".equals(e.getEventName())) {
            FormShowParameter fsp = new FormShowParameter();
            fsp.setFormId("bos_card_qing");
            HashMap custParam = fsp.getOpenStyle().getCustParam();
            if (custParam == null) {
                custParam = new HashMap();
                fsp.getOpenStyle().setCustParam(custParam);
            }
            String cardId = this.getCardId();
            fsp.getOpenStyle().setShowType(ShowType.InContainer);
            fsp.getOpenStyle().setTargetKey("gridcontainerap");
            fsp.getOpenStyle().getCustParam().put(CARD_ID, cardId);
            fsp.getOpenStyle().getCustParam().put("ifDesignMode", "0");
            Map allConfigMap = this.getAllConfigMap();
            HashMap custParamMap = new HashMap(allConfigMap.size());
            for (Map.Entry entry : allConfigMap.entrySet()) {
                custParamMap.put(entry.getKey(), entry.getValue());
            }
            fsp.setCustomParams(custParamMap);
            IFormView parentView = this.getView().getParentView();
            GridContainerPlugin.updateCardIdPageIdMap((IFormView)parentView, (String)cardId, (String)fsp.getPageId());
            parentView.showForm(fsp);
            this.getView().sendFormAction(parentView);
        }
    }

    private void forbidIFramePointerEvt() {
        HashMap<String, Boolean> map = new HashMap<String, Boolean>();
        map.put("disabledPointer", true);
        this.getView().updateControlMetadata(IFRAME_AP, map);
    }

    private void wakenIFramePointerEvt() {
        HashMap<String, Boolean> map = new HashMap<String, Boolean>();
        map.put("disabledPointer", false);
        this.getView().updateControlMetadata(IFRAME_AP, map);
    }

    private void openDesigner() {
        IPageCache cache = this.getPageCache();
        String name = cache.get(NAME_IN_CACHE);
        String metricLib = cache.get(METRIC_LIB_ID);
        String url = QingUtil.getQingURL((String)"/qing_modeler/metricAnalysisDesignerEntrance.do");
        url = QingUtil.appendParamToUrl((String)url, (String)METRIC_LIB_ID, (String)metricLib);
        url = QingUtil.appendParamToUrl((String)url, (String)CARD_ID, (String)cache.get(HOMEPAGE_CARD_ID));
        Base64.Encoder encoder = Base64.getEncoder();
        String markId = new String(encoder.encode(url.getBytes()));
        url = QingUtil.appendParamToUrl((String)url, (String)METRIC_NAME, (String)name);
        url = QingUtil.appendParamToUrl((String)url, (String)"gridContainerPageId", (String)this.getView().getParentView().getPageId());
        url = QingUtil.appendParamToUrl((String)url, (String)"gridContainerCardId", (String)this.getCardId());
        String title = Messages.getMLS((String)"QingCardPlugin_2", (String)"\u6307\u6807-", (Messages.ProjectName)Messages.ProjectName.BOS_QING_PLUGIN_SHARED);
        try {
            title = title + URLDecoder.decode(name, "UTF-8");
        }
        catch (Exception e) {
            logger.error((Throwable)e);
        }
        QingUtil.openQingIFramePageInTabWithMarkId((String)APP_ID, (String)url, (String)title, (IFormView)this.getView(), (String)markId);
    }
}

