/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.portal.pluginnew;

import com.alibaba.fastjson.JSONObject;
import java.io.UnsupportedEncodingException;
import java.net.URLDecoder;
import java.util.Base64;
import java.util.EventObject;
import java.util.HashMap;
import java.util.Map;
import kd.bos.form.FormShowParameter;
import kd.bos.form.IFormView;
import kd.bos.form.IPageCache;
import kd.bos.form.ShowType;
import kd.bos.form.control.IFrame;
import kd.bos.form.events.CustomEventArgs;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.portal.pluginnew.GridCardPlugin;
import kd.bos.portal.pluginnew.GridContainerPlugin;
import kd.bos.qing.plugin.QingUtil;
import kd.bos.qing.plugin.actionhandler.QingActionDispatcher;
import kd.bos.qing.plugin.i18n.Messages;
import kd.bos.qing.plugin.util.PresetUtil;

public class QingCardPlugin
extends GridCardPlugin {
    private static Log logger = LogFactory.getLog(QingCardPlugin.class);
    private static final String QING_APP_ID = "qing";
    private static final String QING_CARD_ID = "QingCardId";
    private static final String QING_CARD_NAME = "QingCardName";
    private static final String HOMEPAGE_CARD_ID = "HomepageCardId";
    private static final String IFRAME_AP = "iframeap";
    private static final String CARD_NAME = "cardName";

    public void afterCreateNewData(EventObject evt) {
        PresetUtil.syncExecutePresetPkg();
        super.afterCreateNewData(evt);
    }

    protected void refreshCard(Map<String, String> allConfigMap) {
        String pageId = this.getView().getPageId();
        String qingCardId = allConfigMap.get(QING_CARD_ID);
        String qingCardName = allConfigMap.get(QING_CARD_NAME);
        String qingSafeCardName = allConfigMap.get("QingSafeCardName");
        if (qingSafeCardName != null) {
            try {
                qingCardName = URLDecoder.decode(qingSafeCardName, "utf-8");
            }
            catch (UnsupportedEncodingException e) {
                logger.error((Throwable)e);
            }
        }
        String homepageCardId = allConfigMap.get(HOMEPAGE_CARD_ID);
        IPageCache cache = this.getPageCache();
        cache.put(QING_CARD_ID, qingCardId);
        cache.put(QING_CARD_NAME, qingCardName);
        cache.put(HOMEPAGE_CARD_ID, homepageCardId);
        String url = QingUtil.getQingURL((String)"/qing/cardEntrance.do");
        url = QingUtil.appendParamToUrl((String)url, (String)"publishId", (String)qingCardId);
        url = QingUtil.appendParamToUrl((String)url, (String)"cardId", (String)homepageCardId);
        url = QingUtil.appendParamToUrl((String)url, (String)CARD_NAME, (String)qingCardName);
        url = QingUtil.appendParamToUrl((String)url, (String)"pageId", (String)pageId);
        IFrame frame = (IFrame)this.getView().getControl(IFRAME_AP);
        QingUtil.setQingIframeSrc((IFormView)this.getView(), (IFrame)frame, (String)url);
        if (this.isDesignMode()) {
            this.forbidIFramePointerEvt(frame);
        } else {
            this.wakenIFramePointerEvt(frame);
        }
    }

    private void forbidIFramePointerEvt(IFrame frame) {
        HashMap<String, Boolean> map = new HashMap<String, Boolean>();
        map.put("disabledPointer", true);
        this.getView().updateControlMetadata(IFRAME_AP, map);
    }

    private void wakenIFramePointerEvt(IFrame frame) {
        HashMap<String, Boolean> map = new HashMap<String, Boolean>();
        map.put("disabledPointer", false);
        this.getView().updateControlMetadata(IFRAME_AP, map);
    }

    public void customEvent(CustomEventArgs e) {
        IFormView view = this.getView();
        if (view.getFormShowParameter().getAppId() == null) {
            view.getFormShowParameter().setAppId(QING_APP_ID);
        }
        if ("refreshCard".equals(e.getEventName())) {
            FormShowParameter fsp = new FormShowParameter();
            fsp.setFormId("bos_card_qing");
            HashMap custParam = fsp.getOpenStyle().getCustParam();
            if (custParam == null) {
                custParam = new HashMap();
                fsp.getOpenStyle().setCustParam(custParam);
            }
            String cardId = this.getCardId();
            fsp.getOpenStyle().setShowType(ShowType.InContainer);
            fsp.getOpenStyle().setTargetKey("gridcontainerap");
            fsp.getOpenStyle().getCustParam().put("cardId", cardId);
            fsp.getOpenStyle().getCustParam().put("ifDesignMode", "0");
            Map allConfigMap = this.getAllConfigMap();
            HashMap custParamMap = new HashMap(allConfigMap.size());
            for (Map.Entry entry : allConfigMap.entrySet()) {
                custParamMap.put(entry.getKey(), entry.getValue());
            }
            fsp.setCustomParams(custParamMap);
            IFormView parentView = this.getView().getParentView();
            GridContainerPlugin.updateCardIdPageIdMap((IFormView)parentView, (String)cardId, (String)fsp.getPageId());
            parentView.showForm(fsp);
            this.getView().sendFormAction(parentView);
        } else if ("openSquare".equals(e.getEventName())) {
            String eventArgs = e.getEventArgs();
            JSONObject jsonObject = JSONObject.parseObject((String)eventArgs);
            String tag = "";
            String cardName = this.getPageCache().get(QING_CARD_NAME);
            if (jsonObject != null) {
                tag = jsonObject.getString("tag");
                cardName = jsonObject.getString(CARD_NAME);
            }
            this.gotoSquareMenu(tag, cardName);
        } else if ("openAnalysis".equals(e.getEventName())) {
            String eventArgs = e.getEventArgs();
            JSONObject jsonObject = JSONObject.parseObject((String)eventArgs);
            String tag = "";
            String cardName = this.getPageCache().get(QING_CARD_NAME);
            if (jsonObject != null) {
                tag = jsonObject.getString("tag");
                cardName = jsonObject.getString(CARD_NAME);
            }
            this.gotoAnalysisMenu(tag, cardName);
        } else if (QingActionDispatcher.dispatch((CustomEventArgs)e, (IFormView)view)) {
            return;
        }
    }

    private void gotoAnalysisMenu(String tag, String cardName) {
        String url = QingUtil.getQingURL((String)"/qing/editAnalysisCardEntrance.do");
        String titlePrefix = Messages.getMLS((String)"QingCardPlugin_0", (String)"\u6570\u636e\u5206\u6790-", (Messages.ProjectName)Messages.ProjectName.BOS_QING_PLUGIN);
        String title = titlePrefix + cardName;
        this.openMenu(url, title, tag);
    }

    private void gotoSquareMenu(String tag, String cardName) {
        String url = QingUtil.getQingURL((String)"/qing/editSquareCardEntrance.do");
        String titlePrefix = Messages.getMLS((String)"QingCardPlugin_1", (String)"\u6570\u636e\u6597\u65b9-", (Messages.ProjectName)Messages.ProjectName.BOS_QING_PLUGIN);
        String title = titlePrefix + cardName;
        this.openMenu(url, title, tag);
    }

    private void openMenu(String url, String title, String tag) {
        String publishId = this.getPageCache().get(QING_CARD_ID);
        String cardId = this.getPageCache().get(HOMEPAGE_CARD_ID);
        url = QingUtil.appendParamToUrl((String)url, (String)"publishId", (String)publishId);
        url = QingUtil.appendParamToUrl((String)url, (String)"cardId", (String)cardId);
        url = QingUtil.appendParamToUrl((String)url, (String)"gridContainerPageId", (String)this.getView().getParentView().getPageId());
        url = QingUtil.appendParamToUrl((String)url, (String)"gridContainerCardId", (String)this.getCardId());
        Base64.Encoder encoder = Base64.getEncoder();
        String markId = new String(encoder.encode(url.getBytes()));
        url = QingUtil.appendParamToUrl((String)url, (String)"tag", (String)tag);
        QingUtil.openQingIFramePageInTabWithMarkId((String)QING_APP_ID, (String)url, (String)title, (IFormView)this.getView(), (String)markId);
    }
}

