/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.qing.formutil;

import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.List;
import kd.bos.form.control.QingAnalysisCard;
import kd.bos.servicehelper.DispatchServiceHelper;

public class QingMsgUtil {
    private static final String QING_APP_ID = "qing";
    private static final String QING_SERVICE = "QingService";
    private static final String FILTER_ACTION = "sendFilterAction";
    private static final String REFRESH_ACTION = "sendRefreshAction";
    private static final String FILTER_TYPE_DISCRETE = "discrete";
    private static final String FILTER_TYPE_DATERANGE = "dateRange";
    private static final String FILTER_TYPE_CONTINUOUS = "continuous";

    public static void sendDiscreteFilter(List<QingAnalysisCard> receivers, String fieldName, List<String> values, boolean nullIsAll) {
        List<String> nodeIds = QingMsgUtil.collectCardCtrlNodeIds(receivers);
        QingMsgUtil.sendFilterAction(FILTER_TYPE_DISCRETE, nodeIds, fieldName, values, nullIsAll);
    }

    public static void sendDateRangeFilter(List<QingAnalysisCard> receivers, String fieldName, long startDate, long endDate) {
        List<String> nodeIds = QingMsgUtil.collectCardCtrlNodeIds(receivers);
        QingMsgUtil.sendFilterAction(FILTER_TYPE_DATERANGE, nodeIds, fieldName, startDate, endDate);
    }

    public static void sendContinuousFilter(List<QingAnalysisCard> receivers, String fieldName, BigDecimal from, BigDecimal to) {
        List<String> nodeIds = QingMsgUtil.collectCardCtrlNodeIds(receivers);
        QingMsgUtil.sendFilterAction(FILTER_TYPE_CONTINUOUS, nodeIds, fieldName, from, to);
    }

    public static void refreshCard(List<QingAnalysisCard> receivers) {
        List<String> nodeIds = QingMsgUtil.collectCardCtrlNodeIds(receivers);
        DispatchServiceHelper.invokeBOSService((String)QING_APP_ID, (String)QING_SERVICE, (String)REFRESH_ACTION, (Object[])new Object[]{nodeIds});
    }

    private static void sendFilterAction(String filterType, List<String> nodeIds, Object ... params) {
        DispatchServiceHelper.invokeBOSService((String)QING_APP_ID, (String)QING_SERVICE, (String)FILTER_ACTION, (Object[])new Object[]{nodeIds, filterType, params});
    }

    private static List<String> collectCardCtrlNodeIds(List<QingAnalysisCard> receivers) {
        ArrayList<String> nodeIds = new ArrayList<String>(receivers.size());
        for (QingAnalysisCard receiver : receivers) {
            nodeIds.add(receiver.getQingCardSource());
        }
        return nodeIds;
    }
}

