/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.qing.i18n;

import java.io.BufferedReader;
import java.io.DataInputStream;
import java.io.File;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.io.InputStreamReader;
import java.net.URL;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kd.bos.qing.plugin.util.StringUtils;

public class JSI18NUtil {
    private static final String I18N_DIRECTORY = "i18n";
    private static final String I18N_FILE_SUFFIX = ".js";
    private static final String APPID = "qing";
    private static final String DOMAIN = "qing";
    private static final String QING_ANALYSIS = "qinganalysis";
    private static final String QING_ANALYSIS_I18N = "qinganalysisi18n";
    private static final String version = new SimpleDateFormat("yyyyMMdd").format(new Date());
    private static String qingAnalysisParentPath = System.getProperty("qinganalysis.web.path", "http://172.18.12.217:88/bos_baseline_a_test/test/prepare/runtime/dockerfiles/static-file-service/webapp");
    private static String qingAnalysisI18nRootDir = System.getProperty("QingAnalysis.TempDir", "/var/data/QingStorage");

    public static List<Map<String, String>> loadAllI18nFileModels(String tlangs) throws IOException {
        if (tlangs.indexOf("en") > -1) {
            tlangs = "en";
        }
        ArrayList<Map<String, String>> fileModelList = new ArrayList<Map<String, String>>(10);
        String qingAnalysisPath = qingAnalysisParentPath + File.separator + QING_ANALYSIS;
        JSI18NUtil.collectI18NFileNamesFromURL(tlangs, qingAnalysisPath, qingAnalysisPath, fileModelList);
        if (fileModelList.size() == 0) {
            throw new IOException("Cannot find i18n file by tlangs " + tlangs);
        }
        return fileModelList;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Map<String, Object> extractI18nFileContent(String tlangs, String filename, String filePath) throws IOException {
        HashMap<String, Object> i18nResultMap = new HashMap<String, Object>(4);
        ArrayList i18nContentList = new ArrayList(10);
        String packageName = null;
        String fileFullPath = qingAnalysisParentPath + filePath;
        URL tmpUrl = new URL(fileFullPath);
        DataInputStream tmpDataInputStream = new DataInputStream(tmpUrl.openStream());
        BufferedReader bufferRead = null;
        HashMap<String, String> contentMap = null;
        HashMap i18nContentMap = new HashMap(1);
        HashMap<String, String> variableMap = new HashMap<String, String>(1);
        try {
            bufferRead = new BufferedReader(new InputStreamReader(tmpDataInputStream));
            String tmpContent = null;
            String tmpMultiplelinesContent = null;
            String tmpMultiplelinesKey = null;
            boolean existsVariable = false;
            while ((tmpContent = bufferRead.readLine()) != null) {
                String keyContent;
                String errorMsg;
                if (tmpContent == null || tmpContent.length() <= 0) continue;
                tmpContent = tmpContent.trim();
                if (variableMap.size() > 0) {
                    for (Map.Entry variableEntry : variableMap.entrySet()) {
                        String tmpVariableName = (String)variableEntry.getKey();
                        if (!tmpContent.contains(tmpVariableName)) continue;
                        String tmpVariableValue = (String)variableEntry.getValue();
                        tmpContent = tmpContent.replaceAll(" ", "");
                        tmpContent = tmpContent.replaceAll("\"\\+" + tmpVariableName + "\\+\"", tmpVariableValue);
                        tmpContent = tmpContent.replaceAll("'\\+" + tmpVariableName + "\\+'", tmpVariableValue);
                        tmpContent = tmpContent.replaceAll("\\+" + tmpVariableName + "\\+\"", tmpVariableValue);
                        tmpContent = tmpContent.replaceAll("\\+" + tmpVariableName + "\\+'", tmpVariableValue);
                        tmpContent = tmpContent.replaceAll(tmpVariableName + "\\+\"", tmpVariableValue);
                        tmpContent = tmpContent.replaceAll(tmpVariableName + "\\+'", tmpVariableValue);
                        existsVariable = true;
                    }
                }
                if (tmpContent.contains("//")) {
                    if (tmpContent.startsWith("//")) continue;
                    errorMsg = filePath + ", content\uff1a\u201c" + tmpContent + "\u201d it is not allowed to define comment content on the same line. If necessary, please set independent line-level comments.";
                    throw new IOException(errorMsg);
                }
                if (tmpContent.contains("=")) {
                    String variableValue;
                    String[] arrContent = tmpContent.split("=", 2);
                    if (tmpContent.contains("oPackage")) {
                        packageName = arrContent[1].trim();
                        if (!packageName.endsWith(";")) continue;
                        packageName = packageName.substring(0, packageName.length() - 1);
                        continue;
                    }
                    if (tmpContent.indexOf("oManager") != -1) continue;
                    String variableName = arrContent[0].trim();
                    if (variableName.startsWith("var")) {
                        variableName = variableName.substring(3, variableName.length()).trim();
                    }
                    if ((variableValue = arrContent[1].trim()).endsWith(";")) {
                        variableValue = variableValue.substring(0, variableValue.length() - 1);
                    }
                    variableValue = variableValue.substring(1, variableValue.length() - 1);
                    variableMap.put(variableName, variableValue);
                    continue;
                }
                if (tmpContent.contains("+") || existsVariable) {
                    existsVariable = false;
                    tmpContent = tmpContent.trim();
                    if (tmpMultiplelinesKey == null || tmpMultiplelinesContent == null) {
                        int keyEndIndex = tmpContent.indexOf(":");
                        if (keyEndIndex == -1) continue;
                        keyContent = tmpContent.substring(0, keyEndIndex).trim();
                        tmpMultiplelinesKey = packageName + "." + keyContent;
                        tmpMultiplelinesContent = tmpContent.substring(keyEndIndex + 1, tmpContent.length()).trim();
                        int excludeNum = 1;
                        if (tmpMultiplelinesContent.endsWith(",")) {
                            excludeNum = 2;
                        }
                        tmpMultiplelinesContent = tmpMultiplelinesContent.substring(1, tmpMultiplelinesContent.length() - excludeNum);
                        if ((tmpMultiplelinesContent = tmpMultiplelinesContent.trim()).endsWith("\"") || tmpMultiplelinesContent.endsWith("'")) {
                            tmpMultiplelinesContent = tmpMultiplelinesContent.substring(0, tmpMultiplelinesContent.length() - 1);
                        }
                    } else {
                        int iTmpContent = tmpContent.indexOf("+");
                        if (iTmpContent > -1) {
                            String excludeAddContent = null;
                            excludeAddContent = tmpContent.endsWith("+") ? tmpContent.substring(0, tmpContent.length() - 1).trim() : tmpContent.substring(iTmpContent + 1, tmpContent.length()).trim();
                            tmpMultiplelinesContent = tmpMultiplelinesContent + excludeAddContent.substring(1, excludeAddContent.length() - 1);
                        } else {
                            int excludeNum = 1;
                            if (tmpContent.endsWith(",")) {
                                excludeNum = 2;
                            }
                            tmpMultiplelinesContent = tmpMultiplelinesContent + tmpContent.substring(0, tmpContent.length() - excludeNum);
                        }
                    }
                    contentMap = new HashMap(1);
                    contentMap.put(tlangs, tmpMultiplelinesContent);
                    i18nContentMap.put(tmpMultiplelinesKey, contentMap);
                    if (i18nContentMap.get(tmpMultiplelinesKey) == null) {
                        i18nContentList.add(i18nContentMap);
                    }
                    if (!tmpContent.endsWith(",")) continue;
                    tmpMultiplelinesContent = null;
                    tmpMultiplelinesKey = null;
                    continue;
                }
                if (tmpContent.contains(":")) {
                    if (packageName == null) {
                        errorMsg = filePath + ", content\uff1a\u201c" + tmpContent + "\u201d There is no oPacket object defined nearby.";
                        throw new IOException(errorMsg);
                    }
                    int keyEndIndex = tmpContent.indexOf(":");
                    keyContent = tmpContent.substring(0, keyEndIndex).trim();
                    String key = packageName + "." + keyContent;
                    String value = tmpContent.substring(keyEndIndex + 1, tmpContent.length()).trim();
                    if (value.endsWith(",")) {
                        value = value.substring(0, value.length() - 1);
                    } else {
                        tmpMultiplelinesKey = key;
                        if (value.endsWith("+")) {
                            value = value.substring(0, value.length() - 1).trim();
                        }
                        tmpMultiplelinesContent = value.substring(1, value.length() - 1);
                    }
                    value = value.substring(1, value.length() - 1);
                    contentMap = new HashMap(1);
                    contentMap.put(tlangs, value);
                    i18nContentMap = new HashMap(1);
                    i18nContentMap.put(key, contentMap);
                    i18nContentList.add(i18nContentMap);
                    continue;
                }
                if (!tmpContent.contains("});")) continue;
                packageName = null;
                if (tmpMultiplelinesContent == null && tmpMultiplelinesKey == null) continue;
                if (i18nContentMap.get(tmpMultiplelinesKey) != null) {
                    contentMap = new HashMap<String, String>(1);
                    contentMap.put(tlangs, tmpMultiplelinesContent);
                    i18nContentMap.put(tmpMultiplelinesKey, contentMap);
                }
                tmpMultiplelinesContent = null;
                tmpMultiplelinesKey = null;
            }
        }
        finally {
            if (bufferRead != null) {
                bufferRead.close();
            }
        }
        i18nResultMap.put("filename", filename);
        i18nResultMap.put("unique", filePath);
        i18nResultMap.put("version", version);
        i18nResultMap.put("localeData", i18nContentList);
        return i18nResultMap;
    }

    private static String getOrCreateRootTmpDirPath() throws IOException {
        String rootDir = qingAnalysisI18nRootDir.startsWith("/") ? qingAnalysisI18nRootDir.substring(1) : qingAnalysisI18nRootDir;
        File tmpFile = null;
        if (rootDir.indexOf(58) > -1) {
            tmpFile = new File(rootDir);
        } else {
            File linuxDefaultRootFile = new File("/");
            tmpFile = new File(linuxDefaultRootFile.getCanonicalPath() + rootDir);
        }
        if (!tmpFile.exists() || !tmpFile.isDirectory()) {
            tmpFile.mkdirs();
        }
        return tmpFile.getCanonicalPath();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void generateJSI18nFile(String tlangs, String unique, String filename, List<Map<String, Map<String, String>>> localeDataList) throws IOException {
        boolean isCreateSuccess;
        JSI18NUtil.checkPathValid(unique);
        JSI18NUtil.checkPathValid(filename);
        HashMap<String, HashMap<String, String>> packageNameMap = new HashMap<String, HashMap<String, String>>(16);
        for (Map<String, Map<String, String>> localeDataMap : localeDataList) {
            Set<Map.Entry<String, Map<String, String>>> entrySet = localeDataMap.entrySet();
            for (Map.Entry<String, Map<String, String>> entry : entrySet) {
                String entryKey = entry.getKey();
                Map<String, String> entryValue = entry.getValue();
                int singleKeyBeginIndex = entryKey.lastIndexOf(".");
                String packageName = entryKey.substring(0, singleKeyBeginIndex);
                String contentKey = entryKey.substring(singleKeyBeginIndex + 1, entryKey.length());
                String contentValue = entryValue.get(tlangs);
                contentValue = contentValue.contains("\"") ? "'" + contentValue + "'" : "\"" + contentValue + "\"";
                HashMap<String, String> contentMap = (HashMap<String, String>)packageNameMap.get(packageName);
                if (contentMap == null) {
                    contentMap = new HashMap<String, String>(16);
                    packageNameMap.put(packageName, contentMap);
                }
                contentMap.put(contentKey, contentValue);
            }
        }
        String oldLangs = JSI18NUtil.getCurrentI18nFileTag(filename);
        String newFileName = filename.replace(oldLangs, tlangs);
        String newFilePath = unique.replace(filename, newFileName);
        File fileDir = new File(JSI18NUtil.getOrCreateRootTmpDirPath() + File.separator + QING_ANALYSIS_I18N);
        if (!fileDir.exists() || !fileDir.isDirectory()) {
            fileDir.mkdir();
        }
        String newFileFullPath = fileDir.getCanonicalPath() + newFilePath;
        String[] subFileNames = JSI18NUtil.parseEntryNameToList(newFilePath);
        File tmpSubFile = null;
        StringBuilder tmpFileName = new StringBuilder(fileDir.getCanonicalPath());
        for (int i = 0; i < subFileNames.length; ++i) {
            if (subFileNames[i].length() <= 0) continue;
            tmpFileName.append(File.separator).append(subFileNames[i]);
            tmpSubFile = new File(tmpFileName.toString());
            if (tmpSubFile.exists() || i >= subFileNames.length - 1) continue;
            tmpSubFile.mkdir();
        }
        File file = new File(newFileFullPath);
        if (!file.exists() && !(isCreateSuccess = file.createNewFile())) {
            return;
        }
        try (FileWriter out = null;){
            out = new FileWriter(file);
            out.write("(function()\r\n");
            out.write("{\r\n");
            out.write("\tvar oManager = com.kingdee.bos.qing.framework.common.MultilanguageManager;\r\n");
            Set entryPackageSet = packageNameMap.entrySet();
            Iterator iteratorPackageEntry = entryPackageSet.iterator();
            String packageName = null;
            while (iteratorPackageEntry.hasNext()) {
                Map.Entry entryPackage = iteratorPackageEntry.next();
                packageName = (String)entryPackage.getKey();
                out.write("\tvar oPackage=" + packageName + ";" + "\r\n");
                out.write("\toManager.registPackageResources(oPackage,\r\n");
                out.write("\t{\r\n");
                Map contentMap = (Map)entryPackage.getValue();
                Set contentSet = contentMap.entrySet();
                Iterator contentIterator = contentSet.iterator();
                int contentMapSize = contentMap.size();
                int iCount = 0;
                while (contentIterator.hasNext()) {
                    Map.Entry contentEntry = contentIterator.next();
                    StringBuilder content = new StringBuilder("\t\t");
                    content.append((String)contentEntry.getKey());
                    content.append(":");
                    content.append((String)contentEntry.getValue());
                    if (++iCount < contentMapSize) {
                        content.append(",");
                    }
                    content.append("\r\n");
                    out.write(content.toString());
                }
                out.write("\t});\r\n");
            }
            out.write("})();\r\n");
            out.write("//i18nVersionTag: " + version);
        }
    }

    private static String getCurrentI18nFileTag(String filename) {
        int startIndex = filename.lastIndexOf(45);
        int endIndex = filename.indexOf(46);
        String i18nFileTag = filename.substring(startIndex + 1, endIndex);
        return i18nFileTag;
    }

    private static String[] parseEntryNameToList(String fileName) {
        String[] zipEntryPath = null;
        zipEntryPath = fileName.contains("\\") ? fileName.split("\\\\") : (fileName.contains("/") ? fileName.split("/") : new String[]{fileName});
        return zipEntryPath;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Map<String, Object> buildI18nFileContent(String tlangs, String unique, String filename) throws IOException {
        String oldLangs = JSI18NUtil.getCurrentI18nFileTag(filename);
        String newFileName = filename.replace(oldLangs, tlangs);
        String newFilePath = unique.replace(filename, newFileName);
        File fileDir = new File(JSI18NUtil.getOrCreateRootTmpDirPath() + File.separator + QING_ANALYSIS_I18N);
        if (!fileDir.exists()) {
            throw new IOException("FileNotFound:" + fileDir.getCanonicalPath());
        }
        String newFileFullPath = fileDir.getCanonicalPath() + newFilePath;
        File file = new File(newFileFullPath);
        HashMap<String, String> contentResult = new HashMap<String, String>(1);
        try (BufferedReader bufferReader = null;){
            bufferReader = new BufferedReader(new FileReader(file));
            StringBuilder fileWholeContent = new StringBuilder();
            String fileLineContent = null;
            while ((fileLineContent = bufferReader.readLine()) != null) {
                fileWholeContent.append(fileLineContent);
            }
            contentResult.put(tlangs, fileWholeContent.toString());
        }
        int startIndex = newFilePath.indexOf(QING_ANALYSIS);
        int endIndex = newFilePath.indexOf(newFileName);
        String buildPath = newFilePath.substring(startIndex, endIndex);
        HashMap<String, Object> result = new HashMap<String, Object>(16);
        result.put("filename", newFileName);
        result.put("unique", newFilePath);
        result.put("buildpath", buildPath);
        result.put("domain", "qing");
        result.put("appId", "qing");
        result.put("version", version);
        result.put("contents", contentResult);
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void collectI18NFileNamesFromURL(String langType, String rootPath, String filePath, List<Map<String, String>> fileModelList) throws IOException {
        String dirName;
        ArrayList<String> dirNameList = new ArrayList<String>(10);
        URL url = new URL(filePath);
        DataInputStream dataInputStream = null;
        BufferedReader buffer = null;
        try {
            dataInputStream = new DataInputStream(url.openStream());
            buffer = new BufferedReader(new InputStreamReader(dataInputStream));
            String tmpContent = null;
            while ((tmpContent = buffer.readLine()) != null) {
                dirName = JSI18NUtil.getDirectoryName(tmpContent = tmpContent.trim());
                if (dirName == null) continue;
                dirNameList.add(dirName);
            }
        }
        finally {
            if (buffer != null) {
                buffer.close();
            }
            if (dataInputStream != null) {
                dataInputStream.close();
            }
        }
        for (int i = 0; i < dirNameList.size(); ++i) {
            dirName = (String)dirNameList.get(i);
            if (I18N_DIRECTORY.equals(dirName)) {
                String currentFilePath = filePath + File.separator + I18N_DIRECTORY;
                URL tmpUrl = new URL(currentFilePath);
                DataInputStream tmpDataInputStream = null;
                BufferedReader tmpBuffer = null;
                try {
                    tmpDataInputStream = new DataInputStream(tmpUrl.openStream());
                    tmpBuffer = new BufferedReader(new InputStreamReader(tmpDataInputStream));
                    String filename = null;
                    while ((filename = tmpBuffer.readLine()) != null) {
                        String i18nFilename = JSI18NUtil.getFileName(filename = filename.trim());
                        if (i18nFilename == null || !i18nFilename.endsWith(langType + I18N_FILE_SUFFIX)) continue;
                        HashMap<String, String> jsFileModelMap = new HashMap<String, String>(5);
                        String unique = currentFilePath.replace(rootPath, File.separator + QING_ANALYSIS) + File.separator + i18nFilename;
                        jsFileModelMap.put("filename", i18nFilename);
                        jsFileModelMap.put("unique", unique);
                        jsFileModelMap.put("version", version);
                        jsFileModelMap.put("appId", "qing");
                        jsFileModelMap.put("domain", "qing");
                        fileModelList.add(jsFileModelMap);
                    }
                    continue;
                }
                finally {
                    if (tmpBuffer != null) {
                        tmpBuffer.close();
                    }
                    if (tmpDataInputStream != null) {
                        tmpDataInputStream.close();
                    }
                }
            }
            JSI18NUtil.collectI18NFileNamesFromURL(langType, rootPath, filePath + File.separator + dirName, fileModelList);
        }
    }

    private static String getFileName(String filename) {
        if (filename.indexOf("href") > -1 && filename.indexOf(46) > -1) {
            int startIndex = filename.indexOf(62);
            int lastIndex = filename.lastIndexOf(60);
            if (startIndex > -1 && lastIndex > -1) {
                return filename.substring(startIndex + 1, lastIndex);
            }
        }
        return null;
    }

    private static String getDirectoryName(String urlFileDesc) {
        if (urlFileDesc.indexOf("href") > -1 && urlFileDesc.indexOf(46) == -1) {
            int startIndex = urlFileDesc.indexOf(62);
            int lastIndex = urlFileDesc.lastIndexOf(47);
            if (startIndex > -1 && lastIndex > -1) {
                String filename = urlFileDesc.substring(startIndex + 1, lastIndex - 2);
                return filename;
            }
        }
        return null;
    }

    private static void checkPathValid(String path) throws IOException {
        if (StringUtils.isNotBlank((CharSequence)path) && path.contains("../")) {
            throw new IOException("InvalidPath" + path);
        }
    }
}

