/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.qing.plugin;

import com.alibaba.fastjson.JSONObject;
import java.io.UnsupportedEncodingException;
import java.net.URLEncoder;
import java.util.ArrayList;
import java.util.EventObject;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import kd.bos.exception.ErrorCode;
import kd.bos.exception.KDException;
import kd.bos.form.IPageCache;
import kd.bos.form.control.IFrame;
import kd.bos.form.events.CustomEventArgs;
import kd.bos.form.plugin.AbstractFormPlugin;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.qing.plugin.QingUtil;
import kd.bos.qing.plugin.util.StringUtils;

public abstract class AbstractQingCardSelectPlugin
extends AbstractFormPlugin {
    public static final String QING_CARD_INFO_MAP_JSON = "QingCardInfoMapJson";
    protected static Log logger = LogFactory.getLog(AbstractQingCardSelectPlugin.class);

    protected abstract IFrame getCardSelectIframeCtrl();

    protected abstract boolean isSingleSelect();

    protected abstract boolean isSupportDsbCard();

    public void beforeBindData(EventObject e) {
        String pageId = this.getView().getPageId();
        String url = QingUtil.getQingURL((String)"/qing/cardSelectEntrance.do");
        url = QingUtil.appendParamToUrl((String)url, (String)"pageId", (String)pageId);
        url = QingUtil.appendParamToUrl((String)url, (String)"singleSelect", (String)(this.isSingleSelect() + ""));
        url = QingUtil.appendParamToUrl((String)url, (String)"supportDsb", (String)(this.isSupportDsbCard() + ""));
        IFrame frame = this.getCardSelectIframeCtrl();
        frame.setSrc(url);
        super.beforeBindData(e);
    }

    public void customEvent(CustomEventArgs e) {
        String eventArgs = e.getEventArgs();
        JSONObject jsonObject = JSONObject.parseObject((String)eventArgs);
        if ("sendCardInfo".equals(e.getEventName())) {
            String cardId = jsonObject.getString("cardId");
            String cardName = jsonObject.getString("cardName");
            IPageCache cache = this.getPageCache();
            List<Map<String, String>> cardConfigList = null;
            cardConfigList = this.isSingleSelect() ? new ArrayList<Map<String, String>>(1) : this.getCardConfigList();
            HashMap<String, String> cardConfig = new HashMap<String, String>();
            cardConfig.put("QingCardId", cardId);
            try {
                cardConfig.put("QingSafeCardName", URLEncoder.encode(cardName, "utf-8"));
            }
            catch (UnsupportedEncodingException ex) {
                logger.error((Throwable)ex);
                throw new KDException(new ErrorCode("qing", "program exception."), new Object[]{ex.getMessage()});
            }
            this.addCustomCardConfigProp(cardConfig);
            cardConfigList.add(cardConfig);
            String jsonQingCardInfoListJson = JSONObject.toJSONString(cardConfigList);
            cache.put(QING_CARD_INFO_MAP_JSON, jsonQingCardInfoListJson);
        } else if ("cancelSendCardInfo".equals(e.getEventName())) {
            String sId = jsonObject.getString("cardId");
            IPageCache cache = this.getPageCache();
            List<Map<String, String>> cardConfigList = this.getCardConfigList();
            Map<String, String> cardToRemove = null;
            for (Map<String, String> cardConfig : cardConfigList) {
                if (!cardConfig.get("QingCardId").equals(sId)) continue;
                cardToRemove = cardConfig;
                break;
            }
            cardConfigList.remove(cardToRemove);
            String jsonQingCardInfoListJson = JSONObject.toJSONString(cardConfigList);
            cache.put(QING_CARD_INFO_MAP_JSON, jsonQingCardInfoListJson);
        }
    }

    protected List<Map<String, String>> getCardConfigList() {
        String jsonQingCardInfoListJson = this.getPageCache().get(QING_CARD_INFO_MAP_JSON);
        List cardConfigList = null;
        cardConfigList = StringUtils.isNotEmpty((CharSequence)jsonQingCardInfoListJson) ? (List)JSONObject.parseObject((String)jsonQingCardInfoListJson, List.class) : new ArrayList();
        return cardConfigList;
    }

    protected void addCustomCardConfigProp(Map<String, String> cardConfig) {
    }
}

