/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.qing.plugin;

import com.alibaba.fastjson.JSONObject;
import java.io.IOException;
import java.util.Date;
import java.util.EventObject;
import java.util.HashMap;
import java.util.Map;
import java.util.UUID;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.metadata.IDataEntityType;
import kd.bos.dataentity.metadata.dynamicobject.DynamicObjectType;
import kd.bos.dc.api.model.Account;
import kd.bos.dc.utils.AccountUtils;
import kd.bos.entity.AppInfo;
import kd.bos.entity.AppMetadataCache;
import kd.bos.entity.MainEntityType;
import kd.bos.entity.param.AppParam;
import kd.bos.form.IFormView;
import kd.bos.form.MessageTypes;
import kd.bos.form.control.Button;
import kd.bos.form.control.Control;
import kd.bos.form.control.events.ClickListener;
import kd.bos.form.plugin.AbstractFormPlugin;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.qing.plugin.i18n.Messages;
import kd.bos.qing.plugin.util.StringUtils;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.MetadataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import kd.bos.servicehelper.parameter.SystemParamServiceHelper;
import kd.bos.url.UrlService;
import kd.bos.util.AESUtils;
import kd.bos.util.HttpClientUtils;
import kd.bos.util.PasswordEncryptUtil;

public class QingDataMiddleOfficeParamPlugin
extends AbstractFormPlugin {
    private static Log logger = LogFactory.getLog(QingDataMiddleOfficeParamPlugin.class);
    private static final String PARAM_KEY = "dmoserver";
    private static final String DMO_APP_ID = "dmo";

    public void registerListener(EventObject e) {
        IFormView view = this.getView();
        Button btn = (Button)view.getControl("buttonap");
        btn.addClickListener((ClickListener)this);
    }

    public void click(EventObject evt) {
        Control control = (Control)evt.getSource();
        String key = control.getKey();
        if ("buttonap".equals(key)) {
            IFormView view = this.getView();
            AppInfo appInfo = AppMetadataCache.getAppInfo((String)DMO_APP_ID);
            AppParam apm = new AppParam();
            apm.setAppId(appInfo.getId());
            apm.setOrgId(Long.valueOf(RequestContext.get().getOrgId()));
            String dmoUrl = (String)SystemParamServiceHelper.loadAppParameterFromCache((AppParam)apm, (String)PARAM_KEY);
            if (StringUtils.isEmpty((CharSequence)dmoUrl)) {
                String errorTips = Messages.getMLS((String)"pleaseClickSave", (String)"\u521d\u59cb\u5316\u5931\u8d25\uff0c\u8bf7\u5148\u914d\u7f6e\u5730\u5740\u5e76\u70b9\u51fb\u4fdd\u5b58\u540e\u518d\u505a\u521d\u59cb\u5316\u3002", (Messages.ProjectName)Messages.ProjectName.BOS_QING_PLUGIN);
                view.showMessage(errorTips, MessageTypes.Default, null);
                return;
            }
            QFilter dmoFilter = new QFilter("number", "=", (Object)DMO_APP_ID);
            DynamicObject dmoObject = QueryServiceHelper.queryOne((String)"open_3rdapps", (String)"id", (QFilter[])new QFilter[]{dmoFilter});
            MainEntityType dmoEntity = MetadataServiceHelper.getDataEntityType((String)"open_3rdapps");
            String publicKey = null;
            try {
                publicKey = AESUtils.getBase64EncodeKey();
            }
            catch (Exception e) {
                String errorTips = Messages.getMLS((String)"createSecretError", (String)"\u521d\u59cb\u5316\u5931\u8d25\uff0c\u521b\u5efa\u5bf9\u79f0\u52a0\u5bc6\u79d8\u94a5\u51fa\u9519:", (Messages.ProjectName)Messages.ProjectName.BOS_QING_PLUGIN);
                logger.error((Throwable)e);
                view.showMessage(errorTips + e, MessageTypes.Default, null);
                return;
            }
            String syspwd = UUID.randomUUID().toString();
            String encryptedSysPassword = PasswordEncryptUtil.getEncryptePasswordWithSalt((String)syspwd);
            if (dmoObject == null) {
                dmoObject = new DynamicObject((DynamicObjectType)dmoEntity);
                dmoObject.set("number", (Object)DMO_APP_ID);
                dmoObject.set("name", (Object)Messages.getMLS((String)DMO_APP_ID, (String)"\u82cd\u7a79\u6570\u636e\u5f00\u53d1\u5e73\u53f0", (Messages.ProjectName)Messages.ProjectName.BOS_QING_PLUGIN));
                dmoObject.set("createtime", (Object)new Date());
                dmoObject.set("modifytime", (Object)new Date());
                dmoObject.set("status", (Object)"A");
                dmoObject.set("enable", (Object)"1");
                dmoObject.set("creator", (Object)Long.toString(RequestContext.get().getCurrUserId()));
                dmoObject.set("syspwd", (Object)encryptedSysPassword);
                dmoObject.set("publickey", (Object)publicKey);
            } else {
                dmoObject = BusinessDataServiceHelper.loadSingle((Object)dmoObject.getString("id"), (DynamicObjectType)dmoEntity);
                dmoObject.set("syspwd", (Object)encryptedSysPassword);
                dmoObject.set("publickey", (Object)publicKey);
                dmoObject.set("modifytime", (Object)new Date());
            }
            SaveServiceHelper.save((IDataEntityType)dmoEntity, (Object[])new DynamicObject[]{dmoObject});
            dmoUrl = this.joinUrl(dmoUrl, "api/uac/current/dict/upsert");
            HashMap<String, String> header = new HashMap<String, String>();
            header.put("Content-Type", "application/json;charset=UTF-8");
            RequestContext requestContext = RequestContext.get();
            Account account = AccountUtils.getCorrectAccount((String)requestContext.getAccountId(), (String)requestContext.getTenantId());
            String tenantId = account.getTenantId();
            String accountId = account.getAccountId();
            JSONObject dictValue = new JSONObject();
            dictValue.put("tenantId", (Object)tenantId);
            dictValue.put("accountId", (Object)accountId);
            dictValue.put("basicUrl", (Object)UrlService.getDomainContextUrl());
            dictValue.put("appId", (Object)DMO_APP_ID);
            dictValue.put("appSecret", (Object)syspwd);
            dictValue.put("secretKey", (Object)publicKey);
            JSONObject data = new JSONObject();
            data.put("dictValue", (Object)dictValue.toString());
            data.put("dictKey", (Object)accountId);
            data.put("dictType", (Object)"SSO");
            try {
                String resultJson = HttpClientUtils.postjson((String)dmoUrl, header, (String)data.toString());
                Map resultMap = (Map)JSONObject.parseObject((String)resultJson, Map.class);
                if (resultMap == null) {
                    logger.error("Init failed, resultJson:%s, dmoUrl:s%, data:s% ", new Object[]{resultJson, dmoUrl, data});
                    view.showMessage(Messages.getMLS((String)"initFail", (String)"\u521d\u59cb\u5316\u5931\u8d25", (Messages.ProjectName)Messages.ProjectName.BOS_QING_PLUGIN), MessageTypes.Default, null);
                    return;
                }
                if ("0".equals(resultMap.get("code"))) {
                    view.showMessage(Messages.getMLS((String)"initSuccess", (String)"\u521d\u59cb\u5316\u6210\u529f", (Messages.ProjectName)Messages.ProjectName.BOS_QING_PLUGIN), MessageTypes.Default, null);
                } else {
                    logger.error((String)resultMap.get("message"));
                    String errorTips = Messages.getMLS((String)"initFail", (String)"\u521d\u59cb\u5316\u5931\u8d25", (Messages.ProjectName)Messages.ProjectName.BOS_QING_PLUGIN);
                    view.showMessage(errorTips + ":" + (String)resultMap.get("message"), MessageTypes.Default, null);
                }
            }
            catch (IOException e) {
                String errorTips = Messages.getMLS((String)"dmoInterfaceError", (String)"\u521d\u59cb\u5316\u5931\u8d25\uff0c\u8c03\u7528\u6570\u636e\u5f00\u53d1\u5e73\u53f0\u63a5\u53e3\u51fa\u9519\uff1a", (Messages.ProjectName)Messages.ProjectName.BOS_QING_PLUGIN);
                logger.error((Throwable)e);
                view.showMessage(errorTips + e, MessageTypes.Default, null);
            }
        }
    }

    private String joinUrl(String url, String path) {
        if (url == null) {
            return null;
        }
        if (url.endsWith("/")) {
            return url + path;
        }
        return url + "/" + path;
    }
}

