/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.qing.plugin;

import java.io.UnsupportedEncodingException;
import java.util.EventObject;
import java.util.HashMap;
import kd.bos.context.RequestContext;
import kd.bos.entity.AppInfo;
import kd.bos.entity.AppMetadataCache;
import kd.bos.entity.param.AppParam;
import kd.bos.form.IClientViewProxy;
import kd.bos.form.IFormView;
import kd.bos.form.MessageTypes;
import kd.bos.form.events.LoadCustomControlMetasArgs;
import kd.bos.form.plugin.AbstractFormPlugin;
import kd.bos.qing.plugin.i18n.Messages;
import kd.bos.qing.plugin.util.StringUtils;
import kd.bos.servicehelper.parameter.SystemParamServiceHelper;
import kd.bos.session.EncreptSessionUtils;

public class QingDataMiddleOfficePlugin
extends AbstractFormPlugin {
    private static final String PARAM_KEY = "dmoserver";

    public void afterBindData(EventObject e) {
        String dmoUrlWithTicket;
        IFormView view = this.getView();
        AppInfo appInfo = AppMetadataCache.getAppInfo((String)view.getFormShowParameter().getFormConfig().getAppId());
        AppParam apm = new AppParam();
        apm.setAppId(appInfo.getId());
        apm.setOrgId(Long.valueOf(RequestContext.get().getOrgId()));
        String dmoUrl = (String)SystemParamServiceHelper.loadAppParameterFromCache((AppParam)apm, (String)PARAM_KEY);
        String redirectUrl = (String)view.getFormShowParameter().getCustomParam("redirectUrl");
        if (StringUtils.isNotEmpty((CharSequence)dmoUrl)) {
            dmoUrlWithTicket = dmoUrl = this.joinUrl(dmoUrl, "ent/index.html");
            if (null != redirectUrl) {
                dmoUrlWithTicket = redirectUrl;
            }
            try {
                dmoUrlWithTicket = EncreptSessionUtils.generateTicketUrl((String)dmoUrl);
            }
            catch (UnsupportedEncodingException e1) {
                String tips = Messages.getMLS((String)"failedToGetTicket", (String)"\u83b7\u53d6Ticket\u5931\u8d25:", (Messages.ProjectName)Messages.ProjectName.BOS_QING_PLUGIN);
                view.showMessage(tips + e1, MessageTypes.Default, null);
            }
        } else {
            String tips = Messages.getMLS((String)"dmoUrlNotFound", (String)"\u8bf7\u8054\u7cfb\u7ba1\u7406\u5458\u914d\u7f6e\u6570\u636e\u5f00\u53d1\u5e73\u53f0\u670d\u52a1\u5668\u5730\u5740:", (Messages.ProjectName)Messages.ProjectName.BOS_QING_PLUGIN);
            view.showMessage(tips, MessageTypes.Default, null);
            return;
        }
        IClientViewProxy proxy = (IClientViewProxy)this.getView().getService(IClientViewProxy.class);
        HashMap<String, String> map = new HashMap<String, String>();
        map.put("url", dmoUrlWithTicket);
        map.put("openStyle", "0");
        proxy.addAction("openUrl", map);
        super.afterBindData(e);
    }

    public void loadCustomControlMetas(LoadCustomControlMetasArgs e) {
        HashMap<String, Object> mapEntry = new HashMap<String, Object>();
        mapEntry.put("id", "data_mid_office_index");
        mapEntry.put("noLoading", true);
        e.getItems().add(mapEntry);
        super.loadCustomControlMetas(e);
    }

    private String joinUrl(String url, String path) {
        if (url == null) {
            return null;
        }
        if (url.endsWith("/")) {
            return url + path;
        }
        return url + "/" + path;
    }
}

