/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.qing.plugin;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import java.util.EventObject;
import java.util.HashMap;
import java.util.Map;
import kd.bos.context.RequestContext;
import kd.bos.form.IClientViewProxy;
import kd.bos.form.control.Control;
import kd.bos.form.control.EntryGrid;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.qing.plugin.AbstractQingSharedPlugin;
import kd.bos.qing.plugin.i18n.Messages;
import kd.bos.qing.plugin.util.StringUtils;
import kd.bos.util.HttpClientUtils;
import kd.bos.yzj.config.YzjConfigServiceHelper;
import kd.bos.yzj.config.YzjTokenHelper;
import kd.bos.yzj.model.YzjConfig;

public class QingYZJSubscribeConfigPlugin
extends AbstractQingSharedPlugin {
    private static final String ENTRY_ENTITY = "entryentity";
    private static final String BOS_PORTAL_PLUGIN = "bos-qing-plugin";
    private static final String PUB_NAME = "pubname";
    private static final String PUB_ID = "pubid";
    private static final String YZJ_SHARE_FINDSSBMSGPUB = "/imsdk/pub/findSsbMsgPub.do?";
    public static final String BTN_OK = "btn_ok";
    public static final String BTN_CANCEL = "btn_cancel";
    private static final Log log = LogFactory.getLog(QingYZJSubscribeConfigPlugin.class);

    public void registerListener(EventObject e) {
        super.registerListener(e);
        this.addClickListeners(new String[]{BTN_OK, BTN_CANCEL});
    }

    public void click(EventObject e) {
        super.click(e);
        Control ctrl = (Control)e.getSource();
        String ctrlKey = ctrl.getKey();
        if (ctrlKey.equals(BTN_OK)) {
            EntryGrid eg = (EntryGrid)this.getControl(ENTRY_ENTITY);
            int[] selRows = eg.getSelectRows();
            if (selRows == null || selRows.length == 0) {
                this.getView().showTipNotification(Messages.getMLS((String)"CloudHubSubscribeConfigPlugin_0", (String)"\u8bf7\u81f3\u5c11\u9009\u62e9\u4e00\u4e2a\u8ba2\u9605\u53f7:", (Messages.ProjectName)Messages.ProjectName.BOS_QING_PLUGIN));
                return;
            }
            for (int idx : selRows) {
                String pubId = (String)this.getModel().getValue(PUB_ID, idx);
                String pubName = (String)this.getModel().getValue(PUB_NAME, idx);
                HashMap<String, String> returnMap = new HashMap<String, String>();
                returnMap.put("pubId", pubId);
                returnMap.put("pubName", pubName);
                String cardTitleMapEntryStr = "[zh_CN=" + pubName + "]";
                returnMap.put("cardtitle", cardTitleMapEntryStr);
                this.getView().returnDataToParent(returnMap);
                this.getView().close();
            }
        } else if (ctrlKey.equals(BTN_CANCEL)) {
            this.getView().close();
        }
    }

    public void afterCreateNewData(EventObject e) {
        super.afterCreateNewData(e);
        RequestContext requestContext = RequestContext.get();
        if (StringUtils.isEmpty((CharSequence)requestContext.getUserOpenId())) {
            String errorInfo = Messages.getMLS((String)"CloudHubSubscribeConfigPlugin_1", (String)"\u5f53\u524d\u7528\u6237\u7684\u4e91\u4e4b\u5bb6openId\u4e3a\u7a7a\uff01", (Messages.ProjectName)Messages.ProjectName.BOS_QING_PLUGIN);
            this.getView().showErrorNotification(errorInfo);
            log.error(errorInfo);
            return;
        }
        String publicAcctListStr = null;
        JSONArray jsonArr = null;
        try {
            publicAcctListStr = this.getUserSubscribePubAcctList();
            jsonArr = JSON.parseArray((String)publicAcctListStr);
        }
        catch (Exception ee) {
            log.error("\u83b7\u53d6\u8ba2\u9605\u53f7\u4fe1\u606f\u51fa\u9519\uff01", (Throwable)ee);
            return;
        }
        if (jsonArr == null || jsonArr.isEmpty()) {
            return;
        }
        int arrSize = jsonArr.size();
        this.getModel().batchCreateNewEntryRow(ENTRY_ENTITY, arrSize);
        IClientViewProxy cvProxy = (IClientViewProxy)this.getView().getService(IClientViewProxy.class);
        for (int i = 0; i < arrSize; ++i) {
            Object arrObj = jsonArr.get(i);
            JSONObject jsonObj = (JSONObject)arrObj;
            String photourl = jsonObj.getString("photourl");
            String pubname = jsonObj.getString(PUB_NAME);
            String pubid = jsonObj.getString(PUB_ID);
            this.getModel().setValue(PUB_ID, (Object)pubid, i);
            this.getModel().setValue(PUB_NAME, (Object)pubname, i);
            HashMap<String, String> propertiesMap = new HashMap<String, String>();
            HashMap<String, HashMap<String, String>> pmap = new HashMap<String, HashMap<String, String>>();
            propertiesMap.put("src", photourl);
            pmap.put("photourl", propertiesMap);
            cvProxy.invokeControlMethod(ENTRY_ENTITY, "setCustomProperties", new Object[]{i, pmap});
        }
    }

    private String getUserSubscribePubAcctList() {
        YzjConfig config = YzjConfigServiceHelper.getConfig();
        if (!config.isEnable()) {
            this.getView().showErrorNotification(Messages.getMLS((String)"CloudHubSubscribeConfigPlugin_2", (String)"\u4e91\u4e4b\u5bb6\u672a\u542f\u7528\uff01", (Messages.ProjectName)Messages.ProjectName.BOS_QING_PLUGIN));
            this.getView().setEnable(Boolean.valueOf(false), new String[]{BTN_OK});
            return null;
        }
        String yzjHost = config.getUrl();
        Map<String, String> header = this.getHttpRequestHeaderForm();
        try {
            String yzjTicket = YzjTokenHelper.getToken((YzjConfig)config, (String)"ticket");
            String sHttpResponse = HttpClientUtils.post((String)(yzjHost + YZJ_SHARE_FINDSSBMSGPUB + "ticket=" + yzjTicket), header, null);
            return sHttpResponse;
        }
        catch (Exception e) {
            log.error((Throwable)e);
            return null;
        }
    }

    private Map<String, String> getHttpRequestHeaderForm() {
        HashMap<String, String> header = new HashMap<String, String>();
        header.put("Content-type", "application/x-www-form-urlencoded;charset=UTF-8");
        return header;
    }
}

