/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.qing.plugin.devctrl;

import com.alibaba.fastjson.JSONObject;
import java.util.Date;
import java.util.EventObject;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import kd.bos.context.RequestContext;
import kd.bos.db.DB;
import kd.bos.db.DBRoute;
import kd.bos.db.SqlParameter;
import kd.bos.db.tx.TX;
import kd.bos.entity.IFrameMessage;
import kd.bos.form.IFormView;
import kd.bos.form.control.IFrame;
import kd.bos.form.events.CustomEventArgs;
import kd.bos.form.plugin.AbstractFormPlugin;
import kd.bos.qing.plugin.QingUtil;
import kd.bos.qing.plugin.actionhandler.QingActionDispatcher;
import kd.bos.qing.plugin.util.StringUtils;

public class QingCardCtrlApSquareDesigner
extends AbstractFormPlugin {
    private static final String UPDATE_REF = "UPDATE T_QING_CARDCTRL_REF SET FMODIFIERID=?, FMODIFYTIME=? WHERE FID=?";

    public void beforeBindData(EventObject e) {
        IFormView view = this.getView();
        String pageId = view.getPageId();
        String url = QingUtil.getQingURL((String)"/qing/editCardCtrlAPEntrance.do");
        url = QingUtil.appendParamToUrl((String)url, (String)"pageId", (String)pageId);
        url = QingUtil.appendParamToUrl((String)url, (String)"cardScene", (String)"devctrlAp");
        Map viewCustomParams = this.getView().getFormShowParameter().getCustomParams();
        String ctrlId = (String)viewCustomParams.get("itemId");
        List contexts = (List)viewCustomParams.get("context");
        String devFormId = (String)((Map)contexts.get(0)).get("Id");
        url = QingUtil.appendParamToUrl((String)url, (String)"ctrlId", (String)ctrlId);
        url = QingUtil.appendParamToUrl((String)url, (String)"formId", (String)devFormId);
        url = QingUtil.appendParamToUrl((String)url, (String)"schemaAdditionalTag", (String)this.getSchemaAddtionalTag(devFormId, ctrlId));
        IFrame iframe = (IFrame)view.getControl("iframeap");
        QingUtil.setQingIframeSrc((IFormView)view, (IFrame)iframe, (String)url);
    }

    public void customEvent(CustomEventArgs e) {
        if ("setCustomSchema".equals(e.getEventName())) {
            HashMap<String, Object> result = new HashMap<String, Object>();
            result.put("value", System.currentTimeMillis());
            this.returnData(result);
            JSONObject jsonObject = this.getEvtParams(e);
            if (jsonObject != null) {
                this.updateModifyInfo(jsonObject);
            }
            this.getView().close();
        } else if ("resetCustomSchema".equals(e.getEventName())) {
            HashMap<String, Object> result = new HashMap<String, Object>();
            result.put("value", "false");
            this.returnData(result);
            this.getView().close();
        } else if ("openTab".equals(e.getEventName()) || "linkageJump".equals(e.getEventName())) {
            this.sendMsg(e.getEventName());
        } else {
            QingActionDispatcher.dispatch((CustomEventArgs)e, (IFormView)this.getView());
        }
    }

    private void returnData(Map<String, Object> result) {
        result.put("itemId", this.getView().getFormShowParameter().getCustomParams().get("itemId"));
        result.put("metaType", this.getView().getFormShowParameter().getCustomParams().get("metaType"));
        result.put("propertyName", this.getView().getFormShowParameter().getCustomParams().get("propertyName"));
        this.getView().returnDataToParent(result);
    }

    private String getSchemaAddtionalTag(String formId, String ctrlId) {
        StringBuilder sb = new StringBuilder();
        sb.append('_');
        sb.append("cardctrl");
        sb.append('_');
        sb.append(formId);
        sb.append('_');
        sb.append(ctrlId);
        return sb.toString();
    }

    private void sendMsg(String evtName) {
        IFrame iframe = (IFrame)this.getControl("iframeap");
        IFrameMessage message = new IFrameMessage();
        message.setType("qingCardCtrl");
        HashMap<String, String> rs = new HashMap<String, String>();
        rs.put("pageId", this.getView().getPageId());
        rs.put("evtName", evtName);
        message.setContent(rs);
        iframe.postMessage(message);
    }

    private void updateModifyInfo(JSONObject jsonObject) {
        String refId = jsonObject.getString("ctrlRefId");
        if (StringUtils.isEmpty((CharSequence)refId)) {
            return;
        }
        try {
            TX.begin();
            this.updateRef(refId);
        }
        finally {
            TX.end();
        }
    }

    private void updateRef(String refId) {
        DB.execute((DBRoute)DBRoute.qing, (String)UPDATE_REF, (Object[])this.toParameterObjects(new Object[]{RequestContext.get().getUserId(), new Date(), refId}));
    }

    private Object[] toParameterObjects(Object[] params) {
        Object[] wraps = null;
        if (params != null) {
            wraps = new Object[params.length];
            int n = params.length;
            for (int i = 0; i < n; ++i) {
                wraps[i] = params[i] instanceof SqlParameter ? params[i] : new SqlParameter(params[i]);
            }
        }
        return wraps;
    }

    private JSONObject getEvtParams(CustomEventArgs e) {
        String eventArgs = e.getEventArgs();
        return JSONObject.parseObject((String)eventArgs);
    }
}

