/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.qing.plugin.devctrl;

import com.alibaba.fastjson.JSONObject;
import java.util.Base64;
import java.util.EventObject;
import java.util.HashMap;
import java.util.Map;
import kd.bos.entity.IFrameMessage;
import kd.bos.form.FormShowParameter;
import kd.bos.form.IFormView;
import kd.bos.form.ShowType;
import kd.bos.form.control.IFrame;
import kd.bos.form.events.CustomEventArgs;
import kd.bos.form.plugin.AbstractFormPlugin;
import kd.bos.qing.plugin.QingUtil;
import kd.bos.qing.plugin.actionhandler.QingActionDispatcher;
import kd.bos.qing.plugin.i18n.Messages;
import kd.bos.qing.plugin.util.StringUtils;

public class QingCardCtrlExhibitionPlugin
extends AbstractFormPlugin {
    private static final String CARD_SCENE = "devctrl";
    private static final String QING_APP_ID = "qing";
    private static final String PUBLISH_ID = "publishId";
    private static final String ADDITIONAL_TAG = "schemaAdditionalTag";
    private static final String BIZTAG = "bizTag";
    private static final String CARDNAME = "cardName";
    private static final String HAS_MAIN_VIEW = "hasMainView";
    private static final String CTRL_REF_ID = "ctrlRefId";
    private static final String HAS_CUSTOM_SCHEMA = "hasCustomSchema";
    private static final String CTRL_NAME = "ctrlName";

    public void beforeBindData(EventObject e) {
        IFormView view = this.getView();
        String pageId = view.getPageId();
        String url = QingUtil.getQingURL((String)"/qing/devctrlCardEntrance.do");
        url = QingUtil.appendParamToUrl((String)url, (String)"pageId", (String)pageId);
        url = QingUtil.appendParamToUrl((String)url, (String)"cardScene", (String)CARD_SCENE);
        FormShowParameter parameter = view.getFormShowParameter();
        Map map = parameter.getCustomParams();
        if (map != null) {
            Object ctrlName;
            Object customSchemaExist;
            Object refId = map.get(CTRL_REF_ID);
            if (refId != null) {
                url = QingUtil.appendParamToUrl((String)url, (String)CTRL_REF_ID, (String)refId.toString());
            }
            if ((customSchemaExist = map.get(HAS_CUSTOM_SCHEMA)) != null) {
                url = QingUtil.appendParamToUrl((String)url, (String)HAS_CUSTOM_SCHEMA, (String)customSchemaExist.toString());
            }
            if ((ctrlName = map.get(CTRL_NAME)) != null) {
                url = QingUtil.appendParamToUrl((String)url, (String)CTRL_NAME, (String)ctrlName.toString());
            }
            url = QingUtil.appendParamToUrl((String)url, (String)"mobileCtrl", (String)map.get("mobileCtrl").toString());
            url = QingUtil.appendParamToUrl((String)url, (String)HAS_MAIN_VIEW, (String)String.valueOf(this.getView().getMainView() != null));
            IFrame iframe = (IFrame)view.getControl("iframeap");
            QingUtil.setQingIframeSrc((IFormView)view, (IFrame)iframe, (String)url);
        }
    }

    public void customEvent(CustomEventArgs e) {
        String eventName = e.getEventName();
        if ("openSquare".equals(eventName)) {
            JSONObject jsonObject = this.getEvtParams(e);
            if (jsonObject != null) {
                Object hasMainView = jsonObject.get((Object)HAS_MAIN_VIEW);
                if (hasMainView != null && Boolean.parseBoolean(hasMainView.toString())) {
                    this.openDesignerInNewTab(jsonObject);
                } else {
                    this.openModalDesigner(jsonObject);
                }
            }
        } else if ("openAnalysis".equals(eventName)) {
            JSONObject jsonObject = this.getEvtParams(e);
            if (jsonObject != null) {
                this.openAnalysisInTab(jsonObject);
            }
        } else if ("refreshCard".equals(eventName)) {
            JSONObject jsonObject = this.getEvtParams(e);
            if (jsonObject != null) {
                if (!Boolean.parseBoolean(jsonObject.getString(HAS_MAIN_VIEW))) {
                    String designerPageId = jsonObject.getString("designerPageId");
                    IFormView designerView = this.getView().getView(designerPageId);
                    if (designerView != null) {
                        designerView.close();
                        this.getView().sendFormAction(designerView);
                    }
                }
                this.refreshForm();
            }
        } else if ("openFullScreenForm".equals(eventName)) {
            JSONObject jsonObject = this.getEvtParams(e);
            this.openFullScreenForm(jsonObject);
        } else {
            QingActionDispatcher.dispatch((CustomEventArgs)e, (IFormView)this.getView());
        }
    }

    private JSONObject getEvtParams(CustomEventArgs e) {
        String eventArgs = e.getEventArgs();
        return JSONObject.parseObject((String)eventArgs);
    }

    private void refreshForm() {
        IFrame iframe = (IFrame)this.getControl("iframeap");
        IFrameMessage message = new IFrameMessage();
        message.setType("qingCardCtrl");
        HashMap<String, String> rs = new HashMap<String, String>();
        rs.put("pageId", this.getView().getPageId());
        rs.put("refreshCard", "true");
        message.setContent(rs);
        iframe.postMessage(message);
    }

    private void openModalDesigner(JSONObject jsonObject) {
        FormShowParameter showParameter = new FormShowParameter();
        showParameter.setFormId("qing_cardctrl_editsquare");
        showParameter.getOpenStyle().setShowType(ShowType.Modal);
        HashMap customParams = showParameter.getCustomParams();
        if (customParams == null) {
            customParams = new HashMap();
            showParameter.setCustomParams(customParams);
        }
        showParameter.setCustomParam("cardCtrlPageId", (Object)this.getView().getPageId());
        showParameter.setCustomParam(PUBLISH_ID, (Object)jsonObject.getString(PUBLISH_ID));
        showParameter.setCustomParam(ADDITIONAL_TAG, (Object)jsonObject.getString(ADDITIONAL_TAG));
        showParameter.setCustomParam(BIZTAG, (Object)jsonObject.getString(BIZTAG));
        showParameter.setCustomParam(CARDNAME, (Object)jsonObject.getString(CARDNAME));
        showParameter.setCustomParam("tag", (Object)jsonObject.getString("tag"));
        showParameter.setCustomParam(HAS_MAIN_VIEW, (Object)"false");
        this.getView().showForm(showParameter);
    }

    private void openDesignerInNewTab(JSONObject jsonObject) {
        String url = QingUtil.getQingURL((String)"/qing/editSquareCardEntrance.do");
        url = QingUtil.appendParamToUrl((String)url, (String)PUBLISH_ID, (String)jsonObject.getString(PUBLISH_ID));
        url = QingUtil.appendParamToUrl((String)url, (String)"cardScene", (String)CARD_SCENE);
        url = QingUtil.appendParamToUrl((String)url, (String)BIZTAG, (String)jsonObject.getString(BIZTAG));
        url = QingUtil.appendParamToUrl((String)url, (String)ADDITIONAL_TAG, (String)jsonObject.getString(ADDITIONAL_TAG));
        url = QingUtil.appendParamToUrl((String)url, (String)HAS_MAIN_VIEW, (String)"true");
        Base64.Encoder encoder = Base64.getEncoder();
        String markId = new String(encoder.encode(url.getBytes()));
        url = QingUtil.appendParamToUrl((String)url, (String)"cardCtrlPageId", (String)this.getView().getPageId());
        url = QingUtil.appendParamToUrl((String)url, (String)"tag", (String)jsonObject.getString("tag"));
        String titlePrefix = Messages.getMLS((String)"QingCardPlugin_1", (String)"\u6570\u636e\u6597\u65b9-", (Messages.ProjectName)Messages.ProjectName.BOS_QING_PLUGIN_SHARED);
        String name = StringUtils.isEmpty((CharSequence)jsonObject.getString(CARDNAME)) ? " " : jsonObject.getString(CARDNAME);
        String title = titlePrefix + name;
        QingUtil.openQingIFramePageInTabWithMarkId((String)QING_APP_ID, (String)url, (String)title, (IFormView)this.getView(), (String)markId);
    }

    private void openFullScreenForm(JSONObject jsonObject) {
        FormShowParameter showParameter = new FormShowParameter();
        showParameter.setFormId("qing_cardctrl_fullscr_m");
        showParameter.getOpenStyle().setShowType(ShowType.Modal);
        showParameter.setShowClose(false);
        showParameter.setShowTitle(false);
        showParameter.setCustomParam(CTRL_REF_ID, (Object)jsonObject.getString(CTRL_REF_ID));
        showParameter.setCustomParam(CTRL_NAME, (Object)jsonObject.getString(CTRL_NAME));
        showParameter.setCustomParam(HAS_CUSTOM_SCHEMA, (Object)jsonObject.getString(HAS_CUSTOM_SCHEMA));
        this.getView().showForm(showParameter);
    }

    private void openAnalysisInTab(JSONObject jsonObject) {
        String url = QingUtil.getQingURL((String)"/qing/editAnalysisCardEntrance.do");
        url = QingUtil.appendParamToUrl((String)url, (String)PUBLISH_ID, (String)jsonObject.getString(PUBLISH_ID));
        url = QingUtil.appendParamToUrl((String)url, (String)"cardScene", (String)CARD_SCENE);
        url = QingUtil.appendParamToUrl((String)url, (String)BIZTAG, (String)jsonObject.getString(BIZTAG));
        url = QingUtil.appendParamToUrl((String)url, (String)ADDITIONAL_TAG, (String)jsonObject.getString(ADDITIONAL_TAG));
        Base64.Encoder encoder = Base64.getEncoder();
        String markId = new String(encoder.encode(url.getBytes()));
        String name = StringUtils.isEmpty((CharSequence)jsonObject.getString(CARDNAME)) ? " " : jsonObject.getString(CARDNAME);
        String titlePrefix = Messages.getMLS((String)"QingCardPlugin_0", (String)"\u6570\u636e\u5206\u6790-", (Messages.ProjectName)Messages.ProjectName.BOS_QING_PLUGIN_SHARED);
        String title = titlePrefix + name;
        QingUtil.openQingIFramePageInTabWithMarkId((String)QING_APP_ID, (String)url, (String)title, (IFormView)this.getView(), (String)markId);
    }
}

