/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.qing.plugin.devctrl;

import java.util.Date;
import java.util.EventObject;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import kd.bos.context.RequestContext;
import kd.bos.db.DB;
import kd.bos.db.DBRoute;
import kd.bos.db.SqlParameter;
import kd.bos.db.tx.TX;
import kd.bos.db.tx.TXHandle;
import kd.bos.form.control.Control;
import kd.bos.form.control.IFrame;
import kd.bos.qing.plugin.AbstractQingCardSelectPlugin;

public class QingCardSourceSelectPlugin
extends AbstractQingCardSelectPlugin {
    public static final String CTRL_BTN_CANCEL = "btn_cancel";
    public static final String CTRL_BTN_OK = "btn_ok";
    private static final String CTRL_IFRAME = "iframeap";
    private static final String DELETE_REF_SQL = "DELETE FROM T_QING_CARDCTRL_REF WHERE FFORMID=? AND FCTRLID=?";
    private static final String INSERT_REF_SQL = "INSERT INTO T_QING_CARDCTRL_REF (FID, FFORMID, FCTRLID, FREFTOID, FREFTYPE, FCREATORID, FCREATETIME, FMODIFIERID, FMODIFYTIME) VALUES (?,?,?,?,?,?,?,?,?)";

    public void registerListener(EventObject e) {
        this.addClickListeners(new String[]{CTRL_BTN_OK, CTRL_BTN_CANCEL});
    }

    @Override
    protected IFrame getCardSelectIframeCtrl() {
        return (IFrame)this.getView().getControl(CTRL_IFRAME);
    }

    public void click(EventObject e) {
        Control ctrl = (Control)e.getSource();
        String ctrlKey = ctrl.getKey();
        if (CTRL_BTN_OK.equals(ctrlKey)) {
            String publishId;
            String refId;
            Map<String, String> cardConfig;
            HashMap result = new HashMap();
            result.put("itemId", this.getView().getFormShowParameter().getCustomParams().get("itemId"));
            result.put("metaType", this.getView().getFormShowParameter().getCustomParams().get("metaType"));
            result.put("propertyName", this.getView().getFormShowParameter().getCustomParams().get("propertyName"));
            List<Map<String, String>> cardConfigList = this.getCardConfigList();
            Map<String, String> map = cardConfig = !cardConfigList.isEmpty() ? cardConfigList.get(0) : null;
            if (cardConfig != null && (refId = this.getRefId(publishId = cardConfig.get("QingCardId"))) != null) {
                result.put("value", refId);
                this.getView().returnDataToParent(result);
            }
            this.getView().close();
        } else if (CTRL_BTN_CANCEL.equals(ctrlKey)) {
            this.getView().close();
        }
    }

    @Override
    protected boolean isSingleSelect() {
        return true;
    }

    @Override
    protected boolean isSupportDsbCard() {
        return false;
    }

    private String getRefId(String publishId) {
        return this.saveRef(publishId);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private String saveRef(String refToId) {
        Map viewCustomParams = this.getView().getFormShowParameter().getCustomParams();
        String ctrlId = (String)viewCustomParams.get("itemId");
        List contexts = (List)viewCustomParams.get("context");
        String devFormId = (String)((Map)contexts.get(0)).get("Id");
        try (TXHandle txHandle = null;){
            txHandle = TX.required();
            this.deleteOldRef(devFormId, ctrlId);
            String string = this.insertRef(devFormId, ctrlId, refToId);
            return string;
        }
    }

    private void deleteOldRef(String formId, String ctrlId) {
        DB.execute((DBRoute)DBRoute.qing, (String)DELETE_REF_SQL, (Object[])this.toParameterObjects(new Object[]{formId, ctrlId}));
    }

    private String insertRef(String formId, String ctrlId, String refToId) {
        Object[] params = new Object[9];
        String refId = UUID.randomUUID().toString();
        String userId = Long.toString(RequestContext.get().getCurrUserId());
        int i = 0;
        params[i++] = refId;
        params[i++] = formId;
        params[i++] = ctrlId;
        params[i++] = refToId;
        params[i++] = 0;
        params[i++] = userId;
        params[i++] = new Date();
        params[i++] = userId;
        params[i++] = new Date();
        DB.execute((DBRoute)DBRoute.qing, (String)INSERT_REF_SQL, (Object[])this.toParameterObjects(params));
        return refId;
    }

    private Object[] toParameterObjects(Object[] params) {
        Object[] wraps = null;
        if (params != null) {
            wraps = new Object[params.length];
            int n = params.length;
            for (int i = 0; i < n; ++i) {
                wraps[i] = params[i] instanceof SqlParameter ? params[i] : new SqlParameter(params[i]);
            }
        }
        return wraps;
    }
}

