/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.qing.plugin;

import java.util.concurrent.TimeUnit;
import kd.bos.cache.CacheFactory;
import kd.bos.cache.DistributeSessionlessCache;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.qing.plugin.util.StringUtils;

public class ClientManager {
    private static final Log logger = LogFactory.getLog(ClientManager.class);
    private static final String CLUSTERNAME = "clusterName";
    private static final String PAGE_CLIENT_MAPPING_KEY = "Qing.Page.Client.Mapping.";
    private static final String DEFAULT_TIMEOUT_KEY = "qing.session.timeout";
    protected static final int DEFAULT_TIMEOUT = 300;
    private static final String CLIENT_KEY_PREFIX = "Qing.Client.";
    private static final String CLIENT_CLOSED_KEY = "ClientClosed";
    private static final String CLIENT_CLOSED_KEY_PAGE_RELEASE = "ClientClosed.PageRelease";
    private static final DistributeSessionlessCache cache = CacheFactory.getCommonCacheFactory().getDistributeSessionlessCache("qing");

    protected static int getDefaultTimeout() {
        String s = System.getProperty(DEFAULT_TIMEOUT_KEY);
        if (s != null) {
            try {
                return Integer.parseInt(s.trim());
            }
            catch (Exception t) {
                logger.error("qing.session.timeout is not legal integer: " + s);
            }
        }
        return 300;
    }

    private static String getCacheKey(String clientID) {
        return CLIENT_KEY_PREFIX + clientID;
    }

    public static void setClientProperty(String clientID, String key, String value) {
        cache.put(ClientManager.getCacheKey(clientID), key, value, ClientManager.getDefaultTimeout(), TimeUnit.SECONDS);
    }

    public static String getClientProperty(String clientID, String key) {
        return (String)cache.get(ClientManager.getCacheKey(clientID), key);
    }

    public static void removeClientProperty(String clientID, String key) {
        cache.remove(ClientManager.getCacheKey(clientID), key);
    }

    public static void setClientClosed(String clientID) {
        String key = ClientManager.getKey(ClientManager.getCacheKey(clientID));
        cache.put(key, CLIENT_CLOSED_KEY_PAGE_RELEASE, "TRUE", ClientManager.getDefaultTimeout(), TimeUnit.SECONDS);
    }

    public static String getKey(String key) {
        String clusterName = System.getProperty(CLUSTERNAME);
        if (clusterName == null) {
            return key;
        }
        return clusterName + "." + key;
    }

    public static String[] getSetValues(String key) {
        key = ClientManager.getKey(key);
        return cache.getSetValues(key);
    }

    public static void setClientsClosed(String pageId) {
        if (StringUtils.isBlank(pageId)) {
            return;
        }
        String setKey = PAGE_CLIENT_MAPPING_KEY + pageId;
        String[] clientIds = ClientManager.getSetValues(setKey);
        if (clientIds != null && clientIds.length > 0) {
            for (int i = 0; i < clientIds.length; ++i) {
                String clientId = clientIds[i];
                ClientManager.setClientClosed(clientId);
            }
            String key = ClientManager.getKey(setKey);
            cache.removeSetValues(key, clientIds);
        }
    }
}

