/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.qing.plugin;

import java.io.UnsupportedEncodingException;
import java.net.URLEncoder;
import java.util.Base64;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import kd.bos.bill.BillOperationStatus;
import kd.bos.bill.BillShowParameter;
import kd.bos.bill.OperationStatus;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.entity.AppInfo;
import kd.bos.entity.AppMetadataCache;
import kd.bos.exception.BosErrorCode;
import kd.bos.exception.KDException;
import kd.bos.form.FormShowParameter;
import kd.bos.form.IClientViewProxy;
import kd.bos.form.IFormView;
import kd.bos.form.OpenStyle;
import kd.bos.form.ShowType;
import kd.bos.form.control.IFrame;
import kd.bos.lang.Lang;
import kd.bos.list.LinkQueryPkIdCollection;
import kd.bos.list.ListShowParameter;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.mvc.SessionManager;
import kd.bos.portal.util.OpenPageUtils;
import kd.bos.qing.plugin.i18n.Messages;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.user.UserServiceHelper;
import kd.bos.session.SessionKeys;
import kd.bos.url.UrlService;

public class QingUtil {
    private static final Log logger = LogFactory.getLog(QingUtil.class);
    public static final String QING_CALLBACK_KEY = "qingCallbackKey";
    public static final String QING_REPORT_APPID = "qing_rpt";
    public static final String QING_ANALYSIS_IFRAME_PAGE = "qing_iframe_page";
    public static final String QING_REPORT_IFRAME_PAGE = "qing_rpt_iframe_page";
    public static final String FIRE_QING_LINKAGE_BY_METHOD_INVOKE = "fireQingLinkageByMethodInvoke";
    private static final Set<Locale> SUPPORTED = new HashSet<Locale>();

    public static String getQingTheme() {
        RequestContext requestContext = RequestContext.get();
        Long userID = requestContext.getCurrUserId();
        Map result = UserServiceHelper.getUserThemeNumAndVerNew((Long)userID);
        Map content = (Map)result.get("content");
        Map theme = (Map)content.get("theme");
        String themeColor = null;
        themeColor = theme == null || theme.get("@theme-color") == null ? "#5582F3" : (String)theme.get("@theme-color");
        return "ierp_" + themeColor.trim();
    }

    public static String getQingURL(String url) {
        String sParamPathPrefix = UrlService.getDomainContextUrl();
        if (sParamPathPrefix == null) {
            throw new KDException(BosErrorCode.zookeepConfiguration, new Object[]{Messages.getMLS("QingUtil_0", "zk\u672a\u914d\u7f6edomain.contextUrl", Messages.ProjectName.BOS_QING_PLUGIN_SHARED)});
        }
        if (sParamPathPrefix.endsWith("/")) {
            sParamPathPrefix = sParamPathPrefix.substring(0, sParamPathPrefix.lastIndexOf(47));
        }
        String sUrl = sParamPathPrefix + url;
        sUrl = QingUtil.appendParamToUrl(sUrl, "language", QingUtil.getLocale());
        sUrl = QingUtil.appendParamToUrl(sUrl, "skin", QingUtil.getQingTheme());
        sUrl = QingUtil.appendParamToUrl(sUrl, "path", sParamPathPrefix);
        sUrl = QingUtil.appendAccountParamToUrl(sUrl);
        return sUrl;
    }

    public static String appendAccountParamToUrl(String url) {
        try {
            RequestContext requestContext = RequestContext.get();
            if (SessionKeys.isAccountSession((String)requestContext.getTenantId())) {
                url = QingUtil.appendParamToUrl(url, "kdcdc", requestContext.getAccountId());
            }
        }
        catch (Throwable t) {
            logger.error(t);
        }
        return url;
    }

    public static String appendParamToUrl(String sUrl, String sParamKey, String sParamValue) {
        if (sParamValue != null && !"".equals(sParamValue.trim())) {
            sUrl = sUrl + (sUrl.indexOf("?") < 0 ? "?" : "&");
            sUrl = sUrl + sParamKey;
            sUrl = sUrl + "=";
            try {
                sParamValue = URLEncoder.encode(sParamValue, "utf-8");
                sParamValue = sParamValue.replace("+", "%20");
                sUrl = sUrl + sParamValue;
            }
            catch (UnsupportedEncodingException e) {
                throw new KDException((Throwable)e, BosErrorCode.systemError, new Object[0]);
            }
        }
        return sUrl;
    }

    private static String getLocale() {
        RequestContext context = RequestContext.get();
        Lang lang = context.getLang();
        Locale langLocale = lang.getLocale();
        if (SUPPORTED.contains(langLocale)) {
            return langLocale.toString();
        }
        if (Locale.US.equals(langLocale)) {
            return Locale.ENGLISH.toString();
        }
        return context.getLang().name();
    }

    public static void setQingIframeSrc(IFormView view, IFrame iframe, String src) {
        iframe.setSrc(src);
        IClientViewProxy proxy = (IClientViewProxy)view.getService(IClientViewProxy.class);
        HashMap<String, Object> dataMap = new HashMap<String, Object>();
        dataMap.put("k", iframe.getKey());
        dataMap.put("allowfullscreen", true);
        dataMap.put("webkitAllowFullScreen", true);
        dataMap.put("mozAllowFullScreen", true);
        proxy.addAction("u", dataMap);
        view.executeClientCommand("loadThirdPartyJS", new Object[]{"./qinganalysis/remote/qing-remote-proxy-top.js?version=20240528"});
    }

    public static void openQingIFramePageInTab(String appid, String url, String title, IFormView view) {
        Base64.Encoder encoder = Base64.getEncoder();
        String markId = new String(encoder.encode(url.getBytes()));
        QingUtil.openQingIFramePageInTabWithMarkId(appid, url, title, view, markId);
    }

    public static void openQingIFramePageInTabWithMarkId(String appid, String url, String title, IFormView view, String markId) {
        String formId = QING_ANALYSIS_IFRAME_PAGE;
        if (QING_REPORT_APPID.equals(appid)) {
            formId = QING_REPORT_IFRAME_PAGE;
        }
        HashMap<String, Object> parameter = new HashMap<String, Object>();
        parameter.put("formId", formId);
        parameter.put("src", url);
        parameter.put("title", title);
        QingUtil.openTab(appid, markId, formId, "FormShowParameter", parameter, view);
    }

    public static void openTab(String appId, String markID, String formnumber, String parametertype, Map<String, Object> parameter, IFormView view) {
        HashMap<String, Object> map = new HashMap<String, Object>();
        if (!QingUtil.beforeJump(map, appId, view)) {
            return;
        }
        map.put("view", view);
        map.put("formnumber", formnumber);
        map.put("parametertype", parametertype);
        map.put("parameter", SerializationUtils.toJsonString(parameter));
        OpenPageUtils.openApp((String)appId, (String)markID, map, (IFormView)view);
    }

    public static void showForm(String appId, String markID, String formnumber, String parametertype, Map<String, Object> parameter, IFormView view) {
        HashMap<String, Object> map = new HashMap<String, Object>();
        if (!QingUtil.beforeJump(map, appId, view)) {
            return;
        }
        map.put("view", view);
        map.put("formnumber", formnumber);
        map.put("parametertype", parametertype);
        map.put("parameter", SerializationUtils.toJsonString(parameter));
        BillShowParameter bsp = new BillShowParameter();
        bsp.setPkId((Object)markID);
        bsp.setBillStatus(BillOperationStatus.VIEW);
        bsp.setFormId(formnumber);
        OperationStatus status = (OperationStatus)parameter.get("Status");
        bsp.setStatus(status != null ? status : OperationStatus.VIEW);
        bsp.setAppId(appId);
        OpenStyle openStyle = new OpenStyle();
        openStyle.setShowType(ShowType.MainNewTabPage);
        openStyle.setClientShowType(ShowType.MainNewTabPage);
        bsp.setOpenStyle(openStyle);
        OpenPageUtils.openApp((String)appId, null, map, (IFormView)view);
        view.showForm((FormShowParameter)bsp);
    }

    public static void openLinkageListTab(String appId, String markID, String formnumber, String parametertype, Map<String, Object> parameter, IFormView view) {
        HashMap<String, Object> map = new HashMap<String, Object>();
        if (!QingUtil.beforeJump(map, appId, view)) {
            return;
        }
        map.put("view", view);
        map.put("formnumber", formnumber);
        map.put("parametertype", parametertype);
        map.put("parameter", SerializationUtils.toJsonString(parameter));
        IFormView mainView = view.getMainView();
        if (mainView == null) {
            String rootPageId = view.getFormShowParameter().getRootPageId();
            mainView = view.getView(rootPageId);
        }
        if (null == mainView || !mainView.getFormShowParameter().getFormId().equals("pc_main_console") && !mainView.getFormShowParameter().getFormId().equals("home_page")) {
            ListShowParameter lsp = new ListShowParameter();
            lsp.setBillFormId(formnumber);
            lsp.setHasRight(true);
            lsp.setAppId(appId);
            lsp.setCustomParam("linkQueryPkIds", parameter.get("linkQueryPkIds"));
            lsp.setCustomParam("type", (Object)"list");
            lsp.setCustomParam("billFormId", (Object)formnumber);
            lsp.setCustomParam("appid", (Object)appId);
            Object linkQueryPkIdsObj = parameter.get("linkQueryPkIds");
            if (linkQueryPkIdsObj instanceof List) {
                List pkIds = (List)parameter.get("linkQueryPkIds");
                LinkQueryPkIdCollection linkPkColl = new LinkQueryPkIdCollection();
                for (Object pkId : pkIds) {
                    linkPkColl.addLinkQueryPkId(pkId);
                }
                lsp.setLinkQueryPkIdCollection(linkPkColl);
            }
            OpenStyle openStyle = new OpenStyle();
            openStyle.setShowType(ShowType.Modal);
            openStyle.setClientShowType(ShowType.Modal);
            lsp.setOpenStyle(openStyle);
            view.showForm((FormShowParameter)lsp);
        } else {
            OpenPageUtils.openApp((String)appId, (String)markID, map, (IFormView)view);
        }
    }

    public static void openLinkageEditTab(String appId, String markID, String formnumber, String parametertype, Map<String, Object> parameter, IFormView view) {
        HashMap<String, Object> map = new HashMap<String, Object>();
        if (!QingUtil.beforeJump(map, appId, view)) {
            return;
        }
        map.put("view", view);
        map.put("formnumber", formnumber);
        map.put("parametertype", parametertype);
        map.put("parameter", SerializationUtils.toJsonString(parameter));
        BillShowParameter bsp = new BillShowParameter();
        bsp.setPkId((Object)markID);
        bsp.setBillStatus(BillOperationStatus.VIEW);
        bsp.setFormId(formnumber);
        OperationStatus status = (OperationStatus)parameter.get("Status");
        bsp.setStatus(status != null ? status : OperationStatus.VIEW);
        bsp.setAppId(appId);
        OpenStyle openStyle = new OpenStyle();
        ShowType showType = ShowType.MainNewTabPage;
        IFormView mainView = view.getMainView();
        if (mainView == null) {
            String rootPageId = view.getFormShowParameter().getRootPageId();
            mainView = view.getView(rootPageId);
        }
        if (null == mainView || !mainView.getFormShowParameter().getFormId().equals("pc_main_console") && !mainView.getFormShowParameter().getFormId().equals("home_page")) {
            showType = ShowType.Modal;
        } else {
            OpenPageUtils.openApp((String)appId, null, map, (IFormView)view);
        }
        openStyle.setShowType(showType);
        openStyle.setClientShowType(showType);
        bsp.setOpenStyle(openStyle);
        view.showForm((FormShowParameter)bsp);
    }

    public static void showForm(String pageId, IFormView view, FormShowParameter showParameter) {
        IFormView actionView = SessionManager.getCurrent().getView(pageId);
        String isMethodInvoke = view.getPageCache().get(FIRE_QING_LINKAGE_BY_METHOD_INVOKE);
        if (Boolean.parseBoolean(isMethodInvoke)) {
            actionView.showForm(showParameter);
        } else {
            view.setClientReturnData((Object)FormShowParameter.toJsonString((FormShowParameter)showParameter));
        }
    }

    private static boolean beforeJump(Map<String, Object> map, String appId, IFormView view) {
        AppInfo appInfo = QingUtil.getAppInfo(appId, view);
        if (appInfo == null) {
            return false;
        }
        map.put("appname", appInfo.getName().getLocaleValue());
        String mainPageId = QingUtil.getMainPageId(view, appInfo);
        if (mainPageId == null) {
            return false;
        }
        DynamicObject pageObject = QingUtil.getPageObject(view, mainPageId);
        if (pageObject == null) {
            return false;
        }
        String mainPageNumber = pageObject.getString("number");
        map.put("appmainnumber", mainPageNumber);
        return true;
    }

    private static DynamicObject getPageObject(IFormView view, String mainPageId) {
        DynamicObject pageObject = BusinessDataServiceHelper.loadSingleFromCache((Object)mainPageId, (String)"bos_formmeta", (String)"number, inheritpath");
        if (pageObject == null) {
            view.showTipNotification(Messages.getMLS("QingUtil_3", "\u5e94\u7528\u9996\u9875\u9875\u9762\u4e0d\u5b58\u5728\uff01", Messages.ProjectName.BOS_QING_PLUGIN_SHARED), Integer.valueOf(3000));
            return null;
        }
        return pageObject;
    }

    private static String getMainPageId(IFormView view, AppInfo appInfo) {
        String mainPageId = appInfo.getHomeId();
        if (mainPageId == null || mainPageId.trim().length() == 0) {
            view.showTipNotification(Messages.getMLS("QingUtil_2", "\u5e94\u7528\u9996\u9875\u6ca1\u6709\u914d\u7f6e\uff0c\u8bf7\u914d\u7f6e\u540e\u518d\u8bd5\uff01", Messages.ProjectName.BOS_QING_PLUGIN_SHARED), Integer.valueOf(3000));
            return null;
        }
        return mainPageId;
    }

    private static AppInfo getAppInfo(String appId, IFormView view) {
        AppInfo appInfo = null;
        try {
            appInfo = AppMetadataCache.getAppInfo((String)appId);
        }
        catch (Exception e) {
            view.showErrorNotification(String.format(Messages.getMLS("QingUtil_1", "\u5e94\u7528 %s \u83b7\u53d6\u4e0d\u5230\u8fd0\u884c\u671f\u4fe1\u606f\uff0c\u53ef\u80fd\u5e94\u7528\u672a\u542f\u7528\u6216\u4e0d\u53ef\u89c1\uff01", Messages.ProjectName.BOS_QING_PLUGIN_SHARED), appId));
            return null;
        }
        return appInfo;
    }

    static {
        SUPPORTED.add(Locale.SIMPLIFIED_CHINESE);
        SUPPORTED.add(Locale.TRADITIONAL_CHINESE);
        SUPPORTED.add(Locale.ENGLISH);
    }
}

