/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.qing.plugin.actionhandler;

import com.alibaba.fastjson.JSONObject;
import java.io.UnsupportedEncodingException;
import java.net.URLEncoder;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.UUID;
import kd.bos.form.IFormView;
import kd.bos.form.events.CustomEventArgs;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.portal.model.CardInfo;
import kd.bos.portal.pluginnew.GridContainerPlugin;
import kd.bos.qing.plugin.actionhandler.IQingActionHandler;

public class AddCardToHomepageActionHandler
implements IQingActionHandler {
    private static final Log logger = LogFactory.getLog(AddCardToHomepageActionHandler.class);

    @Override
    public String getActionName() {
        return "addCardToHomepage";
    }

    @Override
    public void handle(CustomEventArgs e, IFormView view) {
        String eventArgs = e.getEventArgs();
        JSONObject jsonObject = JSONObject.parseObject((String)eventArgs);
        String cardId = jsonObject.getString("cardId");
        String cardName = jsonObject.getString("cardName");
        HashMap<String, String> configMap = new HashMap<String, String>();
        configMap.put("cardType", "bos_card_qing");
        configMap.put("QingCardId", cardId);
        configMap.put("QingCardName", cardName);
        try {
            configMap.put("QingSafeCardName", URLEncoder.encode(cardName, "utf-8"));
        }
        catch (UnsupportedEncodingException exception) {
            logger.error((Throwable)exception);
        }
        configMap.put("HomepageCardId", UUID.randomUUID().toString());
        ArrayList<CardInfo> cardInfoList = new ArrayList<CardInfo>();
        CardInfo cardInfo = new CardInfo(configMap, this.getCardWidth(), this.getHeight());
        cardInfoList.add(cardInfo);
        new GridContainerPlugin().dynamicAddCards("bos_card_qing", cardInfoList, view);
    }

    protected int getCardWidth() {
        return 4;
    }

    protected int getHeight() {
        return 1;
    }
}

