/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.qing.plugin.actionhandler;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.google.gson.Gson;
import com.google.gson.internal.LinkedTreeMap;
import com.kingdee.bos.qing.api.customtable.interfaces.CustomHyperLinkAccessor;
import com.kingdee.bos.qing.api.customtable.model.CustomHyperParam;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import kd.bos.bill.OperationStatus;
import kd.bos.cache.CacheFactory;
import kd.bos.cache.DistributeSessionlessCache;
import kd.bos.context.RequestContext;
import kd.bos.entity.AppMetadataCache;
import kd.bos.form.FormShowParameter;
import kd.bos.form.IFormView;
import kd.bos.form.control.Control;
import kd.bos.form.control.IQingAnalysis;
import kd.bos.form.events.CustomEventArgs;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.metadata.devportal.AppMetadata;
import kd.bos.qing.plugin.QingUtil;
import kd.bos.qing.plugin.actionhandler.IQingActionHandler;
import kd.bos.qing.plugin.i18n.Messages;
import kd.bos.qing.plugin.util.StringUtils;
import kd.bos.servicehelper.DispatchServiceHelper;
import kd.bos.servicehelper.devportal.AppMetaServiceHelper;

public class LinkageJumpActionHandler
implements IQingActionHandler {
    private static final DistributeSessionlessCache cache = CacheFactory.getCommonCacheFactory().getDistributeSessionlessCache("qing");
    private static final Log logger = LogFactory.getLog(LinkageJumpActionHandler.class);
    private static final String MEMBER = "members";
    private static final String IS_STORED_MEMBER = "isStoredMember";
    private static final String PAGE_ID = "pageId";
    private static final String APP_ID = "appId";
    private static final String KEY_CUSTOM_CLASS = "customTargetClass";
    private static final String KEY_CACHEID = "cacheId";
    private static final String KEY_BIZUIID = "bizUiId";
    private static final String KEY_FOREIGN_CACHEDID = "foreignKeyMembersCachedId";
    private static final String KEY_SYSTEM = "System";
    private static final String KEY_CTRKEY = "CtrKey";
    private static final String KEY_FORMID = "FormId";
    private static final String KEY_APPID = "AppId";
    private static final String KEY_BEDITUI = "bEditUi";
    private static final String PK_DATA_TYPE = "pkDataType";
    private static final String KEY_BILLINFO = "rptBillInfo";
    private static final Gson gson = new Gson();
    private static final String KEY_UI_DETAIL = "UI_DETAIL";
    private static final String KEY_UI_APPID = "UI_APPID";
    private static final String KEY_UI_FID = "UI_FID";
    private static final String KEY_UI_ID = "UI_ID";
    private static final String KEY_UI_READ_ONLY = "UI_READ_ONLY";

    @Override
    public String getActionName() {
        return "linkageJump";
    }

    @Override
    public void handle(CustomEventArgs e, IFormView view) {
        this.doJumpAction(e.getEventArgs(), view, false);
    }

    public void doJumpAction(String eventArgs, IFormView view, boolean fromEmbededDesigner) {
        JSONObject jsonObject = JSON.parseObject((String)eventArgs);
        String customTargetClass = jsonObject.getString(KEY_CUSTOM_CLASS);
        if (StringUtils.isNotEmpty(customTargetClass)) {
            String cacheId = jsonObject.getString(KEY_CACHEID);
            LinkageJumpActionHandler.customLink(view, customTargetClass, cacheId);
            return;
        }
        String billInfoStr = jsonObject.getString(KEY_BILLINFO);
        if (StringUtils.isNotEmpty(billInfoStr)) {
            String cacheId = jsonObject.getString(KEY_CACHEID);
            this.rptBillLink(view, billInfoStr, cacheId);
            return;
        }
        String bizUiId = jsonObject.getString(KEY_BIZUIID);
        String foreignKeyMembersCachedId = jsonObject.getString(KEY_FOREIGN_CACHEDID);
        Map linkageDataMap = (Map)JSON.parseObject((String)foreignKeyMembersCachedId, HashMap.class);
        String system = null;
        String ctrKey = null;
        String formId = null;
        String appId = null;
        if (bizUiId != null) {
            JSONObject bizUiIdJson = JSON.parseObject((String)bizUiId);
            system = bizUiIdJson.getString(KEY_SYSTEM);
            ctrKey = bizUiIdJson.getString(KEY_CTRKEY);
            formId = bizUiIdJson.getString(KEY_FORMID);
            appId = bizUiIdJson.getString(KEY_APPID);
        }
        if (StringUtils.isNotEmpty(ctrKey)) {
            this.dynamicBillLink(view, jsonObject, linkageDataMap, ctrKey, formId, appId, fromEmbededDesigner);
            return;
        }
        String pkDataType = jsonObject.getString(PK_DATA_TYPE);
        Boolean bEditUi = jsonObject.getBoolean(KEY_BEDITUI);
        this.generalLink(view, bEditUi, linkageDataMap, system, formId, appId, pkDataType);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void customLink(IFormView view, String customTargetClass, String cacheId) {
        RequestContext requestContext = RequestContext.get();
        try {
            Map temps;
            String[] classNames = customTargetClass.split("\\.");
            if (classNames[classNames.length - 1].indexOf("QingRpt") != 0) {
                String message = Messages.getMLS("linkClassError", "\u81ea\u5b9a\u4e49\u8054\u67e5\u76ee\u6807\u7c7b\u987b\u4ee5\u201cQingRpt\u201d\u5f00\u5934", Messages.ProjectName.BOS_QING_PLUGIN_SHARED);
                throw new IllegalArgumentException(message);
            }
            Class<?> target = Class.forName(customTargetClass);
            CustomHyperLinkAccessor accessor = (CustomHyperLinkAccessor)target.newInstance();
            HashMap<String, IFormView> context = new HashMap<String, IFormView>(1);
            context.put("view", view);
            HashMap params = new HashMap(4);
            String sMap = (String)cache.get(requestContext.getGlobalSessionId(), cacheId);
            if (sMap != null && !(temps = (Map)JSON.parseObject((String)sMap, Map.class)).isEmpty()) {
                for (Map.Entry entry : temps.entrySet()) {
                    JSONObject customJsonObj = (JSONObject)temps.get(entry.getKey());
                    params.put(entry.getKey(), customJsonObj.toJavaObject(CustomHyperParam.class));
                }
            }
            accessor.jump(params, context);
        }
        catch (Exception exception) {
            view.showErrMessage(Messages.getMLS("billLinkageError", "\u5355\u636e\u8054\u67e5\u51fa\u9519", Messages.ProjectName.BOS_QING_PLUGIN_SHARED), exception.getMessage());
            logger.error("customHyper execute error, customTargetClass:" + customTargetClass, (Throwable)exception);
        }
        finally {
            cache.remove(requestContext.getGlobalSessionId(), cacheId);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void rptBillLink(IFormView view, String billInfo, String cacheId) {
        try {
            ArrayList<String> idList;
            RequestContext requestContext = RequestContext.get();
            HashMap billInfoMap = (HashMap)JSON.parseObject((String)billInfo, HashMap.class);
            String appId = (String)billInfoMap.get(KEY_UI_APPID);
            String formId = (String)billInfoMap.get(KEY_UI_ID);
            String cachedJson = (String)cache.get(requestContext.getGlobalSessionId(), cacheId);
            if (StringUtils.isEmpty(cachedJson)) {
                return;
            }
            boolean isNum = this.isNum(this.getFirstItem(cachedJson));
            if (isNum) {
                JSONArray cachedArray = JSONArray.parseArray((String)((String)cache.get(requestContext.getGlobalSessionId(), cacheId)));
                idList = cachedArray.toJavaList(Long.class);
            } else {
                cachedJson = cachedJson.replace("[", "").replace("]", "").replace(" ", "");
                idList = new ArrayList<String>(Arrays.asList(cachedJson.split(",")));
            }
            HashMap<String, Object> parameter = new HashMap<String, Object>(3);
            if (Boolean.parseBoolean((String)billInfoMap.get(KEY_UI_DETAIL))) {
                parameter.put("formId", formId);
                parameter.put("pkId", String.valueOf(idList.get(0)));
                boolean readOnly = Boolean.parseBoolean((String)billInfoMap.get(KEY_UI_READ_ONLY));
                parameter.put("Status", readOnly ? OperationStatus.VIEW : OperationStatus.EDIT);
                QingUtil.openLinkageEditTab(appId, String.valueOf(idList.get(0)), formId, "FormShowParameter", parameter, view);
            } else {
                String markID = UUID.randomUUID().toString();
                parameter.put("linkQueryPkIds", idList);
                QingUtil.openLinkageListTab(appId, markID, formId, "ListShowParameter", parameter, view);
            }
        }
        catch (Exception e) {
            logger.error("bill linkage error:" + e.getMessage(), (Throwable)e);
            view.showErrMessage(Messages.getMLS("billLinkageError", "\u5355\u636e\u8054\u67e5\u51fa\u9519", Messages.ProjectName.BOS_QING_PLUGIN_SHARED), e.getMessage());
        }
        finally {
            cache.remove(cacheId);
        }
    }

    private String getFirstItem(String json) {
        int i = json.indexOf(",");
        if (i < 0) {
            return json.replace("[", "").replace("]", "");
        }
        return json.substring(1, i);
    }

    private boolean isNum(String val) {
        Pattern pattern = Pattern.compile("^-?[0-9]+");
        return pattern.matcher(val).matches();
    }

    private void generalLink(IFormView view, Boolean bEditUi, Map<String, String> linkageDataMap, String system, String formId, String appId, String pkDataType) {
        if ("IERP".equals(system)) {
            appId = this.validateAppId(appId);
            HashMap<String, Object> parameter = new HashMap<String, Object>();
            JSONArray keyMembers = this.getKeyMembers(linkageDataMap);
            List<Object> linkQueryPkIds = "String".equals(pkDataType) ? LinkageJumpActionHandler.toStringPkIds(keyMembers) : this.toLongPkIds(keyMembers);
            String linkagePkId = String.valueOf(linkQueryPkIds.get(0));
            if (bEditUi != null && bEditUi.booleanValue()) {
                String parameterType = "FormShowParameter";
                parameter.put("formId", formId);
                parameter.put("pkId", linkagePkId);
                parameter.put("Status", OperationStatus.EDIT);
                QingUtil.openLinkageEditTab(appId, linkagePkId, formId, parameterType, parameter, view);
            } else {
                String markID = UUID.randomUUID().toString();
                String parameterType = "ListShowParameter";
                parameter.put("linkQueryPkIds", linkQueryPkIds);
                QingUtil.openLinkageListTab(appId, markID, formId, parameterType, parameter, view);
            }
        }
    }

    private void dynamicBillLink(IFormView view, JSONObject jsonObject, Map<String, String> linkageDataMap, String ctrKey, String formId, String appId, boolean fromEmbededDesigner) {
        String pageId = jsonObject.getString(PAGE_ID);
        String mserviceAppId = jsonObject.getString(APP_ID);
        try {
            Control control = view.getControl(ctrKey);
            if (control instanceof IQingAnalysis) {
                JSONArray keyMembers = this.getKeyMembers(linkageDataMap);
                List<String> linkQueryPkIds = LinkageJumpActionHandler.toStringPkIds(keyMembers);
                view.getPageCache().put("fireQingLinkageByMethodInvoke", Boolean.TRUE.toString());
                ((IQingAnalysis)control).fireLinkageInfo(linkQueryPkIds, view.getPageId(), formId, appId);
                return;
            }
        }
        catch (Exception control) {
            // empty catch block
        }
        try {
            JSONArray keyMembers = this.getKeyMembers(linkageDataMap);
            List<String> linkQueryPkIds = LinkageJumpActionHandler.toStringPkIds(keyMembers);
            Object[] paramList = new Object[]{linkQueryPkIds, view.getPageId(), formId, appId};
            Object actionResult = DispatchServiceHelper.invokeBOSService((String)mserviceAppId, (String)"FormService", (String)"invokeAction", (Object[])new Object[]{pageId, ctrKey, "fireLinkageInfo", paramList, null});
            this.showFormByActionResult((String)actionResult, view);
        }
        catch (Exception exception) {
            logger.error("Fire qing linkage error, appId:" + mserviceAppId + ", pageId:" + pageId, (Throwable)exception);
        }
    }

    private String validateAppId(String appId) {
        if (StringUtils.isNotEmpty(appId)) {
            AppMetadata appMetadata = AppMetaServiceHelper.loadAppMetadataById((String)appId);
            if (appMetadata != null && StringUtils.isNotEmpty(appMetadata.getMasterId())) {
                appId = appMetadata.getMasterId();
            }
            if (StringUtils.isNotEmpty(appId)) {
                String number;
                Pattern pattern = Pattern.compile("[a-z]");
                Matcher matcher = pattern.matcher(appId);
                if ((appId.length() > 10 || !matcher.find()) && StringUtils.isNotEmpty(number = AppMetadataCache.getAppNumberById((String)appId))) {
                    appId = number;
                }
            }
        }
        return appId;
    }

    private JSONArray getKeyMembers(Map<String, String> linkageDataMap) {
        boolean isStored = Boolean.parseBoolean(linkageDataMap.get(IS_STORED_MEMBER));
        String foreignKeyData = linkageDataMap.get(MEMBER);
        JSONArray keyMembers = new JSONArray();
        if (isStored) {
            RequestContext requestContext = RequestContext.get();
            keyMembers = JSONArray.parseArray((String)((String)cache.get(requestContext.getGlobalSessionId(), foreignKeyData)));
            cache.remove(requestContext.getGlobalSessionId(), foreignKeyData);
        } else {
            keyMembers = JSONArray.parseArray((String)foreignKeyData);
        }
        return keyMembers;
    }

    private List<Long> toLongPkIds(JSONArray keyMembers) {
        ArrayList<Long> linkQueryPkIds = new ArrayList<Long>(10);
        Object member = keyMembers.get(0);
        boolean isStringMember = member instanceof String;
        for (int index = 0; index < keyMembers.size(); ++index) {
            member = keyMembers.get(index);
            if (isStringMember) {
                try {
                    Long foreignKeyMemberLong = Long.valueOf((String)member);
                    linkQueryPkIds.add(foreignKeyMemberLong);
                }
                catch (NumberFormatException exception) {
                    logger.error("foreignKeyMember:" + member, (Throwable)exception);
                }
                continue;
            }
            linkQueryPkIds.add((Long)member);
        }
        return linkQueryPkIds;
    }

    private static List<String> toStringPkIds(JSONArray keyMembers) {
        ArrayList<String> linkQueryPkIds = new ArrayList<String>(10);
        if (keyMembers != null) {
            for (int index = 0; index < keyMembers.size(); ++index) {
                linkQueryPkIds.add(String.valueOf(keyMembers.get(index)));
            }
        }
        return linkQueryPkIds;
    }

    private void showFormByActionResult(String actionResult, IFormView view) {
        logger.info("Fire qing linkage acrion result:" + actionResult);
        try {
            List resultList = (List)gson.fromJson(actionResult, ArrayList.class);
            if (resultList != null) {
                for (Object rs : resultList) {
                    LinkedTreeMap rsMap = (LinkedTreeMap)rs;
                    if (!"setReturnData".equals(rsMap.get((Object)"a"))) continue;
                    List rsDatas = (List)rsMap.get((Object)"p");
                    for (String rsData : rsDatas) {
                        FormShowParameter formShowParameter = FormShowParameter.fromJsonString((String)rsData);
                        view.showForm(formShowParameter);
                    }
                }
            }
        }
        catch (Exception e) {
            logger.error("Show form by action result error!", (Throwable)e);
        }
    }
}

