/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.qing.plugin.actionhandler;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import kd.bos.bill.OperationStatus;
import kd.bos.entity.AppInfo;
import kd.bos.entity.AppMetadataCache;
import kd.bos.entity.IFrameMessage;
import kd.bos.entity.datamodel.ListSelectedRow;
import kd.bos.entity.datamodel.ListSelectedRowCollection;
import kd.bos.form.CloseCallBack;
import kd.bos.form.FormConfig;
import kd.bos.form.FormMetadataCache;
import kd.bos.form.FormShowParameter;
import kd.bos.form.IClientViewProxy;
import kd.bos.form.ICloseCallBack;
import kd.bos.form.IFormView;
import kd.bos.form.ShowType;
import kd.bos.form.StyleCss;
import kd.bos.form.events.ClosedCallBackEvent;
import kd.bos.form.events.CustomEventArgs;
import kd.bos.list.ListShowParameter;
import kd.bos.orm.query.QFilter;
import kd.bos.qing.plugin.actionhandler.IQingActionHandler;
import kd.bos.qing.plugin.i18n.Messages;
import kd.bos.servicehelper.devportal.BizAppServiceHelp;

public class OpenAppChooseFormActionHandler
implements IQingActionHandler {
    @Override
    public String getActionName() {
        return "openAppChooseForm";
    }

    @Override
    public void handle(CustomEventArgs e, IFormView view) {
        ListShowParameter parameter = new ListShowParameter();
        parameter.setLookUp(true);
        parameter.setBillFormId("bos_devportal_app_layout");
        parameter.setStatus(OperationStatus.VIEW);
        parameter.getOpenStyle().setShowType(ShowType.Modal);
        StyleCss formConfig = new StyleCss();
        formConfig.setWidth("960px");
        formConfig.setHeight("580px");
        parameter.getOpenStyle().setInlineStyleCss(formConfig);
        FormConfig f = FormMetadataCache.getListFormConfig((String)"bos_devportal_app_layout");
        parameter.setFormId(f.getF7ListFormId());
        parameter.setMultiSelect(false);
        parameter.setShowTitle(false);
        parameter.setHasRight(true);
        parameter.setCaption(Messages.getMLS("QingUtil_8", "\u5e94\u7528\u9009\u62e9", Messages.ProjectName.BOS_QING_PLUGIN_SHARED));
        parameter.setFormId("bos_devp_apptreelistf7");
        parameter.setCustomParam("runtime", (Object)false);
        CloseCallBack callBack = new CloseCallBack(OpenAppChooseFormClosedCallback.class.getName(), "bos_devp_apptreelistf7");
        parameter.setCloseCallBack(callBack);
        try {
            String eventArgs = e.getEventArgs();
            JSONObject jsonObject = JSON.parseObject((String)eventArgs);
            String appId = jsonObject.getString("appId");
            AppInfo appInfo = AppMetadataCache.getAppInfo((String)appId);
            parameter.setSelectedRow((Object)appInfo.getId());
        }
        catch (Exception eventArgs) {
            // empty catch block
        }
        try {
            HashSet<String> allAvailableApps = new HashSet<String>(256);
            JSONArray jsonArray = BizAppServiceHelp.getAllAppInfo();
            for (int i = 0; i < jsonArray.size(); ++i) {
                JSONArray jsonArrayEntry = jsonArray.getJSONArray(i);
                for (int j = 0; j < jsonArrayEntry.size(); ++j) {
                    JSONObject jsonObject = jsonArrayEntry.getJSONObject(j);
                    String appId = jsonObject.getString("id");
                    Boolean isCloud = jsonObject.getBoolean("iscloud");
                    if (isCloud != null && isCloud.booleanValue()) continue;
                    allAvailableApps.add(appId);
                }
            }
            ArrayList appIds = new ArrayList(allAvailableApps);
            QFilter idsFilter = new QFilter("id", "in", appIds);
            parameter.getListFilterParameter().getQFilters().add(idsFilter);
        }
        catch (Exception exception) {
            // empty catch block
        }
        view.showForm((FormShowParameter)parameter);
    }

    public static class OpenAppChooseFormClosedCallback
    implements ICloseCallBack {
        public void closedCallBack(ClosedCallBackEvent event) {
            IFormView view = event.getView();
            String pageId = view.getPageId();
            IFrameMessage message = new IFrameMessage();
            message.setType("openAppChooseForm");
            ListSelectedRowCollection selectedRowCollection = (ListSelectedRowCollection)event.getReturnData();
            if (selectedRowCollection != null && !selectedRowCollection.isEmpty()) {
                ListSelectedRow listSelectedRow = selectedRowCollection.get(0);
                String appNumber = listSelectedRow.getNumber();
                AppInfo appInfo = AppMetadataCache.getAppInfo((String)appNumber);
                String appName = appInfo.getName().getLocaleValue();
                HashMap<String, String> rs = new HashMap<String, String>();
                rs.put("appId", String.valueOf(listSelectedRow.getPrimaryKeyValue()));
                rs.put("appName", appName);
                rs.put("appNumber", appNumber);
                rs.put("pageId", pageId);
                message.setContent(rs);
                IClientViewProxy proxy = (IClientViewProxy)view.getService(IClientViewProxy.class);
                proxy.invokeControlMethod("iframeap", "postMessage", new Object[]{message});
            }
        }
    }
}

