/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.qing.plugin.actionhandler;

import java.util.HashMap;
import java.util.Map;
import kd.bos.bill.OperationStatus;
import kd.bos.entity.IFrameMessage;
import kd.bos.form.CloseCallBack;
import kd.bos.form.FormShowParameter;
import kd.bos.form.IClientViewProxy;
import kd.bos.form.ICloseCallBack;
import kd.bos.form.IFormView;
import kd.bos.form.ShowType;
import kd.bos.form.events.ClosedCallBackEvent;
import kd.bos.form.events.CustomEventArgs;
import kd.bos.qing.plugin.actionhandler.IQingActionHandler;
import kd.bos.qing.plugin.i18n.Messages;

public class OpenAppMenuFormActionHandler
implements IQingActionHandler {
    @Override
    public String getActionName() {
        return "openAppMenuForm";
    }

    @Override
    public void handle(CustomEventArgs e, IFormView view) {
        FormShowParameter parameter = new FormShowParameter();
        parameter.getOpenStyle().setShowType(ShowType.Modal);
        parameter.setStatus(OperationStatus.VIEW);
        parameter.setFormId("bos_devp_choosemenu");
        CloseCallBack callBack = new CloseCallBack(OpenAppMenuFormClosedCallBack.class.getName(), "bos_devp_choosemenu");
        parameter.setCloseCallBack(callBack);
        view.showForm(parameter);
    }

    public static class OpenAppMenuFormClosedCallBack
    implements ICloseCallBack {
        private static final String APPNUMBER = "appnumber";
        private static final String CLOUDNAME = "cloudname";
        private static final String CLOUDNUMBER = "cloudnumber";
        private static final String CLOUDID = "cloudid";
        private static final String APP_NAME = "appName";
        private static final String APP_NUMBER = "appNumber";
        private static final String APP_ID = "appId";
        private static final String CLOUD_NAME = "cloudName";
        private static final String CLOUD_NUMBER = "cloudNumber";
        private static final String CLOUD_ID = "cloudId";
        private static final String APPNAME = "appname";
        private static final String APPID = "appid";
        private static final String LEVEL = "level";

        public void closedCallBack(ClosedCallBackEvent event) {
            IFormView view = event.getView();
            String pageId = view.getPageId();
            IFrameMessage message = new IFrameMessage();
            message.setType("openAppMenuForm");
            Map rs = (Map)event.getReturnData();
            if (rs != null) {
                HashMap<String, String> result = new HashMap<String, String>(16);
                if (rs.containsKey(LEVEL) && rs.containsKey(APPID) && rs.containsKey(APPNAME)) {
                    String level = rs.get(LEVEL).toString();
                    if ("appnode".equalsIgnoreCase(level)) {
                        result.put(LEVEL, level);
                        result.put(CLOUD_ID, rs.get(CLOUDID).toString());
                        result.put(CLOUD_NUMBER, rs.get(CLOUDNUMBER).toString());
                        result.put(CLOUD_NAME, rs.get(CLOUDNAME).toString());
                        result.put(APP_ID, rs.get(APPID).toString());
                        result.put(APP_NUMBER, rs.get(APPNUMBER).toString());
                        result.put(APP_NAME, rs.get(APPNAME).toString());
                    } else if ("firmenunode".equalsIgnoreCase(level)) {
                        result.put(LEVEL, level);
                        result.put(CLOUD_ID, rs.get(CLOUDID).toString());
                        result.put(CLOUD_NUMBER, rs.get(CLOUDNUMBER).toString());
                        result.put(CLOUD_NAME, rs.get(CLOUDNAME).toString());
                        result.put(APP_ID, rs.get(APPID).toString());
                        result.put(APP_NUMBER, rs.get(APPNUMBER).toString());
                        result.put(APP_NAME, rs.get(APPNAME).toString());
                        result.put("appMenuId", rs.get("menuid").toString());
                        result.put("appMenuNumber", rs.get("menunumber").toString());
                        result.put("appMenuName", rs.get("menuname").toString());
                    } else if ("secmenunode".equalsIgnoreCase(level)) {
                        result.put(LEVEL, level);
                        result.put(CLOUD_ID, rs.get(CLOUDID).toString());
                        result.put(CLOUD_NUMBER, rs.get(CLOUDNUMBER).toString());
                        result.put(CLOUD_NAME, rs.get(CLOUDNAME).toString());
                        result.put(APP_ID, rs.get(APPID).toString());
                        result.put(APP_NUMBER, rs.get(APPNUMBER).toString());
                        result.put(APP_NAME, rs.get(APPNAME).toString());
                        result.put("appMenuId", rs.get("menuid").toString());
                        result.put("appMenuNumber", rs.get("menunumber").toString());
                        result.put("appMenuName", rs.get("menuname").toString());
                        result.put("appMenuId2", rs.get("menuid2").toString());
                        result.put("appMenuNumber2", rs.get("menunumber2").toString());
                        result.put("appMenuName2", rs.get("menuname2").toString());
                    } else {
                        view.showTipNotification(Messages.getMLS("QingUtil_6", "\u83b7\u53d6\u5e94\u7528\u83dc\u5355\u5931\u8d25\uff0c\u8fd4\u56de\u7684level\u4e0d\u5728\u534f\u8bae\u8303\u56f4\u5185\u3002", Messages.ProjectName.BOS_QING_PLUGIN_SHARED));
                    }
                    result.put("pageId", pageId);
                    message.setContent(result);
                    IClientViewProxy proxy = (IClientViewProxy)view.getService(IClientViewProxy.class);
                    proxy.invokeControlMethod("iframeap", "postMessage", new Object[]{message});
                } else {
                    view.showTipNotification(Messages.getMLS("QingUtil_7", "\u83b7\u53d6\u5e94\u7528\u83dc\u5355\u5931\u8d25\uff0c\u8fd4\u56de\u7684\u6570\u636e\u4e3a\u7a7a\u3002", Messages.ProjectName.BOS_QING_PLUGIN_SHARED));
                }
            }
        }
    }
}

