/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.qing.plugin.actionhandler;

import com.alibaba.fastjson.JSONObject;
import java.util.HashMap;
import kd.bos.entity.IFrameMessage;
import kd.bos.form.CloseCallBack;
import kd.bos.form.FormShowParameter;
import kd.bos.form.IClientViewProxy;
import kd.bos.form.ICloseCallBack;
import kd.bos.form.IFormView;
import kd.bos.form.ShowType;
import kd.bos.form.events.ClosedCallBackEvent;
import kd.bos.form.events.CustomEventArgs;
import kd.bos.qing.plugin.actionhandler.IQingActionHandler;
import kd.bos.servicehelper.DispatchServiceHelper;

public class OpenGaiPrivacyAgreementActionHandler
implements IQingActionHandler {
    private static final String USER_AGREEMENT = "userAgreement";
    private static final String TENANT_AGREEMENT = "tenantAgreement";

    @Override
    public String getActionName() {
        return "openGaiPrivacyAgreement";
    }

    @Override
    public void handle(CustomEventArgs e, IFormView view) {
        String eventArgs = e.getEventArgs();
        JSONObject jsonObject = JSONObject.parseObject((String)eventArgs);
        Boolean isUserAgreement = jsonObject.getBoolean(USER_AGREEMENT);
        Boolean isTenantAgreement = jsonObject.getBoolean(TENANT_AGREEMENT);
        view.getPageCache().put("showAgreement", "true");
        FormShowParameter fsp = new FormShowParameter();
        fsp.setFormId("gai_privacy_agreement");
        fsp.getOpenStyle().setShowType(ShowType.Modal);
        if (isTenantAgreement.booleanValue()) {
            fsp.setCustomParam("agreementType", (Object)TENANT_AGREEMENT);
        } else if (isUserAgreement.booleanValue()) {
            fsp.setCustomParam("agreementType", (Object)USER_AGREEMENT);
        }
        CloseCallBack closeCallBack = new CloseCallBack(OpenGaiPrivacyAgreementClosedCallBack.class.getName(), "gai_privacy_agreement");
        fsp.setCloseCallBack(closeCallBack);
        view.showForm(fsp);
    }

    public static class OpenGaiPrivacyAgreementClosedCallBack
    implements ICloseCallBack {
        public void closedCallBack(ClosedCallBackEvent event) {
            IFormView view = event.getView();
            String pageId = view.getPageId();
            IFrameMessage message = new IFrameMessage();
            message.setType("openGaiPrivacyAgreement");
            Boolean isTenantAgree = (Boolean)DispatchServiceHelper.invokeBizService((String)"ai", (String)"gai", (String)"GaiPrivacyService", (String)"isTenantAgree", (Object[])new Object[0]);
            Boolean isUserAgree = (Boolean)DispatchServiceHelper.invokeBizService((String)"ai", (String)"gai", (String)"GaiPrivacyService", (String)"isUserAgree", (Object[])new Object[0]);
            HashMap<String, Object> result = new HashMap<String, Object>(3);
            result.put("tenantAgree", isTenantAgree);
            result.put("userAgree", isUserAgree);
            result.put("pageId", pageId);
            message.setContent(result);
            IClientViewProxy proxy = (IClientViewProxy)view.getService(IClientViewProxy.class);
            proxy.invokeControlMethod("iframeap", "postMessage", new Object[]{message});
        }
    }
}

