/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.qing.plugin.actionhandler;

import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import kd.bos.entity.IFrameMessage;
import kd.bos.entity.datamodel.ListSelectedRow;
import kd.bos.entity.datamodel.ListSelectedRowCollection;
import kd.bos.form.CloseCallBack;
import kd.bos.form.FormShowParameter;
import kd.bos.form.IClientViewProxy;
import kd.bos.form.ICloseCallBack;
import kd.bos.form.IFormView;
import kd.bos.form.ShowFormHelper;
import kd.bos.form.events.ClosedCallBackEvent;
import kd.bos.form.events.CustomEventArgs;
import kd.bos.list.ListFilterParameter;
import kd.bos.list.ListShowParameter;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.qing.plugin.actionhandler.IQingActionHandler;
import kd.bos.util.JSONUtils;

public class OpenRoleFormActionHandler
implements IQingActionHandler {
    private static final Log logger = LogFactory.getLog(OpenRoleFormActionHandler.class);

    @Override
    public String getActionName() {
        return "openRoleForm";
    }

    @Override
    public void handle(CustomEventArgs e, IFormView view) {
        String eventArgs = e.getEventArgs();
        String billFormId = "perm_role";
        ListShowParameter param = ShowFormHelper.createShowListForm((String)billFormId, (boolean)true);
        param.setMultiSelect(true);
        param.setShowApproved(true);
        param.setShowTitle(false);
        CloseCallBack closeCallBack = new CloseCallBack(OpenRoleFormClosedCallback.class.getName(), billFormId);
        param.setCloseCallBack(closeCallBack);
        ArrayList<QFilter> qFilters = new ArrayList<QFilter>();
        QFilter enableFilter = new QFilter("enable", "=", (Object)true);
        qFilters.add(enableFilter);
        param.setListFilterParameter(new ListFilterParameter(qFilters, null));
        try {
            ArrayList array = (ArrayList)JSONUtils.cast((String)eventArgs, ArrayList.class);
            param.setSelectedRows(array.toArray());
        }
        catch (IOException e1) {
            logger.error("eventArgs:" + eventArgs, (Throwable)e1);
        }
        param.setHasRight(true);
        view.showForm((FormShowParameter)param);
    }

    public static class OpenRoleFormClosedCallback
    implements ICloseCallBack {
        public void closedCallBack(ClosedCallBackEvent event) {
            IFormView view = event.getView();
            String pageId = view.getPageId();
            IFrameMessage message = new IFrameMessage();
            message.setType("perm_role");
            message.setOrigin(pageId);
            ListSelectedRowCollection selectedRowCollection = (ListSelectedRowCollection)event.getReturnData();
            HashMap<String, Object> rs = new HashMap<String, Object>(8);
            if (selectedRowCollection != null) {
                rs.put("operation", "confirm");
                HashMap<Object, String> selecteds = new HashMap<Object, String>(4);
                for (ListSelectedRow listSelectedRow : selectedRowCollection) {
                    Object id = listSelectedRow.getPrimaryKeyValue();
                    String name = listSelectedRow.getName();
                    selecteds.put(id, name);
                }
                rs.put("selecteds", selecteds);
            } else {
                rs.put("operation", "cancel");
            }
            rs.put("pageId", pageId);
            message.setContent(rs);
            IClientViewProxy proxy = (IClientViewProxy)view.getService(IClientViewProxy.class);
            proxy.invokeControlMethod("iframeap", "postMessage", new Object[]{message});
        }
    }
}

