/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.qing.plugin.actionhandler;

import java.io.IOException;
import java.util.ArrayList;
import kd.bos.form.IFormView;
import kd.bos.form.IPageCache;
import kd.bos.form.events.CustomEventArgs;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.qing.plugin.actionhandler.IQingActionHandler;
import kd.bos.util.JSONUtils;

public class SetTabDirtyStatusActionHandler
implements IQingActionHandler {
    private static final Log logger = LogFactory.getLog(SetTabDirtyStatusActionHandler.class);
    private static final String QING_DIRTY_CLIENT_ID_LIST = "QingDirtyClientIDList";

    @Override
    public String getActionName() {
        return "setTabDirtyStatus";
    }

    @Override
    public void handle(CustomEventArgs e, IFormView view) {
        String eventArgs = e.getEventArgs();
        String clientID = e.getKey();
        IPageCache pageCache = (IPageCache)view.getService(IPageCache.class);
        String dirtyClientIDStr = pageCache.get(QING_DIRTY_CLIENT_ID_LIST);
        try {
            if (dirtyClientIDStr != null) {
                ArrayList dirtyClientIDList = (ArrayList)JSONUtils.cast((String)dirtyClientIDStr, ArrayList.class);
                if ("true".equals(eventArgs)) {
                    if (!dirtyClientIDList.contains(clientID)) {
                        dirtyClientIDList.add(clientID);
                        pageCache.put(QING_DIRTY_CLIENT_ID_LIST, JSONUtils.toString((Object)dirtyClientIDList));
                    }
                } else {
                    dirtyClientIDList.remove(clientID);
                    if (dirtyClientIDList.isEmpty()) {
                        pageCache.remove(QING_DIRTY_CLIENT_ID_LIST);
                    } else {
                        pageCache.put(QING_DIRTY_CLIENT_ID_LIST, JSONUtils.toString((Object)dirtyClientIDList));
                    }
                }
            } else if ("true".equals(eventArgs)) {
                ArrayList<String> dirtyClientIDList = new ArrayList<String>();
                dirtyClientIDList.add(clientID);
                pageCache.put(QING_DIRTY_CLIENT_ID_LIST, JSONUtils.toString(dirtyClientIDList));
            }
        }
        catch (IOException e1) {
            logger.error("cast json fail when setTabDirtyStatus", (Throwable)e1);
        }
    }

    public static boolean isDirtyStatus(IFormView view) {
        IPageCache pageCache = (IPageCache)view.getService(IPageCache.class);
        String dirtyClientIDStr = pageCache.get(QING_DIRTY_CLIENT_ID_LIST);
        return dirtyClientIDStr != null;
    }
}

