/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.qing.plugin.appmenu;

import com.alibaba.fastjson.JSONObject;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Set;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.LocaleString;
import kd.bos.db.DB;
import kd.bos.db.DBRoute;
import kd.bos.db.ResultSetHandler;
import kd.bos.entity.AppInfo;
import kd.bos.entity.AppMenuInfo;
import kd.bos.entity.AppMetadataCache;
import kd.bos.entity.plugin.support.util.CollectionUtils;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.qing.plugin.util.StringUtils;
import kd.bos.servicehelper.permission.PermissionServiceHelper;

public class PublishedAppMenuUtil {
    public static final String QING_ANALYSIS_APP_MENU = "qing_analysis_app_menu";
    public static final String QING_REPORT_APP_MENU = "qing_rpt_app_menu";
    public static final String QING_PRESET_ROLE_ID = "0/IWII0D06HW";
    public static final String QING_PRESET_USER_ID = "100000";
    public static final int TYPE_APPMENU = 0;
    private static String APPID = "qing_rpt";
    private static final String QING_RPT_PRESETMANAGE = "qing_rpt_apphome";
    private static final String MANAGE_PRESET_GROUP_PERMITEMID = "37=775XZ9K5N";
    private static final Log logger = LogFactory.getLog(PublishedAppMenuUtil.class);

    public static List<AppMenuInfo> getPublishedAppQingMenuListByAppIds(ArrayList<String> appIds) {
        RequestContext requestContext = RequestContext.get();
        String userId = Long.toString(requestContext.getCurrUserId());
        Set userRoleIds = PermissionServiceHelper.getRolesByUser((Long)Long.valueOf(userId));
        List<AppMenuInfo> result = null;
        try {
            result = PublishedAppMenuUtil.getPublishedAppQingMenuByAppIds(appIds, userId, userRoleIds);
        }
        catch (Exception e) {
            logger.error("getPublishedAPPQingMenu error.", (Throwable)e);
        }
        return result;
    }

    public static List<AppMenuInfo> getPublishedAppQingMenuList(String appId) {
        RequestContext requestContext = RequestContext.get();
        String userId = Long.toString(requestContext.getCurrUserId());
        Set userRoleIds = PermissionServiceHelper.getRolesByUser((Long)Long.valueOf(userId));
        List<AppMenuInfo> result = null;
        try {
            result = PublishedAppMenuUtil.getPublishedAppQingMenu(appId, userId, userRoleIds);
        }
        catch (Exception e) {
            logger.error("getPublishedAPPQingMenu error.", (Throwable)e);
        }
        return result;
    }

    private static List<AppMenuInfo> getPublishedAppQingMenu(String appId, String userId, Set<String> roleIds) {
        String sqlInQuestion = "null";
        if (roleIds != null && !roleIds.isEmpty()) {
            StringBuilder sqlInQuestionBuilder = new StringBuilder();
            sqlInQuestionBuilder.append("?");
            for (int i = 1; i < roleIds.size(); ++i) {
                sqlInQuestionBuilder.append(",?");
            }
            sqlInQuestion = sqlInQuestionBuilder.toString();
        }
        String typeStr = "";
        boolean isInRole = PublishedAppMenuUtil.isInRole(userId);
        if (isInRole && !PublishedAppMenuUtil.checkPresetManagePermission()) {
            typeStr = " AND p.FSOURCE != 'extreport'";
        } else if (!isInRole && PublishedAppMenuUtil.checkPresetManagePermission()) {
            typeStr = " AND p.FSOURCE = 'extreport'";
        }
        String sql = "SELECT DISTINCT FID, FNAME, FPUBLISHID, FSOURCE, FIMGURL, FSCHEMAID, FPATH FROM ( SELECT am.FID, p.FNAME, p.FSCHEMAID, P.FSOURCE, p.FPATH, am.FPUBLISHID, am.FIMGURL FROM T_QING_PERMPUBLISH perm INNER JOIN T_QING_PUBLISH p ON perm.FPUBLISHID=p.FID LEFT JOIN T_QING_PUB_APP_MENU am ON am.FPUBLISHID=p.FID WHERE p.FTYPE='0' AND ((perm.FVIEWERID=? AND perm.FTYPE='0') OR (perm.FVIEWERID IN (" + sqlInQuestion + ") AND perm.FTYPE='1')) AND am.FAPPID=? UNION SELECT am.FID, p.FNAME, p.FSCHEMAID, P.FSOURCE, p.FPATH, am.FPUBLISHID, am.FIMGURL FROM T_QING_PUBLISH p left join T_QING_PUB_APP_MENU am on am.FPUBLISHID = p.FID\tWHERE p.FCREATORID=? AND am.FAPPID=?";
        if (isInRole || PublishedAppMenuUtil.checkPresetManagePermission()) {
            sql = sql + " UNION SELECT am.FID, p.FNAME, p.FSCHEMAID, P.FSOURCE, p.FPATH, am.FPUBLISHID, am.FIMGURL FROM T_QING_PUBLISH p left join T_QING_PUB_APP_MENU am on am.FPUBLISHID = p.FID\tWHERE p.FCREATORID=? AND am.FAPPID=?" + typeStr;
        }
        sql = sql + " ) t WHERE t.FID IS NOT NULL ORDER BY t.FNAME ASC";
        ArrayList<String> queryValue = new ArrayList<String>();
        queryValue.add(userId);
        if (roleIds != null && !CollectionUtils.isEmpty(roleIds)) {
            queryValue.addAll(roleIds);
        }
        queryValue.add(appId);
        queryValue.add(userId);
        queryValue.add(appId);
        if (isInRole || PublishedAppMenuUtil.checkPresetManagePermission()) {
            queryValue.add(QING_PRESET_USER_ID);
            queryValue.add(appId);
        }
        return (List)DB.query((DBRoute)DBRoute.qing, (String)sql, (Object[])queryValue.toArray(), (ResultSetHandler)new ResultSetHandler<List<AppMenuInfo>>(){

            public List<AppMenuInfo> handle(ResultSet rs) throws SQLException {
                ArrayList<AppMenuInfo> list = new ArrayList<AppMenuInfo>(10);
                int i = 0;
                while (rs.next()) {
                    AppMenuInfo appMenuInfo = new AppMenuInfo();
                    String fPath = rs.getString("FPATH");
                    JSONObject fPathObject = JSONObject.parseObject((String)fPath);
                    appMenuInfo.setAppId(fPathObject.getString("appNumber"));
                    if (StringUtils.isEmpty(fPathObject.getString("appMenuId"))) {
                        appMenuInfo.setParentId(fPathObject.getString("appId"));
                    } else if (StringUtils.isEmpty(fPathObject.getString("appMenuId2"))) {
                        appMenuInfo.setParentId(fPathObject.getString("appMenuId"));
                    } else {
                        appMenuInfo.setParentId(fPathObject.getString("appMenuId2"));
                    }
                    appMenuInfo.setId(rs.getString("FID"));
                    appMenuInfo.setSeq(Short.valueOf((short)i++));
                    appMenuInfo.setParamType("ListShowParameter");
                    appMenuInfo.setParams(null);
                    appMenuInfo.setOpenType("MainNewTabPage");
                    appMenuInfo.setPermission(null);
                    appMenuInfo.setNaviVector(rs.getString("FIMGURL"));
                    appMenuInfo.setData("{\"naviVector\":\"" + rs.getString("FIMGURL") + "\",\"shortcutIcon\":\"/icons/pc/entrance/zjy_ppgz_48_48.png\"}");
                    HashMap<String, String> name = new HashMap<String, String>();
                    name.put("zh_CN", rs.getString("FNAME"));
                    appMenuInfo.setName(LocaleString.fromMap(name));
                    appMenuInfo.setDescription(LocaleString.fromMap(name));
                    appMenuInfo.setFormName(LocaleString.fromMap(name));
                    HashMap<String, String> params = new HashMap<String, String>();
                    params.put("publishId", rs.getString("FPUBLISHID"));
                    params.put("caption", rs.getString("FNAME"));
                    params.put("schemaId", rs.getString("FSCHEMAID"));
                    params.put("userId", rs.getString("FID"));
                    appMenuInfo.setParams(JSONObject.toJSONString(params));
                    if ("extreport".equals(rs.getString("FSOURCE"))) {
                        appMenuInfo.setFormId(PublishedAppMenuUtil.QING_REPORT_APP_MENU);
                        appMenuInfo.setEntityNumber(PublishedAppMenuUtil.QING_REPORT_APP_MENU);
                        appMenuInfo.setShortcutIcon("/icons/pc/application/sjfwy_qbb_48_48.png");
                    } else {
                        appMenuInfo.setFormId(PublishedAppMenuUtil.QING_ANALYSIS_APP_MENU);
                        appMenuInfo.setEntityNumber(PublishedAppMenuUtil.QING_ANALYSIS_APP_MENU);
                        if ("kdfont kdfont-yibiaoban".equals(rs.getString("FIMGURL"))) {
                            appMenuInfo.setShortcutIcon("/icons/pc/application/qdy_qdyy_48_48.png");
                        } else {
                            appMenuInfo.setShortcutIcon("/icons/pc/application/qingfenxi_48_48.png");
                        }
                    }
                    list.add(appMenuInfo);
                }
                return list;
            }
        });
    }

    private static List<AppMenuInfo> getPublishedAppQingMenuByAppIds(ArrayList<String> appIds, String userId, Set<String> roleIds) {
        String sqlInQuestion = "null";
        String appIdParams = PublishedAppMenuUtil.getListParamStrInSQL(appIds);
        if (roleIds != null && !roleIds.isEmpty()) {
            StringBuilder sqlInQuestionBuilder = new StringBuilder();
            sqlInQuestionBuilder.append("?");
            for (int i = 1; i < roleIds.size(); ++i) {
                sqlInQuestionBuilder.append(",?");
            }
            sqlInQuestion = sqlInQuestionBuilder.toString();
        }
        String typeStr = "";
        boolean isInRole = PublishedAppMenuUtil.isInRole(userId);
        if (isInRole && !PublishedAppMenuUtil.checkPresetManagePermission()) {
            typeStr = " AND p.FSOURCE != 'extreport'";
        } else if (!isInRole && PublishedAppMenuUtil.checkPresetManagePermission()) {
            typeStr = " AND p.FSOURCE = 'extreport'";
        }
        String sql = "SELECT DISTINCT FID, FNAME, FPUBLISHID, FSOURCE, FIMGURL, FSCHEMAID, FPATH FROM ( SELECT am.FID, p.FNAME, p.FSCHEMAID, P.FSOURCE, p.FPATH, am.FPUBLISHID, am.FIMGURL FROM T_QING_PERMPUBLISH perm INNER JOIN T_QING_PUBLISH p ON perm.FPUBLISHID=p.FID LEFT JOIN T_QING_PUB_APP_MENU am ON am.FPUBLISHID=p.FID WHERE p.FTYPE='0' AND ((perm.FVIEWERID=? AND perm.FTYPE='0') OR (perm.FVIEWERID IN (" + sqlInQuestion + ") AND perm.FTYPE='1')) AND am.FAPPID IN (" + appIdParams + ") UNION SELECT am.FID, p.FNAME, p.FSCHEMAID, P.FSOURCE, p.FPATH, am.FPUBLISHID, am.FIMGURL FROM T_QING_PUBLISH p left join T_QING_PUB_APP_MENU am on am.FPUBLISHID = p.FID\tWHERE p.FCREATORID=? AND am.FAPPID IN (" + appIdParams + ")";
        if (isInRole || PublishedAppMenuUtil.checkPresetManagePermission()) {
            sql = sql + " UNION SELECT am.FID, p.FNAME, p.FSCHEMAID, P.FSOURCE, p.FPATH, am.FPUBLISHID, am.FIMGURL FROM T_QING_PUBLISH p left join T_QING_PUB_APP_MENU am on am.FPUBLISHID = p.FID\tWHERE p.FCREATORID=? AND am.FAPPID IN (" + appIdParams + ")" + typeStr;
        }
        sql = sql + " ) t WHERE t.FID IS NOT NULL ORDER BY t.FNAME ASC";
        ArrayList<String> queryValue = new ArrayList<String>();
        queryValue.add(userId);
        if (roleIds != null && !CollectionUtils.isEmpty(roleIds)) {
            queryValue.addAll(roleIds);
        }
        queryValue.addAll(appIds);
        queryValue.add(userId);
        queryValue.addAll(appIds);
        if (isInRole || PublishedAppMenuUtil.checkPresetManagePermission()) {
            queryValue.add(QING_PRESET_USER_ID);
            queryValue.addAll(appIds);
        }
        return (List)DB.query((DBRoute)DBRoute.qing, (String)sql, (Object[])queryValue.toArray(), (ResultSetHandler)new ResultSetHandler<List<AppMenuInfo>>(){

            public List<AppMenuInfo> handle(ResultSet rs) throws SQLException {
                ArrayList<AppMenuInfo> list = new ArrayList<AppMenuInfo>(10);
                int i = 0;
                while (rs.next()) {
                    AppMenuInfo appMenuInfo = new AppMenuInfo();
                    String fPath = rs.getString("FPATH");
                    JSONObject fPathObject = JSONObject.parseObject((String)fPath);
                    appMenuInfo.setAppId(fPathObject.getString("appNumber"));
                    if (StringUtils.isEmpty(fPathObject.getString("appMenuId"))) {
                        appMenuInfo.setParentId(fPathObject.getString("appId"));
                    } else if (StringUtils.isEmpty(fPathObject.getString("appMenuId2"))) {
                        appMenuInfo.setParentId(fPathObject.getString("appMenuId"));
                    } else {
                        appMenuInfo.setParentId(fPathObject.getString("appMenuId2"));
                    }
                    appMenuInfo.setId(rs.getString("FID"));
                    appMenuInfo.setSeq(Short.valueOf((short)i++));
                    appMenuInfo.setParamType("ListShowParameter");
                    appMenuInfo.setParams(null);
                    appMenuInfo.setOpenType("MainNewTabPage");
                    appMenuInfo.setPermission(null);
                    appMenuInfo.setNaviVector(rs.getString("FIMGURL"));
                    appMenuInfo.setData("{\"naviVector\":\"" + rs.getString("FIMGURL") + "\",\"shortcutIcon\":\"/icons/pc/entrance/zjy_ppgz_48_48.png\"}");
                    HashMap<String, String> name = new HashMap<String, String>();
                    name.put("zh_CN", rs.getString("FNAME"));
                    appMenuInfo.setName(LocaleString.fromMap(name));
                    appMenuInfo.setDescription(LocaleString.fromMap(name));
                    appMenuInfo.setFormName(LocaleString.fromMap(name));
                    HashMap<String, String> params = new HashMap<String, String>();
                    params.put("publishId", rs.getString("FPUBLISHID"));
                    params.put("caption", rs.getString("FNAME"));
                    params.put("schemaId", rs.getString("FSCHEMAID"));
                    params.put("userId", rs.getString("FID"));
                    appMenuInfo.setParams(JSONObject.toJSONString(params));
                    if ("extreport".equals(rs.getString("FSOURCE"))) {
                        appMenuInfo.setFormId(PublishedAppMenuUtil.QING_REPORT_APP_MENU);
                        appMenuInfo.setEntityNumber(PublishedAppMenuUtil.QING_REPORT_APP_MENU);
                        appMenuInfo.setShortcutIcon("/icons/pc/application/sjfwy_qbb_48_48.png");
                    } else {
                        appMenuInfo.setFormId(PublishedAppMenuUtil.QING_ANALYSIS_APP_MENU);
                        appMenuInfo.setEntityNumber(PublishedAppMenuUtil.QING_ANALYSIS_APP_MENU);
                        if ("kdfont kdfont-yibiaoban".equals(rs.getString("FIMGURL"))) {
                            appMenuInfo.setShortcutIcon("/icons/pc/application/qdy_qdyy_48_48.png");
                        } else {
                            appMenuInfo.setShortcutIcon("/icons/pc/application/qingfenxi_48_48.png");
                        }
                    }
                    list.add(appMenuInfo);
                }
                return list;
            }
        });
    }

    private static boolean isInRole(String userID) {
        boolean isInRole = false;
        Set roleIds = PermissionServiceHelper.getRolesByUser((Long)Long.valueOf(userID));
        if (roleIds != null) {
            isInRole = roleIds.contains(QING_PRESET_ROLE_ID);
        }
        return isInRole;
    }

    private static String getListParamStrInSQL(Collection<String> paramList) {
        String sqlInParam = "null";
        if (paramList == null) {
            return sqlInParam;
        }
        StringBuilder sqlInParamBuilder = new StringBuilder();
        sqlInParamBuilder.append("?");
        for (int i = 1; i < paramList.size(); ++i) {
            sqlInParamBuilder.append(",?");
        }
        sqlInParam = sqlInParamBuilder.toString();
        return sqlInParam;
    }

    private static boolean checkPresetManagePermission() {
        boolean hasPermission = false;
        try {
            AppInfo app = AppMetadataCache.getAppInfo((String)APPID);
            RequestContext requestContext = RequestContext.get();
            String userId = Long.toString(requestContext.getCurrUserId());
            hasPermission = PermissionServiceHelper.checkPermission((Long)Long.valueOf(userId), (String)app.getId(), (String)QING_RPT_PRESETMANAGE, (String)MANAGE_PRESET_GROUP_PERMITEMID);
        }
        catch (Exception e) {
            logger.error("\u83b7\u53d6\u9884\u7f6e\u7ba1\u7406\u6743\u9650\u5f02\u5e38", (Throwable)e);
        }
        return hasPermission;
    }
}

