/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.qing.plugin.appmenu;

import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kd.bos.context.RequestContext;
import kd.bos.db.DB;
import kd.bos.db.DBRoute;
import kd.bos.db.ResultSetHandler;
import kd.bos.entity.AppInfo;
import kd.bos.entity.AppMetadataCache;
import kd.bos.entity.plugin.support.util.CollectionUtils;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.qing.plugin.util.StringUtils;
import kd.bos.servicehelper.permission.PermissionServiceHelper;
import kd.bos.util.JSONUtils;

public class QingAppMenuUtil {
    public static final String QING_ANALYSIS_APP_MENU_PAGE = "qing_analysis_app_menu";
    public static final String QING_REPORT_APP_MENU_PAGE = "qing_rpt_app_menu";
    public static final String PUBLISH_SOURCE_QING_RPT = "extreport";
    public static final String QING_PRESET_ROLE_ID = "0/IWII0D06HW";
    public static final String QING_PRESET_USER_ID = "100000";
    public static final int TYPE_APPMENU = 0;
    private static String APPID = "qing_rpt";
    private static final String QING_RPT_PRESETMANAGE = "qing_rpt_apphome";
    private static final String MANAGE_PRESET_GROUP_PERMITEMID = "37=775XZ9K5N";
    private static final Log logger = LogFactory.getLog(QingAppMenuUtil.class);

    public static String getAppQingMenu(String appId) {
        RequestContext requestContext = RequestContext.get();
        String userId = Long.toString(requestContext.getCurrUserId());
        Set userRoleIds = PermissionServiceHelper.getRolesByUser((Long)Long.valueOf(userId));
        String jsonResult = null;
        try {
            List<PublishAppMenuBO> result = QingAppMenuUtil.getAppQingMenu(appId, userId, userRoleIds);
            jsonResult = JSONUtils.toString(result);
        }
        catch (Exception e) {
            logger.error("getAPPQingMenu error.", (Throwable)e);
        }
        return jsonResult;
    }

    private static List<PublishAppMenuBO> getAppQingMenu(String appId, String userId, Set<String> roleIds) {
        String sqlInQuestion = "null";
        if (roleIds != null && !roleIds.isEmpty()) {
            StringBuilder sqlInQuestionBuilder = new StringBuilder();
            sqlInQuestionBuilder.append("?");
            for (int i = 1; i < roleIds.size(); ++i) {
                sqlInQuestionBuilder.append(",?");
            }
            sqlInQuestion = sqlInQuestionBuilder.toString();
        }
        String typeStr = "";
        if (QingAppMenuUtil.isInRole(userId) && !QingAppMenuUtil.checkPresetManagePermission()) {
            typeStr = " AND p.FSOURCE != 'extreport'";
        } else if (!QingAppMenuUtil.isInRole(userId) && QingAppMenuUtil.checkPresetManagePermission()) {
            typeStr = " AND p.FSOURCE = 'extreport'";
        }
        String sql = "SELECT DISTINCT FID, FAPPID, FAPPMENUID, FAPPMENUID2, FNAME, FPUBLISHID, FCREATORID, FSOURCE, FIMGURL, FSCHEMAID FROM ( SELECT am.FID, am.FAPPID, am.FAPPMENUID, am.FAPPMENUID2, p.FNAME, p.FSCHEMAID, p.FCREATORID, P.FSOURCE, am.FPUBLISHID, am.FIMGURL FROM T_QING_PERMPUBLISH perm INNER JOIN T_QING_PUBLISH p ON perm.FPUBLISHID=p.FID LEFT JOIN T_QING_PUB_APP_MENU am ON am.FPUBLISHID=p.FID WHERE p.FTYPE='0' AND ((perm.FVIEWERID=? AND perm.FTYPE='0') OR (perm.FVIEWERID IN (" + sqlInQuestion + ") AND perm.FTYPE='1')) AND am.FAPPID=? UNION SELECT am.FID, am.FAPPID, am.FAPPMENUID, am.FAPPMENUID2, p.FNAME, p.FSCHEMAID, p.FCREATORID, P.FSOURCE, am.FPUBLISHID, am.FIMGURL FROM T_QING_PUBLISH p left join T_QING_PUB_APP_MENU am on am.FPUBLISHID = p.FID\tWHERE p.FCREATORID=? AND am.FAPPID=?";
        if (QingAppMenuUtil.isInRole(userId) || QingAppMenuUtil.checkPresetManagePermission()) {
            sql = sql + " UNION SELECT am.FID, am.FAPPID, am.FAPPMENUID, am.FAPPMENUID2, p.FNAME, p.FSCHEMAID, p.FCREATORID, P.FSOURCE, am.FPUBLISHID, am.FIMGURL FROM T_QING_PUBLISH p left join T_QING_PUB_APP_MENU am on am.FPUBLISHID = p.FID\tWHERE p.FCREATORID=? AND am.FAPPID=?" + typeStr;
        }
        sql = sql + " ) t WHERE t.FID IS NOT NULL ORDER BY t.FNAME ASC";
        ArrayList<String> queryValue = new ArrayList<String>();
        queryValue.add(userId);
        if (roleIds != null && !CollectionUtils.isEmpty(roleIds)) {
            queryValue.addAll(roleIds);
        }
        queryValue.add(appId);
        queryValue.add(userId);
        queryValue.add(appId);
        if (QingAppMenuUtil.isInRole(userId) || QingAppMenuUtil.checkPresetManagePermission()) {
            queryValue.add(QING_PRESET_USER_ID);
            queryValue.add(appId);
        }
        return (List)DB.query((DBRoute)DBRoute.qing, (String)sql, (Object[])queryValue.toArray(), (ResultSetHandler)new ResultSetHandler<List<PublishAppMenuBO>>(){

            public List<PublishAppMenuBO> handle(ResultSet rs) throws SQLException {
                ArrayList<PublishAppMenuBO> list = new ArrayList<PublishAppMenuBO>(10);
                while (rs.next()) {
                    PublishAppMenuBO publishAppMenu = new PublishAppMenuBO();
                    publishAppMenu.setAppId(rs.getString("FAPPID"));
                    String appMenuId = rs.getString("FAPPMENUID");
                    publishAppMenu.setAppMenuId(appMenuId);
                    String appMenuId2 = rs.getString("FAPPMENUID2");
                    if (StringUtils.isNotEmpty(appMenuId2)) {
                        publishAppMenu.setAppMenuId(appMenuId2);
                        publishAppMenu.setParentId(appMenuId);
                    }
                    publishAppMenu.setQingMenuId(rs.getString("FID"));
                    publishAppMenu.setQingMenuName(rs.getString("FNAME"));
                    publishAppMenu.setImgUrl(rs.getString("FIMGURL"));
                    String publishSource = rs.getString("FSOURCE");
                    publishAppMenu.setFormNumber(QingAppMenuUtil.getAppMenuPageNumber(publishSource));
                    HashMap<String, String> params = new HashMap<String, String>();
                    params.put("publishId", rs.getString("FPUBLISHID"));
                    params.put("caption", rs.getString("FNAME"));
                    params.put("schemaId", rs.getString("FSCHEMAID"));
                    params.put("userId", rs.getString("FCREATORID"));
                    publishAppMenu.setFormParams(params);
                    list.add(publishAppMenu);
                }
                return list;
            }
        });
    }

    private static String getAppMenuPageNumber(String publishSource) {
        if (publishSource != null && PUBLISH_SOURCE_QING_RPT.equals(publishSource)) {
            return QING_REPORT_APP_MENU_PAGE;
        }
        return QING_ANALYSIS_APP_MENU_PAGE;
    }

    private static boolean isInRole(String userID) {
        boolean isInRole = false;
        Set roleIds = PermissionServiceHelper.getRolesByUser((Long)Long.valueOf(userID));
        if (roleIds != null) {
            isInRole = roleIds.contains(QING_PRESET_ROLE_ID);
        }
        return isInRole;
    }

    private static boolean checkPresetManagePermission() {
        boolean hasPermission = false;
        try {
            AppInfo app = AppMetadataCache.getAppInfo((String)APPID);
            RequestContext requestContext = RequestContext.get();
            String userId = Long.toString(requestContext.getCurrUserId());
            hasPermission = PermissionServiceHelper.checkPermission((Long)Long.valueOf(userId), (String)app.getId(), (String)QING_RPT_PRESETMANAGE, (String)MANAGE_PRESET_GROUP_PERMITEMID);
        }
        catch (Exception e) {
            logger.error("\u83b7\u53d6\u9884\u7f6e\u7ba1\u7406\u6743\u9650\u5f02\u5e38", (Throwable)e);
        }
        return hasPermission;
    }

    public static class PublishAppMenuBO {
        private String qingMenuId;
        private String appId;
        private String appMenuId;
        private String parentId;
        private String qingMenuName;
        private String imgUrl;
        private String formNumber;
        private Map<String, String> formParams;

        public String getQingMenuId() {
            return this.qingMenuId;
        }

        public void setQingMenuId(String qingMenuId) {
            this.qingMenuId = qingMenuId;
        }

        public String getAppId() {
            return this.appId;
        }

        public void setAppId(String appId) {
            this.appId = appId;
        }

        public String getAppMenuId() {
            return this.appMenuId;
        }

        public void setAppMenuId(String appMenuId) {
            this.appMenuId = appMenuId;
        }

        public String getQingMenuName() {
            return this.qingMenuName;
        }

        public void setQingMenuName(String qingMenuName) {
            this.qingMenuName = qingMenuName;
        }

        public String getImgUrl() {
            return this.imgUrl;
        }

        public void setImgUrl(String imgUrl) {
            this.imgUrl = imgUrl;
        }

        public String getFormNumber() {
            return this.formNumber;
        }

        public void setFormNumber(String formNumber) {
            this.formNumber = formNumber;
        }

        public Map<String, String> getFormParams() {
            return this.formParams;
        }

        public void setFormParams(Map<String, String> formParams) {
            this.formParams = formParams;
        }

        public String getParentId() {
            return this.parentId;
        }

        public void setParentId(String parentId) {
            this.parentId = parentId;
        }
    }
}

