/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.qing.plugin.util;

import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import kd.bos.context.RequestContext;
import kd.bos.context.RequestContextCreator;
import kd.bos.servicehelper.DispatchServiceHelper;

public class PresetUtil {
    private static Map<String, String> presetCacheMap = new ConcurrentHashMap<String, String>(16);
    private static final String QING_APP_ID = "qing";
    private static final String CACHE_KEY_FINISHED = "Qing.Preset.Finished";
    private static final String CACHE_KEY_RUNNING = "Qing.Preset.Running";
    private static final String STATUS_FINISHED = "FINISHED";
    private static final String STATUS_RUNNING = "RUNNING";

    public static void syncExecutePresetPkg() {
        String finishedCacheKey = PresetUtil.getCacheKey(true);
        if (null == finishedCacheKey) {
            return;
        }
        String status = presetCacheMap.get(finishedCacheKey);
        if (STATUS_FINISHED.equals(status)) {
            return;
        }
        try {
            DispatchServiceHelper.invokeBOSService((String)QING_APP_ID, (String)"QingService", (String)"importPreset", (Object[])new Object[0]);
            presetCacheMap.put(finishedCacheKey, STATUS_FINISHED);
        }
        catch (Exception e) {
            presetCacheMap.remove(finishedCacheKey);
        }
    }

    private static String getCacheKey(boolean isFinished) {
        RequestContext requestContext = RequestContext.get();
        String accountId = requestContext.getAccountId();
        String tenantId = requestContext.getTenantId();
        if (tenantId == null || accountId == null) {
            return null;
        }
        if (isFinished) {
            return CACHE_KEY_FINISHED + tenantId + "-" + accountId;
        }
        return CACHE_KEY_RUNNING + tenantId + "-" + accountId;
    }

    public static void asynchExecutePresetPkg() {
        String finishedCacheKey = PresetUtil.getCacheKey(true);
        String runningCacheKey = PresetUtil.getCacheKey(false);
        if (null == finishedCacheKey || null == runningCacheKey) {
            return;
        }
        String statusFinished = presetCacheMap.get(finishedCacheKey);
        String statusRunning = presetCacheMap.get(runningCacheKey);
        if (STATUS_FINISHED.equals(statusFinished) || STATUS_RUNNING.equals(statusRunning)) {
            return;
        }
        presetCacheMap.put(runningCacheKey, STATUS_RUNNING);
        PresetPkgTask presetPkgTask = new PresetPkgTask(finishedCacheKey, runningCacheKey, RequestContext.get());
        ExecutorService executorService = Executors.newSingleThreadExecutor();
        executorService.submit(presetPkgTask);
        executorService.shutdown();
    }

    private static class PresetPkgTask
    implements Runnable {
        private String finishedCacheKey;
        private String runningCacheKey;
        private RequestContext requestContext;

        public PresetPkgTask(String finishedCacheKey, String runningCacheKey, RequestContext requestContext) {
            this.finishedCacheKey = finishedCacheKey;
            this.runningCacheKey = runningCacheKey;
            this.requestContext = requestContext;
        }

        @Override
        public void run() {
            try {
                RequestContextCreator.restoreForThreadPool((RequestContext)this.requestContext);
                DispatchServiceHelper.invokeBOSService((String)PresetUtil.QING_APP_ID, (String)"QingService", (String)"importPreset", (Object[])new Object[0]);
                presetCacheMap.put(this.finishedCacheKey, PresetUtil.STATUS_FINISHED);
            }
            catch (Exception exception) {
                // empty catch block
            }
            presetCacheMap.remove(this.runningCacheKey);
        }
    }
}

