/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.web.qing;

import com.kingdee.bos.qing.common.context.QingContext;
import com.kingdee.bos.qing.common.framework.model.server.ServerWebsocketIsReadyMessage;
import com.kingdee.bos.qing.common.framework.web.IServerMessageSender;
import com.kingdee.bos.qing.common.framework.web.ws.AbstractQingWebSocket;
import com.kingdee.bos.qing.common.init.QingInitializeHelper;
import java.util.Map;
import kd.bos.context.RequestContext;
import kd.bos.mservice.qingshared.common.context.QingIntegratedContext;
import kd.bos.msgjet.websocket.MsgWebSocket;
import kd.bos.msgjet.websocket.WebSocketListener;
import kd.bos.msgjet.websocket.WebSocketObject;
import kd.bos.session.SessionDAO;
import kd.bos.session.SessionDAOFactory;
import kd.bos.trace.util.TraceIdUtil;
import kd.bos.web.qing.impl.ServerMessageSender4WS;

public class QingWebSockerListener
extends AbstractQingWebSocket
implements WebSocketListener {
    public void onConnect(WebSocketObject webSocketObject) {
        String identifytype = webSocketObject.getIdentifyType();
        if (identifytype != null && identifytype.startsWith("QING")) {
            MsgWebSocket.sendMessage((String)identifytype, (String)ServerWebsocketIsReadyMessage.createEncodeMessage());
        }
    }

    private void initRequestContext(String sessionId) {
        SessionDAO sessionDAO = SessionDAOFactory.getSessionDAO((String)sessionId);
        Map sessionInfo = sessionDAO.getAttributesAsMap(new String[]{"tenantId", "userId", "requestId", "client", "userType", "uid", "userName", "userOpenId", "orgId", "accountId"});
        String userId = (String)sessionInfo.get("userId");
        RequestContext requestContext = RequestContext.create();
        requestContext.setRequestId((String)sessionInfo.get("requestId"));
        requestContext.setTraceId(TraceIdUtil.createTraceIdString());
        requestContext.setClient((String)sessionInfo.get("client"));
        requestContext.setAccountId((String)sessionInfo.get("accountId"));
        requestContext.setUserId(userId);
        requestContext.setUserType((String)sessionInfo.get("userType"));
        requestContext.setUid((String)sessionInfo.get("uid"));
        String userOpenId = (String)sessionInfo.get("userOpenId");
        requestContext.setUserOpenId(userOpenId);
        String orgid = (String)sessionInfo.get("orgId");
        requestContext.setOrgId(Long.parseLong(orgid));
        String userName = (String)sessionInfo.get("userName");
        requestContext.setUserName(userName);
        requestContext.setTenantId((String)sessionInfo.get("tenantId"));
        requestContext.setGlobalSessionId(sessionId);
    }

    public void onMessage(WebSocketObject webSocketObject, String message) {
        String sessionId = webSocketObject.getSessionId();
        String identifytype = webSocketObject.getIdentifyType();
        if (sessionId != null && identifytype != null && identifytype.startsWith("QING")) {
            this.initRequestContext(sessionId);
            QingIntegratedContext qintContext = new QingIntegratedContext();
            this.onRequestMessage((QingContext)qintContext, identifytype, message);
        }
    }

    public void onClose(WebSocketObject webSocketObject) {
    }

    protected IServerMessageSender createMessageListenr(String identifytype) {
        return new ServerMessageSender4WS(identifytype);
    }

    static {
        QingInitializeHelper.initializeOnStart();
    }
}

